/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.concurrent;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.orbutil.concurrent.Sync;
import org.omg.CORBA.INTERNAL;

public class ReentrantMutex
implements Sync {
    protected Thread holder_ = null;
    protected int counter_ = 0;
    protected boolean debug = false;

    public ReentrantMutex() {
        this(false);
    }

    public ReentrantMutex(boolean bl2) {
        this.debug = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ReentrantMutex reentrantMutex = this;
        synchronized (reentrantMutex) {
            try {
                Thread thread;
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "acquire enter: holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
                if (this.holder_ != (thread = Thread.currentThread())) {
                    try {
                        while (this.counter_ > 0) {
                            this.wait();
                        }
                        if (this.counter_ != 0) {
                            throw new INTERNAL("counter not 0 when first acquiring mutex");
                        }
                        this.holder_ = thread;
                    }
                    catch (InterruptedException interruptedException) {
                        this.notify();
                        throw interruptedException;
                    }
                }
                ++this.counter_;
            }
            finally {
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "acquire exit: holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireAll(int n2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ReentrantMutex reentrantMutex = this;
        synchronized (reentrantMutex) {
            try {
                Thread thread;
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "acquireAll enter: count=" + n2 + " holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
                if (this.holder_ == (thread = Thread.currentThread())) {
                    throw new INTERNAL("Cannot acquireAll while holding the mutex");
                }
                try {
                    while (this.counter_ > 0) {
                        this.wait();
                    }
                    if (this.counter_ != 0) {
                        throw new INTERNAL("counter not 0 when first acquiring mutex");
                    }
                    this.holder_ = thread;
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
                this.counter_ = n2;
            }
            finally {
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "acquireAll exit: count=" + n2 + " holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        try {
            Thread thread;
            if (this.debug) {
                ORBUtility.dprintTrace(this, "release enter:  holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
            }
            if ((thread = Thread.currentThread()) != this.holder_) {
                throw new INTERNAL("Attempt to release Mutex by thread not holding the Mutex");
            }
            --this.counter_;
            if (this.counter_ == 0) {
                this.holder_ = null;
                this.notify();
            }
        }
        finally {
            if (this.debug) {
                ORBUtility.dprintTrace(this, "release exit:  holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int releaseAll() {
        try {
            Thread thread;
            if (this.debug) {
                ORBUtility.dprintTrace(this, "releaseAll enter:  holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
            }
            if ((thread = Thread.currentThread()) != this.holder_) {
                throw new INTERNAL("Attempt to releaseAll Mutex by thread not holding the Mutex");
            }
            int n2 = this.counter_;
            this.counter_ = 0;
            this.holder_ = null;
            this.notify();
            int n3 = n2;
            return n3;
        }
        finally {
            if (this.debug) {
                ORBUtility.dprintTrace(this, "releaseAll exit:  holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean attempt(long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ReentrantMutex reentrantMutex = this;
        synchronized (reentrantMutex) {
            try {
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "attempt enter: msecs=" + l2 + " holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
                Thread thread = Thread.currentThread();
                if (this.counter_ == 0) {
                    this.holder_ = thread;
                    this.counter_ = 1;
                    boolean bl2 = true;
                    return bl2;
                }
                if (l2 <= 0L) {
                    boolean bl3 = false;
                    return bl3;
                }
                long l3 = l2;
                long l4 = System.currentTimeMillis();
                do {
                    boolean bl4;
                    try {
                        this.wait(l3);
                        if (this.counter_ != 0) continue;
                        this.holder_ = thread;
                        this.counter_ = 1;
                        bl4 = true;
                    }
                    catch (InterruptedException interruptedException) {
                        this.notify();
                        throw interruptedException;
                    }
                    return bl4;
                } while ((l3 = l2 - (System.currentTimeMillis() - l4)) > 0L);
                boolean bl5 = false;
                return bl5;
            }
            finally {
                if (this.debug) {
                    ORBUtility.dprintTrace(this, "attempt exit:  holder_=" + ORBUtility.getThreadName(this.holder_) + " counter_=" + this.counter_);
                }
            }
        }
    }
}

