/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class AdaptiveCoding
implements Constants,
CodingMethod {
    CodingMethod headCoding;
    int headLength;
    CodingMethod tailCoding;
    public static final int KX_MIN = 0;
    public static final int KX_MAX = 3;
    public static final int KX_LG2BASE = 4;
    public static final int KX_BASE = 16;
    public static final int KB_MIN = 0;
    public static final int KB_MAX = 255;
    public static final int KB_OFFSET = 1;
    public static final int KB_DEFAULT = 3;

    public AdaptiveCoding(int n2, CodingMethod codingMethod, CodingMethod codingMethod2) {
        assert (AdaptiveCoding.isCodableLength(n2));
        this.headLength = n2;
        this.headCoding = codingMethod;
        this.tailCoding = codingMethod2;
    }

    public void setHeadCoding(CodingMethod codingMethod) {
        this.headCoding = codingMethod;
    }

    public void setHeadLength(int n2) {
        assert (AdaptiveCoding.isCodableLength(n2));
        this.headLength = n2;
    }

    public void setTailCoding(CodingMethod codingMethod) {
        this.tailCoding = codingMethod;
    }

    public boolean isTrivial() {
        return this.headCoding == this.tailCoding;
    }

    public void writeArrayTo(OutputStream outputStream, int[] nArray, int n2, int n3) throws IOException {
        int n4 = n2 + this.headLength;
        assert (n4 <= n3);
        this.headCoding.writeArrayTo(outputStream, nArray, n2, n4);
        this.tailCoding.writeArrayTo(outputStream, nArray, n4, n3);
    }

    public void readArrayFrom(InputStream inputStream, int[] nArray, int n2, int n3) throws IOException {
        int n4 = n2 + this.headLength;
        assert (n4 <= n3);
        this.headCoding.readArrayFrom(inputStream, nArray, n2, n4);
        this.tailCoding.readArrayFrom(inputStream, nArray, n4, n3);
    }

    static int getKXOf(int n2) {
        for (int i2 = 0; i2 <= 3; ++i2) {
            if ((n2 - 1 & 0xFFFFFF00) == 0) {
                return i2;
            }
            n2 >>>= 4;
        }
        return -1;
    }

    static int getKBOf(int n2) {
        int n3 = AdaptiveCoding.getKXOf(n2);
        if (n3 < 0) {
            return -1;
        }
        return (n2 >>>= n3 * 4) - 1;
    }

    static int decodeK(int n2, int n3) {
        assert (0 <= n2 && n2 <= 3);
        assert (0 <= n3 && n3 <= 255);
        return n3 + 1 << n2 * 4;
    }

    static int getNextK(int n2) {
        if (n2 <= 0) {
            return 1;
        }
        int n3 = AdaptiveCoding.getKXOf(n2);
        if (n3 < 0) {
            return Integer.MAX_VALUE;
        }
        int n4 = 1 << n3 * 4;
        int n5 = 255 << n3 * 4;
        int n6 = n2 + n4;
        if (((n6 &= ~(n4 - 1)) - n4 & ~n5) == 0) {
            assert (AdaptiveCoding.getKXOf(n6) == n3);
            return n6;
        }
        if (n3 == 3) {
            return Integer.MAX_VALUE;
        }
        int n7 = 1 << ++n3 * 4;
        int n8 = 255 << n3 * 4;
        n6 |= n5 & ~n8;
        assert (AdaptiveCoding.getKXOf(n6 += n4) == n3);
        return n6;
    }

    public static boolean isCodableLength(int n2) {
        int n3 = AdaptiveCoding.getKXOf(n2);
        if (n3 < 0) {
            return false;
        }
        int n4 = 1 << n3 * 4;
        int n5 = 255 << n3 * 4;
        return (n2 - n4 & ~n5) == 0;
    }

    public byte[] getMetaCoding(Coding coding) {
        int n2;
        int n3 = this.headLength;
        assert (AdaptiveCoding.isCodableLength(n3));
        int n4 = this.headCoding == coding ? 1 : 0;
        int n5 = n2 = this.tailCoding == coding ? 1 : 0;
        if (n4 + n2 > 1) {
            n2 = 0;
        }
        int n6 = 1 * n4 + 2 * n2;
        assert (n6 < 3);
        int n7 = AdaptiveCoding.getKXOf(n3);
        int n8 = AdaptiveCoding.getKBOf(n3);
        assert (AdaptiveCoding.decodeK(n7, n8) == n3);
        int n9 = n8 != 3 ? 1 : 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        byteArrayOutputStream.write(117 + n7 + 4 * n9 + 8 * n6);
        if (n9 != 0) {
            byteArrayOutputStream.write(n8);
        }
        try {
            if (n4 == 0) {
                byteArrayOutputStream.write(this.headCoding.getMetaCoding(coding));
            }
            if (n2 == 0) {
                byteArrayOutputStream.write(this.tailCoding.getMetaCoding(coding));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int parseMetaCoding(byte[] byArray, int n2, Coding coding, CodingMethod[] codingMethodArray) {
        int n3;
        if ((n3 = byArray[n2++] & 0xFF) < 117) {
            return n2 - 1;
        }
        int n4 = (n3 -= 117) % 4;
        int n5 = n3 / 4 % 2;
        int n6 = n3 / 8;
        if (n6 >= 3) {
            return n2 - 1;
        }
        int n7 = n6 & 1;
        int n8 = n6 & 2;
        CodingMethod[] codingMethodArray2 = new CodingMethod[]{coding};
        CodingMethod[] codingMethodArray3 = new CodingMethod[]{coding};
        int n9 = 3;
        if (n5 != 0) {
            n9 = byArray[n2++] & 0xFF;
        }
        if (n7 == 0) {
            n2 = BandStructure.parseMetaCoding(byArray, n2, coding, codingMethodArray2);
        }
        if (n8 == 0) {
            n2 = BandStructure.parseMetaCoding(byArray, n2, coding, codingMethodArray3);
        }
        codingMethodArray[0] = new AdaptiveCoding(AdaptiveCoding.decodeK(n4, n9), codingMethodArray2[0], codingMethodArray3[0]);
        return n2;
    }

    private String keyString(CodingMethod codingMethod) {
        if (codingMethod instanceof Coding) {
            return ((Coding)codingMethod).keyString();
        }
        return codingMethod.toString();
    }

    public String toString() {
        return "run(K=" + this.headLength + " A=" + this.keyString(this.headCoding) + " B=" + this.keyString(this.tailCoding) + ")";
    }
}

