/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.AdaptiveCoding;
import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingChooser;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.PackageReader;
import com.sun.java.util.jar.pack.PopulationCoding;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

abstract class BandStructure
implements Constants {
    static final int MAX_EFFORT = 9;
    static final int MIN_EFFORT = 1;
    static final int DEFAULT_EFFORT = 5;
    PropMap p200 = Utils.currentPropMap();
    int verbose = this.p200.getInteger("com.sun.java.util.jar.pack.verbose");
    int effort = this.p200.getInteger("pack.effort");
    boolean optDumpBands;
    boolean optDebugBands;
    boolean optVaryCodings;
    boolean optBigStrings;
    private final boolean isReader;
    static final Coding BYTE1;
    static final Coding CHAR3;
    static final Coding BCI5;
    static final Coding BRANCH5;
    static final Coding UNSIGNED5;
    static final Coding UDELTA5;
    static final Coding SIGNED5;
    static final Coding DELTA5;
    static final Coding MDELTA5;
    private static final Coding[] basicCodings;
    private static final HashMap basicCodingIndexes;
    protected byte[] bandHeaderBytes;
    protected int bandHeaderBytePos;
    protected int bandHeaderBytePos0;
    static final int SHORT_BAND_HEURISTIC = 100;
    public static final int NO_PHASE = 0;
    public static final int COLLECT_PHASE = 1;
    public static final int WRITE_PHASE = 3;
    public static final int EXPECT_PHASE = 2;
    public static final int READ_PHASE = 4;
    public static final int DISBURSE_PHASE = 6;
    public static final int DONE_PHASE = 8;
    private ArrayList allKQBands;
    private ArrayList needPredefIndex;
    private CodingChooser codingChooser;
    static final byte[] defaultMetaCoding;
    static final byte[] noMetaCoding;
    ByteCounter outputCounter;
    protected int archiveOptions;
    protected long archiveSize0;
    protected long archiveSize1;
    protected int archiveNextCount;
    static final int AH_LENGTH_0 = 3;
    static final int AH_ARCHIVE_SIZE_HI = 0;
    static final int AH_ARCHIVE_SIZE_LO = 1;
    static final int AH_LENGTH_S = 2;
    static final int AH_LENGTH = 26;
    static final int AH_FILE_HEADER_LEN = 5;
    static final int AH_SPECIAL_FORMAT_LEN = 2;
    static final int AH_CP_NUMBER_LEN = 4;
    static final int AH_LENGTH_MIN = 15;
    static final int AB_FLAGS_HI = 0;
    static final int AB_FLAGS_LO = 1;
    static final int AB_ATTR_COUNT = 2;
    static final int AB_ATTR_INDEXES = 3;
    static final int AB_ATTR_CALLS = 4;
    private static final boolean NULL_IS_OK = true;
    MultiBand all_bands;
    ByteBand archive_magic;
    IntBand archive_header_0;
    IntBand archive_header_S;
    IntBand archive_header_1;
    ByteBand band_headers;
    MultiBand cp_bands;
    IntBand cp_Utf8_prefix;
    IntBand cp_Utf8_suffix;
    IntBand cp_Utf8_chars;
    IntBand cp_Utf8_big_suffix;
    MultiBand cp_Utf8_big_chars;
    IntBand cp_Int;
    IntBand cp_Float;
    IntBand cp_Long_hi;
    IntBand cp_Long_lo;
    IntBand cp_Double_hi;
    IntBand cp_Double_lo;
    CPRefBand cp_String;
    CPRefBand cp_Class;
    CPRefBand cp_Signature_form;
    CPRefBand cp_Signature_classes;
    CPRefBand cp_Descr_name;
    CPRefBand cp_Descr_type;
    CPRefBand cp_Field_class;
    CPRefBand cp_Field_desc;
    CPRefBand cp_Method_class;
    CPRefBand cp_Method_desc;
    CPRefBand cp_Imethod_class;
    CPRefBand cp_Imethod_desc;
    MultiBand attr_definition_bands;
    ByteBand attr_definition_headers;
    CPRefBand attr_definition_name;
    CPRefBand attr_definition_layout;
    MultiBand ic_bands;
    CPRefBand ic_this_class;
    IntBand ic_flags;
    CPRefBand ic_outer_class;
    CPRefBand ic_name;
    MultiBand class_bands;
    CPRefBand class_this;
    CPRefBand class_super;
    IntBand class_interface_count;
    CPRefBand class_interface;
    IntBand class_field_count;
    IntBand class_method_count;
    CPRefBand field_descr;
    MultiBand field_attr_bands;
    IntBand field_flags_hi;
    IntBand field_flags_lo;
    IntBand field_attr_count;
    IntBand field_attr_indexes;
    IntBand field_attr_calls;
    CPRefBand field_ConstantValue_KQ;
    CPRefBand field_Signature_RS;
    MultiBand field_metadata_bands;
    CPRefBand method_descr;
    MultiBand method_attr_bands;
    IntBand method_flags_hi;
    IntBand method_flags_lo;
    IntBand method_attr_count;
    IntBand method_attr_indexes;
    IntBand method_attr_calls;
    IntBand method_Exceptions_N;
    CPRefBand method_Exceptions_RC;
    CPRefBand method_Signature_RS;
    MultiBand method_metadata_bands;
    MultiBand class_attr_bands;
    IntBand class_flags_hi;
    IntBand class_flags_lo;
    IntBand class_attr_count;
    IntBand class_attr_indexes;
    IntBand class_attr_calls;
    CPRefBand class_SourceFile_RUN;
    CPRefBand class_EnclosingMethod_RC;
    CPRefBand class_EnclosingMethod_RDN;
    CPRefBand class_Signature_RS;
    MultiBand class_metadata_bands;
    IntBand class_InnerClasses_N;
    CPRefBand class_InnerClasses_RC;
    IntBand class_InnerClasses_F;
    CPRefBand class_InnerClasses_outer_RCN;
    CPRefBand class_InnerClasses_name_RUN;
    IntBand class_ClassFile_version_minor_H;
    IntBand class_ClassFile_version_major_H;
    MultiBand code_bands;
    ByteBand code_headers;
    IntBand code_max_stack;
    IntBand code_max_na_locals;
    IntBand code_handler_count;
    IntBand code_handler_start_P;
    IntBand code_handler_end_PO;
    IntBand code_handler_catch_PO;
    CPRefBand code_handler_class_RCN;
    MultiBand code_attr_bands;
    IntBand code_flags_hi;
    IntBand code_flags_lo;
    IntBand code_attr_count;
    IntBand code_attr_indexes;
    IntBand code_attr_calls;
    IntBand code_LineNumberTable_N;
    IntBand code_LineNumberTable_bci_P;
    IntBand code_LineNumberTable_line;
    IntBand code_LocalVariableTable_N;
    IntBand code_LocalVariableTable_bci_P;
    IntBand code_LocalVariableTable_span_O;
    CPRefBand code_LocalVariableTable_name_RU;
    CPRefBand code_LocalVariableTable_type_RS;
    IntBand code_LocalVariableTable_slot;
    IntBand code_LocalVariableTypeTable_N;
    IntBand code_LocalVariableTypeTable_bci_P;
    IntBand code_LocalVariableTypeTable_span_O;
    CPRefBand code_LocalVariableTypeTable_name_RU;
    CPRefBand code_LocalVariableTypeTable_type_RS;
    IntBand code_LocalVariableTypeTable_slot;
    MultiBand bc_bands;
    ByteBand bc_codes;
    IntBand bc_case_count;
    IntBand bc_case_value;
    ByteBand bc_byte;
    IntBand bc_short;
    IntBand bc_local;
    IntBand bc_label;
    CPRefBand bc_intref;
    CPRefBand bc_floatref;
    CPRefBand bc_longref;
    CPRefBand bc_doubleref;
    CPRefBand bc_stringref;
    CPRefBand bc_classref;
    CPRefBand bc_fieldref;
    CPRefBand bc_methodref;
    CPRefBand bc_imethodref;
    CPRefBand bc_thisfield;
    CPRefBand bc_superfield;
    CPRefBand bc_thismethod;
    CPRefBand bc_supermethod;
    IntBand bc_initref;
    CPRefBand bc_escref;
    IntBand bc_escrefsize;
    IntBand bc_escsize;
    ByteBand bc_escbyte;
    MultiBand file_bands;
    CPRefBand file_name;
    IntBand file_size_hi;
    IntBand file_size_lo;
    IntBand file_modtime;
    IntBand file_options;
    ByteBand file_bits;
    protected MultiBand[] metadataBands;
    public static final int ADH_CONTEXT_MASK = 3;
    public static final int ADH_BIT_SHIFT = 2;
    public static final int ADH_BIT_IS_LSB = 1;
    public static final int ATTR_INDEX_OVERFLOW = -1;
    public int[] attrIndexLimit;
    protected long[] attrFlagMask;
    protected long[] attrDefSeen;
    protected int[] attrOverflowMask;
    protected int attrClassFileVersionMask;
    protected HashMap attrBandTable;
    protected final Attribute.Layout attrCodeEmpty;
    protected final Attribute.Layout attrInnerClassesEmpty;
    protected final Attribute.Layout attrClassFileVersion;
    protected final Attribute.Layout attrConstantValue;
    HashMap attrIndexTable;
    protected ArrayList[] attrDefs;
    protected MultiBand[] attrBands;
    private static final int[][] shortCodeLimits;
    public final int shortCodeHeader_h_limit;
    static final int LONG_CODE_HEADER = 0;
    static int nextSeqForDebug;
    static File dumpDir;
    private HashMap prevForAssertMap;
    private static int[] noInts;
    private static byte[] noBytes;

    protected abstract ConstantPool.Index getCPIndex(byte var1);

    protected BandStructure(boolean bl2) {
        int n2;
        if (this.effort == 0) {
            this.effort = 5;
        }
        this.optDumpBands = this.p200.getBoolean("com.sun.java.util.jar.pack.dump.bands");
        this.optDebugBands = this.p200.getBoolean("com.sun.java.util.jar.pack.debug.bands");
        this.optVaryCodings = !this.p200.getBoolean("com.sun.java.util.jar.pack.no.vary.codings");
        this.optBigStrings = !this.p200.getBoolean("com.sun.java.util.jar.pack.no.big.strings");
        this.isReader = this instanceof PackageReader;
        this.allKQBands = new ArrayList();
        this.needPredefIndex = new ArrayList();
        this.all_bands = (MultiBand)new MultiBand("(package)", UNSIGNED5).init();
        this.archive_magic = this.all_bands.newByteBand("archive_magic");
        this.archive_header_0 = this.all_bands.newIntBand("archive_header_0", UNSIGNED5);
        this.archive_header_S = this.all_bands.newIntBand("archive_header_S", UNSIGNED5);
        this.archive_header_1 = this.all_bands.newIntBand("archive_header_1", UNSIGNED5);
        this.band_headers = this.all_bands.newByteBand("band_headers");
        this.cp_bands = this.all_bands.newMultiBand("(constant_pool)", DELTA5);
        this.cp_Utf8_prefix = this.cp_bands.newIntBand("cp_Utf8_prefix");
        this.cp_Utf8_suffix = this.cp_bands.newIntBand("cp_Utf8_suffix", UNSIGNED5);
        this.cp_Utf8_chars = this.cp_bands.newIntBand("cp_Utf8_chars", CHAR3);
        this.cp_Utf8_big_suffix = this.cp_bands.newIntBand("cp_Utf8_big_suffix");
        this.cp_Utf8_big_chars = this.cp_bands.newMultiBand("(cp_Utf8_big_chars)", DELTA5);
        this.cp_Int = this.cp_bands.newIntBand("cp_Int", UDELTA5);
        this.cp_Float = this.cp_bands.newIntBand("cp_Float", UDELTA5);
        this.cp_Long_hi = this.cp_bands.newIntBand("cp_Long_hi", UDELTA5);
        this.cp_Long_lo = this.cp_bands.newIntBand("cp_Long_lo");
        this.cp_Double_hi = this.cp_bands.newIntBand("cp_Double_hi", UDELTA5);
        this.cp_Double_lo = this.cp_bands.newIntBand("cp_Double_lo");
        this.cp_String = this.cp_bands.newCPRefBand("cp_String", UDELTA5, (byte)1);
        this.cp_Class = this.cp_bands.newCPRefBand("cp_Class", UDELTA5, (byte)1);
        this.cp_Signature_form = this.cp_bands.newCPRefBand("cp_Signature_form", (byte)1);
        this.cp_Signature_classes = this.cp_bands.newCPRefBand("cp_Signature_classes", UDELTA5, (byte)7);
        this.cp_Descr_name = this.cp_bands.newCPRefBand("cp_Descr_name", (byte)1);
        this.cp_Descr_type = this.cp_bands.newCPRefBand("cp_Descr_type", UDELTA5, (byte)13);
        this.cp_Field_class = this.cp_bands.newCPRefBand("cp_Field_class", (byte)7);
        this.cp_Field_desc = this.cp_bands.newCPRefBand("cp_Field_desc", UDELTA5, (byte)12);
        this.cp_Method_class = this.cp_bands.newCPRefBand("cp_Method_class", (byte)7);
        this.cp_Method_desc = this.cp_bands.newCPRefBand("cp_Method_desc", UDELTA5, (byte)12);
        this.cp_Imethod_class = this.cp_bands.newCPRefBand("cp_Imethod_class", (byte)7);
        this.cp_Imethod_desc = this.cp_bands.newCPRefBand("cp_Imethod_desc", UDELTA5, (byte)12);
        this.attr_definition_bands = this.all_bands.newMultiBand("(attr_definition_bands)", UNSIGNED5);
        this.attr_definition_headers = this.attr_definition_bands.newByteBand("attr_definition_headers");
        this.attr_definition_name = this.attr_definition_bands.newCPRefBand("attr_definition_name", (byte)1);
        this.attr_definition_layout = this.attr_definition_bands.newCPRefBand("attr_definition_layout", (byte)1);
        this.ic_bands = this.all_bands.newMultiBand("(ic_bands)", DELTA5);
        this.ic_this_class = this.ic_bands.newCPRefBand("ic_this_class", UDELTA5, (byte)7);
        this.ic_flags = this.ic_bands.newIntBand("ic_flags", UNSIGNED5);
        this.ic_outer_class = this.ic_bands.newCPRefBand("ic_outer_class", DELTA5, (byte)7, true);
        this.ic_name = this.ic_bands.newCPRefBand("ic_name", DELTA5, (byte)1, true);
        this.class_bands = this.all_bands.newMultiBand("(class_bands)", DELTA5);
        this.class_this = this.class_bands.newCPRefBand("class_this", (byte)7);
        this.class_super = this.class_bands.newCPRefBand("class_super", (byte)7);
        this.class_interface_count = this.class_bands.newIntBand("class_interface_count");
        this.class_interface = this.class_bands.newCPRefBand("class_interface", (byte)7);
        this.class_field_count = this.class_bands.newIntBand("class_field_count");
        this.class_method_count = this.class_bands.newIntBand("class_method_count");
        this.field_descr = this.class_bands.newCPRefBand("field_descr", (byte)12);
        this.field_attr_bands = this.class_bands.newMultiBand("(field_attr_bands)", UNSIGNED5);
        this.field_flags_hi = this.field_attr_bands.newIntBand("field_flags_hi");
        this.field_flags_lo = this.field_attr_bands.newIntBand("field_flags_lo");
        this.field_attr_count = this.field_attr_bands.newIntBand("field_attr_count");
        this.field_attr_indexes = this.field_attr_bands.newIntBand("field_attr_indexes");
        this.field_attr_calls = this.field_attr_bands.newIntBand("field_attr_calls");
        this.field_ConstantValue_KQ = this.field_attr_bands.newCPRefBand("field_ConstantValue_KQ", (byte)20);
        this.field_Signature_RS = this.field_attr_bands.newCPRefBand("field_Signature_RS", (byte)13);
        this.field_metadata_bands = this.field_attr_bands.newMultiBand("(field_metadata_bands)", UNSIGNED5);
        this.method_descr = this.class_bands.newCPRefBand("method_descr", MDELTA5, (byte)12);
        this.method_attr_bands = this.class_bands.newMultiBand("(method_attr_bands)", UNSIGNED5);
        this.method_flags_hi = this.method_attr_bands.newIntBand("method_flags_hi");
        this.method_flags_lo = this.method_attr_bands.newIntBand("method_flags_lo");
        this.method_attr_count = this.method_attr_bands.newIntBand("method_attr_count");
        this.method_attr_indexes = this.method_attr_bands.newIntBand("method_attr_indexes");
        this.method_attr_calls = this.method_attr_bands.newIntBand("method_attr_calls");
        this.method_Exceptions_N = this.method_attr_bands.newIntBand("method_Exceptions_N");
        this.method_Exceptions_RC = this.method_attr_bands.newCPRefBand("method_Exceptions_RC", (byte)7);
        this.method_Signature_RS = this.method_attr_bands.newCPRefBand("method_Signature_RS", (byte)13);
        this.method_metadata_bands = this.method_attr_bands.newMultiBand("(method_metadata_bands)", UNSIGNED5);
        this.class_attr_bands = this.class_bands.newMultiBand("(class_attr_bands)", UNSIGNED5);
        this.class_flags_hi = this.class_attr_bands.newIntBand("class_flags_hi");
        this.class_flags_lo = this.class_attr_bands.newIntBand("class_flags_lo");
        this.class_attr_count = this.class_attr_bands.newIntBand("class_attr_count");
        this.class_attr_indexes = this.class_attr_bands.newIntBand("class_attr_indexes");
        this.class_attr_calls = this.class_attr_bands.newIntBand("class_attr_calls");
        this.class_SourceFile_RUN = this.class_attr_bands.newCPRefBand("class_SourceFile_RUN", UNSIGNED5, (byte)1, true);
        this.class_EnclosingMethod_RC = this.class_attr_bands.newCPRefBand("class_EnclosingMethod_RC", (byte)7);
        this.class_EnclosingMethod_RDN = this.class_attr_bands.newCPRefBand("class_EnclosingMethod_RDN", UNSIGNED5, (byte)12, true);
        this.class_Signature_RS = this.class_attr_bands.newCPRefBand("class_Signature_RS", (byte)13);
        this.class_metadata_bands = this.class_attr_bands.newMultiBand("(class_metadata_bands)", UNSIGNED5);
        this.class_InnerClasses_N = this.class_attr_bands.newIntBand("class_InnerClasses_N");
        this.class_InnerClasses_RC = this.class_attr_bands.newCPRefBand("class_InnerClasses_RC", (byte)7);
        this.class_InnerClasses_F = this.class_attr_bands.newIntBand("class_InnerClasses_F");
        this.class_InnerClasses_outer_RCN = this.class_attr_bands.newCPRefBand("class_InnerClasses_outer_RCN", UNSIGNED5, (byte)7, true);
        this.class_InnerClasses_name_RUN = this.class_attr_bands.newCPRefBand("class_InnerClasses_name_RUN", UNSIGNED5, (byte)1, true);
        this.class_ClassFile_version_minor_H = this.class_attr_bands.newIntBand("class_ClassFile_version_minor_H");
        this.class_ClassFile_version_major_H = this.class_attr_bands.newIntBand("class_ClassFile_version_major_H");
        this.code_bands = this.class_bands.newMultiBand("(code_bands)", UNSIGNED5);
        this.code_headers = this.code_bands.newByteBand("code_headers");
        this.code_max_stack = this.code_bands.newIntBand("code_max_stack", UNSIGNED5);
        this.code_max_na_locals = this.code_bands.newIntBand("code_max_na_locals", UNSIGNED5);
        this.code_handler_count = this.code_bands.newIntBand("code_handler_count", UNSIGNED5);
        this.code_handler_start_P = this.code_bands.newIntBand("code_handler_start_P", BCI5);
        this.code_handler_end_PO = this.code_bands.newIntBand("code_handler_end_PO", BRANCH5);
        this.code_handler_catch_PO = this.code_bands.newIntBand("code_handler_catch_PO", BRANCH5);
        this.code_handler_class_RCN = this.code_bands.newCPRefBand("code_handler_class_RCN", UNSIGNED5, (byte)7, true);
        this.code_attr_bands = this.class_bands.newMultiBand("(code_attr_bands)", UNSIGNED5);
        this.code_flags_hi = this.code_attr_bands.newIntBand("code_flags_hi");
        this.code_flags_lo = this.code_attr_bands.newIntBand("code_flags_lo");
        this.code_attr_count = this.code_attr_bands.newIntBand("code_attr_count");
        this.code_attr_indexes = this.code_attr_bands.newIntBand("code_attr_indexes");
        this.code_attr_calls = this.code_attr_bands.newIntBand("code_attr_calls");
        this.code_LineNumberTable_N = this.code_attr_bands.newIntBand("code_LineNumberTable_N");
        this.code_LineNumberTable_bci_P = this.code_attr_bands.newIntBand("code_LineNumberTable_bci_P", BCI5);
        this.code_LineNumberTable_line = this.code_attr_bands.newIntBand("code_LineNumberTable_line");
        this.code_LocalVariableTable_N = this.code_attr_bands.newIntBand("code_LocalVariableTable_N");
        this.code_LocalVariableTable_bci_P = this.code_attr_bands.newIntBand("code_LocalVariableTable_bci_P", BCI5);
        this.code_LocalVariableTable_span_O = this.code_attr_bands.newIntBand("code_LocalVariableTable_span_O", BRANCH5);
        this.code_LocalVariableTable_name_RU = this.code_attr_bands.newCPRefBand("code_LocalVariableTable_name_RU", (byte)1);
        this.code_LocalVariableTable_type_RS = this.code_attr_bands.newCPRefBand("code_LocalVariableTable_type_RS", (byte)13);
        this.code_LocalVariableTable_slot = this.code_attr_bands.newIntBand("code_LocalVariableTable_slot");
        this.code_LocalVariableTypeTable_N = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_N");
        this.code_LocalVariableTypeTable_bci_P = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_bci_P", BCI5);
        this.code_LocalVariableTypeTable_span_O = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_span_O", BRANCH5);
        this.code_LocalVariableTypeTable_name_RU = this.code_attr_bands.newCPRefBand("code_LocalVariableTypeTable_name_RU", (byte)1);
        this.code_LocalVariableTypeTable_type_RS = this.code_attr_bands.newCPRefBand("code_LocalVariableTypeTable_type_RS", (byte)13);
        this.code_LocalVariableTypeTable_slot = this.code_attr_bands.newIntBand("code_LocalVariableTypeTable_slot");
        this.bc_bands = this.all_bands.newMultiBand("(byte_codes)", UNSIGNED5);
        this.bc_codes = this.bc_bands.newByteBand("bc_codes");
        this.bc_case_count = this.bc_bands.newIntBand("bc_case_count");
        this.bc_case_value = this.bc_bands.newIntBand("bc_case_value", DELTA5);
        this.bc_byte = this.bc_bands.newByteBand("bc_byte");
        this.bc_short = this.bc_bands.newIntBand("bc_short", DELTA5);
        this.bc_local = this.bc_bands.newIntBand("bc_local");
        this.bc_label = this.bc_bands.newIntBand("bc_label", BRANCH5);
        this.bc_intref = this.bc_bands.newCPRefBand("bc_intref", DELTA5, (byte)3);
        this.bc_floatref = this.bc_bands.newCPRefBand("bc_floatref", DELTA5, (byte)4);
        this.bc_longref = this.bc_bands.newCPRefBand("bc_longref", DELTA5, (byte)5);
        this.bc_doubleref = this.bc_bands.newCPRefBand("bc_doubleref", DELTA5, (byte)6);
        this.bc_stringref = this.bc_bands.newCPRefBand("bc_stringref", DELTA5, (byte)8);
        this.bc_classref = this.bc_bands.newCPRefBand("bc_classref", UNSIGNED5, (byte)7, true);
        this.bc_fieldref = this.bc_bands.newCPRefBand("bc_fieldref", DELTA5, (byte)9);
        this.bc_methodref = this.bc_bands.newCPRefBand("bc_methodref", (byte)10);
        this.bc_imethodref = this.bc_bands.newCPRefBand("bc_imethodref", DELTA5, (byte)11);
        this.bc_thisfield = this.bc_bands.newCPRefBand("bc_thisfield", (byte)0);
        this.bc_superfield = this.bc_bands.newCPRefBand("bc_superfield", (byte)0);
        this.bc_thismethod = this.bc_bands.newCPRefBand("bc_thismethod", (byte)0);
        this.bc_supermethod = this.bc_bands.newCPRefBand("bc_supermethod", (byte)0);
        this.bc_initref = this.bc_bands.newIntBand("bc_initref");
        this.bc_escref = this.bc_bands.newCPRefBand("bc_escref", (byte)19);
        this.bc_escrefsize = this.bc_bands.newIntBand("bc_escrefsize");
        this.bc_escsize = this.bc_bands.newIntBand("bc_escsize");
        this.bc_escbyte = this.bc_bands.newByteBand("bc_escbyte");
        this.file_bands = this.all_bands.newMultiBand("(file_bands)", UNSIGNED5);
        this.file_name = this.file_bands.newCPRefBand("file_name", (byte)1);
        this.file_size_hi = this.file_bands.newIntBand("file_size_hi");
        this.file_size_lo = this.file_bands.newIntBand("file_size_lo");
        this.file_modtime = this.file_bands.newIntBand("file_modtime", DELTA5);
        this.file_options = this.file_bands.newIntBand("file_options");
        this.file_bits = this.file_bands.newByteBand("file_bits");
        this.metadataBands = new MultiBand[4];
        this.metadataBands[0] = this.class_metadata_bands;
        this.metadataBands[1] = this.field_metadata_bands;
        this.metadataBands[2] = this.method_metadata_bands;
        this.attrIndexLimit = new int[4];
        this.attrFlagMask = new long[4];
        this.attrDefSeen = new long[4];
        this.attrOverflowMask = new int[4];
        this.attrBandTable = new HashMap();
        this.attrIndexTable = new HashMap();
        this.attrDefs = new ArrayList[4];
        for (n2 = 0; n2 < 4; ++n2) {
            assert (this.attrIndexLimit[n2] == 0);
            this.attrIndexLimit[n2] = 32;
            this.attrDefs[n2] = new ArrayList<Object>(Collections.nCopies(this.attrIndexLimit[n2], null));
        }
        this.attrInnerClassesEmpty = this.predefineAttribute(23, 0, null, "InnerClasses", "");
        assert (this.attrInnerClassesEmpty == Package.attrInnerClassesEmpty);
        this.predefineAttribute(17, 0, new Band[]{this.class_SourceFile_RUN}, "SourceFile", "RUNH");
        this.predefineAttribute(18, 0, new Band[]{this.class_EnclosingMethod_RC, this.class_EnclosingMethod_RDN}, "EnclosingMethod", "RCHRDNH");
        this.attrClassFileVersion = this.predefineAttribute(24, 0, new Band[]{this.class_ClassFile_version_minor_H, this.class_ClassFile_version_major_H}, ".ClassFile.version", "HH");
        this.predefineAttribute(19, 0, new Band[]{this.class_Signature_RS}, "Signature", "RSH");
        this.predefineAttribute(20, 0, null, "Deprecated", "");
        this.predefineAttribute(16, 0, null, ".Overflow", "");
        this.attrConstantValue = this.predefineAttribute(17, 1, new Band[]{this.field_ConstantValue_KQ}, "ConstantValue", "KQH");
        this.predefineAttribute(19, 1, new Band[]{this.field_Signature_RS}, "Signature", "RSH");
        this.predefineAttribute(20, 1, null, "Deprecated", "");
        this.predefineAttribute(16, 1, null, ".Overflow", "");
        this.attrCodeEmpty = this.predefineAttribute(17, 2, null, "Code", "");
        this.predefineAttribute(18, 2, new Band[]{this.method_Exceptions_N, this.method_Exceptions_RC}, "Exceptions", "NH[RCH]");
        assert (this.attrCodeEmpty == Package.attrCodeEmpty);
        this.predefineAttribute(19, 2, new Band[]{this.method_Signature_RS}, "Signature", "RSH");
        this.predefineAttribute(20, 2, null, "Deprecated", "");
        this.predefineAttribute(16, 2, null, ".Overflow", "");
        for (n2 = 0; n2 < 4; ++n2) {
            MultiBand multiBand = this.metadataBands[n2];
            if (multiBand == null) continue;
            this.predefineAttribute(21, ATTR_CONTEXT_NAME[n2] + "_RVA_", multiBand, Attribute.lookup(null, n2, "RuntimeVisibleAnnotations"));
            this.predefineAttribute(22, ATTR_CONTEXT_NAME[n2] + "_RIA_", multiBand, Attribute.lookup(null, n2, "RuntimeInvisibleAnnotations"));
            if (n2 != 2) continue;
            this.predefineAttribute(23, "method_RVPA_", multiBand, Attribute.lookup(null, n2, "RuntimeVisibleParameterAnnotations"));
            this.predefineAttribute(24, "method_RIPA_", multiBand, Attribute.lookup(null, n2, "RuntimeInvisibleParameterAnnotations"));
            this.predefineAttribute(25, "method_AD_", multiBand, Attribute.lookup(null, n2, "AnnotationDefault"));
        }
        this.predefineAttribute(1, 3, new Band[]{this.code_LineNumberTable_N, this.code_LineNumberTable_bci_P, this.code_LineNumberTable_line}, "LineNumberTable", "NH[PHH]");
        this.predefineAttribute(2, 3, new Band[]{this.code_LocalVariableTable_N, this.code_LocalVariableTable_bci_P, this.code_LocalVariableTable_span_O, this.code_LocalVariableTable_name_RU, this.code_LocalVariableTable_type_RS, this.code_LocalVariableTable_slot}, "LocalVariableTable", "NH[PHOHRUHRSHH]");
        this.predefineAttribute(3, 3, new Band[]{this.code_LocalVariableTypeTable_N, this.code_LocalVariableTypeTable_bci_P, this.code_LocalVariableTypeTable_span_O, this.code_LocalVariableTypeTable_name_RU, this.code_LocalVariableTypeTable_type_RS, this.code_LocalVariableTypeTable_slot}, "LocalVariableTypeTable", "NH[PHOHRUHRSHH]");
        this.predefineAttribute(16, 3, null, ".Overflow", "");
        for (n2 = 0; n2 < 4; ++n2) {
            this.attrDefSeen[n2] = 0L;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this.attrOverflowMask[n2] = 65536;
            this.attrIndexLimit[n2] = 0;
        }
        this.attrClassFileVersionMask = 0x1000000;
        this.attrBands = new MultiBand[4];
        this.attrBands[0] = this.class_attr_bands;
        this.attrBands[1] = this.field_attr_bands;
        this.attrBands[2] = this.method_attr_bands;
        this.attrBands[3] = this.code_attr_bands;
        this.shortCodeHeader_h_limit = shortCodeLimits.length;
        assert (this.isReader == bl2);
    }

    public static Coding codingForIndex(int n2) {
        return n2 < basicCodings.length ? basicCodings[n2] : null;
    }

    public static int indexOf(Coding coding) {
        Integer n2 = (Integer)basicCodingIndexes.get(coding);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public static Coding[] getBasicCodings() {
        return (Coding[])basicCodings.clone();
    }

    protected CodingMethod getBandHeader(int n2, Coding coding) {
        CodingMethod[] codingMethodArray = new CodingMethod[]{null};
        this.bandHeaderBytes[--this.bandHeaderBytePos] = (byte)n2;
        this.bandHeaderBytePos0 = this.bandHeaderBytePos;
        this.bandHeaderBytePos = BandStructure.parseMetaCoding(this.bandHeaderBytes, this.bandHeaderBytePos, coding, codingMethodArray);
        return codingMethodArray[0];
    }

    public static int parseMetaCoding(byte[] byArray, int n2, Coding coding, CodingMethod[] codingMethodArray) {
        if ((byArray[n2] & 0xFF) == 0) {
            codingMethodArray[0] = coding;
            return n2 + 1;
        }
        int n3 = Coding.parseMetaCoding(byArray, n2, coding, codingMethodArray);
        if (n3 > n2) {
            return n3;
        }
        n3 = PopulationCoding.parseMetaCoding(byArray, n2, coding, codingMethodArray);
        if (n3 > n2) {
            return n3;
        }
        n3 = AdaptiveCoding.parseMetaCoding(byArray, n2, coding, codingMethodArray);
        if (n3 > n2) {
            return n3;
        }
        throw new RuntimeException("Bad meta-coding op " + (byArray[n2] & 0xFF));
    }

    static boolean phaseIsRead(int n2) {
        return n2 % 2 == 0;
    }

    static int phaseCmp(int n2, int n3) {
        assert (n2 % 2 == n3 % 2 || n2 % 8 == 0 || n3 % 8 == 0);
        return n2 - n3;
    }

    static int getIntTotal(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 += nArray[i2];
        }
        return n2;
    }

    int encodeRef(ConstantPool.Entry entry, ConstantPool.Index index) {
        int n2 = index.indexOf(entry);
        if (this.verbose > 2) {
            Utils.log.fine("putRef " + n2 + " => " + entry);
        }
        return n2;
    }

    ConstantPool.Entry decodeRef(int n2, ConstantPool.Index index) {
        if (n2 < 0 || n2 >= index.size()) {
            Utils.log.warning("decoding bad ref " + n2 + " in " + index);
        }
        ConstantPool.Entry entry = index.getEntry(n2);
        if (this.verbose > 2) {
            Utils.log.fine("getRef " + n2 + " => " + entry);
        }
        return entry;
    }

    protected CodingChooser getCodingChooser() {
        if (this.codingChooser == null) {
            this.codingChooser = new CodingChooser(this.effort, basicCodings);
        }
        return this.codingChooser;
    }

    public CodingMethod chooseCoding(int[] nArray, int n2, int n3, Coding coding, String string, int[] nArray2) {
        assert (this.optVaryCodings);
        if (this.effort <= 1) {
            return coding;
        }
        CodingChooser codingChooser = this.getCodingChooser();
        if (this.verbose > 1 || codingChooser.verbose > 1) {
            Utils.log.fine("--- chooseCoding " + string);
        }
        return this.getCodingChooser().choose(nArray, n2, n3, coding, nArray2);
    }

    protected static int decodeEscapeValue(int n2, Coding coding) {
        if (coding.B() == 1 || coding.L() == 0) {
            return -1;
        }
        if (coding.S() != 0) {
            if (-256 <= n2 && n2 <= -1 && coding.min() <= -256) {
                int n3 = -1 - n2;
                assert (n3 >= 0 && n3 < 256);
                return n3;
            }
        } else {
            int n4 = coding.L();
            if (n4 <= n2 && n2 <= n4 + 255 && coding.max() >= n4 + 255) {
                int n5 = n2 - n4;
                assert (n5 >= 0 && n5 < 256);
                return n5;
            }
        }
        return -1;
    }

    protected static int encodeEscapeValue(int n2, Coding coding) {
        int n3;
        assert (n2 >= 0 && n2 < 256);
        assert (coding.B() > 1 && coding.L() > 0);
        if (coding.S() != 0) {
            assert (coding.min() <= -256);
            n3 = -1 - n2;
        } else {
            int n4 = coding.L();
            assert (coding.max() >= n4 + 255);
            n3 = n2 + n4;
        }
        assert (BandStructure.decodeEscapeValue(n3, coding) == n2) : coding + " XB=" + n2 + " X=" + n3;
        return n3;
    }

    void writeAllBandsTo(OutputStream outputStream) throws IOException {
        this.outputCounter = new ByteCounter(outputStream);
        outputStream = this.outputCounter;
        this.all_bands.writeTo(outputStream);
        if (this.verbose > 0) {
            long l2 = this.outputCounter.getCount();
            Utils.log.info("Wrote total of " + l2 + " bytes.");
            assert (l2 == this.archiveSize0 + this.archiveSize1);
        }
        this.outputCounter = null;
    }

    static IntBand getAttrBand(MultiBand multiBand, int n2) {
        IntBand intBand = (IntBand)multiBand.get(n2);
        switch (n2) {
            case 0: {
                assert (intBand.name().endsWith("_flags_hi"));
                break;
            }
            case 1: {
                assert (intBand.name().endsWith("_flags_lo"));
                break;
            }
            case 2: {
                assert (intBand.name().endsWith("_attr_count"));
                break;
            }
            case 3: {
                assert (intBand.name().endsWith("_attr_indexes"));
                break;
            }
            case 4: {
                assert (intBand.name().endsWith("_attr_calls"));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return intBand;
    }

    protected void setBandIndexes() {
        for (Object[] objectArray : this.needPredefIndex) {
            CPRefBand cPRefBand = (CPRefBand)objectArray[0];
            Byte by = (Byte)objectArray[1];
            cPRefBand.setIndex(this.getCPIndex(by));
        }
        this.needPredefIndex = null;
        if (this.verbose > 3) {
            BandStructure.printCDecl(this.all_bands);
        }
    }

    protected void setBandIndex(CPRefBand cPRefBand, byte by) {
        Object[] objectArray = new Object[]{cPRefBand, new Byte(by)};
        if (by == 20) {
            this.allKQBands.add(cPRefBand);
        } else if (this.needPredefIndex != null) {
            this.needPredefIndex.add(objectArray);
        } else {
            cPRefBand.setIndex(this.getCPIndex(by));
        }
    }

    protected void setConstantValueIndex(Package.Class.Field field) {
        ConstantPool.Index index = null;
        if (field != null) {
            byte by = field.getLiteralTag();
            index = this.getCPIndex(by);
            if (this.verbose > 2) {
                Utils.log.fine("setConstantValueIndex " + field + " " + ConstantPool.tagName(by) + " => " + index);
            }
            assert (index != null);
        }
        for (CPRefBand cPRefBand : this.allKQBands) {
            cPRefBand.setIndex(index);
        }
    }

    protected void initAttrIndexLimit() {
        for (int i2 = 0; i2 < 4; ++i2) {
            assert (this.attrIndexLimit[i2] == 0);
            int n2 = this.attrIndexLimit[i2] = this.haveFlagsHi(i2) ? 63 : 32;
            assert (this.attrDefs[i2].size() == 32);
            int n3 = this.attrIndexLimit[i2] - this.attrDefs[i2].size();
            this.attrDefs[i2].addAll(Collections.nCopies(n3, null));
        }
    }

    protected boolean haveFlagsHi(int n2) {
        int n3 = 1 << 9 + n2;
        switch (n2) {
            case 0: {
                assert (n3 == 512);
                break;
            }
            case 1: {
                assert (n3 == 1024);
                break;
            }
            case 2: {
                assert (n3 == 2048);
                break;
            }
            case 3: {
                assert (n3 == 4096);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return BandStructure.testBit(this.archiveOptions, n3);
    }

    protected ArrayList getPredefinedAttrs(int n2) {
        assert (this.attrIndexLimit[n2] != 0);
        ArrayList<Attribute.Layout> arrayList = new ArrayList<Attribute.Layout>(this.attrIndexLimit[n2]);
        for (int i2 = 0; i2 < this.attrIndexLimit[n2]; ++i2) {
            Attribute.Layout layout;
            if (BandStructure.testBit(this.attrDefSeen[n2], 1L << i2) || (layout = (Attribute.Layout)this.attrDefs[n2].get(i2)) == null) continue;
            assert (this.isPredefinedAttr(n2, i2));
            arrayList.add(layout);
        }
        return arrayList;
    }

    protected boolean isPredefinedAttr(int n2, int n3) {
        assert (this.attrIndexLimit[n2] != 0);
        if (n3 >= this.attrIndexLimit[n2]) {
            return false;
        }
        if (BandStructure.testBit(this.attrDefSeen[n2], 1L << n3)) {
            return false;
        }
        return this.attrDefs[n2].get(n3) != null;
    }

    protected void adjustSpecialAttrMasks() {
        this.attrClassFileVersionMask = (int)((long)this.attrClassFileVersionMask & (this.attrDefSeen[0] ^ 0xFFFFFFFFFFFFFFFFL));
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2 = i2;
            this.attrOverflowMask[n2] = (int)((long)this.attrOverflowMask[n2] & (this.attrDefSeen[i2] ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    protected Attribute makeClassFileVersionAttr(int n2, int n3) {
        byte[] byArray = new byte[]{(byte)(n2 >> 8), (byte)n2, (byte)(n3 >> 8), (byte)n3};
        return this.attrClassFileVersion.addContent(byArray);
    }

    protected short[] parseClassFileVersionAttr(Attribute attribute) {
        assert (attribute.layout() == this.attrClassFileVersion);
        assert (attribute.size() == 4);
        byte[] byArray = attribute.bytes();
        int n2 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        int n3 = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return new short[]{(short)n2, (short)n3};
    }

    private boolean assertBandOKForElems(Band[] bandArray, Attribute.Layout.Element[] elementArray) {
        for (int i2 = 0; i2 < elementArray.length; ++i2) {
            assert (this.assertBandOKForElem(bandArray, elementArray[i2]));
        }
        return true;
    }

    private boolean assertBandOKForElem(Band[] bandArray, Attribute.Layout.Element element) {
        Band band = null;
        if (element.bandIndex != -1) {
            band = bandArray[element.bandIndex];
        }
        Coding coding = UNSIGNED5;
        boolean bl2 = true;
        switch (element.kind) {
            case 1: {
                if (element.flagTest((byte)1)) {
                    coding = SIGNED5;
                    break;
                }
                if (element.len != 1) break;
                coding = BYTE1;
                break;
            }
            case 2: {
                if (!element.flagTest((byte)2)) {
                    coding = BCI5;
                    break;
                }
                coding = BRANCH5;
                break;
            }
            case 3: {
                coding = BRANCH5;
                break;
            }
            case 4: {
                if (element.len != 1) break;
                coding = BYTE1;
                break;
            }
            case 5: {
                if (element.len == 1) {
                    coding = BYTE1;
                }
                this.assertBandOKForElems(bandArray, element.body);
                break;
            }
            case 7: {
                if (element.flagTest((byte)1)) {
                    coding = SIGNED5;
                } else if (element.len == 1) {
                    coding = BYTE1;
                }
                this.assertBandOKForElems(bandArray, element.body);
                break;
            }
            case 8: {
                assert (band == null);
                this.assertBandOKForElems(bandArray, element.body);
                return true;
            }
            case 9: {
                assert (band == null);
                return true;
            }
            case 10: {
                assert (band == null);
                this.assertBandOKForElems(bandArray, element.body);
                return true;
            }
            case 6: {
                bl2 = false;
                assert (band instanceof CPRefBand);
                assert (((CPRefBand)band).nullOK == element.flagTest((byte)4));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (band.regularCoding == coding) : element + " // " + band;
        if (bl2) assert (band instanceof IntBand);
        return true;
    }

    private Attribute.Layout predefineAttribute(int n2, int n3, Band[] bandArray, String string, String string2) {
        Attribute.Layout layout = Attribute.find(n3, string, string2).layout();
        if (n2 >= 0) {
            this.setAttributeLayoutIndex(layout, n2);
        }
        if (bandArray == null) {
            bandArray = new Band[]{};
        }
        assert (this.attrBandTable.get(layout) == null);
        this.attrBandTable.put(layout, bandArray);
        assert (layout.bandCount == bandArray.length) : layout + " // " + Arrays.asList(bandArray);
        assert (this.assertBandOKForElems(bandArray, layout.elems));
        return layout;
    }

    private Attribute.Layout predefineAttribute(int n2, String string, MultiBand multiBand, Attribute attribute) {
        Attribute.Layout layout = attribute.layout();
        int n3 = layout.ctype();
        return this.predefineAttribute(n2, n3, this.makeNewAttributeBands(string, layout, multiBand), layout.name(), layout.layout());
    }

    void makeNewAttributeBands() {
        this.adjustSpecialAttrMasks();
        for (int i2 = 0; i2 < 4; ++i2) {
            String string = ATTR_CONTEXT_NAME[i2];
            MultiBand multiBand = this.attrBands[i2];
            long l2 = this.attrDefSeen[i2];
            assert ((l2 & (this.attrFlagMask[i2] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L);
            for (int i3 = 0; i3 < this.attrDefs[i2].size(); ++i3) {
                Attribute.Layout layout = (Attribute.Layout)this.attrDefs[i2].get(i3);
                if (layout == null || layout.bandCount == 0) continue;
                if (i3 < this.attrIndexLimit[i2] && !BandStructure.testBit(l2, 1L << i3)) {
                    assert (this.attrBandTable.get(layout) != null);
                    continue;
                }
                int n2 = multiBand.size();
                String string2 = string + "_" + layout.name() + "_";
                if (this.verbose > 1) {
                    Utils.log.fine("Making new bands for " + layout);
                }
                Band[] bandArray = this.makeNewAttributeBands(string2, layout, multiBand);
                assert (bandArray.length == layout.bandCount);
                Band[] bandArray2 = this.attrBandTable.put(layout, bandArray);
                if (bandArray2 == null) continue;
                for (int i4 = 0; i4 < bandArray2.length; ++i4) {
                    bandArray2[i4].doneWithUnusedBand();
                }
            }
        }
    }

    private Band[] makeNewAttributeBands(String string, Attribute.Layout layout, MultiBand multiBand) {
        int n2 = multiBand.size();
        this.makeNewAttributeBands(string, layout.elems, multiBand);
        int n3 = multiBand.size() - n2;
        Band[] bandArray = new Band[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            bandArray[i2] = multiBand.get(n2 + i2);
        }
        return bandArray;
    }

    private void makeNewAttributeBands(String string, Attribute.Layout.Element[] elementArray, MultiBand multiBand) {
        block12: for (int i2 = 0; i2 < elementArray.length; ++i2) {
            Band band;
            Attribute.Layout.Element element = elementArray[i2];
            String string2 = string + multiBand.size() + "_" + element.layout;
            int n2 = string2.indexOf(91);
            if (n2 > 0) {
                string2 = string2.substring(0, n2);
            }
            if ((n2 = string2.indexOf(40)) > 0) {
                string2 = string2.substring(0, n2);
            }
            if (string2.endsWith("H")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            switch (element.kind) {
                case 1: {
                    band = this.newElemBand(element, string2, multiBand);
                    break;
                }
                case 2: {
                    if (!element.flagTest((byte)2)) {
                        band = multiBand.newIntBand(string2, BCI5);
                        break;
                    }
                    band = multiBand.newIntBand(string2, BRANCH5);
                    break;
                }
                case 3: {
                    band = multiBand.newIntBand(string2, BRANCH5);
                    break;
                }
                case 4: {
                    assert (!element.flagTest((byte)1));
                    band = this.newElemBand(element, string2, multiBand);
                    break;
                }
                case 5: {
                    assert (!element.flagTest((byte)1));
                    band = this.newElemBand(element, string2, multiBand);
                    this.makeNewAttributeBands(string, element.body, multiBand);
                    break;
                }
                case 7: {
                    band = this.newElemBand(element, string2, multiBand);
                    this.makeNewAttributeBands(string, element.body, multiBand);
                    break;
                }
                case 8: {
                    if (element.flagTest((byte)8)) continue block12;
                    this.makeNewAttributeBands(string, element.body, multiBand);
                    continue block12;
                }
                case 6: {
                    byte by = element.refKind;
                    boolean bl2 = element.flagTest((byte)4);
                    band = multiBand.newCPRefBand(string2, UNSIGNED5, by, bl2);
                    break;
                }
                case 9: {
                    continue block12;
                }
                case 10: {
                    this.makeNewAttributeBands(string, element.body, multiBand);
                    continue block12;
                }
                default: {
                    assert (false);
                    continue block12;
                }
            }
            if (this.verbose <= 1) continue;
            Utils.log.fine("New attribute band " + band);
        }
    }

    private Band newElemBand(Attribute.Layout.Element element, String string, MultiBand multiBand) {
        if (element.flagTest((byte)1)) {
            return multiBand.newIntBand(string, SIGNED5);
        }
        if (element.len == 1) {
            return multiBand.newIntBand(string, BYTE1);
        }
        return multiBand.newIntBand(string, UNSIGNED5);
    }

    protected int setAttributeLayoutIndex(Attribute.Layout layout, int n2) {
        int n3 = layout.ctype;
        assert (-1 <= n2 && n2 < this.attrIndexLimit[n3]);
        ArrayList arrayList = this.attrDefs[n3];
        if (n2 == -1) {
            n2 = arrayList.size();
            arrayList.add(layout);
            if (this.verbose > 0) {
                Utils.log.info("Adding new attribute at " + layout + ": " + n2);
            }
            this.attrIndexTable.put(layout, new Integer(n2));
            return n2;
        }
        if (BandStructure.testBit(this.attrDefSeen[n3], 1L << n2)) {
            throw new RuntimeException("Multiple explicit definition at " + n2 + ": " + layout);
        }
        int n4 = n3;
        this.attrDefSeen[n4] = this.attrDefSeen[n4] | 1L << n2;
        assert (0 <= n2 && n2 < this.attrIndexLimit[n3]);
        if (this.verbose > (this.attrClassFileVersionMask == 0 ? 2 : 0)) {
            Utils.log.fine("Fixing new attribute at " + n2 + ": " + layout + (arrayList.get(n2) == null ? "" : "; replacing " + arrayList.get(n2)));
        }
        int n5 = n3;
        this.attrFlagMask[n5] = this.attrFlagMask[n5] | 1L << n2;
        this.attrIndexTable.put(arrayList.get(n2), null);
        arrayList.set(n2, layout);
        this.attrIndexTable.put(layout, new Integer(n2));
        return n2;
    }

    static int shortCodeHeader(Code code) {
        int n2 = code.max_stack;
        int n3 = code.max_locals;
        int n4 = code.handler_class.length;
        if (n4 >= shortCodeLimits.length) {
            return 0;
        }
        int n5 = code.getMethod().getArgumentSize();
        assert (n3 >= n5);
        if (n3 < n5) {
            return 0;
        }
        int n6 = n3 - n5;
        int n7 = shortCodeLimits[n4][0];
        int n8 = shortCodeLimits[n4][1];
        if (n2 >= n7 || n6 >= n8) {
            return 0;
        }
        int n9 = BandStructure.shortCodeHeader_h_base(n4);
        if ((n9 += n2 + n7 * n6) > 255) {
            return 0;
        }
        assert (BandStructure.shortCodeHeader_max_stack(n9) == n2);
        assert (BandStructure.shortCodeHeader_max_na_locals(n9) == n6);
        assert (BandStructure.shortCodeHeader_handler_count(n9) == n4);
        return n9;
    }

    static int shortCodeHeader_handler_count(int n2) {
        assert (n2 > 0 && n2 <= 255);
        int n3 = 0;
        while (n2 >= BandStructure.shortCodeHeader_h_base(n3 + 1)) {
            ++n3;
        }
        return n3;
    }

    static int shortCodeHeader_max_stack(int n2) {
        int n3 = BandStructure.shortCodeHeader_handler_count(n2);
        int n4 = shortCodeLimits[n3][0];
        return (n2 - BandStructure.shortCodeHeader_h_base(n3)) % n4;
    }

    static int shortCodeHeader_max_na_locals(int n2) {
        int n3 = BandStructure.shortCodeHeader_handler_count(n2);
        int n4 = shortCodeLimits[n3][0];
        return (n2 - BandStructure.shortCodeHeader_h_base(n3)) / n4;
    }

    private static int shortCodeHeader_h_base(int n2) {
        assert (n2 <= shortCodeLimits.length);
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = shortCodeLimits[i2][0];
            int n5 = shortCodeLimits[i2][1];
            n3 += n4 * n5;
        }
        return n3;
    }

    protected void putLabel(IntBand intBand, Code code, int n2, int n3) {
        intBand.putInt(code.encodeBCI(n3) - code.encodeBCI(n2));
    }

    protected int getLabel(IntBand intBand, Code code, int n2) {
        return code.decodeBCI(intBand.getInt() + code.encodeBCI(n2));
    }

    protected CPRefBand getCPRefOpBand(int n2) {
        switch (Instruction.getCPRefOpTag(n2)) {
            case 7: {
                return this.bc_classref;
            }
            case 9: {
                return this.bc_fieldref;
            }
            case 10: {
                return this.bc_methodref;
            }
            case 11: {
                return this.bc_imethodref;
            }
            case 20: {
                switch (n2) {
                    case 234: 
                    case 237: {
                        return this.bc_intref;
                    }
                    case 235: 
                    case 238: {
                        return this.bc_floatref;
                    }
                    case 20: {
                        return this.bc_longref;
                    }
                    case 239: {
                        return this.bc_doubleref;
                    }
                    case 18: 
                    case 19: {
                        return this.bc_stringref;
                    }
                    case 233: 
                    case 236: {
                        return this.bc_classref;
                    }
                }
            }
        }
        assert (false);
        return null;
    }

    protected CPRefBand selfOpRefBand(int n2) {
        boolean bl2;
        boolean bl3;
        assert (Instruction.isSelfLinkerOp(n2));
        int n3 = n2 - 202;
        boolean bl4 = bl3 = n3 >= 14;
        if (bl3) {
            n3 -= 14;
        }
        boolean bl5 = bl2 = n3 >= 7;
        if (bl2) {
            n3 -= 7;
        }
        int n4 = 178 + n3;
        boolean bl6 = Instruction.isFieldOp(n4);
        if (!bl3) {
            return bl6 ? this.bc_thisfield : this.bc_thismethod;
        }
        return bl6 ? this.bc_superfield : this.bc_supermethod;
    }

    static OutputStream getDumpStream(Band band, String string) throws IOException {
        return BandStructure.getDumpStream(band.name, band.seqForDebug, string, band);
    }

    static OutputStream getDumpStream(ConstantPool.Index index, String string) throws IOException {
        if (index.size() == 0) {
            return new ByteArrayOutputStream();
        }
        byte by = ConstantPool.TAG_ORDER[index.cpMap[0].tag];
        return BandStructure.getDumpStream(index.debugName, by, string, index);
    }

    static OutputStream getDumpStream(String string, int n2, String string2, Object object) throws IOException {
        if (dumpDir == null) {
            dumpDir = File.createTempFile("BD_", "", new File("."));
            dumpDir.delete();
            if (dumpDir.mkdir()) {
                Utils.log.info("Dumping bands to " + dumpDir);
            }
        }
        string = string.replace('(', ' ').replace(')', ' ');
        string = string.replace('/', ' ');
        string = string.replace('*', ' ');
        string = string.trim().replace(' ', '_');
        string = (10000 + n2 + "_" + string).substring(1);
        File file = new File(dumpDir, string + string2);
        Utils.log.info("Dumping " + object + " to " + file);
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    static boolean assertCanChangeLength(Band band) {
        switch (band.phase) {
            case 1: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    static boolean assertPhase(Band band, int n2) {
        if (band.phase() != n2) {
            Utils.log.warning("phase expected " + n2 + " was " + band.phase() + " in " + band);
            return false;
        }
        return true;
    }

    static int verbose() {
        return Utils.currentPropMap().getInteger("com.sun.java.util.jar.pack.verbose");
    }

    static boolean assertPhaseChangeOK(Band band, int n2, int n3) {
        switch (n2 * 10 + n3) {
            case 1: {
                assert (!band.isReader());
                assert (band.capacity() >= 0);
                assert (band.length() == 0);
                return true;
            }
            case 13: {
                return true;
            }
            case 38: {
                return true;
            }
            case 2: {
                assert (band.isReader());
                assert (band.capacity() < 0);
                return true;
            }
            case 24: {
                assert (Math.max(0, band.capacity()) >= band.valuesExpected());
                assert (band.length() <= 0);
                return true;
            }
            case 46: {
                assert (band.valuesRemainingForDebug() == band.length());
                return true;
            }
            case 68: {
                assert (BandStructure.assertDoneDisbursing(band));
                return true;
            }
        }
        if (n2 == n3) {
            Utils.log.warning("Already in phase " + n2);
        } else {
            Utils.log.warning("Unexpected phase " + n2 + " -> " + n3);
        }
        return false;
    }

    private static boolean assertDoneDisbursing(Band band) {
        int n2;
        if (band.phase != 6) {
            Utils.log.warning("assertDoneDisbursing: still in phase " + band.phase + ": " + band);
            if (BandStructure.verbose() <= 1) {
                return false;
            }
        }
        if ((n2 = band.valuesRemainingForDebug()) > 0) {
            Utils.log.warning("assertDoneDisbursing: " + n2 + " values left in " + band);
            if (BandStructure.verbose() <= 1) {
                return false;
            }
        }
        if (band instanceof MultiBand) {
            MultiBand multiBand = (MultiBand)band;
            for (int i2 = 0; i2 < multiBand.bandCount; ++i2) {
                Band band2 = multiBand.bands[i2];
                if (band2.phase == 8) continue;
                Utils.log.warning("assertDoneDisbursing: sub-band still in phase " + band2.phase + ": " + band2);
                if (BandStructure.verbose() > 1) continue;
                return false;
            }
        }
        return true;
    }

    private static void printCDecl(Band band) {
        Coding[] codingArray;
        if (band instanceof MultiBand) {
            MultiBand multiBand = (MultiBand)band;
            for (int i2 = 0; i2 < multiBand.bandCount; ++i2) {
                BandStructure.printCDecl(multiBand.bands[i2]);
            }
            return;
        }
        String string = "NULL";
        if (band instanceof CPRefBand && (codingArray = ((CPRefBand)band).index) != null) {
            string = "INDEX(" + codingArray.debugName + ")";
        }
        codingArray = new Coding[]{BYTE1, CHAR3, BCI5, BRANCH5, UNSIGNED5, UDELTA5, SIGNED5, DELTA5, MDELTA5};
        String[] stringArray = new String[]{"BYTE1", "CHAR3", "BCI5", "BRANCH5", "UNSIGNED5", "UDELTA5", "SIGNED5", "DELTA5", "MDELTA5"};
        Coding coding = band.regularCoding;
        int n2 = Arrays.asList(codingArray).indexOf(coding);
        String string2 = n2 >= 0 ? stringArray[n2] : "CODING" + coding.keyString();
        System.out.println("  BAND_INIT(\"" + band.name() + "\"" + ", " + string2 + ", " + string + "),");
    }

    boolean notePrevForAssert(Band band, Band band2) {
        if (this.prevForAssertMap == null) {
            this.prevForAssertMap = new HashMap();
        }
        this.prevForAssertMap.put(band, band2);
        return true;
    }

    private boolean assertReadyToReadFrom(Band band, InputStream inputStream) throws IOException {
        Band band2 = (Band)this.prevForAssertMap.get(band);
        if (band2 != null && BandStructure.phaseCmp(band2.phase(), 6) < 0) {
            Utils.log.warning("Previous band not done reading.");
            Utils.log.info("    Previous band: " + band2);
            Utils.log.info("        Next band: " + band);
            Thread.dumpStack();
            assert (this.verbose > 0);
        }
        String string = band.name;
        if (this.optDebugBands && !string.startsWith("(")) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = inputStream.read()) > 0) {
                stringBuffer.append((char)n2);
            }
            String string2 = stringBuffer.toString();
            if (!string2.equals(string)) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("Expected " + string + " but read: ");
                string2 = string2 + (char)n2;
                while (string2.length() < 10) {
                    string2 = string2 + (char)inputStream.read();
                }
                for (int i2 = 0; i2 < string2.length(); ++i2) {
                    stringBuffer2.append(string2.charAt(i2));
                }
                Utils.log.warning(stringBuffer2.toString());
                return false;
            }
        }
        return true;
    }

    private boolean assertValidCPRefs(CPRefBand cPRefBand) {
        if (cPRefBand.index == null) {
            return true;
        }
        int n2 = cPRefBand.index.size() + 1;
        for (int i2 = 0; i2 < cPRefBand.length(); ++i2) {
            int n3 = cPRefBand.valueAtForDebug(i2);
            if (n3 >= 0 && n3 < n2) continue;
            Utils.log.warning("CP ref out of range [" + i2 + "] = " + n3 + " in " + cPRefBand);
            return false;
        }
        return true;
    }

    private boolean assertReadyToWriteTo(Band band, OutputStream outputStream) throws IOException {
        Band band2 = (Band)this.prevForAssertMap.get(band);
        if (band2 != null && BandStructure.phaseCmp(band2.phase(), 8) < 0) {
            Utils.log.warning("Previous band not done writing.");
            Utils.log.info("    Previous band: " + band2);
            Utils.log.info("        Next band: " + band);
            Thread.dumpStack();
            assert (this.verbose > 0);
        }
        String string = band.name;
        if (this.optDebugBands && !string.startsWith("(")) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                outputStream.write((byte)string.charAt(i2));
            }
            outputStream.write(0);
        }
        return true;
    }

    protected static boolean testBit(int n2, int n3) {
        return (n2 & n3) != 0;
    }

    protected static int setBit(int n2, int n3, boolean bl2) {
        return bl2 ? n2 | n3 : n2 & ~n3;
    }

    protected static boolean testBit(long l2, long l3) {
        return (l2 & l3) != 0L;
    }

    protected static long setBit(long l2, long l3, boolean bl2) {
        return bl2 ? l2 | l3 : l2 & (l3 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static void printArrayTo(PrintStream printStream, int[] nArray, int n2, int n3) {
        int n4 = n3 - n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (i2 % 10 == 0) {
                printStream.println();
            } else {
                printStream.print(" ");
            }
            printStream.print(nArray[n2 + i2]);
        }
        printStream.println();
    }

    static void printArrayTo(PrintStream printStream, ConstantPool.Entry[] entryArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n3 - n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            String string = entryArray[n2 + i2].stringValue();
            stringBuffer.setLength(0);
            for (int i3 = 0; i3 < string.length(); ++i3) {
                char c2 = string.charAt(i3);
                if (c2 >= ' ' && c2 <= '~' && c2 != '\\') {
                    stringBuffer.append(c2);
                    continue;
                }
                if (c2 == '\n') {
                    stringBuffer.append("\\n");
                    continue;
                }
                if (c2 == '\t') {
                    stringBuffer.append("\\t");
                    continue;
                }
                if (c2 == '\r') {
                    stringBuffer.append("\\r");
                    continue;
                }
                stringBuffer.append("\\x" + Integer.toHexString(c2));
            }
            printStream.println(stringBuffer);
        }
    }

    protected static Object[] realloc(Object[] objectArray, int n2) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n2);
        System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(objectArray.length, n2));
        return objectArray2;
    }

    protected static Object[] realloc(Object[] objectArray) {
        return BandStructure.realloc(objectArray, Math.max(10, objectArray.length * 2));
    }

    protected static int[] realloc(int[] nArray, int n2) {
        if (n2 == 0) {
            return noInts;
        }
        if (nArray == null) {
            return new int[n2];
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n2));
        return nArray2;
    }

    protected static int[] realloc(int[] nArray) {
        return BandStructure.realloc(nArray, Math.max(10, nArray.length * 2));
    }

    protected static byte[] realloc(byte[] byArray, int n2) {
        if (n2 == 0) {
            return noBytes;
        }
        if (byArray == null) {
            return new byte[n2];
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n2));
        return byArray2;
    }

    protected static byte[] realloc(byte[] byArray) {
        return BandStructure.realloc(byArray, Math.max(10, byArray.length * 2));
    }

    static {
        Coding coding;
        int n2;
        BYTE1 = Coding.of(1, 256);
        CHAR3 = Coding.of(3, 128);
        BCI5 = Coding.of(5, 4);
        BRANCH5 = Coding.of(5, 4, 2);
        UNSIGNED5 = Coding.of(5, 64);
        UDELTA5 = UNSIGNED5.getDeltaCoding();
        SIGNED5 = Coding.of(5, 64, 1);
        DELTA5 = SIGNED5.getDeltaCoding();
        MDELTA5 = Coding.of(5, 64, 2).getDeltaCoding();
        basicCodings = new Coding[]{null, Coding.of(1, 256, 0), Coding.of(1, 256, 1), Coding.of(1, 256, 0).getDeltaCoding(), Coding.of(1, 256, 1).getDeltaCoding(), Coding.of(2, 256, 0), Coding.of(2, 256, 1), Coding.of(2, 256, 0).getDeltaCoding(), Coding.of(2, 256, 1).getDeltaCoding(), Coding.of(3, 256, 0), Coding.of(3, 256, 1), Coding.of(3, 256, 0).getDeltaCoding(), Coding.of(3, 256, 1).getDeltaCoding(), Coding.of(4, 256, 0), Coding.of(4, 256, 1), Coding.of(4, 256, 0).getDeltaCoding(), Coding.of(4, 256, 1).getDeltaCoding(), Coding.of(5, 4, 0), Coding.of(5, 4, 1), Coding.of(5, 4, 2), Coding.of(5, 16, 0), Coding.of(5, 16, 1), Coding.of(5, 16, 2), Coding.of(5, 32, 0), Coding.of(5, 32, 1), Coding.of(5, 32, 2), Coding.of(5, 64, 0), Coding.of(5, 64, 1), Coding.of(5, 64, 2), Coding.of(5, 128, 0), Coding.of(5, 128, 1), Coding.of(5, 128, 2), Coding.of(5, 4, 0).getDeltaCoding(), Coding.of(5, 4, 1).getDeltaCoding(), Coding.of(5, 4, 2).getDeltaCoding(), Coding.of(5, 16, 0).getDeltaCoding(), Coding.of(5, 16, 1).getDeltaCoding(), Coding.of(5, 16, 2).getDeltaCoding(), Coding.of(5, 32, 0).getDeltaCoding(), Coding.of(5, 32, 1).getDeltaCoding(), Coding.of(5, 32, 2).getDeltaCoding(), Coding.of(5, 64, 0).getDeltaCoding(), Coding.of(5, 64, 1).getDeltaCoding(), Coding.of(5, 64, 2).getDeltaCoding(), Coding.of(5, 128, 0).getDeltaCoding(), Coding.of(5, 128, 1).getDeltaCoding(), Coding.of(5, 128, 2).getDeltaCoding(), Coding.of(2, 192, 0), Coding.of(2, 224, 0), Coding.of(2, 240, 0), Coding.of(2, 248, 0), Coding.of(2, 252, 0), Coding.of(2, 8, 0).getDeltaCoding(), Coding.of(2, 8, 1).getDeltaCoding(), Coding.of(2, 16, 0).getDeltaCoding(), Coding.of(2, 16, 1).getDeltaCoding(), Coding.of(2, 32, 0).getDeltaCoding(), Coding.of(2, 32, 1).getDeltaCoding(), Coding.of(2, 64, 0).getDeltaCoding(), Coding.of(2, 64, 1).getDeltaCoding(), Coding.of(2, 128, 0).getDeltaCoding(), Coding.of(2, 128, 1).getDeltaCoding(), Coding.of(2, 192, 0).getDeltaCoding(), Coding.of(2, 192, 1).getDeltaCoding(), Coding.of(2, 224, 0).getDeltaCoding(), Coding.of(2, 224, 1).getDeltaCoding(), Coding.of(2, 240, 0).getDeltaCoding(), Coding.of(2, 240, 1).getDeltaCoding(), Coding.of(2, 248, 0).getDeltaCoding(), Coding.of(2, 248, 1).getDeltaCoding(), Coding.of(3, 192, 0), Coding.of(3, 224, 0), Coding.of(3, 240, 0), Coding.of(3, 248, 0), Coding.of(3, 252, 0), Coding.of(3, 8, 0).getDeltaCoding(), Coding.of(3, 8, 1).getDeltaCoding(), Coding.of(3, 16, 0).getDeltaCoding(), Coding.of(3, 16, 1).getDeltaCoding(), Coding.of(3, 32, 0).getDeltaCoding(), Coding.of(3, 32, 1).getDeltaCoding(), Coding.of(3, 64, 0).getDeltaCoding(), Coding.of(3, 64, 1).getDeltaCoding(), Coding.of(3, 128, 0).getDeltaCoding(), Coding.of(3, 128, 1).getDeltaCoding(), Coding.of(3, 192, 0).getDeltaCoding(), Coding.of(3, 192, 1).getDeltaCoding(), Coding.of(3, 224, 0).getDeltaCoding(), Coding.of(3, 224, 1).getDeltaCoding(), Coding.of(3, 240, 0).getDeltaCoding(), Coding.of(3, 240, 1).getDeltaCoding(), Coding.of(3, 248, 0).getDeltaCoding(), Coding.of(3, 248, 1).getDeltaCoding(), Coding.of(4, 192, 0), Coding.of(4, 224, 0), Coding.of(4, 240, 0), Coding.of(4, 248, 0), Coding.of(4, 252, 0), Coding.of(4, 8, 0).getDeltaCoding(), Coding.of(4, 8, 1).getDeltaCoding(), Coding.of(4, 16, 0).getDeltaCoding(), Coding.of(4, 16, 1).getDeltaCoding(), Coding.of(4, 32, 0).getDeltaCoding(), Coding.of(4, 32, 1).getDeltaCoding(), Coding.of(4, 64, 0).getDeltaCoding(), Coding.of(4, 64, 1).getDeltaCoding(), Coding.of(4, 128, 0).getDeltaCoding(), Coding.of(4, 128, 1).getDeltaCoding(), Coding.of(4, 192, 0).getDeltaCoding(), Coding.of(4, 192, 1).getDeltaCoding(), Coding.of(4, 224, 0).getDeltaCoding(), Coding.of(4, 224, 1).getDeltaCoding(), Coding.of(4, 240, 0).getDeltaCoding(), Coding.of(4, 240, 1).getDeltaCoding(), Coding.of(4, 248, 0).getDeltaCoding(), Coding.of(4, 248, 1).getDeltaCoding(), null};
        assert (basicCodings[0] == null);
        assert (basicCodings[1] != null);
        assert (basicCodings[115] != null);
        HashMap<Coding, Integer> hashMap = new HashMap<Coding, Integer>();
        for (n2 = 0; n2 < basicCodings.length; ++n2) {
            coding = basicCodings[n2];
            if (coding == null) continue;
            assert (n2 >= 1);
            assert (n2 <= 115);
            hashMap.put(coding, new Integer(n2));
        }
        basicCodingIndexes = hashMap;
        defaultMetaCoding = new byte[]{0};
        noMetaCoding = new byte[0];
        boolean bl2 = false;
        if (!$assertionsDisabled) {
            bl2 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl2) {
            for (n2 = 0; n2 < basicCodings.length; ++n2) {
                coding = basicCodings[n2];
                if (coding == null || coding.B() == 1 || coding.L() == 0) continue;
                for (int i2 = 0; i2 <= 255; ++i2) {
                    BandStructure.encodeEscapeValue(i2, coding);
                }
            }
        }
        shortCodeLimits = new int[][]{{12, 12}, {8, 8}, {7, 7}};
        noInts = new int[0];
        noBytes = new byte[0];
    }

    abstract class Band {
        private int phase = 0;
        private final String name;
        private int valuesExpected;
        protected long outputSize = -1L;
        public final Coding regularCoding;
        public final int seqForDebug;
        public int elementCountForDebug;
        protected int lengthForDebug = -1;

        protected Band(String string, Coding coding) {
            this.name = string;
            this.regularCoding = coding;
            this.seqForDebug = ++nextSeqForDebug;
            if (BandStructure.this.verbose > 2) {
                Utils.log.fine("Band " + this.seqForDebug + " is " + string);
            }
        }

        public Band init() {
            if (BandStructure.this.isReader) {
                this.readyToExpect();
            } else {
                this.readyToCollect();
            }
            return this;
        }

        boolean isReader() {
            return BandStructure.this.isReader;
        }

        int phase() {
            return this.phase;
        }

        String name() {
            return this.name;
        }

        public abstract int capacity();

        protected abstract void setCapacity(int var1);

        public abstract int length();

        protected abstract int valuesRemainingForDebug();

        public final int valuesExpected() {
            return this.valuesExpected;
        }

        public final void writeTo(OutputStream outputStream) throws IOException {
            assert (BandStructure.this.assertReadyToWriteTo(this, outputStream));
            this.setPhase(3);
            this.writeDataTo(outputStream);
            this.doneWriting();
        }

        abstract void chooseBandCodings() throws IOException;

        public final long outputSize() {
            if (this.outputSize >= 0L) {
                long l2 = this.outputSize;
                assert (l2 == this.computeOutputSize());
                return l2;
            }
            return this.computeOutputSize();
        }

        protected abstract long computeOutputSize();

        protected abstract void writeDataTo(OutputStream var1) throws IOException;

        void expectLength(int n2) {
            assert (BandStructure.assertPhase(this, 2));
            assert (this.valuesExpected == 0);
            assert (n2 >= 0);
            this.valuesExpected = n2;
        }

        void expectMoreLength(int n2) {
            assert (BandStructure.assertPhase(this, 2));
            this.valuesExpected += n2;
        }

        private void readyToCollect() {
            this.setCapacity(1);
            this.setPhase(1);
        }

        protected void doneWriting() {
            assert (BandStructure.assertPhase(this, 3));
            this.setPhase(8);
        }

        private void readyToExpect() {
            this.setPhase(2);
        }

        public final void readFrom(InputStream inputStream) throws IOException {
            assert (BandStructure.this.assertReadyToReadFrom(this, inputStream));
            this.setCapacity(this.valuesExpected());
            this.setPhase(4);
            this.readDataFrom(inputStream);
            this.readyToDisburse();
        }

        protected abstract void readDataFrom(InputStream var1) throws IOException;

        protected void readyToDisburse() {
            if (BandStructure.this.verbose > 1) {
                Utils.log.fine("readyToDisburse " + this);
            }
            this.setPhase(6);
        }

        public void doneDisbursing() {
            assert (BandStructure.assertPhase(this, 6));
            this.setPhase(8);
        }

        public final void doneWithUnusedBand() {
            assert (BandStructure.assertPhase(this, 2));
            assert (this.valuesExpected() == 0);
            this.setPhase(4);
            this.setPhase(6);
            this.setPhase(8);
        }

        protected void setPhase(int n2) {
            assert (BandStructure.assertPhaseChangeOK(this, this.phase, n2));
            this.phase = n2;
        }

        public String toString() {
            int n2 = this.lengthForDebug != -1 ? this.lengthForDebug : this.length();
            String string = this.name;
            if (n2 != 0) {
                string = string + "[" + n2 + "]";
            }
            if (this.elementCountForDebug != 0) {
                string = string + "(" + this.elementCountForDebug + ")";
            }
            return string;
        }
    }

    class ByteBand
    extends Band {
        private ByteArrayOutputStream bytes;
        private ByteArrayOutputStream bytesForDump;
        private InputStream in;

        public ByteBand(String string) {
            super(string, BYTE1);
        }

        public int capacity() {
            return this.bytes == null ? -1 : Integer.MAX_VALUE;
        }

        protected void setCapacity(int n2) {
            assert (this.bytes == null);
            this.bytes = new ByteArrayOutputStream(n2);
        }

        public void destroy() {
            this.lengthForDebug = this.length();
            this.bytes = null;
        }

        public int length() {
            return this.bytes == null ? -1 : this.bytes.size();
        }

        public void reset() {
            this.bytes.reset();
        }

        protected int valuesRemainingForDebug() {
            return this.bytes == null ? -1 : ((ByteArrayInputStream)this.in).available();
        }

        protected void chooseBandCodings() throws IOException {
            assert (BandStructure.decodeEscapeValue(this.regularCoding.min(), this.regularCoding) < 0);
            assert (BandStructure.decodeEscapeValue(this.regularCoding.max(), this.regularCoding) < 0);
        }

        protected long computeOutputSize() {
            return this.bytes.size();
        }

        public void writeDataTo(OutputStream outputStream) throws IOException {
            if (this.length() == 0) {
                return;
            }
            this.bytes.writeTo(outputStream);
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
            this.destroy();
        }

        private void dumpBand() throws IOException {
            assert (BandStructure.this.optDumpBands);
            OutputStream outputStream = BandStructure.getDumpStream(this, ".bnd");
            if (this.bytesForDump != null) {
                this.bytesForDump.writeTo(outputStream);
            } else {
                this.bytes.writeTo(outputStream);
            }
            outputStream.close();
        }

        public void readDataFrom(InputStream inputStream) throws IOException {
            int n2 = this.valuesExpected();
            if (n2 == 0) {
                return;
            }
            if (BandStructure.this.verbose > 1) {
                this.lengthForDebug = n2;
                Utils.log.fine("Reading band " + this);
                this.lengthForDebug = -1;
            }
            byte[] byArray = new byte[Math.min(n2, 16384)];
            while (n2 > 0) {
                int n3 = inputStream.read(byArray, 0, Math.min(n2, byArray.length));
                if (n3 < 0) {
                    throw new EOFException();
                }
                this.bytes.write(byArray, 0, n3);
                n2 -= n3;
            }
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
        }

        public void readyToDisburse() {
            this.in = new ByteArrayInputStream(this.bytes.toByteArray());
            super.readyToDisburse();
        }

        public void doneDisbursing() {
            super.doneDisbursing();
            if (BandStructure.this.optDumpBands && this.bytesForDump != null && this.bytesForDump.size() > 0) {
                try {
                    this.dumpBand();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            this.in = null;
            this.bytes = null;
            this.bytesForDump = null;
        }

        public void setInputStreamFrom(InputStream inputStream) throws IOException {
            assert (this.bytes == null);
            assert (BandStructure.this.assertReadyToReadFrom(this, inputStream));
            this.setPhase(4);
            this.in = inputStream;
            if (BandStructure.this.optDumpBands) {
                this.bytesForDump = new ByteArrayOutputStream();
                this.in = new FilterInputStream(inputStream){

                    public int read() throws IOException {
                        int n2 = this.in.read();
                        if (n2 >= 0) {
                            ByteBand.this.bytesForDump.write(n2);
                        }
                        return n2;
                    }

                    public int read(byte[] byArray, int n2, int n3) throws IOException {
                        int n4 = this.in.read(byArray, n2, n3);
                        if (n4 >= 0) {
                            ByteBand.this.bytesForDump.write(byArray, n2, n4);
                        }
                        return n4;
                    }
                };
            }
            super.readyToDisburse();
        }

        public OutputStream collectorStream() {
            assert (this.phase() == 1);
            assert (this.bytes != null);
            return this.bytes;
        }

        public InputStream getInputStream() {
            assert (this.phase() == 6);
            assert (this.in != null);
            return this.in;
        }

        public int getByte() throws IOException {
            int n2 = this.getInputStream().read();
            if (n2 < 0) {
                throw new EOFException();
            }
            return n2;
        }

        public void putByte(int n2) throws IOException {
            assert (n2 == (n2 & 0xFF));
            this.collectorStream().write(n2);
        }

        public String toString() {
            return "byte " + super.toString();
        }
    }

    private static class ByteCounter
    extends FilterOutputStream {
        private long count;

        public ByteCounter(OutputStream outputStream) {
            super(outputStream);
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long l2) {
            this.count = l2;
        }

        public void write(int n2) throws IOException {
            ++this.count;
            if (this.out != null) {
                this.out.write(n2);
            }
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.count += (long)n3;
            if (this.out != null) {
                this.out.write(byArray, n2, n3);
            }
        }

        public String toString() {
            return String.valueOf(this.getCount());
        }
    }

    class CPRefBand
    extends ValueBand {
        ConstantPool.Index index;
        boolean nullOK;

        public CPRefBand(String string, Coding coding, byte by, boolean bl2) {
            super(string, coding);
            this.nullOK = bl2;
            if (by != 0) {
                BandStructure.this.setBandIndex(this, by);
            }
        }

        public CPRefBand(String string, Coding coding, byte by) {
            this(string, coding, by, false);
        }

        public CPRefBand(String string, Coding coding, Object object) {
            this(string, coding, 0, false);
        }

        public void setIndex(ConstantPool.Index index) {
            this.index = index;
        }

        protected void readDataFrom(InputStream inputStream) throws IOException {
            super.readDataFrom(inputStream);
            assert (BandStructure.this.assertValidCPRefs(this));
        }

        public void putRef(ConstantPool.Entry entry) {
            assert (this.index != null);
            this.addValue(this.encodeRefOrNull(entry, this.index));
        }

        public void putRef(ConstantPool.Entry entry, ConstantPool.Index index) {
            assert (this.index == null);
            this.addValue(this.encodeRefOrNull(entry, index));
        }

        public void putRef(ConstantPool.Entry entry, byte by) {
            this.putRef(entry, BandStructure.this.getCPIndex(by));
        }

        public ConstantPool.Entry getRef() {
            if (this.index == null) {
                Utils.log.warning("No index for " + this);
            }
            assert (this.index != null);
            return this.decodeRefOrNull(this.getValue(), this.index);
        }

        public ConstantPool.Entry getRef(ConstantPool.Index index) {
            assert (this.index == null);
            return this.decodeRefOrNull(this.getValue(), index);
        }

        public ConstantPool.Entry getRef(byte by) {
            return this.getRef(BandStructure.this.getCPIndex(by));
        }

        private int encodeRefOrNull(ConstantPool.Entry entry, ConstantPool.Index index) {
            int n2 = entry == null ? -1 : BandStructure.this.encodeRef(entry, index);
            return (this.nullOK ? 1 : 0) + n2;
        }

        private ConstantPool.Entry decodeRefOrNull(int n2, ConstantPool.Index index) {
            int n3 = n2 - (this.nullOK ? 1 : 0);
            if (n3 == -1) {
                return null;
            }
            return BandStructure.this.decodeRef(n3, index);
        }
    }

    class IntBand
    extends ValueBand {
        public IntBand(String string, Coding coding) {
            super(string, coding);
        }

        public void putInt(int n2) {
            assert (this.phase() == 1);
            this.addValue(n2);
        }

        public int getInt() {
            return this.getValue();
        }

        public int getIntTotal() {
            assert (this.phase() == 6);
            assert (this.valuesRemainingForDebug() == this.length());
            int n2 = 0;
            for (int i2 = this.length(); i2 > 0; --i2) {
                n2 += this.getInt();
            }
            this.resetForSecondPass();
            return n2;
        }

        public int getIntCount(int n2) {
            assert (this.phase() == 6);
            assert (this.valuesRemainingForDebug() == this.length());
            int n3 = 0;
            for (int i2 = this.length(); i2 > 0; --i2) {
                if (this.getInt() != n2) continue;
                ++n3;
            }
            this.resetForSecondPass();
            return n3;
        }
    }

    class MultiBand
    extends Band {
        Band[] bands;
        int bandCount;
        private int cap;

        MultiBand(String string, Coding coding) {
            super(string, coding);
            this.bands = new Band[10];
            this.bandCount = 0;
            this.cap = -1;
        }

        public Band init() {
            super.init();
            this.setCapacity(0);
            if (this.phase() == 2) {
                this.setPhase(4);
                this.setPhase(6);
            }
            return this;
        }

        int size() {
            return this.bandCount;
        }

        Band get(int n2) {
            assert (n2 < this.bandCount);
            return this.bands[n2];
        }

        Band[] toArray() {
            return (Band[])BandStructure.realloc(this.bands, this.bandCount);
        }

        void add(Band band) {
            assert (this.bandCount == 0 || BandStructure.this.notePrevForAssert(band, this.bands[this.bandCount - 1]));
            if (this.bandCount == this.bands.length) {
                this.bands = (Band[])BandStructure.realloc(this.bands);
            }
            this.bands[this.bandCount++] = band;
        }

        ByteBand newByteBand(String string) {
            ByteBand byteBand = new ByteBand(string);
            byteBand.init();
            this.add(byteBand);
            return byteBand;
        }

        IntBand newIntBand(String string) {
            IntBand intBand = new IntBand(string, this.regularCoding);
            intBand.init();
            this.add(intBand);
            return intBand;
        }

        IntBand newIntBand(String string, Coding coding) {
            IntBand intBand = new IntBand(string, coding);
            intBand.init();
            this.add(intBand);
            return intBand;
        }

        MultiBand newMultiBand(String string, Coding coding) {
            MultiBand multiBand = new MultiBand(string, coding);
            multiBand.init();
            this.add(multiBand);
            return multiBand;
        }

        CPRefBand newCPRefBand(String string, byte by) {
            CPRefBand cPRefBand = new CPRefBand(string, this.regularCoding, by);
            cPRefBand.init();
            this.add(cPRefBand);
            return cPRefBand;
        }

        CPRefBand newCPRefBand(String string, Coding coding, byte by) {
            CPRefBand cPRefBand = new CPRefBand(string, coding, by);
            cPRefBand.init();
            this.add(cPRefBand);
            return cPRefBand;
        }

        CPRefBand newCPRefBand(String string, Coding coding, byte by, boolean bl2) {
            CPRefBand cPRefBand = new CPRefBand(string, coding, by, bl2);
            cPRefBand.init();
            this.add(cPRefBand);
            return cPRefBand;
        }

        int bandCount() {
            return this.bandCount;
        }

        public int capacity() {
            return this.cap;
        }

        public void setCapacity(int n2) {
            this.cap = n2;
        }

        public int length() {
            return 0;
        }

        public int valuesRemainingForDebug() {
            return 0;
        }

        protected void chooseBandCodings() throws IOException {
            for (int i2 = 0; i2 < this.bandCount; ++i2) {
                Band band = this.bands[i2];
                band.chooseBandCodings();
            }
        }

        protected long computeOutputSize() {
            long l2 = 0L;
            for (int i2 = 0; i2 < this.bandCount; ++i2) {
                Band band = this.bands[i2];
                long l3 = band.outputSize();
                assert (l3 >= 0L) : band;
                l2 += l3;
            }
            return l2;
        }

        protected void writeDataTo(OutputStream outputStream) throws IOException {
            long l2 = 0L;
            if (BandStructure.this.outputCounter != null) {
                l2 = BandStructure.this.outputCounter.getCount();
            }
            for (int i2 = 0; i2 < this.bandCount; ++i2) {
                Band band = this.bands[i2];
                band.writeTo(outputStream);
                if (BandStructure.this.outputCounter == null) continue;
                long l3 = BandStructure.this.outputCounter.getCount();
                long l4 = l3 - l2;
                l2 = l3;
                if ((BandStructure.this.verbose <= 0 || l4 <= 0L) && BandStructure.this.verbose <= 1) continue;
                Utils.log.info("  ...wrote " + l4 + " bytes from " + band);
            }
        }

        protected void readDataFrom(InputStream inputStream) throws IOException {
            assert (false);
            for (int i2 = 0; i2 < this.bandCount; ++i2) {
                Band band = this.bands[i2];
                band.readFrom(inputStream);
                if ((BandStructure.this.verbose <= 0 || band.length() <= 0) && BandStructure.this.verbose <= 1) continue;
                Utils.log.info("  ...read " + band);
            }
        }

        public String toString() {
            return "{" + this.bandCount() + " bands: " + super.toString() + "}";
        }
    }

    class ValueBand
    extends Band {
        private int[] values;
        private int length;
        private int valuesDisbursed;
        private CodingMethod bandCoding;
        private byte[] metaCoding;

        protected ValueBand(String string, Coding coding) {
            super(string, coding);
        }

        public int capacity() {
            return this.values == null ? -1 : this.values.length;
        }

        protected void setCapacity(int n2) {
            assert (this.length <= n2);
            if (n2 == -1) {
                this.values = null;
                return;
            }
            this.values = BandStructure.realloc(this.values, n2);
        }

        public int length() {
            return this.length;
        }

        protected int valuesRemainingForDebug() {
            return this.length - this.valuesDisbursed;
        }

        protected int valueAtForDebug(int n2) {
            return this.values[n2];
        }

        void patchValue(int n2, int n3) {
            assert (this == BandStructure.this.archive_header_S);
            assert (n2 == 0 || n2 == 1);
            assert (n2 < this.length);
            this.values[n2] = n3;
            this.outputSize = -1L;
        }

        protected void initializeValues(int[] nArray) {
            assert (BandStructure.assertCanChangeLength(this));
            assert (this.length == 0);
            this.values = nArray;
            this.length = nArray.length;
        }

        protected void addValue(int n2) {
            assert (BandStructure.assertCanChangeLength(this));
            if (this.length == this.values.length) {
                this.setCapacity(this.length < 1000 ? this.length * 10 : this.length * 2);
            }
            this.values[this.length++] = n2;
        }

        private boolean canVaryCoding() {
            if (!BandStructure.this.optVaryCodings) {
                return false;
            }
            if (this.length == 0) {
                return false;
            }
            if (this == BandStructure.this.archive_header_0) {
                return false;
            }
            if (this == BandStructure.this.archive_header_S) {
                return false;
            }
            if (this == BandStructure.this.archive_header_1) {
                return false;
            }
            return this.regularCoding.min() <= -256 || this.regularCoding.max() >= 256;
        }

        private boolean shouldVaryCoding() {
            assert (this.canVaryCoding());
            return BandStructure.this.effort >= 9 || this.length >= 100;
        }

        protected void chooseBandCodings() throws IOException {
            Object object;
            boolean bl2 = this.canVaryCoding();
            if (!bl2 || !this.shouldVaryCoding()) {
                if (this.regularCoding.canRepresent(this.values, 0, this.length)) {
                    this.bandCoding = this.regularCoding;
                } else {
                    assert (bl2);
                    if (BandStructure.this.verbose > 1) {
                        Utils.log.fine("regular coding fails in band " + this.name());
                    }
                    this.bandCoding = UNSIGNED5;
                }
                this.outputSize = -1L;
            } else {
                object = new int[]{0, 0};
                this.bandCoding = BandStructure.this.chooseCoding(this.values, 0, this.length, this.regularCoding, this.name(), (int[])object);
                this.outputSize = object[0];
                if (this.outputSize == 0L) {
                    this.outputSize = -1L;
                }
            }
            if (this.bandCoding != this.regularCoding) {
                this.metaCoding = this.bandCoding.getMetaCoding(this.regularCoding);
                if (BandStructure.this.verbose > 1) {
                    Utils.log.fine("alternate coding " + this + " " + this.bandCoding);
                }
            } else {
                this.metaCoding = bl2 && BandStructure.decodeEscapeValue(this.values[0], this.regularCoding) >= 0 ? defaultMetaCoding : noMetaCoding;
            }
            if (this.metaCoding.length > 0 && (BandStructure.this.verbose > 2 || BandStructure.this.verbose > 1 && this.metaCoding.length > 1)) {
                object = new StringBuffer();
                for (int i2 = 0; i2 < this.metaCoding.length; ++i2) {
                    if (i2 == 1) {
                        ((StringBuffer)object).append(" /");
                    }
                    ((StringBuffer)object).append(" ").append(this.metaCoding[i2] & 0xFF);
                }
                Utils.log.fine("   meta-coding " + object);
            }
            assert (this.outputSize < 0L || !(this.bandCoding instanceof Coding) || this.outputSize == (long)((Coding)this.bandCoding).getLength(this.values, 0, this.length)) : this.bandCoding + " : " + this.outputSize + " != " + ((Coding)this.bandCoding).getLength(this.values, 0, this.length) + " ?= " + BandStructure.this.getCodingChooser().computeByteSize(this.bandCoding, this.values, 0, this.length);
            if (this.metaCoding.length > 0) {
                if (this.outputSize >= 0L) {
                    this.outputSize += (long)this.computeEscapeSize();
                }
                for (int i3 = 1; i3 < this.metaCoding.length; ++i3) {
                    BandStructure.this.band_headers.putByte(this.metaCoding[i3] & 0xFF);
                }
            }
        }

        protected long computeOutputSize() {
            this.outputSize = BandStructure.this.getCodingChooser().computeByteSize(this.bandCoding, this.values, 0, this.length);
            assert (this.outputSize < Integer.MAX_VALUE);
            this.outputSize += (long)this.computeEscapeSize();
            return this.outputSize;
        }

        protected int computeEscapeSize() {
            if (this.metaCoding.length == 0) {
                return 0;
            }
            int n2 = this.metaCoding[0] & 0xFF;
            int n3 = BandStructure.encodeEscapeValue(n2, this.regularCoding);
            return this.regularCoding.setD(0).getLength(n3);
        }

        protected void writeDataTo(OutputStream outputStream) throws IOException {
            if (this.length == 0) {
                return;
            }
            long l2 = 0L;
            if (outputStream == BandStructure.this.outputCounter) {
                l2 = BandStructure.this.outputCounter.getCount();
            }
            if (this.metaCoding.length > 0) {
                int n2 = this.metaCoding[0] & 0xFF;
                int n3 = BandStructure.encodeEscapeValue(n2, this.regularCoding);
                this.regularCoding.setD(0).writeTo(outputStream, n3);
            }
            this.bandCoding.writeArrayTo(outputStream, this.values, 0, this.length);
            if (outputStream == BandStructure.this.outputCounter) {
                long l3 = BandStructure.this.outputCounter.getCount();
                assert (this.outputSize == BandStructure.this.outputCounter.getCount() - l2) : this.outputSize + " != " + BandStructure.this.outputCounter.getCount() + "-" + l2;
            }
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
        }

        protected void readDataFrom(InputStream inputStream) throws IOException {
            this.length = this.valuesExpected();
            if (this.length == 0) {
                return;
            }
            if (BandStructure.this.verbose > 1) {
                Utils.log.fine("Reading band " + this);
            }
            if (!this.canVaryCoding()) {
                this.bandCoding = this.regularCoding;
                this.metaCoding = noMetaCoding;
            } else {
                assert (inputStream.markSupported());
                inputStream.mark(5);
                int n2 = this.regularCoding.setD(0).readFrom(inputStream);
                int n3 = BandStructure.decodeEscapeValue(n2, this.regularCoding);
                if (n3 < 0) {
                    inputStream.reset();
                    n3 = 0;
                    this.bandCoding = this.regularCoding;
                    this.metaCoding = noMetaCoding;
                } else if (n3 == 0) {
                    this.bandCoding = this.regularCoding;
                    this.metaCoding = defaultMetaCoding;
                } else {
                    if (BandStructure.this.verbose > 2) {
                        Utils.log.fine("found X=" + n2 + " => XB=" + n3);
                    }
                    this.bandCoding = BandStructure.this.getBandHeader(n3, this.regularCoding);
                    int n4 = BandStructure.this.bandHeaderBytePos0;
                    int n5 = BandStructure.this.bandHeaderBytePos;
                    this.metaCoding = new byte[n5 - n4];
                    System.arraycopy(BandStructure.this.bandHeaderBytes, n4, this.metaCoding, 0, this.metaCoding.length);
                }
            }
            if (this.bandCoding != this.regularCoding && BandStructure.this.verbose > 1) {
                Utils.log.fine(this.name() + ": irregular coding " + this.bandCoding);
            }
            this.bandCoding.readArrayFrom(inputStream, this.values, 0, this.length);
            if (BandStructure.this.optDumpBands) {
                this.dumpBand();
            }
        }

        public void doneDisbursing() {
            super.doneDisbursing();
            this.values = null;
        }

        private void dumpBand() throws IOException {
            Object object;
            assert (BandStructure.this.optDumpBands);
            PrintStream printStream = new PrintStream(BandStructure.getDumpStream(this, ".txt"));
            String string = this.bandCoding == this.regularCoding ? "" : " irregular";
            printStream.print("# length=" + this.length + " size=" + this.outputSize() + string + " coding=" + this.bandCoding);
            if (this.metaCoding != noMetaCoding) {
                object = new StringBuffer();
                for (int i2 = 0; i2 < this.metaCoding.length; ++i2) {
                    if (i2 == 1) {
                        ((StringBuffer)object).append(" /");
                    }
                    ((StringBuffer)object).append(" ").append(this.metaCoding[i2] & 0xFF);
                }
                printStream.print(" //header: " + object);
            }
            BandStructure.printArrayTo(printStream, this.values, 0, this.length);
            printStream.close();
            object = BandStructure.getDumpStream(this, ".bnd");
            this.bandCoding.writeArrayTo((OutputStream)object, this.values, 0, this.length);
            ((OutputStream)object).close();
        }

        protected int getValue() {
            assert (this.phase() == 6);
            assert (this.valuesDisbursed < this.length);
            return this.values[this.valuesDisbursed++];
        }

        public void resetForSecondPass() {
            assert (this.phase() == 6);
            assert (this.valuesDisbursed == this.length());
            this.valuesDisbursed = 0;
        }
    }
}

