/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

class ClassReader
implements Constants {
    int verbose;
    Package pkg;
    Package.Class cls;
    long inPos;
    DataInputStream in;
    Map attrDefs;
    Map attrCommands;
    String unknownAttrCommand = "error";

    ClassReader(Package.Class clazz, InputStream inputStream) throws IOException {
        this.pkg = clazz.getPackage();
        this.cls = clazz;
        this.verbose = this.pkg.verbose;
        this.in = new DataInputStream(new FilterInputStream(inputStream){

            public int read(byte[] byArray, int n2, int n3) throws IOException {
                int n4 = super.read(byArray, n2, n3);
                if (n4 >= 0) {
                    ClassReader.this.inPos += (long)n4;
                }
                return n4;
            }

            public int read() throws IOException {
                int n2 = super.read();
                if (n2 >= 0) {
                    ++ClassReader.this.inPos;
                }
                return n2;
            }

            public long skip(long l2) throws IOException {
                long l3 = super.skip(l2);
                if (l3 >= 0L) {
                    ClassReader.this.inPos += l3;
                }
                return l3;
            }
        });
    }

    public void setAttrDefs(Map map) {
        this.attrDefs = map;
    }

    public void setAttrCommands(Map map) {
        this.attrCommands = map;
    }

    private void skip(int n2, String string) throws IOException {
        long l2;
        long l3;
        Utils.log.warning("skipping " + n2 + " bytes of " + string);
        for (l2 = 0L; l2 < (long)n2; l2 += l3) {
            l3 = this.in.skip((long)n2 - l2);
            assert (l3 > 0L);
        }
        assert (l2 == (long)n2);
    }

    private int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    private int readInt() throws IOException {
        return this.in.readInt();
    }

    private ConstantPool.Entry readRef() throws IOException {
        int n2 = this.in.readUnsignedShort();
        return n2 == 0 ? null : this.cls.cpMap[n2];
    }

    private ConstantPool.Entry readRef(byte by) throws IOException {
        ConstantPool.Entry entry = this.readRef();
        assert (entry != null);
        assert (entry.tagMatches(by));
        return entry;
    }

    private ConstantPool.Entry readRefOrNull(byte by) throws IOException {
        ConstantPool.Entry entry = this.readRef();
        assert (entry == null || entry.tagMatches(by));
        return entry;
    }

    private ConstantPool.Utf8Entry readUtf8Ref() throws IOException {
        return (ConstantPool.Utf8Entry)this.readRef((byte)1);
    }

    private ConstantPool.ClassEntry readClassRef() throws IOException {
        return (ConstantPool.ClassEntry)this.readRef((byte)7);
    }

    private ConstantPool.ClassEntry readClassRefOrNull() throws IOException {
        return (ConstantPool.ClassEntry)this.readRefOrNull((byte)7);
    }

    private ConstantPool.SignatureEntry readSignatureRef() throws IOException {
        ConstantPool.Entry entry = this.readRef((byte)1);
        return ConstantPool.getSignatureEntry(entry.stringValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read() throws IOException {
        boolean bl2 = false;
        try {
            this.readMagicNumbers();
            this.readConstantPool();
            this.readHeader();
            this.readMembers(false);
            this.readMembers(true);
            this.readAttributes(0, this.cls);
            this.cls.finishReading();
            assert (0 >= this.in.read(new byte[1]));
            bl2 = true;
        }
        finally {
            if (!bl2 && this.verbose > 0) {
                Utils.log.warning("Erroneous data at input offset " + this.inPos + " of " + this.cls.file);
            }
        }
    }

    void readMagicNumbers() throws IOException {
        this.cls.magic = this.in.readInt();
        if (this.cls.magic != -889275714) {
            throw new Attribute.FormatException("Bad magic number in class file " + Integer.toHexString(this.cls.magic), 0, "magic-number", "pass");
        }
        this.cls.minver = (short)this.readUnsignedShort();
        this.cls.majver = (short)this.readUnsignedShort();
        String string = this.checkVersion(this.cls.majver, this.cls.minver);
        if (string != null) {
            throw new Attribute.FormatException("classfile version too " + string + ": " + this.cls.majver + "." + this.cls.minver + " in " + this.cls.file, 0, "version", "pass");
        }
    }

    private String checkVersion(int n2, int n3) {
        if (n2 < this.pkg.min_class_majver || n2 == this.pkg.min_class_majver && n3 < this.pkg.min_class_minver) {
            return "small";
        }
        if (n2 > this.pkg.max_class_majver || n2 == this.pkg.max_class_majver && n3 > this.pkg.max_class_minver) {
            return "large";
        }
        return null;
    }

    void readConstantPool() throws IOException {
        int n2;
        int n3;
        int n4 = this.in.readUnsignedShort();
        int[] nArray = new int[n4 * 4];
        int n5 = 0;
        ConstantPool.Entry[] entryArray = new ConstantPool.Entry[n4];
        entryArray[0] = null;
        block15: for (n3 = 1; n3 < n4; ++n3) {
            n2 = this.in.readByte();
            switch (n2) {
                case 1: {
                    entryArray[n3] = ConstantPool.getUtf8Entry(this.in.readUTF());
                    continue block15;
                }
                case 3: {
                    Number number = new Integer(this.in.readInt());
                    entryArray[n3] = ConstantPool.getLiteralEntry(number);
                    continue block15;
                }
                case 4: {
                    Number number = new Float(this.in.readFloat());
                    entryArray[n3] = ConstantPool.getLiteralEntry(number);
                    continue block15;
                }
                case 5: {
                    Number number = new Long(this.in.readLong());
                    entryArray[n3] = ConstantPool.getLiteralEntry(number);
                    entryArray[++n3] = null;
                    continue block15;
                }
                case 6: {
                    Number number = new Double(this.in.readDouble());
                    entryArray[n3] = ConstantPool.getLiteralEntry(number);
                    entryArray[++n3] = null;
                    continue block15;
                }
                case 7: 
                case 8: {
                    nArray[n5++] = n3;
                    nArray[n5++] = n2;
                    nArray[n5++] = this.in.readUnsignedShort();
                    nArray[n5++] = -1;
                    continue block15;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    nArray[n5++] = n3;
                    nArray[n5++] = n2;
                    nArray[n5++] = this.in.readUnsignedShort();
                    nArray[n5++] = this.in.readUnsignedShort();
                    continue block15;
                }
                default: {
                    throw new IOException("Bad constant pool tag " + n2);
                }
            }
        }
        while (n5 > 0) {
            if (this.verbose > 3) {
                Utils.log.fine("CP fixups [" + n5 / 4 + "]");
            }
            n3 = n5;
            n5 = 0;
            n2 = 0;
            block17: while (n2 < n3) {
                int n6 = nArray[n2++];
                int n7 = nArray[n2++];
                int n8 = nArray[n2++];
                int n9 = nArray[n2++];
                if (this.verbose > 3) {
                    Utils.log.fine("  cp[" + n6 + "] = " + ConstantPool.tagName(n7) + "{" + n8 + "," + n9 + "}");
                }
                if (entryArray[n8] == null || n9 >= 0 && entryArray[n9] == null) {
                    nArray[n5++] = n6;
                    nArray[n5++] = n7;
                    nArray[n5++] = n8;
                    nArray[n5++] = n9;
                    continue;
                }
                switch (n7) {
                    case 7: {
                        entryArray[n6] = ConstantPool.getClassEntry(entryArray[n8].stringValue());
                        continue block17;
                    }
                    case 8: {
                        entryArray[n6] = ConstantPool.getStringEntry(entryArray[n8].stringValue());
                        continue block17;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        ConstantPool.ClassEntry classEntry = (ConstantPool.ClassEntry)entryArray[n8];
                        ConstantPool.DescriptorEntry descriptorEntry = (ConstantPool.DescriptorEntry)entryArray[n9];
                        entryArray[n6] = ConstantPool.getMemberEntry((byte)n7, classEntry, descriptorEntry);
                        continue block17;
                    }
                    case 12: {
                        ConstantPool.Utf8Entry utf8Entry = (ConstantPool.Utf8Entry)entryArray[n8];
                        ConstantPool.Utf8Entry utf8Entry2 = (ConstantPool.Utf8Entry)entryArray[n9];
                        entryArray[n6] = ConstantPool.getDescriptorEntry(utf8Entry, utf8Entry2);
                        continue block17;
                    }
                }
                assert (false);
            }
            assert (n5 < n3);
        }
        this.cls.cpMap = entryArray;
    }

    void readHeader() throws IOException {
        this.cls.flags = this.readUnsignedShort();
        this.cls.thisClass = this.readClassRef();
        this.cls.superClass = this.readClassRefOrNull();
        int n2 = this.readUnsignedShort();
        this.cls.interfaces = new ConstantPool.ClassEntry[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.cls.interfaces[i2] = this.readClassRef();
        }
    }

    void readMembers(boolean bl2) throws IOException {
        int n2 = this.readUnsignedShort();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.readMember(bl2);
        }
    }

    void readMember(boolean bl2) throws IOException {
        Package.Class.Member member;
        int n2 = this.readUnsignedShort();
        ConstantPool.Utf8Entry utf8Entry = this.readUtf8Ref();
        ConstantPool.SignatureEntry signatureEntry = this.readSignatureRef();
        ConstantPool.DescriptorEntry descriptorEntry = ConstantPool.getDescriptorEntry(utf8Entry, signatureEntry);
        if (!bl2) {
            Package.Class clazz = this.cls;
            clazz.getClass();
            member = new Package.Class.Field(clazz, n2, descriptorEntry);
        } else {
            Package.Class clazz = this.cls;
            clazz.getClass();
            member = new Package.Class.Method(clazz, n2, descriptorEntry);
        }
        this.readAttributes(!bl2 ? 1 : 2, member);
    }

    void readAttributes(int n2, Attribute.Holder holder) throws IOException {
        int n3 = this.readUnsignedShort();
        if (n3 == 0) {
            return;
        }
        if (this.verbose > 2) {
            Utils.log.fine("readAttributes " + holder + " [" + n3 + "]");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            boolean bl2;
            Object object;
            String string = this.readUtf8Ref().stringValue();
            int n4 = this.readInt();
            if (this.attrCommands != null) {
                object = Attribute.keyForLookup(n2, string);
                String string2 = (String)this.attrCommands.get(object);
                if (string2 == "pass") {
                    String string3 = "passing attribute bitwise in " + holder;
                    throw new Attribute.FormatException(string3, n2, string, string2);
                }
                if (string2 == "error") {
                    String string4 = "attribute not allowed in " + holder;
                    throw new Attribute.FormatException(string4, n2, string, string2);
                }
                if (string2 == "strip") {
                    this.skip(n4, string + " attribute in " + holder);
                    continue;
                }
            }
            if ((object = Attribute.lookup(Package.attrDefs, n2, string)) == null) {
                object = Attribute.lookup(this.attrDefs, n2, string);
            }
            if (object == null) {
                object = Attribute.lookup(null, n2, string);
            }
            if (object == null && n4 == 0) {
                object = Attribute.find(n2, string, "");
            }
            boolean bl3 = bl2 = n2 == 3 && (string.equals("StackMap") || string.equals("StackMapX"));
            if (bl2) {
                Code code = (Code)holder;
                if (code.max_stack >= 65536 || code.max_locals >= 65536 || code.getLength() >= 65536 || string.endsWith("X")) {
                    object = null;
                }
            }
            if (object == null) {
                if (bl2) {
                    String string5 = "unsupported StackMap variant in " + holder;
                    throw new Attribute.FormatException(string5, n2, string, "pass");
                }
                if (this.unknownAttrCommand == "strip") {
                    this.skip(n4, "unknown " + string + " attribute in " + holder);
                    continue;
                }
                String string6 = "unknown in " + holder;
                throw new Attribute.FormatException(string6, n2, string, this.unknownAttrCommand);
            }
            if (((Attribute)object).layout() == Package.attrCodeEmpty || ((Attribute)object).layout() == Package.attrInnerClassesEmpty) {
                long l2 = this.inPos;
                if (((Attribute)object).name() == "Code") {
                    Package.Class.Method method = (Package.Class.Method)holder;
                    method.code = new Code(method);
                    this.readCode(method.code);
                } else {
                    assert (holder == this.cls);
                    this.readInnerClasses(this.cls);
                }
                assert ((long)n4 == this.inPos - l2);
            } else if (n4 > 0) {
                byte[] byArray = new byte[n4];
                this.in.readFully(byArray);
                object = ((Attribute)object).addContent(byArray);
            }
            holder.addAttribute((Attribute)object);
            if (this.verbose <= 2) continue;
            Utils.log.fine("read " + object);
        }
    }

    void readCode(Code code) throws IOException {
        code.max_stack = this.readUnsignedShort();
        code.max_locals = this.readUnsignedShort();
        code.bytes = new byte[this.readInt()];
        this.in.readFully(code.bytes);
        int n2 = this.readUnsignedShort();
        code.setHandlerCount(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            code.handler_start[i2] = this.readUnsignedShort();
            code.handler_end[i2] = this.readUnsignedShort();
            code.handler_catch[i2] = this.readUnsignedShort();
            code.handler_class[i2] = this.readClassRefOrNull();
        }
        this.readAttributes(3, code);
    }

    void readInnerClasses(Package.Class clazz) throws IOException {
        int n2 = this.readUnsignedShort();
        ArrayList<Package.InnerClass> arrayList = new ArrayList<Package.InnerClass>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Package.InnerClass innerClass = new Package.InnerClass(this.readClassRef(), this.readClassRefOrNull(), (ConstantPool.Utf8Entry)this.readRefOrNull((byte)1), this.readUnsignedShort());
            arrayList.add(innerClass);
        }
        clazz.innerClasses = arrayList;
    }
}

