/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Fixups;
import com.sun.java.util.jar.pack.Instruction;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

class PackageReader
extends BandStructure {
    Package pkg;
    byte[] bytes;
    LimitedBuffer in;
    int[] tagCount = new int[14];
    int numFiles;
    int numAttrDefs;
    int numInnerClasses;
    int numClasses;
    static final int MAGIC_BYTES = 4;
    HashMap utf8Signatures;
    static final int NO_FLAGS_YET = 0;
    Comparator entryOutputOrder = new Comparator(){

        public int compare(Object object, Object object2) {
            ConstantPool.Entry entry = (ConstantPool.Entry)object;
            ConstantPool.Entry entry2 = (ConstantPool.Entry)object2;
            int n2 = PackageReader.this.getOutputIndex(entry);
            int n3 = PackageReader.this.getOutputIndex(entry2);
            if (n2 >= 0 && n3 >= 0) {
                return n2 - n3;
            }
            if (n2 == n3) {
                return entry.compareTo(entry2);
            }
            return n2 >= 0 ? -1 : 1;
        }
    };
    Code[] allCodes;
    List codesWithFlags;
    HashMap ldcRefMap = new HashMap();

    PackageReader(Package package_, InputStream inputStream) throws IOException {
        super(true);
        this.pkg = package_;
        this.in = new LimitedBuffer(inputStream);
    }

    void read() throws IOException {
        boolean bl2 = false;
        try {
            this.readFileHeader();
            this.readBandHeaders();
            this.readConstantPool();
            this.readAttrDefs();
            this.readInnerClasses();
            Package.Class[] classArray = this.readClasses();
            this.readByteCodes();
            this.readFiles();
            assert (this.archiveSize1 == 0L || this.in.atLimit());
            assert (this.archiveSize1 == 0L || this.in.getBytesServed() == this.archiveSize0 + this.archiveSize1);
            this.all_bands.doneDisbursing();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                this.reconstructClass(classArray[i2]);
            }
            bl2 = true;
        }
        catch (Exception exception) {
            Utils.log.log(Level.WARNING, "Error on input: " + exception, exception);
            if (this.verbose > 0) {
                Utils.log.info("Stream offsets: served=" + this.in.getBytesServed() + " buffered=" + this.in.buffered + " limit=" + this.in.limit);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("error unpacking", exception);
        }
    }

    void readFileHeader() throws IOException {
        this.readArchiveMagic();
        this.readArchiveHeader();
    }

    private int getMagicInt32() throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n2 <<= 8;
            n2 |= this.archive_magic.getByte() & 0xFF;
        }
        return n2;
    }

    void readArchiveMagic() throws IOException {
        this.in.setReadLimit(19L);
        this.archive_magic.expectLength(4);
        this.archive_magic.readFrom(this.in);
        this.pkg.magic = this.getMagicInt32();
        this.archive_magic.doneDisbursing();
    }

    void readArchiveHeader() throws IOException {
        assert (26 == 8 + ConstantPool.TAGS_IN_ORDER.length + 6);
        this.archive_header_0.expectLength(3);
        this.archive_header_0.readFrom(this.in);
        this.pkg.package_minver = this.archive_header_0.getInt();
        this.pkg.package_majver = this.archive_header_0.getInt();
        this.pkg.checkVersion();
        this.archiveOptions = this.archive_header_0.getInt();
        this.archive_header_0.doneDisbursing();
        boolean bl2 = PackageReader.testBit(this.archiveOptions, 1);
        boolean bl3 = PackageReader.testBit(this.archiveOptions, 16);
        boolean bl4 = PackageReader.testBit(this.archiveOptions, 2);
        this.initAttrIndexLimit();
        this.archive_header_S.expectLength(bl3 ? 2 : 0);
        this.archive_header_S.readFrom(this.in);
        if (bl3) {
            long l2 = this.archive_header_S.getInt();
            long l3 = this.archive_header_S.getInt();
            this.archiveSize1 = (l2 << 32) + (l3 << 32 >>> 32);
            this.in.setReadLimit(this.archiveSize1);
        } else {
            this.archiveSize1 = 0L;
            this.in.setReadLimit(-1L);
        }
        this.archive_header_S.doneDisbursing();
        this.archiveSize0 = this.in.getBytesServed();
        int n2 = 21;
        if (!bl3) {
            n2 -= 3;
        }
        if (!bl2) {
            n2 -= 2;
        }
        if (!bl4) {
            n2 -= 4;
        }
        assert (n2 >= 12);
        this.archive_header_1.expectLength(n2);
        this.archive_header_1.readFrom(this.in);
        if (bl3) {
            this.archiveNextCount = this.archive_header_1.getInt();
            this.pkg.default_modtime = this.archive_header_1.getInt();
            this.numFiles = this.archive_header_1.getInt();
        } else {
            this.archiveNextCount = 0;
            this.numFiles = 0;
        }
        if (bl2) {
            this.band_headers.expectLength(this.archive_header_1.getInt());
            this.numAttrDefs = this.archive_header_1.getInt();
        } else {
            this.band_headers.expectLength(0);
            this.numAttrDefs = 0;
        }
        this.readConstantPoolCounts(bl4);
        this.numInnerClasses = this.archive_header_1.getInt();
        this.pkg.default_class_minver = (short)this.archive_header_1.getInt();
        this.pkg.default_class_majver = (short)this.archive_header_1.getInt();
        this.numClasses = this.archive_header_1.getInt();
        this.archive_header_1.doneDisbursing();
        if (PackageReader.testBit(this.archiveOptions, 32)) {
            this.pkg.default_options |= 1;
        }
    }

    void readBandHeaders() throws IOException {
        this.band_headers.readFrom(this.in);
        this.bandHeaderBytePos = 1;
        this.bandHeaderBytes = new byte[this.bandHeaderBytePos + this.band_headers.length()];
        for (int i2 = this.bandHeaderBytePos; i2 < this.bandHeaderBytes.length; ++i2) {
            this.bandHeaderBytes[i2] = (byte)this.band_headers.getByte();
        }
        this.band_headers.doneDisbursing();
    }

    /*
     * Unable to fully structure code
     */
    void readConstantPoolCounts(boolean var1_1) throws IOException {
        block3: for (var2_2 = 0; var2_2 < ConstantPool.TAGS_IN_ORDER.length; ++var2_2) {
            var3_3 = ConstantPool.TAGS_IN_ORDER[var2_2];
            if (var1_1) ** GOTO lbl-1000
            switch (var3_3) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    continue block3;
                }
                default: lbl-1000:
                // 2 sources

                {
                    this.tagCount[var3_3] = this.archive_header_1.getInt();
                }
            }
        }
    }

    protected ConstantPool.Index getCPIndex(byte by) {
        return this.pkg.cp.getIndexByTag(by);
    }

    ConstantPool.Index initCPIndex(byte by, ConstantPool.Entry[] entryArray) {
        if (this.verbose > 3) {
            for (int i2 = 0; i2 < entryArray.length; ++i2) {
                Utils.log.fine("cp.add " + entryArray[i2]);
            }
        }
        ConstantPool.Index index = ConstantPool.makeIndex(ConstantPool.tagName(by), entryArray);
        if (this.verbose > 1) {
            Utils.log.fine("Read " + index);
        }
        this.pkg.cp.initIndexByTag(by, index);
        return index;
    }

    void readConstantPool() throws IOException {
        if (this.verbose > 0) {
            Utils.log.info("Reading CP");
        }
        for (int i2 = 0; i2 < ConstantPool.TAGS_IN_ORDER.length; ++i2) {
            byte by = ConstantPool.TAGS_IN_ORDER[i2];
            int n2 = this.tagCount[by];
            ConstantPool.Entry[] entryArray = new ConstantPool.Entry[n2];
            if (this.verbose > 0) {
                Utils.log.info("Reading " + entryArray.length + " " + ConstantPool.tagName(by) + " entries...");
            }
            switch (by) {
                case 1: {
                    this.readUtf8Bands(entryArray);
                    break;
                }
                case 3: {
                    this.cp_Int.expectLength(entryArray.length);
                    this.cp_Int.readFrom(this.in);
                    for (int i3 = 0; i3 < entryArray.length; ++i3) {
                        int n3 = this.cp_Int.getInt();
                        entryArray[i3] = ConstantPool.getLiteralEntry(new Integer(n3));
                    }
                    this.cp_Int.doneDisbursing();
                    break;
                }
                case 4: {
                    this.cp_Float.expectLength(entryArray.length);
                    this.cp_Float.readFrom(this.in);
                    for (int i4 = 0; i4 < entryArray.length; ++i4) {
                        int n4 = this.cp_Float.getInt();
                        float f2 = Float.intBitsToFloat(n4);
                        entryArray[i4] = ConstantPool.getLiteralEntry(new Float(f2));
                    }
                    this.cp_Float.doneDisbursing();
                    break;
                }
                case 5: {
                    long l2;
                    long l3;
                    this.cp_Long_hi.expectLength(entryArray.length);
                    this.cp_Long_hi.readFrom(this.in);
                    this.cp_Long_lo.expectLength(entryArray.length);
                    this.cp_Long_lo.readFrom(this.in);
                    for (int i5 = 0; i5 < entryArray.length; ++i5) {
                        long l4 = this.cp_Long_hi.getInt();
                        l3 = this.cp_Long_lo.getInt();
                        l2 = (l4 << 32) + (l3 << 32 >>> 32);
                        entryArray[i5] = ConstantPool.getLiteralEntry(new Long(l2));
                    }
                    this.cp_Long_hi.doneDisbursing();
                    this.cp_Long_lo.doneDisbursing();
                    break;
                }
                case 6: {
                    long l2;
                    long l3;
                    this.cp_Double_hi.expectLength(entryArray.length);
                    this.cp_Double_hi.readFrom(this.in);
                    this.cp_Double_lo.expectLength(entryArray.length);
                    this.cp_Double_lo.readFrom(this.in);
                    for (int i6 = 0; i6 < entryArray.length; ++i6) {
                        long l5 = this.cp_Double_hi.getInt();
                        l3 = this.cp_Double_lo.getInt();
                        l2 = (l5 << 32) + (l3 << 32 >>> 32);
                        double d2 = Double.longBitsToDouble(l2);
                        entryArray[i6] = ConstantPool.getLiteralEntry(new Double(d2));
                    }
                    this.cp_Double_hi.doneDisbursing();
                    this.cp_Double_lo.doneDisbursing();
                    break;
                }
                case 8: {
                    this.cp_String.expectLength(entryArray.length);
                    this.cp_String.readFrom(this.in);
                    this.cp_String.setIndex(this.getCPIndex((byte)1));
                    for (int i7 = 0; i7 < entryArray.length; ++i7) {
                        entryArray[i7] = ConstantPool.getLiteralEntry((Comparable)((Object)this.cp_String.getRef().stringValue()));
                    }
                    this.cp_String.doneDisbursing();
                    break;
                }
                case 7: {
                    this.cp_Class.expectLength(entryArray.length);
                    this.cp_Class.readFrom(this.in);
                    this.cp_Class.setIndex(this.getCPIndex((byte)1));
                    for (int i8 = 0; i8 < entryArray.length; ++i8) {
                        entryArray[i8] = ConstantPool.getClassEntry(this.cp_Class.getRef().stringValue());
                    }
                    this.cp_Class.doneDisbursing();
                    break;
                }
                case 13: {
                    this.readSignatureBands(entryArray);
                    break;
                }
                case 12: {
                    this.cp_Descr_name.expectLength(entryArray.length);
                    this.cp_Descr_name.readFrom(this.in);
                    this.cp_Descr_name.setIndex(this.getCPIndex((byte)1));
                    this.cp_Descr_type.expectLength(entryArray.length);
                    this.cp_Descr_type.readFrom(this.in);
                    this.cp_Descr_type.setIndex(this.getCPIndex((byte)13));
                    for (int i9 = 0; i9 < entryArray.length; ++i9) {
                        ConstantPool.Entry entry = this.cp_Descr_name.getRef();
                        ConstantPool.Entry entry2 = this.cp_Descr_type.getRef();
                        entryArray[i9] = ConstantPool.getDescriptorEntry((ConstantPool.Utf8Entry)entry, (ConstantPool.SignatureEntry)entry2);
                    }
                    this.cp_Descr_name.doneDisbursing();
                    this.cp_Descr_type.doneDisbursing();
                    break;
                }
                case 9: {
                    this.readMemberRefs(by, entryArray, this.cp_Field_class, this.cp_Field_desc);
                    break;
                }
                case 10: {
                    this.readMemberRefs(by, entryArray, this.cp_Method_class, this.cp_Method_desc);
                    break;
                }
                case 11: {
                    this.readMemberRefs(by, entryArray, this.cp_Imethod_class, this.cp_Imethod_desc);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ConstantPool.Index index = this.initCPIndex(by, entryArray);
            if (!this.optDumpBands) continue;
            PrintStream printStream = new PrintStream(PackageReader.getDumpStream(index, ".idx"));
            PackageReader.printArrayTo(printStream, index.cpMap, 0, index.cpMap.length);
            printStream.close();
        }
        this.cp_bands.doneDisbursing();
        this.setBandIndexes();
    }

    void readUtf8Bands(ConstantPool.Entry[] entryArray) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = entryArray.length;
        if (n6 == 0) {
            return;
        }
        this.cp_Utf8_prefix.expectLength(Math.max(0, n6 - 2));
        this.cp_Utf8_prefix.readFrom(this.in);
        this.cp_Utf8_suffix.expectLength(Math.max(0, n6 - 1));
        this.cp_Utf8_suffix.readFrom(this.in);
        char[][] cArrayArray = new char[n6][];
        int n7 = 0;
        this.cp_Utf8_chars.expectLength(this.cp_Utf8_suffix.getIntTotal());
        this.cp_Utf8_chars.readFrom(this.in);
        for (n5 = 0; n5 < n6; ++n5) {
            int n8 = n4 = n5 < 1 ? 0 : this.cp_Utf8_suffix.getInt();
            if (n4 == 0 && n5 >= 1) {
                ++n7;
                continue;
            }
            cArrayArray[n5] = new char[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = this.cp_Utf8_chars.getInt();
                assert (n2 == (char)n2);
                cArrayArray[n5][n3] = (char)n2;
            }
        }
        this.cp_Utf8_chars.doneDisbursing();
        n5 = 0;
        this.cp_Utf8_big_suffix.expectLength(n7);
        this.cp_Utf8_big_suffix.readFrom(this.in);
        this.cp_Utf8_suffix.resetForSecondPass();
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = n4 < 1 ? 0 : this.cp_Utf8_suffix.getInt();
            int n9 = n2 = n4 < 2 ? 0 : this.cp_Utf8_prefix.getInt();
            if (n3 == 0 && n4 >= 1) {
                assert (cArrayArray[n4] == null);
                n3 = this.cp_Utf8_big_suffix.getInt();
            } else assert (cArrayArray[n4] != null);
            if (n5 >= n2 + n3) continue;
            n5 = n2 + n3;
        }
        char[] cArray = new char[n5];
        this.cp_Utf8_suffix.resetForSecondPass();
        this.cp_Utf8_big_suffix.resetForSecondPass();
        for (n3 = 0; n3 < n6; ++n3) {
            if (n3 < 1 || (n2 = this.cp_Utf8_suffix.getInt()) != 0) continue;
            n2 = this.cp_Utf8_big_suffix.getInt();
            cArrayArray[n3] = new char[n2];
            if (n2 == 0) continue;
            BandStructure.IntBand intBand = this.cp_Utf8_big_chars.newIntBand("(Utf8_big_" + n3 + ")");
            intBand.expectLength(n2);
            intBand.readFrom(this.in);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n10 = intBand.getInt();
                assert (n10 == (char)n10);
                cArrayArray[n3][i2] = (char)n10;
            }
            intBand.doneDisbursing();
        }
        this.cp_Utf8_big_chars.doneDisbursing();
        this.cp_Utf8_prefix.resetForSecondPass();
        this.cp_Utf8_suffix.resetForSecondPass();
        this.cp_Utf8_big_suffix.resetForSecondPass();
        for (n3 = 0; n3 < n6; ++n3) {
            int n11;
            n2 = n3 < 2 ? 0 : this.cp_Utf8_prefix.getInt();
            int n12 = n11 = n3 < 1 ? 0 : this.cp_Utf8_suffix.getInt();
            if (n11 == 0 && n3 >= 1) {
                n11 = this.cp_Utf8_big_suffix.getInt();
            }
            System.arraycopy(cArrayArray[n3], 0, cArray, n2, n11);
            entryArray[n3] = ConstantPool.getUtf8Entry(new String(cArray, 0, n2 + n11));
        }
        this.cp_Utf8_prefix.doneDisbursing();
        this.cp_Utf8_suffix.doneDisbursing();
        this.cp_Utf8_big_suffix.doneDisbursing();
    }

    void readSignatureBands(ConstantPool.Entry[] entryArray) throws IOException {
        ConstantPool.Utf8Entry utf8Entry;
        int n2;
        this.cp_Signature_form.expectLength(entryArray.length);
        this.cp_Signature_form.readFrom(this.in);
        this.cp_Signature_form.setIndex(this.getCPIndex((byte)1));
        int[] nArray = new int[entryArray.length];
        for (n2 = 0; n2 < entryArray.length; ++n2) {
            utf8Entry = (ConstantPool.Utf8Entry)this.cp_Signature_form.getRef();
            nArray[n2] = ConstantPool.countClassParts(utf8Entry);
        }
        this.cp_Signature_form.resetForSecondPass();
        this.cp_Signature_classes.expectLength(PackageReader.getIntTotal(nArray));
        this.cp_Signature_classes.readFrom(this.in);
        this.cp_Signature_classes.setIndex(this.getCPIndex((byte)7));
        this.utf8Signatures = new HashMap();
        for (n2 = 0; n2 < entryArray.length; ++n2) {
            utf8Entry = (ConstantPool.Utf8Entry)this.cp_Signature_form.getRef();
            ConstantPool.ClassEntry[] classEntryArray = new ConstantPool.ClassEntry[nArray[n2]];
            for (int i2 = 0; i2 < classEntryArray.length; ++i2) {
                classEntryArray[i2] = (ConstantPool.ClassEntry)this.cp_Signature_classes.getRef();
            }
            ConstantPool.SignatureEntry signatureEntry = ConstantPool.getSignatureEntry(utf8Entry, classEntryArray);
            entryArray[n2] = signatureEntry;
            this.utf8Signatures.put(signatureEntry.asUtf8Entry(), signatureEntry);
        }
        this.cp_Signature_form.doneDisbursing();
        this.cp_Signature_classes.doneDisbursing();
    }

    void readMemberRefs(byte by, ConstantPool.Entry[] entryArray, BandStructure.CPRefBand cPRefBand, BandStructure.CPRefBand cPRefBand2) throws IOException {
        cPRefBand.expectLength(entryArray.length);
        cPRefBand.readFrom(this.in);
        cPRefBand.setIndex(this.getCPIndex((byte)7));
        cPRefBand2.expectLength(entryArray.length);
        cPRefBand2.readFrom(this.in);
        cPRefBand2.setIndex(this.getCPIndex((byte)12));
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            ConstantPool.ClassEntry classEntry = (ConstantPool.ClassEntry)cPRefBand.getRef();
            ConstantPool.DescriptorEntry descriptorEntry = (ConstantPool.DescriptorEntry)cPRefBand2.getRef();
            entryArray[i2] = ConstantPool.getMemberEntry(by, classEntry, descriptorEntry);
        }
        cPRefBand.doneDisbursing();
        cPRefBand2.doneDisbursing();
    }

    void readFiles() throws IOException {
        if (this.verbose > 0) {
            Utils.log.info("  ...building " + this.numFiles + " files...");
        }
        this.file_name.expectLength(this.numFiles);
        this.file_size_lo.expectLength(this.numFiles);
        int n2 = this.archiveOptions;
        boolean bl2 = PackageReader.testBit(n2, 256);
        boolean bl3 = PackageReader.testBit(n2, 64);
        boolean bl4 = PackageReader.testBit(n2, 128);
        if (bl2) {
            this.file_size_hi.expectLength(this.numFiles);
        }
        if (bl3) {
            this.file_modtime.expectLength(this.numFiles);
        }
        if (bl4) {
            this.file_options.expectLength(this.numFiles);
        }
        this.file_name.readFrom(this.in);
        this.file_size_hi.readFrom(this.in);
        this.file_size_lo.readFrom(this.in);
        this.file_modtime.readFrom(this.in);
        this.file_options.readFrom(this.in);
        this.file_bits.setInputStreamFrom(this.in);
        Iterator iterator = this.pkg.getClasses().iterator();
        long l2 = 0L;
        long[] lArray = new long[this.numFiles];
        for (int i2 = 0; i2 < this.numFiles; ++i2) {
            long l3 = (long)this.file_size_lo.getInt() << 32 >>> 32;
            if (bl2) {
                l3 += (long)this.file_size_hi.getInt() << 32;
            }
            lArray[i2] = l3;
            l2 += l3;
        }
        assert (this.in.getReadLimit() == -1L || this.in.getReadLimit() == l2);
        byte[] byArray = new byte[65536];
        for (int i3 = 0; i3 < this.numFiles; ++i3) {
            int n3;
            ConstantPool.Utf8Entry utf8Entry = (ConstantPool.Utf8Entry)this.file_name.getRef();
            long l4 = lArray[i3];
            Package package_ = this.pkg;
            package_.getClass();
            Package.File file = package_.new Package.File(utf8Entry);
            file.modtime = this.pkg.default_modtime;
            file.options = this.pkg.default_options;
            if (bl3) {
                file.modtime += this.file_modtime.getInt();
            }
            if (bl4) {
                file.options |= this.file_options.getInt();
            }
            if (this.verbose > 1) {
                Utils.log.fine("Reading " + l4 + " bytes of " + utf8Entry.stringValue());
            }
            for (long i4 = l4; i4 > 0L; i4 -= (long)n3) {
                n3 = byArray.length;
                if ((long)n3 > i4) {
                    n3 = (int)i4;
                }
                if ((n3 = this.file_bits.getInputStream().read(byArray, 0, n3)) < 0) {
                    throw new EOFException();
                }
                file.addBytes(byArray, 0, n3);
            }
            this.pkg.addFile(file);
            if (!file.isClassStub()) continue;
            assert (file.getFileLength() == 0L);
            Package.Class clazz = (Package.Class)iterator.next();
            clazz.initFile(file);
        }
        while (iterator.hasNext()) {
            Package.Class clazz = (Package.Class)iterator.next();
            clazz.initFile(null);
            clazz.file.modtime = this.pkg.default_modtime;
        }
        this.file_name.doneDisbursing();
        this.file_size_hi.doneDisbursing();
        this.file_size_lo.doneDisbursing();
        this.file_modtime.doneDisbursing();
        this.file_options.doneDisbursing();
        this.file_bits.doneDisbursing();
        this.file_bands.doneDisbursing();
        if (this.archiveSize1 != 0L && !this.in.atLimit()) {
            throw new RuntimeException("Predicted archive_size " + this.archiveSize1 + " != " + (this.in.getBytesServed() - this.archiveSize0));
        }
    }

    void readAttrDefs() throws IOException {
        this.attr_definition_headers.expectLength(this.numAttrDefs);
        this.attr_definition_name.expectLength(this.numAttrDefs);
        this.attr_definition_layout.expectLength(this.numAttrDefs);
        this.attr_definition_headers.readFrom(this.in);
        this.attr_definition_name.readFrom(this.in);
        this.attr_definition_layout.readFrom(this.in);
        PrintStream printStream = !this.optDumpBands ? null : new PrintStream(PackageReader.getDumpStream(this.attr_definition_headers, ".def"));
        for (int i2 = 0; i2 < this.numAttrDefs; ++i2) {
            int n2 = this.attr_definition_headers.getByte();
            ConstantPool.Utf8Entry utf8Entry = (ConstantPool.Utf8Entry)this.attr_definition_name.getRef();
            ConstantPool.Utf8Entry utf8Entry2 = (ConstantPool.Utf8Entry)this.attr_definition_layout.getRef();
            int n3 = n2 & 3;
            int n4 = (n2 >> 2) - 1;
            Attribute.Layout layout = new Attribute.Layout(n3, utf8Entry.stringValue(), utf8Entry2.stringValue());
            this.setAttributeLayoutIndex(layout, n4);
            if (printStream == null) continue;
            printStream.println(n4 + " " + layout);
        }
        if (printStream != null) {
            printStream.close();
        }
        this.attr_definition_headers.doneDisbursing();
        this.attr_definition_name.doneDisbursing();
        this.attr_definition_layout.doneDisbursing();
        this.makeNewAttributeBands();
        this.attr_definition_bands.doneDisbursing();
    }

    void readInnerClasses() throws IOException {
        int n2;
        int n3;
        this.ic_this_class.expectLength(this.numInnerClasses);
        this.ic_this_class.readFrom(this.in);
        this.ic_flags.expectLength(this.numInnerClasses);
        this.ic_flags.readFrom(this.in);
        int n4 = 0;
        for (int i2 = 0; i2 < this.numInnerClasses; ++i2) {
            n3 = this.ic_flags.getInt();
            int n5 = n2 = (n3 & 0x10000) != 0 ? 1 : 0;
            if (n2 == 0) continue;
            ++n4;
        }
        this.ic_outer_class.expectLength(n4);
        this.ic_outer_class.readFrom(this.in);
        this.ic_name.expectLength(n4);
        this.ic_name.readFrom(this.in);
        this.ic_flags.resetForSecondPass();
        ArrayList<Object> arrayList = new ArrayList<Object>(this.numInnerClasses);
        for (n3 = 0; n3 < this.numInnerClasses; ++n3) {
            Object object;
            ConstantPool.Utf8Entry utf8Entry;
            ConstantPool.ClassEntry classEntry;
            n2 = this.ic_flags.getInt();
            boolean bl2 = (n2 & 0x10000) != 0;
            n2 &= 0xFFFEFFFF;
            ConstantPool.ClassEntry classEntry2 = (ConstantPool.ClassEntry)this.ic_this_class.getRef();
            if (bl2) {
                classEntry = (ConstantPool.ClassEntry)this.ic_outer_class.getRef();
                utf8Entry = (ConstantPool.Utf8Entry)this.ic_name.getRef();
            } else {
                object = classEntry2.stringValue();
                String[] stringArray = Package.parseInnerClassName((String)object);
                assert (stringArray != null);
                String string = stringArray[0];
                String string2 = stringArray[2];
                classEntry = string == null ? null : ConstantPool.getClassEntry(string);
                utf8Entry = string2 == null ? null : ConstantPool.getUtf8Entry(string2);
            }
            object = new Package.InnerClass(classEntry2, classEntry, utf8Entry, n2);
            assert (bl2 || ((Package.InnerClass)object).predictable);
            arrayList.add(object);
        }
        this.ic_flags.doneDisbursing();
        this.ic_this_class.doneDisbursing();
        this.ic_outer_class.doneDisbursing();
        this.ic_name.doneDisbursing();
        this.pkg.setAllInnerClasses(arrayList);
        this.ic_bands.doneDisbursing();
    }

    void readLocalInnerClasses(Package.Class clazz) throws IOException {
        int n2 = this.class_InnerClasses_N.getInt();
        ArrayList<Package.InnerClass> arrayList = new ArrayList<Package.InnerClass>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Comparable comparable;
            ConstantPool.ClassEntry classEntry = (ConstantPool.ClassEntry)this.class_InnerClasses_RC.getRef();
            int n3 = this.class_InnerClasses_F.getInt();
            if (n3 == 0) {
                comparable = this.pkg.getGlobalInnerClass(classEntry);
                assert (comparable != null);
                arrayList.add((Package.InnerClass)comparable);
                continue;
            }
            if (n3 == 65536) {
                n3 = 0;
            }
            comparable = (ConstantPool.ClassEntry)this.class_InnerClasses_outer_RCN.getRef();
            ConstantPool.Utf8Entry utf8Entry = (ConstantPool.Utf8Entry)this.class_InnerClasses_name_RUN.getRef();
            arrayList.add(new Package.InnerClass(classEntry, (ConstantPool.ClassEntry)comparable, utf8Entry, n3));
        }
        clazz.setInnerClasses(arrayList);
    }

    Package.Class[] readClasses() throws IOException {
        Package.Class[] classArray = new Package.Class[this.numClasses];
        if (this.verbose > 0) {
            Utils.log.info("  ...building " + classArray.length + " classes...");
        }
        this.class_this.expectLength(this.numClasses);
        this.class_super.expectLength(this.numClasses);
        this.class_interface_count.expectLength(this.numClasses);
        this.class_this.readFrom(this.in);
        this.class_super.readFrom(this.in);
        this.class_interface_count.readFrom(this.in);
        this.class_interface.expectLength(this.class_interface_count.getIntTotal());
        this.class_interface.readFrom(this.in);
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Package.Class clazz;
            ConstantPool.ClassEntry classEntry = (ConstantPool.ClassEntry)this.class_this.getRef();
            ConstantPool.ClassEntry classEntry2 = (ConstantPool.ClassEntry)this.class_super.getRef();
            ConstantPool.ClassEntry[] classEntryArray = new ConstantPool.ClassEntry[this.class_interface_count.getInt()];
            for (int i3 = 0; i3 < classEntryArray.length; ++i3) {
                classEntryArray[i3] = (ConstantPool.ClassEntry)this.class_interface.getRef();
            }
            if (classEntry2 == classEntry) {
                classEntry2 = null;
            }
            Package package_ = this.pkg;
            package_.getClass();
            classArray[i2] = clazz = package_.new Package.Class(0, classEntry, classEntry2, classEntryArray);
        }
        this.class_this.doneDisbursing();
        this.class_super.doneDisbursing();
        this.class_interface_count.doneDisbursing();
        this.class_interface.doneDisbursing();
        this.readMembers(classArray);
        this.countAndReadAttrs(0, Arrays.asList(classArray));
        this.pkg.trimToSize();
        this.readCodeHeaders();
        return classArray;
    }

    private int getOutputIndex(ConstantPool.Entry entry) {
        assert (entry.tag != 13);
        int n2 = this.pkg.cp.untypedIndexOf(entry);
        if (n2 >= 0) {
            return n2;
        }
        if (entry.tag == 1) {
            ConstantPool.Entry entry2 = (ConstantPool.Entry)this.utf8Signatures.get(entry);
            return this.pkg.cp.untypedIndexOf(entry2);
        }
        return -1;
    }

    void reconstructClass(Package.Class clazz) {
        Attribute attribute;
        if (this.verbose > 1) {
            Utils.log.fine("reconstruct " + clazz);
        }
        if ((attribute = clazz.getAttribute(this.attrClassFileVersion)) != null) {
            clazz.removeAttribute(attribute);
            short[] sArray = this.parseClassFileVersionAttr(attribute);
            clazz.minver = sArray[0];
            clazz.majver = sArray[1];
        } else {
            clazz.minver = this.pkg.default_class_minver;
            clazz.majver = this.pkg.default_class_majver;
        }
        clazz.expandSourceFile();
        clazz.setCPMap(this.reconstructLocalCPMap(clazz));
    }

    ConstantPool.Entry[] reconstructLocalCPMap(Package.Class clazz) {
        ConstantPool.Entry entry;
        HashSet hashSet = (HashSet)this.ldcRefMap.get(clazz);
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        clazz.visitRefs(0, hashSet2);
        ConstantPool.completeReferencesIn(hashSet2, true);
        int n2 = clazz.expandLocalICs();
        if (n2 != 0) {
            if (n2 > 0) {
                clazz.visitInnerClassRefs(0, hashSet2);
            } else {
                hashSet2.clear();
                clazz.visitRefs(0, hashSet2);
            }
            ConstantPool.completeReferencesIn(hashSet2, true);
        }
        int n3 = 0;
        for (ConstantPool.Entry entry2 : hashSet2) {
            if (entry2.isDoubleWord()) {
                ++n3;
            }
            assert (entry2.tag != 13) : entry2;
        }
        ConstantPool.Entry[] entryArray = new ConstantPool.Entry[1 + n3 + hashSet2.size()];
        int n4 = 1;
        if (hashSet != null) {
            assert (hashSet2.containsAll(hashSet));
            for (ConstantPool.Entry entry3 : hashSet) {
                entryArray[n4++] = entry3;
            }
            assert (n4 == 1 + hashSet.size());
            hashSet2.removeAll(hashSet);
            hashSet = null;
        }
        HashSet hashSet4 = hashSet2;
        hashSet2 = null;
        int n5 = n4;
        Iterator iterator = hashSet4.iterator();
        while (iterator.hasNext()) {
            entry = (ConstantPool.Entry)iterator.next();
            entryArray[n4++] = entry;
        }
        assert (n4 == n5 + hashSet4.size());
        Arrays.sort(entryArray, 1, n5, this.entryOutputOrder);
        Arrays.sort(entryArray, n5, n4, this.entryOutputOrder);
        if (this.verbose > 3) {
            Utils.log.fine("CP of " + this + " {");
            for (int i2 = 0; i2 < n4; ++i2) {
                entry = entryArray[i2];
                Utils.log.fine("  " + (entry == null ? -1 : this.getOutputIndex(entry)) + " : " + entry);
            }
            Utils.log.fine("}");
        }
        int n6 = entryArray.length;
        int n7 = n4;
        while (--n7 >= 1) {
            ConstantPool.Entry entry4 = entryArray[n7];
            if (entry4.isDoubleWord()) {
                entryArray[--n6] = null;
            }
            entryArray[--n6] = entry4;
        }
        assert (n6 == 1);
        return entryArray;
    }

    void readMembers(Package.Class[] classArray) throws IOException {
        int n2;
        assert (classArray.length == this.numClasses);
        this.class_field_count.expectLength(this.numClasses);
        this.class_method_count.expectLength(this.numClasses);
        this.class_field_count.readFrom(this.in);
        this.class_method_count.readFrom(this.in);
        int n3 = this.class_field_count.getIntTotal();
        int n4 = this.class_method_count.getIntTotal();
        this.field_descr.expectLength(n3);
        this.method_descr.expectLength(n4);
        if (this.verbose > 1) {
            Utils.log.fine("expecting #fields=" + n3 + " and #methods=" + n4 + " in #classes=" + this.numClasses);
        }
        ArrayList<Package.Class.Field> arrayList = new ArrayList<Package.Class.Field>(n3);
        this.field_descr.readFrom(this.in);
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Package.Class clazz = classArray[i2];
            int n5 = this.class_field_count.getInt();
            for (n2 = 0; n2 < n5; ++n2) {
                Package.Class clazz2 = clazz;
                clazz2.getClass();
                Package.Class.Field field = clazz2.new Package.Class.Field(0, (ConstantPool.DescriptorEntry)this.field_descr.getRef());
                arrayList.add(field);
            }
        }
        this.class_field_count.doneDisbursing();
        this.field_descr.doneDisbursing();
        this.countAndReadAttrs(1, arrayList);
        arrayList = null;
        ArrayList<Package.Class.Method> arrayList2 = new ArrayList<Package.Class.Method>(n4);
        this.method_descr.readFrom(this.in);
        for (int i3 = 0; i3 < classArray.length; ++i3) {
            Package.Class clazz = classArray[i3];
            n2 = this.class_method_count.getInt();
            for (int i4 = 0; i4 < n2; ++i4) {
                Package.Class clazz3 = clazz;
                clazz3.getClass();
                Package.Class.Method method = clazz3.new Package.Class.Method(0, (ConstantPool.DescriptorEntry)this.method_descr.getRef());
                arrayList2.add(method);
            }
        }
        this.class_method_count.doneDisbursing();
        this.method_descr.doneDisbursing();
        this.countAndReadAttrs(2, arrayList2);
        this.allCodes = this.buildCodeAttrs(arrayList2);
    }

    Code[] buildCodeAttrs(List list) {
        ArrayList<Code> arrayList = new ArrayList<Code>(list.size());
        for (Package.Class.Method method : list) {
            if (method.getAttribute(this.attrCodeEmpty) == null) continue;
            method.code = new Code(method);
            arrayList.add(method.code);
        }
        Code[] codeArray = new Code[arrayList.size()];
        arrayList.toArray(codeArray);
        return codeArray;
    }

    void readCodeHeaders() throws IOException {
        boolean bl2 = PackageReader.testBit(this.archiveOptions, 4);
        this.code_headers.expectLength(this.allCodes.length);
        this.code_headers.readFrom(this.in);
        ArrayList<Code> arrayList = new ArrayList<Code>(this.allCodes.length / 10);
        for (int i2 = 0; i2 < this.allCodes.length; ++i2) {
            Code code = this.allCodes[i2];
            int n2 = this.code_headers.getByte();
            assert (n2 == (n2 & 0xFF));
            if (this.verbose > 2) {
                Utils.log.fine("codeHeader " + code + " = " + n2);
            }
            if (n2 == 0) {
                arrayList.add(code);
                continue;
            }
            code.setMaxStack(PackageReader.shortCodeHeader_max_stack(n2));
            code.setMaxNALocals(PackageReader.shortCodeHeader_max_na_locals(n2));
            code.setHandlerCount(PackageReader.shortCodeHeader_handler_count(n2));
            assert (PackageReader.shortCodeHeader(code) == n2);
        }
        this.code_headers.doneDisbursing();
        this.code_max_stack.expectLength(arrayList.size());
        this.code_max_na_locals.expectLength(arrayList.size());
        this.code_handler_count.expectLength(arrayList.size());
        this.code_max_stack.readFrom(this.in);
        this.code_max_na_locals.readFrom(this.in);
        this.code_handler_count.readFrom(this.in);
        for (Code code : arrayList) {
            code.setMaxStack(this.code_max_stack.getInt());
            code.setMaxNALocals(this.code_max_na_locals.getInt());
            code.setHandlerCount(this.code_handler_count.getInt());
        }
        this.code_max_stack.doneDisbursing();
        this.code_max_na_locals.doneDisbursing();
        this.code_handler_count.doneDisbursing();
        this.readCodeHandlers();
        this.codesWithFlags = bl2 ? Arrays.asList(this.allCodes) : arrayList;
        this.countAttrs(3, this.codesWithFlags);
    }

    void readCodeHandlers() throws IOException {
        int n2;
        int n3 = 0;
        for (int i2 = 0; i2 < this.allCodes.length; ++i2) {
            Code code = this.allCodes[i2];
            n3 += code.getHandlerCount();
        }
        BandStructure.ValueBand[] valueBandArray = new BandStructure.ValueBand[]{this.code_handler_start_P, this.code_handler_end_PO, this.code_handler_catch_PO, this.code_handler_class_RCN};
        for (n2 = 0; n2 < valueBandArray.length; ++n2) {
            valueBandArray[n2].expectLength(n3);
            valueBandArray[n2].readFrom(this.in);
        }
        for (n2 = 0; n2 < this.allCodes.length; ++n2) {
            Code code = this.allCodes[n2];
            int n4 = code.getHandlerCount();
            for (int i3 = 0; i3 < n4; ++i3) {
                code.handler_class[i3] = this.code_handler_class_RCN.getRef();
                code.handler_start[i3] = this.code_handler_start_P.getInt();
                code.handler_end[i3] = this.code_handler_end_PO.getInt();
                code.handler_catch[i3] = this.code_handler_catch_PO.getInt();
            }
        }
        for (n2 = 0; n2 < valueBandArray.length; ++n2) {
            valueBandArray[n2].doneDisbursing();
        }
    }

    void fixupCodeHandlers() {
        for (int i2 = 0; i2 < this.allCodes.length; ++i2) {
            Code code = this.allCodes[i2];
            int n2 = code.getHandlerCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                int n3 = code.handler_start[i3];
                code.handler_start[i3] = code.decodeBCI(n3);
                code.handler_end[i3] = code.decodeBCI(n3 += code.handler_end[i3]);
                code.handler_catch[i3] = code.decodeBCI(n3 += code.handler_catch[i3]);
            }
        }
    }

    void countAndReadAttrs(int n2, Collection collection) throws IOException {
        this.countAttrs(n2, collection);
        this.readAttrs(n2, collection);
    }

    void countAttrs(int n2, Collection collection) throws IOException {
        int n3;
        Attribute.Layout layout;
        int n4;
        BandStructure.MultiBand multiBand = this.attrBands[n2];
        long l2 = this.attrFlagMask[n2];
        if (this.verbose > 1) {
            Utils.log.fine("scanning flags and attrs for " + Attribute.contextName(n2) + "[" + collection.size() + "]");
        }
        Attribute.Layout[] layoutArray = new Attribute.Layout[this.attrDefs[n2].size()];
        this.attrDefs[n2].toArray(layoutArray);
        BandStructure.IntBand intBand = PackageReader.getAttrBand(multiBand, 0);
        BandStructure.IntBand intBand2 = PackageReader.getAttrBand(multiBand, 1);
        BandStructure.IntBand intBand3 = PackageReader.getAttrBand(multiBand, 2);
        BandStructure.IntBand intBand4 = PackageReader.getAttrBand(multiBand, 3);
        BandStructure.IntBand intBand5 = PackageReader.getAttrBand(multiBand, 4);
        int n5 = this.attrOverflowMask[n2];
        int n6 = 0;
        boolean bl2 = this.haveFlagsHi(n2);
        intBand.expectLength(bl2 ? collection.size() : 0);
        intBand.readFrom(this.in);
        intBand2.expectLength(collection.size());
        intBand2.readFrom(this.in);
        assert ((l2 & (long)n5) == (long)n5);
        for (Object object : collection) {
            int n7;
            ((Attribute.Holder)object).flags = n7 = intBand2.getInt();
            if ((n7 & n5) == 0) continue;
            ++n6;
        }
        intBand3.expectLength(n6);
        intBand3.readFrom(this.in);
        intBand4.expectLength(intBand3.getIntTotal());
        intBand4.readFrom(this.in);
        Object object = new int[layoutArray.length];
        for (Attribute.Holder holder : collection) {
            Attribute attribute;
            ArrayList<Attribute> n14;
            assert (holder.attributes == null);
            long l3 = ((long)holder.flags & l2) << 32 >>> 32;
            holder.flags -= (int)l3;
            assert (holder.flags == (char)holder.flags);
            assert (n2 != 3 || holder.flags == 0);
            if (bl2) {
                l3 += (long)intBand.getInt() << 32;
            }
            if (l3 == 0L) continue;
            int n7 = 0;
            long bandArray = l3 & (long)n5;
            assert (bandArray >= 0L);
            l3 -= bandArray;
            if (bandArray != 0L) {
                n7 = intBand3.getInt();
            }
            int elementArray = 0;
            long nArray = l3;
            int n8 = 0;
            while (nArray != 0L) {
                if ((nArray & 1L << n8) != 0L) {
                    nArray -= 1L << n8;
                    ++elementArray;
                }
                ++n8;
            }
            holder.attributes = n14 = new ArrayList<Attribute>(elementArray + n7);
            nArray = l3;
            int n9 = 0;
            while (nArray != 0L) {
                if ((nArray & 1L << n9) != 0L) {
                    nArray -= 1L << n9;
                    Object object2 = object;
                    int n10 = n9;
                    object2[n10] = object2[n10] + true;
                    attribute = layoutArray[n9].canonicalInstance();
                    n14.add(attribute);
                    --elementArray;
                }
                ++n9;
            }
            assert (elementArray == 0);
            while (n7 > 0) {
                n9 = intBand4.getInt();
                Object object3 = object;
                int n11 = n9;
                object3[n11] = object3[n11] + true;
                attribute = layoutArray[n9].canonicalInstance();
                n14.add(attribute);
                --n7;
            }
        }
        intBand.doneDisbursing();
        intBand2.doneDisbursing();
        intBand3.doneDisbursing();
        intBand4.doneDisbursing();
        int n13 = 0;
        boolean bl3 = true;
        while (true) {
            for (n4 = 0; n4 < layoutArray.length; ++n4) {
                Object object4;
                layout = layoutArray[n4];
                if (layout == null || bl3 != this.isPredefinedAttr(n2, n4) || (object4 = object[n4]) == false) continue;
                Attribute.Layout.Element[] elementArray = layout.getCallables();
                for (n3 = 0; n3 < elementArray.length; ++n3) {
                    assert (elementArray[n3].kind == 10);
                    if (!elementArray[n3].flagTest((byte)8)) continue;
                    ++n13;
                }
            }
            if (!bl3) break;
            bl3 = false;
        }
        intBand5.expectLength(n13);
        intBand5.readFrom(this.in);
        bl3 = true;
        while (true) {
            for (n4 = 0; n4 < layoutArray.length; ++n4) {
                layout = layoutArray[n4];
                if (layout == null || bl3 != this.isPredefinedAttr(n2, n4)) continue;
                Object object5 = object[n4];
                BandStructure.Band[] bandArray = (BandStructure.Band[])this.attrBandTable.get(layout);
                if (layout == this.attrInnerClassesEmpty) {
                    this.class_InnerClasses_N.expectLength((int)object5);
                    this.class_InnerClasses_N.readFrom(this.in);
                    n3 = this.class_InnerClasses_N.getIntTotal();
                    this.class_InnerClasses_RC.expectLength(n3);
                    this.class_InnerClasses_RC.readFrom(this.in);
                    this.class_InnerClasses_F.expectLength(n3);
                    this.class_InnerClasses_F.readFrom(this.in);
                    this.class_InnerClasses_outer_RCN.expectLength(n3 -= this.class_InnerClasses_F.getIntCount(0));
                    this.class_InnerClasses_outer_RCN.readFrom(this.in);
                    this.class_InnerClasses_name_RUN.expectLength(n3);
                    this.class_InnerClasses_name_RUN.readFrom(this.in);
                    continue;
                }
                if (object5 == false) {
                    for (n3 = 0; n3 < bandArray.length; ++n3) {
                        bandArray[n3].doneWithUnusedBand();
                    }
                    continue;
                }
                n3 = layout.hasCallables() ? 1 : 0;
                if (n3 == 0) {
                    this.readAttrBands(layout.elems, (int)object5, new int[0], bandArray);
                    continue;
                }
                Attribute.Layout.Element[] elementArray = layout.getCallables();
                int[] nArray = new int[elementArray.length];
                nArray[0] = (int)object5;
                for (int i2 = 0; i2 < elementArray.length; ++i2) {
                    assert (elementArray[i2].kind == 10);
                    int n12 = nArray[i2];
                    nArray[i2] = -1;
                    if (elementArray[i2].flagTest((byte)8)) {
                        n12 += intBand5.getInt();
                    }
                    this.readAttrBands(elementArray[i2].body, n12, nArray, bandArray);
                }
            }
            if (!bl3) break;
            bl3 = false;
        }
        intBand5.doneDisbursing();
    }

    /*
     * WARNING - void declaration
     */
    void readAttrs(int n2, Collection collection) throws IOException {
        void var6_10;
        Object object;
        HashSet<Attribute.Layout> hashSet = new HashSet<Attribute.Layout>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (final Attribute.Holder object2 : collection) {
            if (object2.attributes == null) continue;
            object = object2.attributes.listIterator();
            while (object.hasNext()) {
                boolean bl2;
                Attribute attribute = (Attribute)object.next();
                Attribute.Layout layout = attribute.layout();
                if (layout.bandCount == 0) {
                    if (layout != this.attrInnerClassesEmpty) continue;
                    this.readLocalInnerClasses((Package.Class)object2);
                    continue;
                }
                hashSet.add(layout);
                boolean bl3 = bl2 = n2 == 1 && layout == this.attrConstantValue;
                if (bl2) {
                    this.setConstantValueIndex((Package.Class.Field)object2);
                }
                if (this.verbose > 2) {
                    Utils.log.fine("read " + attribute + " in " + object2);
                }
                final BandStructure.Band[] bandArray = (BandStructure.Band[])this.attrBandTable.get(layout);
                byteArrayOutputStream.reset();
                Object object3 = attribute.unparse(new Attribute.ValueStream(){

                    public int getInt(int n2) {
                        return ((BandStructure.IntBand)bandArray[n2]).getInt();
                    }

                    public ConstantPool.Entry getRef(int n2) {
                        return ((BandStructure.CPRefBand)bandArray[n2]).getRef();
                    }

                    public int decodeBCI(int n2) {
                        Code code = (Code)object2;
                        return code.decodeBCI(n2);
                    }
                }, byteArrayOutputStream);
                object.set(attribute.addContent(byteArrayOutputStream.toByteArray(), object3));
                if (!bl2) continue;
                this.setConstantValueIndex(null);
            }
        }
        for (Attribute.Layout layout : hashSet) {
            if (layout == null) continue;
            object = (BandStructure.Band[])this.attrBandTable.get(layout);
            for (int i2 = 0; i2 < ((BandStructure.Band[])object).length; ++i2) {
                object[i2].doneDisbursing();
            }
        }
        if (n2 == 0) {
            this.class_InnerClasses_N.doneDisbursing();
            this.class_InnerClasses_RC.doneDisbursing();
            this.class_InnerClasses_F.doneDisbursing();
            this.class_InnerClasses_outer_RCN.doneDisbursing();
            this.class_InnerClasses_name_RUN.doneDisbursing();
        }
        BandStructure.MultiBand multiBand = this.attrBands[n2];
        boolean bl4 = false;
        while (var6_10 < multiBand.size()) {
            object = multiBand.get((int)var6_10);
            if (object instanceof BandStructure.MultiBand) {
                ((BandStructure.Band)object).doneDisbursing();
            }
            ++var6_10;
        }
        multiBand.doneDisbursing();
    }

    private void readAttrBands(Attribute.Layout.Element[] elementArray, int n2, int[] nArray, BandStructure.Band[] bandArray) throws IOException {
        block6: for (int i2 = 0; i2 < elementArray.length; ++i2) {
            Attribute.Layout.Element element = elementArray[i2];
            BandStructure.Band band = null;
            if (element.hasBand()) {
                band = bandArray[element.bandIndex];
                band.expectLength(n2);
                band.readFrom(this.in);
            }
            switch (element.kind) {
                case 5: {
                    int n3 = ((BandStructure.IntBand)band).getIntTotal();
                    this.readAttrBands(element.body, n3, nArray, bandArray);
                    continue block6;
                }
                case 7: {
                    int n4 = n2;
                    for (int i3 = 0; i3 < element.body.length; ++i3) {
                        int n5;
                        if (i3 == element.body.length - 1) {
                            n5 = n4;
                        } else {
                            n5 = 0;
                            int n6 = i3;
                            while (i3 == n6 || i3 < element.body.length && element.body[i3].flagTest((byte)8)) {
                                n5 += ((BandStructure.IntBand)band).getIntCount(element.body[i3].value);
                                ++i3;
                            }
                            --i3;
                        }
                        n4 -= n5;
                        this.readAttrBands(element.body[i3].body, n5, nArray, bandArray);
                    }
                    assert (n4 == 0);
                    continue block6;
                }
                case 9: {
                    assert (element.body.length == 1);
                    assert (element.body[0].kind == 10);
                    if (element.flagTest((byte)8)) continue block6;
                    assert (nArray[element.value] >= 0);
                    int n7 = element.value;
                    nArray[n7] = nArray[n7] + n2;
                    continue block6;
                }
                case 10: {
                    assert (false);
                    continue block6;
                }
            }
        }
    }

    void readByteCodes() throws IOException {
        int n2;
        this.bc_codes.elementCountForDebug = this.allCodes.length;
        this.bc_codes.setInputStreamFrom(this.in);
        this.readByteCodeOps();
        this.bc_codes.doneDisbursing();
        BandStructure.Band[] bandArray = new BandStructure.Band[]{this.bc_case_value, this.bc_byte, this.bc_short, this.bc_local, this.bc_label, this.bc_intref, this.bc_floatref, this.bc_longref, this.bc_doubleref, this.bc_stringref, this.bc_classref, this.bc_fieldref, this.bc_methodref, this.bc_imethodref, this.bc_thisfield, this.bc_superfield, this.bc_thismethod, this.bc_supermethod, this.bc_initref, this.bc_escref, this.bc_escrefsize, this.bc_escsize};
        for (n2 = 0; n2 < bandArray.length; ++n2) {
            bandArray[n2].readFrom(this.in);
        }
        this.bc_escbyte.expectLength(this.bc_escsize.getIntTotal());
        this.bc_escbyte.readFrom(this.in);
        this.expandByteCodeOps();
        this.bc_case_count.doneDisbursing();
        for (n2 = 0; n2 < bandArray.length; ++n2) {
            bandArray[n2].doneDisbursing();
        }
        this.bc_escbyte.doneDisbursing();
        this.bc_bands.doneDisbursing();
        this.readAttrs(3, this.codesWithFlags);
        this.fixupCodeHandlers();
        this.code_bands.doneDisbursing();
        this.class_bands.doneDisbursing();
    }

    private void readByteCodeOps() throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block11: for (int i2 = 0; i2 < this.allCodes.length; ++i2) {
            Code code = this.allCodes[i2];
            n2 = 0;
            while (true) {
                int n3 = this.bc_codes.getByte();
                if (n2 + 10 > byArray.length) {
                    byArray = PackageReader.realloc(byArray);
                }
                byArray[n2] = (byte)n3;
                boolean bl2 = false;
                if (n3 == 196) {
                    n3 = this.bc_codes.getByte();
                    byArray[++n2] = (byte)n3;
                    bl2 = true;
                }
                assert (n3 == (0xFF & n3));
                switch (n3) {
                    case 170: 
                    case 171: {
                        this.bc_case_count.expectMoreLength(1);
                        arrayList.add(new Integer(n3));
                        break;
                    }
                    case 132: {
                        this.bc_local.expectMoreLength(1);
                        if (bl2) {
                            this.bc_short.expectMoreLength(1);
                            break;
                        }
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 17: {
                        this.bc_short.expectMoreLength(1);
                        break;
                    }
                    case 16: {
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 188: {
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 197: {
                        assert (this.getCPRefOpBand(n3) == this.bc_classref);
                        this.bc_classref.expectMoreLength(1);
                        this.bc_byte.expectMoreLength(1);
                        break;
                    }
                    case 253: {
                        this.bc_escrefsize.expectMoreLength(1);
                        this.bc_escref.expectMoreLength(1);
                        break;
                    }
                    case 254: {
                        this.bc_escsize.expectMoreLength(1);
                        break;
                    }
                    default: {
                        BandStructure.CPRefBand cPRefBand;
                        if (Instruction.isInvokeInitOp(n3)) {
                            this.bc_initref.expectMoreLength(1);
                            break;
                        }
                        if (Instruction.isSelfLinkerOp(n3)) {
                            cPRefBand = this.selfOpRefBand(n3);
                            cPRefBand.expectMoreLength(1);
                            break;
                        }
                        if (Instruction.isBranchOp(n3)) {
                            this.bc_label.expectMoreLength(1);
                            break;
                        }
                        if (Instruction.isCPRefOp(n3)) {
                            cPRefBand = this.getCPRefOpBand(n3);
                            cPRefBand.expectMoreLength(1);
                            assert (n3 != 197);
                            break;
                        }
                        if (!Instruction.isLocalSlotOp(n3)) break;
                        this.bc_local.expectMoreLength(1);
                        break;
                    }
                    case 255: {
                        code.bytes = PackageReader.realloc(byArray, n2);
                        continue block11;
                    }
                }
                ++n2;
            }
        }
        this.bc_case_count.readFrom(this.in);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            n2 = this.bc_case_count.getInt();
            this.bc_label.expectMoreLength(1 + n2);
            this.bc_case_value.expectMoreLength(n4 == 170 ? 1 : n2);
        }
        this.bc_case_count.resetForSecondPass();
    }

    private void expandByteCodeOps() throws IOException {
        byte[] byArray = new byte[4096];
        int[] nArray = new int[4096];
        int[] nArray2 = new int[1024];
        Fixups fixups = new Fixups();
        for (int i2 = 0; i2 < this.allCodes.length; ++i2) {
            int n2;
            int n3;
            Code code = this.allCodes[i2];
            byte[] byArray2 = code.bytes;
            code.bytes = null;
            Package.Class clazz = code.thisClass();
            HashSet<ConstantPool.Entry> hashSet = (HashSet<ConstantPool.Entry>)this.ldcRefMap.get(clazz);
            if (hashSet == null) {
                hashSet = new HashSet<ConstantPool.Entry>();
                this.ldcRefMap.put(clazz, hashSet);
            }
            ConstantPool.ClassEntry classEntry = clazz.thisClass;
            ConstantPool.ClassEntry classEntry2 = clazz.superClass;
            ConstantPool.ClassEntry classEntry3 = null;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl2 = false;
            fixups.clear();
            block27: for (int i3 = 0; i3 < byArray2.length; ++i3) {
                n3 = Instruction.getByte(byArray2, i3);
                n2 = n4;
                nArray[n5++] = n2;
                if (n4 + 10 > byArray.length) {
                    byArray = PackageReader.realloc(byArray);
                }
                if (n5 + 10 > nArray.length) {
                    nArray = PackageReader.realloc(nArray);
                }
                if (n6 + 10 > nArray2.length) {
                    nArray2 = PackageReader.realloc(nArray2);
                }
                boolean bl3 = false;
                if (n3 == 196) {
                    byArray[n4++] = (byte)n3;
                    n3 = Instruction.getByte(byArray2, ++i3);
                    bl3 = true;
                }
                switch (n3) {
                    case 170: 
                    case 171: {
                        int n7 = this.bc_case_count.getInt();
                        while (n4 + 30 + n7 * 8 > byArray.length) {
                            byArray = PackageReader.realloc(byArray);
                        }
                        byArray[n4++] = (byte)n3;
                        Arrays.fill(byArray, n4, n4 + 30, (byte)0);
                        Instruction.Switch switch_ = (Instruction.Switch)Instruction.at(byArray, n2);
                        switch_.setCaseCount(n7);
                        if (n3 == 170) {
                            switch_.setCaseValue(0, this.bc_case_value.getInt());
                        } else {
                            for (int i4 = 0; i4 < n7; ++i4) {
                                switch_.setCaseValue(i4, this.bc_case_value.getInt());
                            }
                        }
                        nArray2[n6++] = n2;
                        n4 = switch_.getNextPC();
                        continue block27;
                    }
                    case 132: {
                        byArray[n4++] = (byte)n3;
                        int n8 = this.bc_local.getInt();
                        if (bl3) {
                            int n9 = this.bc_short.getInt();
                            Instruction.setShort(byArray, n4, n8);
                            Instruction.setShort(byArray, n4 += 2, n9);
                            n4 += 2;
                            continue block27;
                        }
                        byte by = (byte)this.bc_byte.getByte();
                        byArray[n4++] = (byte)n8;
                        byArray[n4++] = by;
                        continue block27;
                    }
                    case 17: {
                        int n10 = this.bc_short.getInt();
                        byArray[n4++] = (byte)n3;
                        Instruction.setShort(byArray, n4, n10);
                        n4 += 2;
                        continue block27;
                    }
                    case 16: 
                    case 188: {
                        int n11 = this.bc_byte.getByte();
                        byArray[n4++] = (byte)n3;
                        byArray[n4++] = (byte)n11;
                        continue block27;
                    }
                    case 253: {
                        int n12;
                        bl2 = true;
                        int n13 = this.bc_escrefsize.getInt();
                        ConstantPool.Entry entry = this.bc_escref.getRef();
                        if (n13 == 1) {
                            hashSet.add(entry);
                        }
                        switch (n13) {
                            case 1: {
                                n12 = 1;
                                break;
                            }
                            case 2: {
                                n12 = 0;
                                break;
                            }
                            default: {
                                assert (false);
                                n12 = 0;
                            }
                        }
                        fixups.add(n4, n12, entry);
                        byArray[n4 + 1] = 0;
                        byArray[n4 + 0] = 0;
                        n4 += n13;
                        continue block27;
                    }
                    case 254: {
                        bl2 = true;
                        int n14 = this.bc_escsize.getInt();
                        while (n4 + n14 > byArray.length) {
                            byArray = PackageReader.realloc(byArray);
                        }
                        while (n14-- > 0) {
                            byArray[n4++] = (byte)this.bc_escbyte.getByte();
                        }
                        continue block27;
                    }
                    default: {
                        int n15;
                        if (Instruction.isInvokeInitOp(n3)) {
                            ConstantPool.ClassEntry classEntry4;
                            int n16 = n3 - 230;
                            int n17 = 183;
                            switch (n16) {
                                case 0: {
                                    classEntry4 = classEntry;
                                    break;
                                }
                                case 1: {
                                    classEntry4 = classEntry2;
                                    break;
                                }
                                default: {
                                    assert (n16 == 2);
                                    classEntry4 = classEntry3;
                                }
                            }
                            byArray[n4++] = (byte)n17;
                            n15 = this.bc_initref.getInt();
                            ConstantPool.MemberEntry memberEntry = this.pkg.cp.getOverloadingForIndex((byte)10, classEntry4, "<init>", n15);
                            fixups.add(n4, 0, memberEntry);
                            byArray[n4 + 1] = 0;
                            byArray[n4 + 0] = 0;
                            assert (Instruction.opLength(n17) == (n4 += 2) - n2);
                            continue block27;
                        }
                        if (Instruction.isSelfLinkerOp(n3)) {
                            ConstantPool.Index index;
                            BandStructure.CPRefBand cPRefBand;
                            ConstantPool.ClassEntry classEntry5;
                            boolean bl4;
                            boolean bl5;
                            int n18 = n3 - 202;
                            boolean bl6 = bl5 = n18 >= 14;
                            if (bl5) {
                                n18 -= 14;
                            }
                            boolean bl7 = bl4 = n18 >= 7;
                            if (bl4) {
                                n18 -= 7;
                            }
                            n15 = 178 + n18;
                            boolean bl8 = Instruction.isFieldOp(n15);
                            ConstantPool.ClassEntry classEntry6 = classEntry5 = bl5 ? classEntry2 : classEntry;
                            if (bl8) {
                                cPRefBand = bl5 ? this.bc_superfield : this.bc_thisfield;
                                index = this.pkg.cp.getMemberIndex((byte)9, classEntry5);
                            } else {
                                cPRefBand = bl5 ? this.bc_supermethod : this.bc_thismethod;
                                index = this.pkg.cp.getMemberIndex((byte)10, classEntry5);
                            }
                            assert (cPRefBand == this.selfOpRefBand(n3));
                            ConstantPool.MemberEntry memberEntry = (ConstantPool.MemberEntry)cPRefBand.getRef(index);
                            if (bl4) {
                                byArray[n4++] = 42;
                                n2 = n4;
                                nArray[n5++] = n2;
                            }
                            byArray[n4++] = (byte)n15;
                            fixups.add(n4, 0, memberEntry);
                            byArray[n4 + 1] = 0;
                            byArray[n4 + 0] = 0;
                            assert (Instruction.opLength(n15) == (n4 += 2) - n2);
                            continue block27;
                        }
                        if (Instruction.isBranchOp(n3)) {
                            byArray[n4++] = (byte)n3;
                            assert (!bl3);
                            int n19 = n2 + Instruction.opLength(n3);
                            nArray2[n6++] = n2;
                            while (n4 < n19) {
                                byArray[n4++] = 0;
                            }
                            continue block27;
                        }
                        if (Instruction.isCPRefOp(n3)) {
                            int n20;
                            BandStructure.CPRefBand cPRefBand = this.getCPRefOpBand(n3);
                            ConstantPool.Entry entry = cPRefBand.getRef();
                            if (entry == null) {
                                if (cPRefBand == this.bc_classref) {
                                    entry = classEntry;
                                } else assert (false);
                            }
                            int n21 = n3;
                            n15 = 2;
                            switch (n3) {
                                case 18: 
                                case 233: 
                                case 234: 
                                case 235: {
                                    n21 = 18;
                                    n15 = 1;
                                    hashSet.add(entry);
                                    break;
                                }
                                case 19: 
                                case 236: 
                                case 237: 
                                case 238: {
                                    n21 = 19;
                                    break;
                                }
                                case 20: 
                                case 239: {
                                    n21 = 20;
                                    break;
                                }
                                case 187: {
                                    classEntry3 = (ConstantPool.ClassEntry)entry;
                                }
                            }
                            byArray[n4++] = (byte)n21;
                            switch (n15) {
                                case 1: {
                                    n20 = 1;
                                    break;
                                }
                                case 2: {
                                    n20 = 0;
                                    break;
                                }
                                default: {
                                    assert (false);
                                    n20 = 0;
                                }
                            }
                            fixups.add(n4, n20, entry);
                            byArray[n4 + 1] = 0;
                            byArray[n4 + 0] = 0;
                            n4 += n15;
                            if (n21 == 197) {
                                int n22 = this.bc_byte.getByte();
                                byArray[n4++] = (byte)n22;
                            } else if (n21 == 185) {
                                int n23 = ((ConstantPool.MemberEntry)entry).descRef.typeRef.computeSize(true);
                                byArray[n4++] = (byte)(1 + n23);
                                byArray[n4++] = 0;
                            }
                            assert (Instruction.opLength(n21) == n4 - n2);
                            continue block27;
                        }
                        if (Instruction.isLocalSlotOp(n3)) {
                            byArray[n4++] = (byte)n3;
                            int n24 = this.bc_local.getInt();
                            if (bl3) {
                                Instruction.setShort(byArray, n4, n24);
                                n4 += 2;
                                if (n3 == 132) {
                                    int n25 = this.bc_short.getInt();
                                    Instruction.setShort(byArray, n4, n25);
                                    n4 += 2;
                                }
                            } else {
                                Instruction.setByte(byArray, n4, n24);
                                ++n4;
                                if (n3 == 132) {
                                    int n26 = this.bc_byte.getByte();
                                    Instruction.setByte(byArray, n4, n26);
                                    ++n4;
                                }
                            }
                            assert (Instruction.opLength(n3) == n4 - n2);
                            continue block27;
                        }
                        if (n3 >= 202) {
                            Utils.log.warning("unrecognized bytescode " + n3 + " " + Instruction.byteName(n3));
                        }
                        assert (n3 < 202);
                        byArray[n4++] = (byte)n3;
                        assert (Instruction.opLength(n3) == n4 - n2);
                        continue block27;
                    }
                }
            }
            code.setBytes(PackageReader.realloc(byArray, n4));
            code.setInstructionMap(nArray, n5);
            Instruction instruction = null;
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = nArray2[n3];
                if ((instruction = Instruction.at(code.bytes, n2, instruction)) instanceof Instruction.Switch) {
                    Instruction.Switch switch_ = (Instruction.Switch)instruction;
                    switch_.setDefaultLabel(this.getLabel(this.bc_label, code, n2));
                    int n27 = switch_.getCaseCount();
                    for (int i5 = 0; i5 < n27; ++i5) {
                        switch_.setCaseLabel(i5, this.getLabel(this.bc_label, code, n2));
                    }
                    continue;
                }
                instruction.setBranchLabel(this.getLabel(this.bc_label, code, n2));
            }
            if (fixups.size() <= 0) continue;
            if (this.verbose > 2) {
                Utils.log.fine("Fixups in code: " + fixups);
            }
            code.addFixups(fixups);
        }
    }

    static class LimitedBuffer
    extends BufferedInputStream {
        long served;
        int servedPos;
        long limit;
        long buffered;

        public boolean atLimit() {
            boolean bl2;
            boolean bl3 = bl2 = this.getBytesServed() == this.limit;
            assert (!bl2 || this.limit == this.buffered);
            return bl2;
        }

        public long getBytesServed() {
            return this.served + (long)(this.pos - this.servedPos);
        }

        public void setReadLimit(long l2) {
            this.limit = l2 == -1L ? -1L : this.getBytesServed() + l2;
        }

        public long getReadLimit() {
            if (this.limit == -1L) {
                return this.limit;
            }
            return this.limit - this.getBytesServed();
        }

        public int read() throws IOException {
            if (this.pos < this.count) {
                return this.buf[this.pos++] & 0xFF;
            }
            this.served += (long)(this.pos - this.servedPos);
            int n2 = super.read();
            this.servedPos = this.pos;
            if (n2 >= 0) {
                ++this.served;
            }
            assert (this.served <= this.limit || this.limit == -1L);
            this.servedPos = this.pos;
            return n2;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            this.served += (long)(this.pos - this.servedPos);
            int n4 = super.read(byArray, n2, n3);
            this.servedPos = this.pos;
            if (n4 >= 0) {
                this.served += (long)n4;
            }
            assert (this.served <= this.limit || this.limit == -1L);
            return n4;
        }

        public long skip(long l2) throws IOException {
            throw new RuntimeException("no skipping");
        }

        LimitedBuffer(InputStream inputStream) {
            super(null, 16384);
            this.servedPos = this.pos;
            this.in = new FilterInputStream(inputStream){

                public int read() throws IOException {
                    if (LimitedBuffer.this.buffered == LimitedBuffer.this.limit) {
                        return -1;
                    }
                    ++LimitedBuffer.this.buffered;
                    return super.read();
                }

                public int read(byte[] byArray, int n2, int n3) throws IOException {
                    int n4;
                    long l2;
                    if (LimitedBuffer.this.buffered == LimitedBuffer.this.limit) {
                        return -1;
                    }
                    if (LimitedBuffer.this.limit != -1L && (long)n3 > (l2 = LimitedBuffer.this.limit - LimitedBuffer.this.buffered)) {
                        n3 = (int)l2;
                    }
                    if ((n4 = super.read(byArray, n2, n3)) >= 0) {
                        LimitedBuffer.this.buffered += (long)n4;
                    }
                    return n4;
                }
            };
        }
    }
}

