/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class Toolkit {
    static void getUnsigned8(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            int n5 = n4++;
            byArray[n5] = (byte)(byArray[n5] + 128);
        }
    }

    static void getByteSwapped(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; i2 += 2) {
            byte by = byArray[i2];
            byArray[i2] = byArray[i2 + 1];
            byArray[i2 + 1] = by;
        }
    }

    static float linearToDB(float f2) {
        float f3 = (float)(Math.log((double)f2 == 0.0 ? 1.0E-4 : (double)f2) / Math.log(10.0) * 20.0);
        return f3;
    }

    static float dBToLinear(float f2) {
        float f3 = (float)Math.pow(10.0, (double)f2 / 20.0);
        return f3;
    }

    static long align(long l2, int n2) {
        if (n2 <= 1) {
            return l2;
        }
        return l2 - l2 % (long)n2;
    }

    static int align(int n2, int n3) {
        if (n3 <= 1) {
            return n2;
        }
        return n2 - n2 % n3;
    }

    static long millis2bytes(AudioFormat audioFormat, long l2) {
        long l3 = (long)((float)l2 * audioFormat.getFrameRate() / 1000.0f * (float)audioFormat.getFrameSize());
        return Toolkit.align(l3, audioFormat.getFrameSize());
    }

    static long bytes2millis(AudioFormat audioFormat, long l2) {
        return (long)((float)l2 / audioFormat.getFrameRate() * 1000.0f / (float)audioFormat.getFrameSize());
    }

    static long micros2bytes(AudioFormat audioFormat, long l2) {
        long l3 = (long)((float)l2 * audioFormat.getFrameRate() / 1000000.0f * (float)audioFormat.getFrameSize());
        return Toolkit.align(l3, audioFormat.getFrameSize());
    }

    static long bytes2micros(AudioFormat audioFormat, long l2) {
        return (long)((float)l2 / audioFormat.getFrameRate() * 1000000.0f / (float)audioFormat.getFrameSize());
    }

    static long micros2frames(AudioFormat audioFormat, long l2) {
        return (long)((float)l2 * audioFormat.getFrameRate() / 1000000.0f);
    }

    static long frames2micros(AudioFormat audioFormat, long l2) {
        return (long)((double)l2 / (double)audioFormat.getFrameRate() * 1000000.0);
    }

    static void isFullySpecifiedAudioFormat(AudioFormat audioFormat) {
        if (!(audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) || audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW) || audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW))) {
            return;
        }
        if (audioFormat.getFrameRate() <= 0.0f) {
            throw new IllegalArgumentException("invalid frame rate: " + (audioFormat.getFrameRate() == -1.0f ? "NOT_SPECIFIED" : String.valueOf(audioFormat.getFrameRate())));
        }
        if (audioFormat.getSampleRate() <= 0.0f) {
            throw new IllegalArgumentException("invalid sample rate: " + (audioFormat.getSampleRate() == -1.0f ? "NOT_SPECIFIED" : String.valueOf(audioFormat.getSampleRate())));
        }
        if (audioFormat.getSampleSizeInBits() <= 0) {
            throw new IllegalArgumentException("invalid sample size in bits: " + (audioFormat.getSampleSizeInBits() == -1 ? "NOT_SPECIFIED" : String.valueOf(audioFormat.getSampleSizeInBits())));
        }
        if (audioFormat.getFrameSize() <= 0) {
            throw new IllegalArgumentException("invalid frame size: " + (audioFormat.getFrameSize() == -1 ? "NOT_SPECIFIED" : String.valueOf(audioFormat.getFrameSize())));
        }
        if (audioFormat.getChannels() <= 0) {
            throw new IllegalArgumentException("invalid number of channels: " + (audioFormat.getChannels() == -1 ? "NOT_SPECIFIED" : String.valueOf(audioFormat.getChannels())));
        }
    }

    static boolean isFullySpecifiedPCMFormat(AudioFormat audioFormat) {
        if (!audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            return false;
        }
        return !(audioFormat.getFrameRate() <= 0.0f) && !(audioFormat.getSampleRate() <= 0.0f) && audioFormat.getSampleSizeInBits() > 0 && audioFormat.getFrameSize() > 0 && audioFormat.getChannels() > 0;
    }

    public static AudioInputStream getPCMConvertedAudioInputStream(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        if (!audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            try {
                AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), Platform.isBigEndian());
                audioInputStream = AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
            }
            catch (Exception exception) {
                audioInputStream = null;
            }
        }
        return audioInputStream;
    }
}

