/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.opti;

import com.sun.org.apache.xerces.internal.impl.xs.opti.AttrImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.DefaultDocument;
import com.sun.org.apache.xerces.internal.impl.xs.opti.ElementImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.TextImpl;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    NodeImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;
    StringBuffer fAnnotationBuffer = null;

    public SchemaDOM() {
        this.reset();
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, int n2, int n3) {
        ElementImpl elementImpl = new ElementImpl(n2, n3);
        this.processElement(qName, xMLAttributes, elementImpl);
        this.parent = elementImpl;
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, int n2, int n3) {
        ElementImpl elementImpl = new ElementImpl(n2, n3);
        this.processElement(qName, xMLAttributes, elementImpl);
    }

    private void processElement(QName qName, XMLAttributes xMLAttributes, ElementImpl elementImpl) {
        int n2;
        elementImpl.prefix = qName.prefix;
        elementImpl.localpart = qName.localpart;
        elementImpl.rawname = qName.rawname;
        elementImpl.uri = qName.uri;
        elementImpl.schemaDOM = this;
        Attr[] attrArray = new Attr[xMLAttributes.getLength()];
        for (n2 = 0; n2 < xMLAttributes.getLength(); ++n2) {
            attrArray[n2] = new AttrImpl(null, xMLAttributes.getPrefix(n2), xMLAttributes.getLocalName(n2), xMLAttributes.getQName(n2), xMLAttributes.getURI(n2), xMLAttributes.getValue(n2));
        }
        elementImpl.attrs = attrArray;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        n2 = 0;
        int n3 = 1;
        for (n3 = 1; n3 < this.relations[this.currLoc].length; ++n3) {
            if (this.relations[this.currLoc][n3] != null) continue;
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][n3] = elementImpl;
        this.parent.parentRow = this.currLoc;
        elementImpl.row = this.currLoc;
        elementImpl.col = n3;
    }

    public void endElement() {
        this.currLoc = this.parent.row;
        this.parent = (ElementImpl)this.relations[this.currLoc][0];
    }

    void comment(XMLString xMLString) {
        this.fAnnotationBuffer.append("<!--").append(xMLString.toString()).append("-->");
    }

    void processingInstruction(String string, String string2) {
        this.fAnnotationBuffer.append("<?").append(string).append(" ").append(string2).append("?>");
    }

    void characters(XMLString xMLString) {
        for (int i2 = xMLString.offset; i2 < xMLString.offset + xMLString.length; ++i2) {
            if (xMLString.ch[i2] == '&') {
                this.fAnnotationBuffer.append("&amp;");
                continue;
            }
            if (xMLString.ch[i2] == '<') {
                this.fAnnotationBuffer.append("&lt;");
                continue;
            }
            this.fAnnotationBuffer.append(xMLString.ch[i2]);
        }
    }

    void endAnnotationElement(QName qName, boolean bl2) {
        if (bl2) {
            int n2;
            this.fAnnotationBuffer.append("\n</").append(qName.rawname).append(">");
            ElementImpl elementImpl = (ElementImpl)this.relations[this.currLoc][1];
            if (this.nextFreeLoc == this.relations.length) {
                this.resizeRelations();
            }
            elementImpl.parentRow = this.nextFreeLoc++;
            int n3 = elementImpl.parentRow;
            boolean bl3 = false;
            for (n2 = 1; n2 < this.relations[n3].length; ++n2) {
                if (this.relations[n3][n2] != null) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                this.resizeRelations(n3);
            }
            this.relations[n3][n2] = new TextImpl(this.fAnnotationBuffer, this, n3, n2);
            this.fAnnotationBuffer = null;
        } else {
            this.fAnnotationBuffer.append("</").append(qName.rawname).append(">");
        }
    }

    void startAnnotationCDATA() {
        this.fAnnotationBuffer.append("<![CDATA[");
    }

    void endAnnotationCDATA() {
        this.fAnnotationBuffer.append("]]>");
    }

    private void resizeRelations() {
        NodeImpl[][] nodeImplArrayArray = new NodeImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, nodeImplArrayArray, 0, this.relations.length);
        for (int i2 = this.relations.length; i2 < nodeImplArrayArray.length; ++i2) {
            nodeImplArrayArray[i2] = new NodeImpl[10];
        }
        this.relations = nodeImplArrayArray;
    }

    private void resizeRelations(int n2) {
        NodeImpl[] nodeImplArray = new NodeImpl[this.relations[n2].length + 10];
        System.arraycopy(this.relations[n2], 0, nodeImplArray, 0, this.relations[n2].length);
        this.relations[n2] = nodeImplArray;
    }

    public void reset() {
        int n2;
        if (this.relations != null) {
            for (n2 = 0; n2 < this.relations.length; ++n2) {
                for (int i2 = 0; i2 < this.relations[n2].length; ++i2) {
                    this.relations[n2][i2] = null;
                }
            }
        }
        this.relations = new NodeImpl[15][];
        this.parent = new ElementImpl(0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        for (n2 = 0; n2 < 15; ++n2) {
            this.relations[n2] = new NodeImpl[10];
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    public void printDOM() {
    }

    public static void traverse(Node node, int n2) {
        Object object;
        SchemaDOM.indent(n2);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (int i2 = 0; i2 < object.getLength(); ++i2) {
                System.out.print("  " + ((Attr)object.item(i2)).getName() + "=\"" + ((Attr)object.item(i2)).getValue() + "\"");
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            n2 += 4;
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                SchemaDOM.traverse((Node)object, n2);
            }
            SchemaDOM.indent(n2 -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    public static void indent(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            System.out.print(' ');
        }
    }

    public Element getDocumentElement() {
        return (ElementImpl)this.relations[0][1];
    }

    void startAnnotation(QName qName, XMLAttributes xMLAttributes, NamespaceContext namespaceContext) {
        String string;
        String string2;
        if (this.fAnnotationBuffer == null) {
            this.fAnnotationBuffer = new StringBuffer(256);
        }
        this.fAnnotationBuffer.append("<").append(qName.rawname).append(" ");
        Vector<String> vector = new Vector<String>();
        for (int i2 = 0; i2 < xMLAttributes.getLength(); ++i2) {
            string2 = xMLAttributes.getValue(i2);
            string = xMLAttributes.getPrefix(i2);
            vector.addElement(string2);
            this.fAnnotationBuffer.append(xMLAttributes.getQName(i2)).append("=\"").append(string2).append("\" ");
        }
        Enumeration enumeration = namespaceContext.getAllPrefixes();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = namespaceContext.getURI(string2);
            if (vector.contains(string)) continue;
            if (string2 == XMLSymbols.EMPTY_STRING) {
                this.fAnnotationBuffer.append("xmlns").append("=\"").append(string).append("\" ");
                continue;
            }
            this.fAnnotationBuffer.append("xmlns:").append(string2).append("=\"").append(string).append("\" ");
        }
        this.fAnnotationBuffer.append(">\n");
    }

    void startAnnotationElement(QName qName, XMLAttributes xMLAttributes) {
        this.fAnnotationBuffer.append("<").append(qName.rawname).append(" ");
        for (int i2 = 0; i2 < xMLAttributes.getLength(); ++i2) {
            String string = xMLAttributes.getValue(i2);
            this.fAnnotationBuffer.append(" ").append(xMLAttributes.getQName(i2)).append("=\"").append(SchemaDOM.processAttValue(string)).append("\" ");
        }
        this.fAnnotationBuffer.append(">");
    }

    private static String processAttValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c2 == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c2 == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }
}

