/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import com.sun.rowset.CachedRowSetImpl;
import com.sun.rowset.JdbcRowSetImpl;
import com.sun.rowset.WebRowSetImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.JoinRowSet;
import javax.sql.rowset.Joinable;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.WebRowSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinRowSetImpl
extends WebRowSetImpl
implements JoinRowSet {
    private Vector vecRowSetsInJOIN = new Vector();
    private CachedRowSetImpl crsInternal = new CachedRowSetImpl();
    private Vector vecJoinType = new Vector();
    private Vector vecTableNames = new Vector();
    private int iMatchKey = -1;
    private String strMatchKey = null;
    boolean[] supportedJOINs = new boolean[]{false, true, false, false, false};
    private WebRowSet wrs;

    @Override
    public void addRowSet(Joinable joinable) throws SQLException {
        CachedRowSetImpl cachedRowSetImpl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!(joinable instanceof RowSet)) {
            throw new SQLException("Not an instance of rowset ");
        }
        if (joinable instanceof JdbcRowSetImpl) {
            cachedRowSetImpl = new CachedRowSetImpl();
            cachedRowSetImpl.populate((RowSet)((Object)joinable));
            try {
                cachedRowSetImpl.setMatchColumn(joinable.getMatchColumnIndexes()[0]);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                cachedRowSetImpl.setMatchColumn(joinable.getMatchColumnNames()[0]);
            }
            catch (SQLException sQLException) {}
        } else {
            cachedRowSetImpl = (CachedRowSetImpl)joinable;
        }
        try {
            this.iMatchKey = cachedRowSetImpl.getMatchColumnIndexes()[0];
        }
        catch (SQLException sQLException) {
            bl2 = true;
        }
        try {
            this.strMatchKey = cachedRowSetImpl.getMatchColumnNames()[0];
        }
        catch (SQLException sQLException) {
            bl3 = true;
        }
        if (bl2 && bl3) {
            throw new SQLException("Match Column is not set for Join");
        }
        if (bl2) {
            this.iMatchKey = cachedRowSetImpl.findColumn(this.strMatchKey);
            cachedRowSetImpl.setMatchColumn(this.iMatchKey);
        }
        this.initJOIN(cachedRowSetImpl);
    }

    @Override
    public void addRowSet(RowSet rowSet, int n2) throws SQLException {
        ((CachedRowSetImpl)rowSet).setMatchColumn(n2);
        this.addRowSet((Joinable)((Object)rowSet));
    }

    @Override
    public void addRowSet(RowSet rowSet, String string) throws SQLException {
        ((CachedRowSetImpl)rowSet).setMatchColumn(string);
        this.addRowSet((Joinable)((Object)rowSet));
    }

    @Override
    public void addRowSet(RowSet[] rowSetArray, int[] nArray) throws SQLException {
        if (rowSetArray.length != nArray.length) {
            throw new SQLException("Number of elements in rowset is not equal to match column");
        }
        for (int i2 = 0; i2 < rowSetArray.length; ++i2) {
            ((CachedRowSetImpl)rowSetArray[i2]).setMatchColumn(nArray[i2]);
            this.addRowSet((Joinable)((Object)rowSetArray[i2]));
        }
    }

    @Override
    public void addRowSet(RowSet[] rowSetArray, String[] stringArray) throws SQLException {
        if (rowSetArray.length != stringArray.length) {
            throw new SQLException("Number of elements in rowset is not equal to match column");
        }
        for (int i2 = 0; i2 < rowSetArray.length; ++i2) {
            ((CachedRowSetImpl)rowSetArray[i2]).setMatchColumn(stringArray[i2]);
            this.addRowSet((Joinable)((Object)rowSetArray[i2]));
        }
    }

    public Collection getRowSets() throws SQLException {
        return this.vecRowSetsInJOIN;
    }

    @Override
    public String[] getRowSetNames() throws SQLException {
        Object[] objectArray = this.vecTableNames.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringArray[i2] = objectArray[i2].toString();
        }
        return stringArray;
    }

    @Override
    public CachedRowSet toCachedRowSet() throws SQLException {
        return this.crsInternal;
    }

    @Override
    public boolean supportsCrossJoin() {
        return this.supportedJOINs[0];
    }

    @Override
    public boolean supportsInnerJoin() {
        return this.supportedJOINs[1];
    }

    @Override
    public boolean supportsLeftOuterJoin() {
        return this.supportedJOINs[2];
    }

    @Override
    public boolean supportsRightOuterJoin() {
        return this.supportedJOINs[3];
    }

    @Override
    public boolean supportsFullJoin() {
        return this.supportedJOINs[4];
    }

    @Override
    public void setJoinType(int n2) throws SQLException {
        if (n2 >= 0 && n2 <= 4) {
            if (n2 != 1) {
                throw new UnsupportedOperationException();
            }
        } else {
            throw new SQLException("This is not a defined type of Join");
        }
        Integer n3 = new Integer(1);
        this.vecJoinType.add(n3);
    }

    private boolean checkforMatchColumn(Joinable joinable) throws SQLException {
        int[] nArray = joinable.getMatchColumnIndexes();
        return nArray.length > 0;
    }

    private void initJOIN(CachedRowSet cachedRowSet) throws SQLException {
        try {
            CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)cachedRowSet;
            CachedRowSetImpl cachedRowSetImpl2 = new CachedRowSetImpl();
            RowSetMetaDataImpl rowSetMetaDataImpl = new RowSetMetaDataImpl();
            if (this.vecRowSetsInJOIN.isEmpty()) {
                this.crsInternal = (CachedRowSetImpl)cachedRowSet.createCopy();
                this.crsInternal.setMetaData((RowSetMetaDataImpl)cachedRowSetImpl.getMetaData());
                this.vecRowSetsInJOIN.add(cachedRowSetImpl);
            } else {
                int n2;
                if (this.vecRowSetsInJOIN.size() - this.vecJoinType.size() == 2) {
                    this.setJoinType(1);
                } else if (this.vecRowSetsInJOIN.size() - this.vecJoinType.size() == 1) {
                    // empty if block
                }
                this.vecTableNames.add(this.crsInternal.getTableName());
                this.vecTableNames.add(cachedRowSetImpl.getTableName());
                int n3 = cachedRowSetImpl.size();
                int n4 = this.crsInternal.size();
                rowSetMetaDataImpl.setColumnCount(this.crsInternal.getMetaData().getColumnCount() + cachedRowSetImpl.getMetaData().getColumnCount() - 1);
                cachedRowSetImpl2.setMetaData(rowSetMetaDataImpl);
                this.crsInternal.beforeFirst();
                cachedRowSetImpl.beforeFirst();
                for (n2 = 1; n2 <= n4 && !this.crsInternal.isAfterLast(); ++n2) {
                    if (!this.crsInternal.next()) continue;
                    cachedRowSetImpl.beforeFirst();
                    for (int i2 = 1; i2 <= n3 && !cachedRowSetImpl.isAfterLast(); ++i2) {
                        int n5;
                        if (!cachedRowSetImpl.next() || !this.crsInternal.getObject(this.crsInternal.getMatchColumnIndexes()[0]).equals(cachedRowSetImpl.getObject(cachedRowSetImpl.getMatchColumnIndexes()[0]))) continue;
                        int n6 = 0;
                        cachedRowSetImpl2.moveToInsertRow();
                        for (n5 = 1; n5 <= this.crsInternal.getMetaData().getColumnCount(); ++n5) {
                            if (n5 != cachedRowSetImpl.getMatchColumnIndexes()[0]) {
                                cachedRowSetImpl2.updateObject(++n6, this.crsInternal.getObject(n5));
                                rowSetMetaDataImpl.setColumnName(n6, this.crsInternal.getMetaData().getColumnName(n5));
                                rowSetMetaDataImpl.setTableName(n6, this.crsInternal.getTableName());
                                rowSetMetaDataImpl.setColumnType(n5, this.crsInternal.getMetaData().getColumnType(n5));
                                rowSetMetaDataImpl.setAutoIncrement(n5, this.crsInternal.getMetaData().isAutoIncrement(n5));
                                rowSetMetaDataImpl.setCaseSensitive(n5, this.crsInternal.getMetaData().isCaseSensitive(n5));
                                rowSetMetaDataImpl.setCatalogName(n5, this.crsInternal.getMetaData().getCatalogName(n5));
                                rowSetMetaDataImpl.setColumnDisplaySize(n5, this.crsInternal.getMetaData().getColumnDisplaySize(n5));
                                rowSetMetaDataImpl.setColumnLabel(n5, this.crsInternal.getMetaData().getColumnLabel(n5));
                                rowSetMetaDataImpl.setColumnType(n5, this.crsInternal.getMetaData().getColumnType(n5));
                                rowSetMetaDataImpl.setColumnTypeName(n5, this.crsInternal.getMetaData().getColumnTypeName(n5));
                                rowSetMetaDataImpl.setCurrency(n5, this.crsInternal.getMetaData().isCurrency(n5));
                                rowSetMetaDataImpl.setNullable(n5, this.crsInternal.getMetaData().isNullable(n5));
                                rowSetMetaDataImpl.setPrecision(n5, this.crsInternal.getMetaData().getPrecision(n5));
                                rowSetMetaDataImpl.setScale(n5, this.crsInternal.getMetaData().getScale(n5));
                                rowSetMetaDataImpl.setSchemaName(n5, this.crsInternal.getMetaData().getSchemaName(n5));
                                rowSetMetaDataImpl.setSearchable(n5, this.crsInternal.getMetaData().isSearchable(n5));
                                rowSetMetaDataImpl.setSigned(n5, this.crsInternal.getMetaData().isSigned(n5));
                                continue;
                            }
                            cachedRowSetImpl2.updateObject(++n6, this.crsInternal.getObject(n5));
                            rowSetMetaDataImpl.setColumnName(n6, "MergedCol");
                            rowSetMetaDataImpl.setTableName(n6, this.crsInternal.getTableName() + "#" + cachedRowSetImpl.getTableName());
                            rowSetMetaDataImpl.setColumnType(n5, this.crsInternal.getMetaData().getColumnType(n5));
                            rowSetMetaDataImpl.setAutoIncrement(n5, this.crsInternal.getMetaData().isAutoIncrement(n5));
                            rowSetMetaDataImpl.setCaseSensitive(n5, this.crsInternal.getMetaData().isCaseSensitive(n5));
                            rowSetMetaDataImpl.setCatalogName(n5, this.crsInternal.getMetaData().getCatalogName(n5));
                            rowSetMetaDataImpl.setColumnDisplaySize(n5, this.crsInternal.getMetaData().getColumnDisplaySize(n5));
                            rowSetMetaDataImpl.setColumnLabel(n5, this.crsInternal.getMetaData().getColumnLabel(n5));
                            rowSetMetaDataImpl.setColumnType(n5, this.crsInternal.getMetaData().getColumnType(n5));
                            rowSetMetaDataImpl.setColumnTypeName(n5, this.crsInternal.getMetaData().getColumnTypeName(n5));
                            rowSetMetaDataImpl.setCurrency(n5, this.crsInternal.getMetaData().isCurrency(n5));
                            rowSetMetaDataImpl.setNullable(n5, this.crsInternal.getMetaData().isNullable(n5));
                            rowSetMetaDataImpl.setPrecision(n5, this.crsInternal.getMetaData().getPrecision(n5));
                            rowSetMetaDataImpl.setScale(n5, this.crsInternal.getMetaData().getScale(n5));
                            rowSetMetaDataImpl.setSchemaName(n5, this.crsInternal.getMetaData().getSchemaName(n5));
                            rowSetMetaDataImpl.setSearchable(n5, this.crsInternal.getMetaData().isSearchable(n5));
                            rowSetMetaDataImpl.setSigned(n5, this.crsInternal.getMetaData().isSigned(n5));
                        }
                        for (int i3 = 1; i3 <= cachedRowSetImpl.getMetaData().getColumnCount(); ++i3) {
                            if (i3 == cachedRowSetImpl.getMatchColumnIndexes()[0]) continue;
                            cachedRowSetImpl2.updateObject(++n6, cachedRowSetImpl.getObject(i3));
                            rowSetMetaDataImpl.setColumnName(n6, cachedRowSetImpl.getMetaData().getColumnName(i3));
                            rowSetMetaDataImpl.setTableName(n6, cachedRowSetImpl.getTableName());
                            if (n5 + i3 - 1 > this.crsInternal.getMetaData().getColumnCount() + cachedRowSetImpl.getMetaData().getColumnCount() - 1) {
                                --n5;
                            }
                            rowSetMetaDataImpl.setColumnType(n5 + i3 - 1, cachedRowSetImpl.getMetaData().getColumnType(i3));
                            rowSetMetaDataImpl.setAutoIncrement(n5 + i3 - 1, cachedRowSetImpl.getMetaData().isAutoIncrement(i3));
                            rowSetMetaDataImpl.setCaseSensitive(n5 + i3 - 1, cachedRowSetImpl.getMetaData().isCaseSensitive(i3));
                            rowSetMetaDataImpl.setCatalogName(n5 + i3 - 1, cachedRowSetImpl.getMetaData().getCatalogName(i3));
                            rowSetMetaDataImpl.setColumnDisplaySize(n5 + i3 - 1, cachedRowSetImpl.getMetaData().getColumnDisplaySize(i3));
                            rowSetMetaDataImpl.setColumnLabel(n5 + i3 - 1, cachedRowSetImpl.getMetaData().getColumnLabel(i3));
                            rowSetMetaDataImpl.setColumnType(n5 + i3 - 1, cachedRowSetImpl.getMetaData().getColumnType(i3));
                            rowSetMetaDataImpl.setColumnTypeName(n5 + i3 - 1, cachedRowSetImpl.getMetaData().getColumnTypeName(i3));
                            rowSetMetaDataImpl.setCurrency(n5 + i3 - 1, cachedRowSetImpl.getMetaData().isCurrency(i3));
                            rowSetMetaDataImpl.setNullable(n5 + i3 - 1, cachedRowSetImpl.getMetaData().isNullable(i3));
                            rowSetMetaDataImpl.setPrecision(n5 + i3 - 1, cachedRowSetImpl.getMetaData().getPrecision(i3));
                            rowSetMetaDataImpl.setScale(n5 + i3 - 1, cachedRowSetImpl.getMetaData().getScale(i3));
                            rowSetMetaDataImpl.setSchemaName(n5 + i3 - 1, cachedRowSetImpl.getMetaData().getSchemaName(i3));
                            rowSetMetaDataImpl.setSearchable(n5 + i3 - 1, cachedRowSetImpl.getMetaData().isSearchable(i3));
                            rowSetMetaDataImpl.setSigned(n5 + i3 - 1, cachedRowSetImpl.getMetaData().isSigned(i3));
                        }
                        cachedRowSetImpl2.insertRow();
                        cachedRowSetImpl2.moveToCurrentRow();
                    }
                }
                cachedRowSetImpl2.setMetaData(rowSetMetaDataImpl);
                cachedRowSetImpl2.setOriginal();
                n2 = this.crsInternal.getMatchColumnIndexes()[0];
                this.crsInternal = new CachedRowSetImpl();
                this.crsInternal = (CachedRowSetImpl)cachedRowSetImpl2.createCopy();
                this.crsInternal.setMatchColumn(n2);
                this.crsInternal.setMetaData(rowSetMetaDataImpl);
                this.vecRowSetsInJOIN.add(cachedRowSetImpl);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException("JoinRowSet initialization error: " + sQLException);
        }
        catch (Exception exception) {
            throw new SQLException("Generic JoinRowSet initial error: " + exception);
        }
    }

    @Override
    public String getWhereClause() throws SQLException {
        int n2;
        String string = "Select ";
        String string2 = null;
        String string3 = null;
        string2 = new String();
        string3 = new String();
        int n3 = this.vecRowSetsInJOIN.size();
        for (n2 = 0; n2 < n3; ++n2) {
            CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)this.vecRowSetsInJOIN.get(n2);
            int n4 = cachedRowSetImpl.getMetaData().getColumnCount();
            string2 = string2.concat(cachedRowSetImpl.getTableName());
            string3 = string3.concat(string2 + ", ");
            int n5 = 1;
            while (n5 < n4) {
                string = string.concat(string2 + "." + cachedRowSetImpl.getMetaData().getColumnName(n5++));
                string = string.concat(", ");
            }
        }
        string = string.substring(0, string.lastIndexOf(","));
        string = string.concat(" from ");
        string = string.concat(string3);
        string = string.substring(0, string.lastIndexOf(","));
        string = string.concat(" where ");
        for (n2 = 0; n2 < n3; ++n2) {
            string = string.concat(((CachedRowSetImpl)this.vecRowSetsInJOIN.get(n2)).getMatchColumnNames()[0]);
            string = n2 % 2 != 0 ? string.concat("=") : string.concat(" and");
            string = string.concat(" ");
        }
        return string;
    }

    @Override
    public boolean next() throws SQLException {
        return this.crsInternal.next();
    }

    @Override
    public void close() throws SQLException {
        this.crsInternal.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.crsInternal.wasNull();
    }

    @Override
    public String getString(int n2) throws SQLException {
        return this.crsInternal.getString(n2);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        return this.crsInternal.getBoolean(n2);
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        return this.crsInternal.getByte(n2);
    }

    @Override
    public short getShort(int n2) throws SQLException {
        return this.crsInternal.getShort(n2);
    }

    @Override
    public int getInt(int n2) throws SQLException {
        return this.crsInternal.getInt(n2);
    }

    @Override
    public long getLong(int n2) throws SQLException {
        return this.crsInternal.getLong(n2);
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        return this.crsInternal.getFloat(n2);
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        return this.crsInternal.getDouble(n2);
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.crsInternal.getBigDecimal(n2);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        return this.crsInternal.getBytes(n2);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return this.crsInternal.getDate(n2);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return this.crsInternal.getTime(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.crsInternal.getTimestamp(n2);
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        return this.crsInternal.getAsciiStream(n2);
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        return this.crsInternal.getUnicodeStream(n2);
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        return this.crsInternal.getBinaryStream(n2);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.crsInternal.getString(string);
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.crsInternal.getBoolean(string);
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.crsInternal.getByte(string);
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.crsInternal.getShort(string);
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.crsInternal.getInt(string);
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.crsInternal.getLong(string);
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.crsInternal.getFloat(string);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.crsInternal.getDouble(string);
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.crsInternal.getBigDecimal(string);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.crsInternal.getBytes(string);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.crsInternal.getDate(string);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.crsInternal.getTime(string);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.crsInternal.getTimestamp(string);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.crsInternal.getAsciiStream(string);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.crsInternal.getUnicodeStream(string);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.crsInternal.getBinaryStream(string);
    }

    @Override
    public SQLWarning getWarnings() {
        return this.crsInternal.getWarnings();
    }

    @Override
    public void clearWarnings() {
        this.crsInternal.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.crsInternal.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.crsInternal.getMetaData();
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        return this.crsInternal.getObject(n2);
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        return this.crsInternal.getObject(n2, map);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.crsInternal.getObject(string);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.crsInternal.getObject(string, map);
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        return this.crsInternal.getCharacterStream(n2);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.crsInternal.getCharacterStream(string);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.crsInternal.getBigDecimal(n2);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.crsInternal.getBigDecimal(string);
    }

    @Override
    public int size() {
        return this.crsInternal.size();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.crsInternal.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.crsInternal.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.crsInternal.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.crsInternal.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.crsInternal.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.crsInternal.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        return this.crsInternal.first();
    }

    @Override
    public boolean last() throws SQLException {
        return this.crsInternal.last();
    }

    @Override
    public int getRow() throws SQLException {
        return this.crsInternal.getRow();
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        return this.crsInternal.absolute(n2);
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        return this.crsInternal.relative(n2);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.crsInternal.previous();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.crsInternal.findColumn(string);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.crsInternal.rowUpdated();
    }

    @Override
    public boolean columnUpdated(int n2) throws SQLException {
        return this.crsInternal.columnUpdated(n2);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.crsInternal.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.crsInternal.rowDeleted();
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        this.crsInternal.updateNull(n2);
    }

    @Override
    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        this.crsInternal.updateBoolean(n2, bl2);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        this.crsInternal.updateByte(n2, by);
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.crsInternal.updateShort(n2, s2);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.crsInternal.updateInt(n2, n3);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.crsInternal.updateLong(n2, l2);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        this.crsInternal.updateFloat(n2, f2);
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        this.crsInternal.updateDouble(n2, d2);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.crsInternal.updateBigDecimal(n2, bigDecimal);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        this.crsInternal.updateString(n2, string);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.crsInternal.updateBytes(n2, byArray);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        this.crsInternal.updateDate(n2, date);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.crsInternal.updateTime(n2, time);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.crsInternal.updateTimestamp(n2, timestamp);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.crsInternal.updateAsciiStream(n2, inputStream, n3);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.crsInternal.updateBinaryStream(n2, inputStream, n3);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.crsInternal.updateCharacterStream(n2, reader, n3);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.crsInternal.updateObject(n2, object, n3);
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        this.crsInternal.updateObject(n2, object);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.crsInternal.updateNull(string);
    }

    @Override
    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.crsInternal.updateBoolean(string, bl2);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.crsInternal.updateByte(string, by);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        this.crsInternal.updateShort(string, s2);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        this.crsInternal.updateInt(string, n2);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        this.crsInternal.updateLong(string, l2);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        this.crsInternal.updateFloat(string, f2);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        this.crsInternal.updateDouble(string, d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.crsInternal.updateBigDecimal(string, bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.crsInternal.updateString(string, string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.crsInternal.updateBytes(string, byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.crsInternal.updateDate(string, date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.crsInternal.updateTime(string, time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.crsInternal.updateTimestamp(string, timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.crsInternal.updateAsciiStream(string, inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.crsInternal.updateBinaryStream(string, inputStream, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.crsInternal.updateCharacterStream(string, reader, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.crsInternal.updateObject(string, object, n2);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.crsInternal.updateObject(string, object);
    }

    @Override
    public void insertRow() throws SQLException {
        this.crsInternal.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.crsInternal.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.crsInternal.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.crsInternal.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.crsInternal.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.crsInternal.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.crsInternal.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.crsInternal.getStatement();
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        return this.crsInternal.getRef(n2);
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        return this.crsInternal.getBlob(n2);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        return this.crsInternal.getClob(n2);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        return this.crsInternal.getArray(n2);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.crsInternal.getRef(string);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.crsInternal.getBlob(string);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.crsInternal.getClob(string);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.crsInternal.getArray(string);
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.crsInternal.getDate(n2, calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.crsInternal.getDate(string, calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.crsInternal.getTime(n2, calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.crsInternal.getTime(string, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.crsInternal.getTimestamp(n2, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.crsInternal.getTimestamp(string, calendar);
    }

    @Override
    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.crsInternal.setMetaData(rowSetMetaData);
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        return this.crsInternal.getOriginal();
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        return this.crsInternal.getOriginalRow();
    }

    @Override
    public void setOriginalRow() throws SQLException {
        this.crsInternal.setOriginalRow();
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return this.crsInternal.getKeyColumns();
    }

    @Override
    public void setKeyColumns(int[] nArray) throws SQLException {
        this.crsInternal.setKeyColumns(nArray);
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        this.crsInternal.updateRef(n2, ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.crsInternal.updateRef(string, ref);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        this.crsInternal.updateClob(n2, clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.crsInternal.updateClob(string, clob);
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.crsInternal.updateBlob(n2, blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.crsInternal.updateBlob(string, blob);
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        this.crsInternal.updateArray(n2, array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.crsInternal.updateArray(string, array);
    }

    @Override
    public void execute() throws SQLException {
        this.crsInternal.execute();
    }

    @Override
    public void execute(Connection connection) throws SQLException {
        this.crsInternal.execute(connection);
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        return this.crsInternal.getURL(n2);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.crsInternal.getURL(string);
    }

    @Override
    public void writeXml(ResultSet resultSet, Writer writer) throws SQLException {
        this.wrs = new WebRowSetImpl();
        this.wrs.populate(resultSet);
        this.wrs.writeXml(writer);
    }

    @Override
    public void writeXml(Writer writer) throws SQLException {
        this.createWebRowSet().writeXml(writer);
    }

    @Override
    public void readXml(Reader reader) throws SQLException {
        this.wrs = new WebRowSetImpl();
        this.wrs.readXml(reader);
        this.crsInternal = (CachedRowSetImpl)((Object)this.wrs);
    }

    @Override
    public void readXml(InputStream inputStream) throws SQLException, IOException {
        this.wrs = new WebRowSetImpl();
        this.wrs.readXml(inputStream);
        this.crsInternal = (CachedRowSetImpl)((Object)this.wrs);
    }

    @Override
    public void writeXml(OutputStream outputStream) throws SQLException, IOException {
        this.createWebRowSet().writeXml(outputStream);
    }

    @Override
    public void writeXml(ResultSet resultSet, OutputStream outputStream) throws SQLException, IOException {
        this.wrs = new WebRowSetImpl();
        this.wrs.populate(resultSet);
        this.wrs.writeXml(outputStream);
    }

    private WebRowSet createWebRowSet() throws SQLException {
        if (this.wrs != null) {
            return this.wrs;
        }
        this.wrs = new WebRowSetImpl();
        this.crsInternal.beforeFirst();
        this.wrs.populate(this.crsInternal);
        return this.wrs;
    }

    @Override
    public int getJoinType() throws SQLException {
        if (this.vecJoinType == null) {
            this.setJoinType(1);
        }
        Integer n2 = (Integer)this.vecJoinType.get(this.vecJoinType.size() - 1);
        return n2;
    }
}

