/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.SentEvent;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class DefaultKeyboardFocusManager
extends KeyboardFocusManager {
    private static final Logger focusLog = Logger.getLogger("java.awt.focus.DefaultKeyboardFocusManager");
    private Window realOppositeWindow;
    private Component realOppositeComponent;
    private int inSendMessage;
    private LinkedList enqueuedKeyEvents = new LinkedList();
    private LinkedList typeAheadMarkers = new LinkedList();
    private boolean consumeNextKeyTyped;

    private Window getOwningFrameDialog(Window window) {
        while (window != null && !(window instanceof Frame) && !(window instanceof Dialog)) {
            window = (Window)window.getParent();
        }
        return window;
    }

    private void restoreFocus(FocusEvent focusEvent, Window window) {
        Component component = this.realOppositeComponent;
        Component component2 = focusEvent.getComponent();
        if (!(window != null && this.restoreFocus(window, component2, false) || component != null && this.restoreFocus(component, false) || focusEvent.getOppositeComponent() != null && this.restoreFocus(focusEvent.getOppositeComponent(), false))) {
            this.clearGlobalFocusOwner();
        }
    }

    private void restoreFocus(WindowEvent windowEvent) {
        Window window = this.realOppositeWindow;
        if (!(window != null && this.restoreFocus(window, null, false) || windowEvent.getOppositeWindow() != null && this.restoreFocus(windowEvent.getOppositeWindow(), null, false))) {
            this.clearGlobalFocusOwner();
        }
    }

    private boolean restoreFocus(Window window, Component component, boolean bl2) {
        Component component2 = KeyboardFocusManager.getMostRecentFocusOwner(window);
        if (component2 != null && component2 != component && this.restoreFocus(component2, false)) {
            return true;
        }
        if (bl2) {
            this.clearGlobalFocusOwner();
            return true;
        }
        return false;
    }

    private boolean restoreFocus(Component component, boolean bl2) {
        if (component.isShowing() && component.isFocusable() && component.requestFocus(false)) {
            return true;
        }
        if (component.nextFocusHelper()) {
            return true;
        }
        if (bl2) {
            this.clearGlobalFocusOwner();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean sendMessage(Component component, AWTEvent aWTEvent) {
        aWTEvent.isPosted = true;
        AppContext appContext = AppContext.getAppContext();
        final AppContext appContext2 = component.appContext;
        final DefaultKeyboardFocusManagerSentEvent defaultKeyboardFocusManagerSentEvent = new DefaultKeyboardFocusManagerSentEvent(aWTEvent, appContext);
        if (appContext == appContext2) {
            ((SentEvent)defaultKeyboardFocusManagerSentEvent).dispatch();
        } else {
            if (appContext2.isDisposed()) {
                return false;
            }
            SunToolkit.postEvent(appContext2, defaultKeyboardFocusManagerSentEvent);
            if (EventQueue.isDispatchThread()) {
                EventDispatchThread eventDispatchThread = (EventDispatchThread)Thread.currentThread();
                eventDispatchThread.pumpEvents(1007, new Conditional(){

                    public boolean evaluate() {
                        return !defaultKeyboardFocusManagerSentEvent.dispatched && !appContext2.isDisposed();
                    }
                });
            } else {
                DefaultKeyboardFocusManagerSentEvent defaultKeyboardFocusManagerSentEvent2 = defaultKeyboardFocusManagerSentEvent;
                synchronized (defaultKeyboardFocusManagerSentEvent2) {
                    while (!defaultKeyboardFocusManagerSentEvent.dispatched && !appContext2.isDisposed()) {
                        try {
                            defaultKeyboardFocusManagerSentEvent.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }
        return defaultKeyboardFocusManagerSentEvent.dispatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean dispatchEvent(AWTEvent aWTEvent) {
        if (focusLog.isLoggable(Level.FINE) && (aWTEvent instanceof WindowEvent || aWTEvent instanceof FocusEvent)) {
            focusLog.fine("" + aWTEvent);
        }
        switch (aWTEvent.getID()) {
            case 207: {
                Component component;
                Window window;
                Window window2;
                boolean bl2;
                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                Window window3 = this.getGlobalFocusedWindow();
                Window window4 = windowEvent.getWindow();
                if (window4 == window3) {
                    return true;
                }
                if (window3 != null && !(bl2 = DefaultKeyboardFocusManager.sendMessage(window3, new WindowEvent(window3, 208, window4)))) {
                    this.setGlobalFocusOwner(null);
                    this.setGlobalFocusedWindow(null);
                }
                if ((window2 = this.getOwningFrameDialog(window4)) != (window = this.getGlobalActiveWindow())) {
                    DefaultKeyboardFocusManager.sendMessage(window2, new WindowEvent(window2, 205, window));
                    if (window2 != this.getGlobalActiveWindow()) {
                        this.restoreFocus(windowEvent);
                        return true;
                    }
                }
                this.setGlobalFocusedWindow(window4);
                if (window4 != this.getGlobalFocusedWindow()) {
                    this.restoreFocus(windowEvent);
                    return true;
                }
                this.setNativeFocusedWindow(window4);
                if (this.inSendMessage == 0) {
                    component = KeyboardFocusManager.getMostRecentFocusOwner(window4);
                    if (component == null && window4.isFocusableWindow()) {
                        component = window4.getFocusTraversalPolicy().getInitialComponent(window4);
                    }
                    Component component2 = null;
                    Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
                    // MONITORENTER : java.awt.KeyboardFocusManager.class
                    component2 = window4.setTemporaryLostComponent(null);
                    // MONITOREXIT : clazz
                    if (focusLog.isLoggable(Level.FINER)) {
                        focusLog.log(Level.FINER, "tempLost {0}, toFocus {1}", new Object[]{component2, component});
                    }
                    if (component2 != null) {
                        component2.requestFocusInWindow();
                    }
                    if (component != null && component != component2) {
                        component.requestFocusInWindow();
                    }
                }
                if ((component = this.realOppositeWindow) == windowEvent.getOppositeWindow()) return this.typeAheadAssertions(window4, windowEvent);
                windowEvent = new WindowEvent(window4, 207, (Window)component);
                return this.typeAheadAssertions(window4, windowEvent);
            }
            case 205: {
                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                Window window = this.getGlobalActiveWindow();
                Window window5 = windowEvent.getWindow();
                if (window == window5) {
                    return true;
                }
                if (window != null) {
                    boolean bl3 = DefaultKeyboardFocusManager.sendMessage(window, new WindowEvent(window, 206, window5));
                    if (!bl3) {
                        this.setGlobalActiveWindow(null);
                    }
                    if (this.getGlobalActiveWindow() != null) {
                        return true;
                    }
                }
                this.setGlobalActiveWindow(window5);
                if (window5 == this.getGlobalActiveWindow()) return this.typeAheadAssertions(window5, windowEvent);
                return true;
            }
            case 1004: {
                Component component;
                boolean bl4;
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                Component component3 = this.getGlobalFocusOwner();
                Component component4 = focusEvent.getComponent();
                if (component3 == component4) {
                    if (!focusLog.isLoggable(Level.FINE)) return true;
                    focusLog.log(Level.FINE, "Skipping {0} because focus owner is the same", new Object[]{aWTEvent});
                    return true;
                }
                if (component3 != null && !(bl4 = DefaultKeyboardFocusManager.sendMessage(component3, new FocusEvent(component3, 1005, focusEvent.isTemporary(), component4)))) {
                    this.setGlobalFocusOwner(null);
                    if (!focusEvent.isTemporary()) {
                        this.setGlobalPermanentFocusOwner(null);
                    }
                }
                Component component5 = component4;
                while (component5 != null && !(component5 instanceof Window)) {
                    component5 = component5.parent;
                }
                Window window = this.getGlobalFocusedWindow();
                if (component5 != null && component5 != window) {
                    DefaultKeyboardFocusManager.sendMessage(component5, new WindowEvent((Window)component5, 207, window));
                    if (component5 != this.getGlobalFocusedWindow()) {
                        this.dequeueKeyEvents(-1L, component4);
                        return true;
                    }
                }
                this.setGlobalFocusOwner(component4);
                if (component4 != this.getGlobalFocusOwner()) {
                    this.dequeueKeyEvents(-1L, component4);
                    this.restoreFocus(focusEvent, (Window)component5);
                    return true;
                }
                if (!focusEvent.isTemporary()) {
                    this.setGlobalPermanentFocusOwner(component4);
                    if (component4 != this.getGlobalPermanentFocusOwner()) {
                        this.dequeueKeyEvents(-1L, component4);
                        this.restoreFocus(focusEvent, (Window)component5);
                        return true;
                    }
                }
                if ((component = this.realOppositeComponent) == null) return this.typeAheadAssertions(component4, focusEvent);
                if (component == focusEvent.getOppositeComponent()) return this.typeAheadAssertions(component4, focusEvent);
                focusEvent = new FocusEvent(component4, 1004, focusEvent.isTemporary(), component);
                focusEvent.isPosted = true;
                return this.typeAheadAssertions(component4, focusEvent);
            }
            case 1005: {
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                Component component = this.getGlobalFocusOwner();
                if (component == null) {
                    if (!focusLog.isLoggable(Level.FINE)) return true;
                    focusLog.log(Level.FINE, "Skipping {0} because focus owner is null", new Object[]{aWTEvent});
                    return true;
                }
                if (component == focusEvent.getOppositeComponent()) {
                    if (!focusLog.isLoggable(Level.FINE)) return true;
                    focusLog.log(Level.FINE, "Skipping {0} because current focus owner is equal to opposite", new Object[]{aWTEvent});
                    return true;
                }
                this.setGlobalFocusOwner(null);
                if (this.getGlobalFocusOwner() != null) {
                    this.restoreFocus(component, true);
                    return true;
                }
                if (!focusEvent.isTemporary()) {
                    this.setGlobalPermanentFocusOwner(null);
                    if (this.getGlobalPermanentFocusOwner() != null) {
                        this.restoreFocus(component, true);
                        return true;
                    }
                } else {
                    Window window = component.getContainingWindow();
                    if (window != null) {
                        window.setTemporaryLostComponent(component);
                    }
                }
                focusEvent.setSource(component);
                this.realOppositeComponent = focusEvent.getOppositeComponent() != null ? component : null;
                return this.typeAheadAssertions(component, focusEvent);
            }
            case 206: {
                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                Window window = this.getGlobalActiveWindow();
                if (window == null) {
                    return true;
                }
                if (window != aWTEvent.getSource()) {
                    return true;
                }
                this.setGlobalActiveWindow(null);
                if (this.getGlobalActiveWindow() != null) {
                    return true;
                }
                windowEvent.setSource(window);
                return this.typeAheadAssertions(window, windowEvent);
            }
            case 208: {
                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                Window window = this.getGlobalFocusedWindow();
                Window window6 = windowEvent.getWindow();
                Window window7 = this.getGlobalActiveWindow();
                Window window8 = windowEvent.getOppositeWindow();
                if (focusLog.isLoggable(Level.FINE)) {
                    focusLog.log(Level.FINE, "Active {0}, Current focused {1}, losing focus {2} opposite {3}", new Object[]{window7, window, window6, window8});
                }
                if (window == null) {
                    return true;
                }
                if (this.inSendMessage == 0 && window6 == window7 && window8 == window) {
                    return true;
                }
                Component component = this.getGlobalFocusOwner();
                if (component != null) {
                    Component component6 = null;
                    if (window8 != null && (component6 = window8.getTemporaryLostComponent()) == null) {
                        component6 = window8.getMostRecentFocusOwner();
                    }
                    if (component6 == null) {
                        component6 = window8;
                    }
                    DefaultKeyboardFocusManager.sendMessage(component, new FocusEvent(component, 1005, true, component6));
                }
                this.setGlobalFocusedWindow(null);
                if (this.getGlobalFocusedWindow() != null) {
                    this.restoreFocus(window, null, true);
                    return true;
                }
                this.setNativeFocusedWindow(null);
                windowEvent.setSource(window);
                this.realOppositeWindow = window8 != null ? window : null;
                this.typeAheadAssertions(window, windowEvent);
                if (window8 != null) return true;
                DefaultKeyboardFocusManager.sendMessage(window7, new WindowEvent(window7, 206, null));
                if (this.getGlobalActiveWindow() == null) return true;
                this.restoreFocus(window, null, true);
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                return this.typeAheadAssertions(null, aWTEvent);
            }
        }
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        Container container;
        ComponentPeer componentPeer;
        Object object;
        Component component;
        Component component2;
        Component component3 = component2 = keyEvent.isPosted ? this.getFocusOwner() : keyEvent.getComponent();
        if (component2 != null && component2.isShowing() && component2.isFocusable() && component2.isEnabled() && !keyEvent.isConsumed() && (component = keyEvent.getComponent()) != null && component.isEnabled()) {
            this.redispatchEvent(component, keyEvent);
        }
        boolean bl2 = false;
        List<KeyEventPostProcessor> list = this.getKeyEventPostProcessors();
        if (list != null) {
            object = list.iterator();
            while (!bl2 && object.hasNext()) {
                bl2 = ((KeyEventPostProcessor)object.next()).postProcessKeyEvent(keyEvent);
            }
        }
        if (!bl2) {
            this.postProcessKeyEvent(keyEvent);
        }
        if (((componentPeer = ((Component)(object = keyEvent.getComponent())).getPeer()) == null || componentPeer instanceof LightweightPeer) && (container = ((Component)object).getNativeContainer()) != null) {
            componentPeer = container.getPeer();
        }
        if (componentPeer != null) {
            componentPeer.handleEvent(keyEvent);
        }
        return true;
    }

    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        Component component;
        Container container;
        if (!keyEvent.isConsumed() && (container = (Container)((component = keyEvent.getComponent()) instanceof Container ? component : component.getParent())) != null) {
            container.postProcessKeyEvent(keyEvent);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pumpApprovedKeyEvents() {
        KeyEvent keyEvent;
        do {
            keyEvent = null;
            DefaultKeyboardFocusManager defaultKeyboardFocusManager = this;
            synchronized (defaultKeyboardFocusManager) {
                if (this.enqueuedKeyEvents.size() != 0) {
                    keyEvent = (KeyEvent)this.enqueuedKeyEvents.getFirst();
                    if (this.typeAheadMarkers.size() != 0) {
                        TypeAheadMarker typeAheadMarker = (TypeAheadMarker)this.typeAheadMarkers.getFirst();
                        if (keyEvent.getWhen() > typeAheadMarker.after) {
                            keyEvent = null;
                        }
                    }
                    if (keyEvent != null) {
                        this.enqueuedKeyEvents.removeFirst();
                    }
                }
            }
            if (keyEvent == null) continue;
            this.preDispatchKeyEvent(keyEvent);
        } while (keyEvent != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpMarkers() {
        System.err.println(">>> Markers dump, time: " + System.currentTimeMillis());
        DefaultKeyboardFocusManager defaultKeyboardFocusManager = this;
        synchronized (defaultKeyboardFocusManager) {
            if (this.typeAheadMarkers.size() != 0) {
                for (TypeAheadMarker typeAheadMarker : this.typeAheadMarkers) {
                    System.err.println(typeAheadMarker);
                }
            }
        }
        System.err.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean typeAheadAssertions(Component component, AWTEvent aWTEvent) {
        this.pumpApprovedKeyEvents();
        switch (aWTEvent.getID()) {
            case 400: 
            case 401: 
            case 402: {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                DefaultKeyboardFocusManager defaultKeyboardFocusManager = this;
                synchronized (defaultKeyboardFocusManager) {
                    if (aWTEvent.isPosted && this.typeAheadMarkers.size() != 0) {
                        TypeAheadMarker typeAheadMarker = (TypeAheadMarker)this.typeAheadMarkers.getFirst();
                        if (keyEvent.getWhen() > typeAheadMarker.after) {
                            this.enqueuedKeyEvents.addLast(keyEvent);
                            return true;
                        }
                    }
                }
                return this.preDispatchKeyEvent(keyEvent);
            }
            case 1004: {
                DefaultKeyboardFocusManager defaultKeyboardFocusManager = this;
                synchronized (defaultKeyboardFocusManager) {
                    boolean bl2 = false;
                    if (this.hasMarker(component)) {
                        Iterator iterator = this.typeAheadMarkers.iterator();
                        while (iterator.hasNext()) {
                            if (((TypeAheadMarker)iterator.next()).untilFocused == component) {
                                bl2 = true;
                            } else if (bl2) break;
                            iterator.remove();
                        }
                    }
                }
                this.redispatchEvent(component, aWTEvent);
                this.pumpApprovedKeyEvents();
                return true;
            }
        }
        this.redispatchEvent(component, aWTEvent);
        return true;
    }

    private boolean hasMarker(Component component) {
        Iterator iterator = this.typeAheadMarkers.iterator();
        while (iterator.hasNext()) {
            if (((TypeAheadMarker)iterator.next()).untilFocused != component) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearMarkers() {
        DefaultKeyboardFocusManager defaultKeyboardFocusManager = this;
        synchronized (defaultKeyboardFocusManager) {
            this.typeAheadMarkers.clear();
        }
    }

    private boolean preDispatchKeyEvent(KeyEvent keyEvent) {
        List<KeyEventDispatcher> list;
        if (keyEvent.isPosted) {
            list = this.getFocusOwner();
            keyEvent.setSource(list != null ? list : this.getFocusedWindow());
        }
        if (keyEvent.getSource() == null) {
            return true;
        }
        EventQueue.setCurrentEventAndMostRecentTime(keyEvent);
        if (KeyboardFocusManager.isProxyActive(keyEvent)) {
            ComponentPeer componentPeer;
            list = (Component)keyEvent.getSource();
            Container container = ((Component)((Object)list)).getNativeContainer();
            if (container != null && (componentPeer = container.getPeer()) != null) {
                componentPeer.handleEvent(keyEvent);
                keyEvent.consume();
            }
            return true;
        }
        list = this.getKeyEventDispatchers();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!((KeyEventDispatcher)iterator.next()).dispatchKeyEvent(keyEvent)) continue;
                return true;
            }
        }
        return this.dispatchKeyEvent(keyEvent);
    }

    private void consumeTraversalKey(KeyEvent keyEvent) {
        keyEvent.consume();
        this.consumeNextKeyTyped = keyEvent.getID() == 401 && !keyEvent.isActionKey();
    }

    private boolean consumeProcessedKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400 && this.consumeNextKeyTyped) {
            keyEvent.consume();
            this.consumeNextKeyTyped = false;
            return true;
        }
        return false;
    }

    public void processKeyEvent(Component component, KeyEvent keyEvent) {
        if (this.consumeProcessedKeyEvent(keyEvent)) {
            return;
        }
        if (keyEvent.getID() == 400) {
            return;
        }
        if (component.getFocusTraversalKeysEnabled() && !keyEvent.isConsumed()) {
            AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
            AWTKeyStroke aWTKeyStroke2 = AWTKeyStroke.getAWTKeyStroke(aWTKeyStroke.getKeyCode(), aWTKeyStroke.getModifiers(), !aWTKeyStroke.isOnKeyRelease());
            Set<AWTKeyStroke> set = component.getFocusTraversalKeys(0);
            boolean bl2 = set.contains(aWTKeyStroke);
            boolean bl3 = set.contains(aWTKeyStroke2);
            if (bl2 || bl3) {
                this.consumeTraversalKey(keyEvent);
                if (bl2) {
                    this.focusNextComponent(component);
                }
                return;
            }
            set = component.getFocusTraversalKeys(1);
            bl2 = set.contains(aWTKeyStroke);
            bl3 = set.contains(aWTKeyStroke2);
            if (bl2 || bl3) {
                this.consumeTraversalKey(keyEvent);
                if (bl2) {
                    this.focusPreviousComponent(component);
                }
                return;
            }
            set = component.getFocusTraversalKeys(2);
            bl2 = set.contains(aWTKeyStroke);
            bl3 = set.contains(aWTKeyStroke2);
            if (bl2 || bl3) {
                this.consumeTraversalKey(keyEvent);
                if (bl2) {
                    this.upFocusCycle(component);
                }
                return;
            }
            if (!(component instanceof Container) || !((Container)component).isFocusCycleRoot()) {
                return;
            }
            set = component.getFocusTraversalKeys(3);
            bl2 = set.contains(aWTKeyStroke);
            bl3 = set.contains(aWTKeyStroke2);
            if (bl2 || bl3) {
                this.consumeTraversalKey(keyEvent);
                if (bl2) {
                    this.downFocusCycle((Container)component);
                }
            }
        }
    }

    protected synchronized void enqueueKeyEvents(long l2, Component component) {
        int n2;
        if (component == null) {
            return;
        }
        int n3 = 0;
        ListIterator listIterator = this.typeAheadMarkers.listIterator(n2);
        for (n2 = this.typeAheadMarkers.size(); n2 > 0; --n2) {
            TypeAheadMarker typeAheadMarker = (TypeAheadMarker)listIterator.previous();
            if (typeAheadMarker.after > l2) continue;
            n3 = n2;
            break;
        }
        this.typeAheadMarkers.add(n3, new TypeAheadMarker(l2, component));
    }

    protected synchronized void dequeueKeyEvents(long l2, Component component) {
        if (component == null) {
            return;
        }
        ListIterator listIterator = this.typeAheadMarkers.listIterator(l2 >= 0L ? this.typeAheadMarkers.size() : 0);
        if (l2 < 0L) {
            while (listIterator.hasNext()) {
                TypeAheadMarker typeAheadMarker = (TypeAheadMarker)listIterator.next();
                if (typeAheadMarker.untilFocused != component) continue;
                listIterator.remove();
                return;
            }
        } else {
            while (listIterator.hasPrevious()) {
                TypeAheadMarker typeAheadMarker = (TypeAheadMarker)listIterator.previous();
                if (typeAheadMarker.untilFocused != component || typeAheadMarker.after != l2) continue;
                listIterator.remove();
                return;
            }
        }
    }

    protected synchronized void discardKeyEvents(Component component) {
        if (component == null) {
            return;
        }
        long l2 = -1L;
        Iterator iterator = this.typeAheadMarkers.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            TypeAheadMarker typeAheadMarker = (TypeAheadMarker)iterator.next();
            Component component2 = typeAheadMarker.untilFocused;
            boolean bl3 = bl2 = component2 == component;
            while (!bl2 && component2 != null && !(component2 instanceof Window)) {
                bl2 = (component2 = component2.getParent()) == component;
            }
            if (bl2) {
                if (l2 < 0L) {
                    l2 = typeAheadMarker.after;
                }
                iterator.remove();
                continue;
            }
            if (l2 < 0L) continue;
            this.purgeStampedEvents(l2, typeAheadMarker.after);
            l2 = -1L;
        }
        this.purgeStampedEvents(l2, -1L);
    }

    private void purgeStampedEvents(long l2, long l3) {
        if (l2 < 0L) {
            return;
        }
        Iterator iterator = this.enqueuedKeyEvents.iterator();
        while (iterator.hasNext()) {
            KeyEvent keyEvent = (KeyEvent)iterator.next();
            long l4 = keyEvent.getWhen();
            if (l2 < l4 && (l3 < 0L || l4 <= l3)) {
                iterator.remove();
            }
            if (l3 < 0L || l4 <= l3) continue;
            break;
        }
    }

    public void focusPreviousComponent(Component component) {
        if (component != null) {
            component.transferFocusBackward();
        }
    }

    public void focusNextComponent(Component component) {
        if (component != null) {
            component.transferFocus();
        }
    }

    public void upFocusCycle(Component component) {
        if (component != null) {
            component.transferFocusUpCycle();
        }
    }

    public void downFocusCycle(Container container) {
        if (container != null && container.isFocusCycleRoot()) {
            container.transferFocusDownCycle();
        }
    }

    private static class DefaultKeyboardFocusManagerSentEvent
    extends SentEvent {
        public DefaultKeyboardFocusManagerSentEvent(AWTEvent aWTEvent, AppContext appContext) {
            super(aWTEvent, appContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dispatch() {
            DefaultKeyboardFocusManager defaultKeyboardFocusManager;
            DefaultKeyboardFocusManager defaultKeyboardFocusManager2;
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            DefaultKeyboardFocusManager defaultKeyboardFocusManager3 = defaultKeyboardFocusManager2 = keyboardFocusManager instanceof DefaultKeyboardFocusManager ? (DefaultKeyboardFocusManager)keyboardFocusManager : null;
            if (defaultKeyboardFocusManager2 != null) {
                defaultKeyboardFocusManager = defaultKeyboardFocusManager2;
                synchronized (defaultKeyboardFocusManager) {
                    defaultKeyboardFocusManager2.inSendMessage++;
                }
            }
            super.dispatch();
            if (defaultKeyboardFocusManager2 != null) {
                defaultKeyboardFocusManager = defaultKeyboardFocusManager2;
                synchronized (defaultKeyboardFocusManager) {
                    defaultKeyboardFocusManager2.inSendMessage--;
                }
            }
        }
    }

    private static class TypeAheadMarker {
        long after;
        Component untilFocused;

        TypeAheadMarker(long l2, Component component) {
            this.after = l2;
            this.untilFocused = component;
        }

        public String toString() {
            return ">>> Marker after " + this.after + " on " + this.untilFocused;
        }
    }
}

