/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Hashtable;
import java.util.Vector;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.OffScreenImageSource;
import sun.awt.image.ShortComponentRaster;
import sun.awt.image.SurfaceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedImage
extends Image
implements WritableRenderedImage,
Transparency {
    int imageType = 0;
    ColorModel colorModel;
    WritableRaster raster;
    OffScreenImageSource osis;
    Hashtable properties;
    boolean isAlphaPremultiplied;
    SurfaceManager surfaceManager;
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_INT_RGB = 1;
    public static final int TYPE_INT_ARGB = 2;
    public static final int TYPE_INT_ARGB_PRE = 3;
    public static final int TYPE_INT_BGR = 4;
    public static final int TYPE_3BYTE_BGR = 5;
    public static final int TYPE_4BYTE_ABGR = 6;
    public static final int TYPE_4BYTE_ABGR_PRE = 7;
    public static final int TYPE_USHORT_565_RGB = 8;
    public static final int TYPE_USHORT_555_RGB = 9;
    public static final int TYPE_BYTE_GRAY = 10;
    public static final int TYPE_USHORT_GRAY = 11;
    public static final int TYPE_BYTE_BINARY = 12;
    public static final int TYPE_BYTE_INDEXED = 13;
    private static final int DCM_RED_MASK = 0xFF0000;
    private static final int DCM_GREEN_MASK = 65280;
    private static final int DCM_BLUE_MASK = 255;
    private static final int DCM_ALPHA_MASK = -16777216;
    private static final int DCM_565_RED_MASK = 63488;
    private static final int DCM_565_GRN_MASK = 2016;
    private static final int DCM_565_BLU_MASK = 31;
    private static final int DCM_555_RED_MASK = 31744;
    private static final int DCM_555_GRN_MASK = 992;
    private static final int DCM_555_BLU_MASK = 31;
    private static final int DCM_BGR_RED_MASK = 255;
    private static final int DCM_BGR_GRN_MASK = 65280;
    private static final int DCM_BGR_BLU_MASK = 0xFF0000;

    private static native void initIDs();

    public BufferedImage(int n2, int n3, int n4) {
        switch (n4) {
            case 1: {
                this.colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
                this.raster = this.colorModel.createCompatibleWritableRaster(n2, n3);
                break;
            }
            case 2: {
                this.colorModel = ColorModel.getRGBdefault();
                this.raster = this.colorModel.createCompatibleWritableRaster(n2, n3);
                break;
            }
            case 3: {
                this.colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
                this.raster = this.colorModel.createCompatibleWritableRaster(n2, n3);
                break;
            }
            case 4: {
                this.colorModel = new DirectColorModel(24, 255, 65280, 0xFF0000);
                this.raster = this.colorModel.createCompatibleWritableRaster(n2, n3);
                break;
            }
            case 5: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{8, 8, 8};
                int[] nArray2 = new int[]{2, 1, 0};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, 0);
                this.raster = Raster.createInterleavedRaster(0, n2, n3, n2 * 3, 3, nArray2, null);
                break;
            }
            case 6: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{8, 8, 8, 8};
                int[] nArray3 = new int[]{3, 2, 1, 0};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, true, false, 3, 0);
                this.raster = Raster.createInterleavedRaster(0, n2, n3, n2 * 4, 4, nArray3, null);
                break;
            }
            case 7: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{8, 8, 8, 8};
                int[] nArray4 = new int[]{3, 2, 1, 0};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, true, true, 3, 0);
                this.raster = Raster.createInterleavedRaster(0, n2, n3, n2 * 4, 4, nArray4, null);
                break;
            }
            case 10: {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                int[] nArray = new int[]{8};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, false, true, 1, 0);
                this.raster = this.colorModel.createCompatibleWritableRaster(n2, n3);
                break;
            }
            case 11: {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                int[] nArray = new int[]{16};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, false, true, 1, 1);
                this.raster = this.colorModel.createCompatibleWritableRaster(n2, n3);
                break;
            }
            case 12: {
                byte[] byArray = new byte[]{0, -1};
                this.colorModel = new IndexColorModel(1, 2, byArray, byArray, byArray);
                this.raster = Raster.createPackedRaster(0, n2, n3, 1, 1, null);
                break;
            }
            case 13: {
                int n5;
                int n6;
                int[] nArray = new int[256];
                int n7 = 0;
                for (n6 = 0; n6 < 256; n6 += 51) {
                    for (n5 = 0; n5 < 256; n5 += 51) {
                        for (int i2 = 0; i2 < 256; i2 += 51) {
                            nArray[n7++] = n6 << 16 | n5 << 8 | i2;
                        }
                    }
                }
                n6 = 256 / (256 - n7);
                n5 = n6 * 3;
                while (n7 < 256) {
                    nArray[n7] = n5 << 16 | n5 << 8 | n5;
                    n5 += n6;
                    ++n7;
                }
                this.colorModel = new IndexColorModel(8, 256, nArray, 0, false, -1, 0);
                this.raster = Raster.createInterleavedRaster(0, n2, n3, 1, null);
                break;
            }
            case 8: {
                this.colorModel = new DirectColorModel(16, 63488, 2016, 31);
                this.raster = this.colorModel.createCompatibleWritableRaster(n2, n3);
                break;
            }
            case 9: {
                this.colorModel = new DirectColorModel(15, 31744, 992, 31);
                this.raster = this.colorModel.createCompatibleWritableRaster(n2, n3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image type " + n4);
            }
        }
        this.imageType = n4;
    }

    public BufferedImage(int n2, int n3, int n4, IndexColorModel indexColorModel) {
        if (indexColorModel.hasAlpha() && indexColorModel.isAlphaPremultiplied()) {
            throw new IllegalArgumentException("This image types do not have premultiplied alpha.");
        }
        switch (n4) {
            case 12: {
                int n5;
                int n6 = indexColorModel.getMapSize();
                if (n6 <= 2) {
                    n5 = 1;
                } else if (n6 <= 4) {
                    n5 = 2;
                } else if (n6 <= 16) {
                    n5 = 4;
                } else {
                    throw new IllegalArgumentException("Color map for TYPE_BYTE_BINARY must have no more than 16 entries");
                }
                this.raster = Raster.createPackedRaster(0, n2, n3, 1, n5, null);
                break;
            }
            case 13: {
                this.raster = Raster.createInterleavedRaster(0, n2, n3, 1, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid image type (" + n4 + ").  Image type must" + " be either TYPE_BYTE_BINARY or " + " TYPE_BYTE_INDEXED");
            }
        }
        if (!indexColorModel.isCompatibleRaster(this.raster)) {
            throw new IllegalArgumentException("Incompatible image type and IndexColorModel");
        }
        this.colorModel = indexColorModel;
        this.imageType = n4;
    }

    public BufferedImage(ColorModel colorModel, WritableRaster writableRaster, boolean bl2, Hashtable<?, ?> hashtable) {
        if (!colorModel.isCompatibleRaster(writableRaster)) {
            throw new IllegalArgumentException("Raster " + writableRaster + " is incompatible with ColorModel " + colorModel);
        }
        if (writableRaster.minX != 0 || writableRaster.minY != 0) {
            throw new IllegalArgumentException("Raster " + writableRaster + " has minX or minY not equal to zero: " + writableRaster.minX + " " + writableRaster.minY);
        }
        this.colorModel = colorModel;
        this.raster = writableRaster;
        this.properties = hashtable;
        int n2 = writableRaster.getNumBands();
        boolean bl3 = colorModel.isAlphaPremultiplied();
        this.coerceData(bl2);
        SampleModel sampleModel = writableRaster.getSampleModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n3 = colorSpace.getType();
        if (n3 != 5) {
            if (n3 == 6 && colorModel instanceof ComponentColorModel) {
                if (sampleModel instanceof ComponentSampleModel && ((ComponentSampleModel)sampleModel).getPixelStride() != n2) {
                    this.imageType = 0;
                } else if (writableRaster instanceof ByteComponentRaster && writableRaster.getNumBands() == 1 && colorModel.getComponentSize(0) == 8 && ((ByteComponentRaster)writableRaster).getPixelStride() == 1) {
                    this.imageType = 10;
                } else if (writableRaster instanceof ShortComponentRaster && writableRaster.getNumBands() == 1 && colorModel.getComponentSize(0) == 16 && ((ShortComponentRaster)writableRaster).getPixelStride() == 1) {
                    this.imageType = 11;
                }
            } else {
                this.imageType = 0;
            }
            return;
        }
        if (writableRaster instanceof IntegerComponentRaster && (n2 == 3 || n2 == 4)) {
            IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)writableRaster;
            int n4 = colorModel.getPixelSize();
            if (integerComponentRaster.getPixelStride() == 1 && colorModel instanceof DirectColorModel && (n4 == 32 || n4 == 24)) {
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                int n5 = directColorModel.getRedMask();
                int n6 = directColorModel.getGreenMask();
                int n7 = directColorModel.getBlueMask();
                if (n5 == 0xFF0000 && n6 == 65280 && n7 == 255) {
                    if (directColorModel.getAlphaMask() == -16777216) {
                        this.imageType = bl3 ? 3 : 2;
                    } else if (!directColorModel.hasAlpha()) {
                        this.imageType = 1;
                    }
                } else if (n5 == 255 && n6 == 65280 && n7 == 0xFF0000 && !directColorModel.hasAlpha()) {
                    this.imageType = 4;
                }
            }
        } else if (!(!(colorModel instanceof IndexColorModel) || n2 != 1 || colorModel.hasAlpha() && bl3)) {
            ByteComponentRaster byteComponentRaster;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n8 = indexColorModel.getPixelSize();
            if (writableRaster instanceof BytePackedRaster) {
                this.imageType = 12;
            } else if (writableRaster instanceof ByteComponentRaster && (byteComponentRaster = (ByteComponentRaster)writableRaster).getPixelStride() == 1 && n8 <= 8) {
                this.imageType = 13;
            }
        } else if (writableRaster instanceof ShortComponentRaster && colorModel instanceof DirectColorModel && n2 == 3 && !colorModel.hasAlpha()) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            if (directColorModel.getRedMask() == 63488) {
                if (directColorModel.getGreenMask() == 2016 && directColorModel.getBlueMask() == 31) {
                    this.imageType = 8;
                }
            } else if (directColorModel.getRedMask() == 31744 && directColorModel.getGreenMask() == 992 && directColorModel.getBlueMask() == 31) {
                this.imageType = 9;
            }
        } else if (writableRaster instanceof ByteComponentRaster && colorModel instanceof ComponentColorModel && writableRaster.getSampleModel() instanceof PixelInterleavedSampleModel && (n2 == 3 || n2 == 4)) {
            ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
            PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
            ByteComponentRaster byteComponentRaster = (ByteComponentRaster)writableRaster;
            int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
            if (componentColorModel.getNumComponents() != n2) {
                throw new RasterFormatException("Number of components in ColorModel (" + componentColorModel.getNumComponents() + ") does not match # in " + " Raster (" + n2 + ")");
            }
            int[] nArray2 = componentColorModel.getComponentSize();
            boolean bl4 = true;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (nArray2[i2] == 8) continue;
                bl4 = false;
                break;
            }
            if (bl4 && nArray[0] == n2 - 1 && nArray[1] == n2 - 2 && nArray[2] == n2 - 3) {
                if (n2 == 3) {
                    this.imageType = 5;
                } else if (nArray[3] == 0) {
                    this.imageType = bl3 ? 7 : 6;
                }
            }
        }
    }

    public int getType() {
        return this.imageType;
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public WritableRaster getRaster() {
        return this.raster;
    }

    public WritableRaster getAlphaRaster() {
        return this.colorModel.getAlphaRaster(this.raster);
    }

    public int getRGB(int n2, int n3) {
        return this.colorModel.getRGB(this.raster.getDataElements(n2, n3, null));
    }

    public int[] getRGB(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        Object[] objectArray;
        int n8 = n6;
        int n9 = this.raster.getNumBands();
        int n10 = this.raster.getDataBuffer().getDataType();
        switch (n10) {
            case 0: {
                objectArray = new byte[n9];
                break;
            }
            case 1: {
                objectArray = new short[n9];
                break;
            }
            case 3: {
                objectArray = new int[n9];
                break;
            }
            case 4: {
                objectArray = new float[n9];
                break;
            }
            case 5: {
                objectArray = new double[n9];
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data buffer type: " + n10);
            }
        }
        if (nArray == null) {
            nArray = new int[n6 + n5 * n7];
        }
        int n11 = n3;
        while (n11 < n3 + n5) {
            int n12 = n8;
            for (int i2 = n2; i2 < n2 + n4; ++i2) {
                nArray[n12++] = this.colorModel.getRGB(this.raster.getDataElements(i2, n11, objectArray));
            }
            ++n11;
            n8 += n7;
        }
        return nArray;
    }

    public synchronized void setRGB(int n2, int n3, int n4) {
        this.raster.setDataElements(n2, n3, this.colorModel.getDataElements(n4, null));
    }

    public void setRGB(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        int n8 = n6;
        Object object = null;
        int n9 = n3;
        while (n9 < n3 + n5) {
            int n10 = n8;
            for (int i2 = n2; i2 < n2 + n4; ++i2) {
                object = this.colorModel.getDataElements(nArray[n10++], object);
                this.raster.setDataElements(i2, n9, object);
            }
            ++n9;
            n8 += n7;
        }
    }

    @Override
    public int getWidth() {
        return this.raster.getWidth();
    }

    @Override
    public int getHeight() {
        return this.raster.getHeight();
    }

    @Override
    public int getWidth(ImageObserver imageObserver) {
        return this.raster.getWidth();
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        return this.raster.getHeight();
    }

    @Override
    public ImageProducer getSource() {
        if (this.osis == null) {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            this.osis = new OffScreenImageSource(this, this.properties);
        }
        return this.osis;
    }

    @Override
    public Object getProperty(String string, ImageObserver imageObserver) {
        return this.getProperty(string);
    }

    @Override
    public Object getProperty(String string) {
        Object object;
        if (string == null) {
            throw new NullPointerException("null property name is not allowed");
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if ((object = this.properties.get(string)) == null) {
            object = Image.UndefinedProperty;
        }
        return object;
    }

    @Override
    public void flush() {
        if (this.surfaceManager != null) {
            this.surfaceManager.flush();
        }
    }

    @Override
    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public Graphics2D createGraphics() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.createGraphics(this);
    }

    public BufferedImage getSubimage(int n2, int n3, int n4, int n5) {
        return new BufferedImage(this.colorModel, this.raster.createWritableChild(n2, n3, n4, n5, 0, 0, null), this.colorModel.isAlphaPremultiplied(), this.properties);
    }

    public boolean isAlphaPremultiplied() {
        return this.colorModel.isAlphaPremultiplied();
    }

    public void coerceData(boolean bl2) {
        if (this.colorModel.hasAlpha() && this.colorModel.isAlphaPremultiplied() != bl2) {
            this.colorModel = this.colorModel.coerceData(this.raster, bl2);
        }
    }

    public String toString() {
        return new String("BufferedImage@" + Integer.toHexString(this.hashCode()) + ": type = " + this.imageType + " " + this.colorModel + " " + this.raster);
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return null;
    }

    @Override
    public int getMinX() {
        return this.raster.getMinX();
    }

    @Override
    public int getMinY() {
        return this.raster.getMinY();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.raster.getSampleModel();
    }

    @Override
    public int getNumXTiles() {
        return 1;
    }

    @Override
    public int getNumYTiles() {
        return 1;
    }

    @Override
    public int getMinTileX() {
        return 0;
    }

    @Override
    public int getMinTileY() {
        return 0;
    }

    @Override
    public int getTileWidth() {
        return this.raster.getWidth();
    }

    @Override
    public int getTileHeight() {
        return this.raster.getHeight();
    }

    @Override
    public int getTileGridXOffset() {
        return this.raster.getSampleModelTranslateX();
    }

    @Override
    public int getTileGridYOffset() {
        return this.raster.getSampleModelTranslateY();
    }

    @Override
    public Raster getTile(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this.raster;
        }
        throw new ArrayIndexOutOfBoundsException("BufferedImages only have one tile with index 0,0");
    }

    @Override
    public Raster getData() {
        int n2 = this.raster.getWidth();
        int n3 = this.raster.getHeight();
        int n4 = this.raster.getMinX();
        int n5 = this.raster.getMinY();
        WritableRaster writableRaster = Raster.createWritableRaster(this.raster.getSampleModel(), new Point(this.raster.getSampleModelTranslateX(), this.raster.getSampleModelTranslateY()));
        Object object = null;
        for (int i2 = n5; i2 < n5 + n3; ++i2) {
            object = this.raster.getDataElements(n4, i2, n2, 1, object);
            writableRaster.setDataElements(n4, i2, n2, 1, object);
        }
        return writableRaster;
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        SampleModel sampleModel = this.raster.getSampleModel();
        SampleModel sampleModel2 = sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel2, rectangle.getLocation());
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        Object object = null;
        for (int i2 = n5; i2 < n5 + n3; ++i2) {
            object = this.raster.getDataElements(n4, i2, n2, 1, object);
            writableRaster.setDataElements(n4, i2, n2, 1, object);
        }
        return writableRaster;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        if (writableRaster == null) {
            return (WritableRaster)this.getData();
        }
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getMinX();
        int n5 = writableRaster.getMinY();
        Object object = null;
        for (int i2 = n5; i2 < n5 + n3; ++i2) {
            object = this.raster.getDataElements(n4, i2, n2, 1, object);
            writableRaster.setDataElements(n4, i2, n2, 1, object);
        }
        return writableRaster;
    }

    @Override
    public void setData(Raster raster) {
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        int n4 = raster.getMinX();
        int n5 = raster.getMinY();
        int[] nArray = null;
        Rectangle rectangle = new Rectangle(n4, n5, n2, n3);
        Rectangle rectangle2 = new Rectangle(0, 0, this.raster.width, this.raster.height);
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.isEmpty()) {
            return;
        }
        n2 = rectangle3.width;
        n3 = rectangle3.height;
        n4 = rectangle3.x;
        for (int i2 = n5 = rectangle3.y; i2 < n5 + n3; ++i2) {
            nArray = raster.getPixels(n4, i2, n2, 1, nArray);
            this.raster.setPixels(n4, i2, n2, 1, nArray);
        }
    }

    @Override
    public void addTileObserver(TileObserver tileObserver) {
    }

    @Override
    public void removeTileObserver(TileObserver tileObserver) {
    }

    @Override
    public boolean isTileWritable(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return true;
        }
        throw new IllegalArgumentException("Only 1 tile in image");
    }

    @Override
    public Point[] getWritableTileIndices() {
        Point[] pointArray = new Point[]{new Point(0, 0)};
        return pointArray;
    }

    @Override
    public boolean hasTileWriters() {
        return true;
    }

    @Override
    public WritableRaster getWritableTile(int n2, int n3) {
        return this.raster;
    }

    @Override
    public void releaseWritableTile(int n2, int n3) {
    }

    @Override
    public int getTransparency() {
        return this.colorModel.getTransparency();
    }

    @Override
    public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
        if (this.surfaceManager != null) {
            return this.surfaceManager.getCapabilities(graphicsConfiguration);
        }
        return super.getCapabilities(graphicsConfiguration);
    }

    static {
        ColorModel.loadLibraries();
        BufferedImage.initIDs();
    }
}

