/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;

public abstract class InputStream
implements Closeable {
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static byte[] skipBuffer;

    public abstract int read() throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n5 = this.read();
        if (n5 == -1) {
            return -1;
        }
        byArray[n2] = (byte)n5;
        try {
            for (n4 = 1; n4 < n3 && (n5 = this.read()) != -1; ++n4) {
                if (byArray == null) continue;
                byArray[n2 + n4] = (byte)n5;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n4;
    }

    public long skip(long l2) throws IOException {
        int n2;
        long l3 = l2;
        if (skipBuffer == null) {
            skipBuffer = new byte[2048];
        }
        byte[] byArray = skipBuffer;
        if (l2 <= 0L) {
            return 0L;
        }
        while (l3 > 0L && (n2 = this.read(byArray, 0, (int)Math.min(2048L, l3))) >= 0) {
            l3 -= (long)n2;
        }
        return l2 - l3;
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int n2) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }
}

