/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.InterruptibleChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.ch.Interruptible;

public abstract class AbstractInterruptibleChannel
implements Channel,
InterruptibleChannel {
    private Object closeLock = new Object();
    private volatile boolean open = true;
    private Interruptible interruptor;
    private volatile boolean interrupted = false;
    private static Method blockedOnMethod = null;

    protected AbstractInterruptibleChannel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.implCloseChannel();
        }
    }

    protected abstract void implCloseChannel() throws IOException;

    public final boolean isOpen() {
        return this.open;
    }

    protected final void begin() {
        if (this.interruptor == null) {
            this.interruptor = new Interruptible(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void interrupt() {
                    Object object = AbstractInterruptibleChannel.this.closeLock;
                    synchronized (object) {
                        if (!AbstractInterruptibleChannel.this.open) {
                            return;
                        }
                        AbstractInterruptibleChannel.this.interrupted = true;
                        AbstractInterruptibleChannel.this.open = false;
                        try {
                            AbstractInterruptibleChannel.this.implCloseChannel();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
        }
        AbstractInterruptibleChannel.blockedOn(this.interruptor);
        if (Thread.currentThread().isInterrupted()) {
            this.interruptor.interrupt();
        }
    }

    protected final void end(boolean bl2) throws AsynchronousCloseException {
        AbstractInterruptibleChannel.blockedOn(null);
        if (bl2) {
            this.interrupted = false;
            return;
        }
        if (this.interrupted) {
            throw new ClosedByInterruptException();
        }
        if (!this.open) {
            throw new AsynchronousCloseException();
        }
    }

    static void blockedOn(Interruptible interruptible) {
        if (blockedOnMethod == null) {
            AbstractInterruptibleChannel.initBlockedOn();
        }
        try {
            blockedOnMethod.invoke(Thread.currentThread(), interruptible);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException);
        }
    }

    private static void initBlockedOn() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("java.lang.Thread");
                    blockedOnMethod = clazz.getDeclaredMethod("blockedOn", Interruptible.class);
                    blockedOnMethod.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new Error(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new Error(noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Error(illegalArgumentException);
                }
                catch (ClassCastException classCastException) {
                    throw new Error(classCastException);
                }
                return null;
            }
        });
    }

    static {
        FooChannel fooChannel = new FooChannel();
        fooChannel.begin();
        try {
            fooChannel.end(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class FooChannel
    extends AbstractInterruptibleChannel {
        private FooChannel() {
        }

        protected void implCloseChannel() {
        }
    }
}

