/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.WeakHashMap;
import sun.security.provider.PolicyFile;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public abstract class Policy {
    private static Policy policy;
    private static final Debug debug;
    private WeakHashMap pdMapping;

    static boolean isSet() {
        return policy != null;
    }

    public static Policy getPolicy() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
        }
        return Policy.getPolicyNoCheck();
    }

    static synchronized Policy getPolicyNoCheck() {
        block5: {
            if (policy == null) {
                String string = null;
                string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Security.getProperty("policy.provider");
                    }
                });
                if (string == null) {
                    string = "sun.security.provider.PolicyFile";
                }
                try {
                    policy = (Policy)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    policy = new PolicyFile();
                    final String string2 = string;
                    Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                ClassLoader classLoader = null;
                                for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
                                    classLoader = classLoader2;
                                }
                                return classLoader != null ? Class.forName(string2, true, classLoader).newInstance() : null;
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }
                    });
                    if (policy != null) {
                        Policy.policy = policy;
                    }
                    if (policy != null || debug == null) break block5;
                    debug.println("policy provider " + string + " not available;using " + "sun.security.provider.PolicyFile");
                    exception.printStackTrace();
                }
            }
        }
        return policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicy(Policy policy) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (policy != null) {
            Policy.initPolicy(policy);
        }
        Class<Policy> clazz = Policy.class;
        synchronized (Policy.class) {
            Policy.policy = policy;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPolicy(final Policy policy) {
        ProtectionDomain protectionDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return policy.getClass().getProtectionDomain();
            }
        });
        PermissionCollection permissionCollection = null;
        Object object = policy;
        synchronized (object) {
            if (policy.pdMapping == null) {
                policy.pdMapping = new WeakHashMap();
            }
        }
        if (protectionDomain.getCodeSource() != null) {
            if (Policy.isSet()) {
                permissionCollection = Policy.policy.getPermissions(protectionDomain);
            }
            if (permissionCollection == null) {
                permissionCollection = new Permissions();
                permissionCollection.add(SecurityConstants.ALL_PERMISSION);
            }
            object = policy.pdMapping;
            synchronized (object) {
                policy.pdMapping.put(protectionDomain, permissionCollection);
            }
        }
    }

    public abstract PermissionCollection getPermissions(CodeSource var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        PermissionCollection permissionCollection = null;
        if (protectionDomain == null) {
            return new Permissions();
        }
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        Object object = this.pdMapping;
        synchronized (object) {
            permissionCollection = (PermissionCollection)this.pdMapping.get(protectionDomain);
        }
        if (permissionCollection != null) {
            object = new Permissions();
            PermissionCollection permissionCollection2 = permissionCollection;
            synchronized (permissionCollection2) {
                Enumeration<Permission> enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    ((Permissions)object).add(enumeration.nextElement());
                }
            }
            return object;
        }
        permissionCollection = this.getPermissions(protectionDomain.getCodeSource());
        if (permissionCollection == null) {
            permissionCollection = new Permissions();
        }
        this.addStaticPerms(permissionCollection, protectionDomain.getPermissions());
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticPerms(PermissionCollection permissionCollection, PermissionCollection permissionCollection2) {
        if (permissionCollection2 != null) {
            PermissionCollection permissionCollection3 = permissionCollection2;
            synchronized (permissionCollection3) {
                Enumeration<Permission> enumeration = permissionCollection2.elements();
                while (enumeration.hasMoreElements()) {
                    permissionCollection.add(enumeration.nextElement());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        PermissionCollection permissionCollection;
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        WeakHashMap weakHashMap = this.pdMapping;
        synchronized (weakHashMap) {
            permissionCollection = (PermissionCollection)this.pdMapping.get(protectionDomain);
        }
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        permissionCollection = this.getPermissions(protectionDomain);
        if (permissionCollection == null) {
            return false;
        }
        weakHashMap = this.pdMapping;
        synchronized (weakHashMap) {
            this.pdMapping.put(protectionDomain, permissionCollection);
        }
        return permissionCollection.implies(permission);
    }

    public abstract void refresh();

    static {
        debug = Debug.getInstance("policy");
    }
}

