/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicInteger
extends Number
implements Serializable {
    private static final long serialVersionUID = 6214790243416807050L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    private volatile int value;

    public AtomicInteger(int n2) {
        this.value = n2;
    }

    public AtomicInteger() {
    }

    public final int get() {
        return this.value;
    }

    public final void set(int n2) {
        this.value = n2;
    }

    public final int getAndSet(int n2) {
        int n3;
        while (!this.compareAndSet(n3 = this.get(), n2)) {
        }
        return n3;
    }

    public final boolean compareAndSet(int n2, int n3) {
        return unsafe.compareAndSwapInt(this, valueOffset, n2, n3);
    }

    public final boolean weakCompareAndSet(int n2, int n3) {
        return unsafe.compareAndSwapInt(this, valueOffset, n2, n3);
    }

    public final int getAndIncrement() {
        int n2;
        int n3;
        while (!this.compareAndSet(n3 = this.get(), n2 = n3 + 1)) {
        }
        return n3;
    }

    public final int getAndDecrement() {
        int n2;
        int n3;
        while (!this.compareAndSet(n3 = this.get(), n2 = n3 - 1)) {
        }
        return n3;
    }

    public final int getAndAdd(int n2) {
        int n3;
        int n4;
        while (!this.compareAndSet(n4 = this.get(), n3 = n4 + n2)) {
        }
        return n4;
    }

    public final int incrementAndGet() {
        int n2;
        int n3;
        while (!this.compareAndSet(n3 = this.get(), n2 = n3 + 1)) {
        }
        return n2;
    }

    public final int decrementAndGet() {
        int n2;
        int n3;
        while (!this.compareAndSet(n3 = this.get(), n2 = n3 - 1)) {
        }
        return n2;
    }

    public final int addAndGet(int n2) {
        int n3;
        int n4;
        while (!this.compareAndSet(n4 = this.get(), n3 = n4 + n2)) {
        }
        return n3;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    public int intValue() {
        return this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    static {
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicInteger.class.getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

