/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.Arrays;
import sun.misc.Unsafe;

public class AtomicLongArray
implements Serializable {
    private static final long serialVersionUID = -2308431214976778248L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(long[].class);
    private static final int scale = unsafe.arrayIndexScale(long[].class);
    private final long[] array;

    private long rawIndex(int n2) {
        if (n2 < 0 || n2 >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + n2);
        }
        return base + n2 * scale;
    }

    public AtomicLongArray(int n2) {
        this.array = new long[n2];
        if (n2 > 0) {
            unsafe.putLongVolatile(this.array, this.rawIndex(0), 0L);
        }
    }

    public AtomicLongArray(long[] lArray) {
        if (lArray == null) {
            throw new NullPointerException();
        }
        int n2 = lArray.length;
        this.array = new long[n2];
        if (n2 > 0) {
            int n3 = n2 - 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.array[i2] = lArray[i2];
            }
            unsafe.putLongVolatile(this.array, this.rawIndex(n3), lArray[n3]);
        }
    }

    public final int length() {
        return this.array.length;
    }

    public final long get(int n2) {
        return unsafe.getLongVolatile(this.array, this.rawIndex(n2));
    }

    public final void set(int n2, long l2) {
        unsafe.putLongVolatile(this.array, this.rawIndex(n2), l2);
    }

    public final long getAndSet(int n2, long l2) {
        long l3;
        while (!this.compareAndSet(n2, l3 = this.get(n2), l2)) {
        }
        return l3;
    }

    public final boolean compareAndSet(int n2, long l2, long l3) {
        return unsafe.compareAndSwapLong(this.array, this.rawIndex(n2), l2, l3);
    }

    public final boolean weakCompareAndSet(int n2, long l2, long l3) {
        return this.compareAndSet(n2, l2, l3);
    }

    public final long getAndIncrement(int n2) {
        long l2;
        long l3;
        while (!this.compareAndSet(n2, l3 = this.get(n2), l2 = l3 + 1L)) {
        }
        return l3;
    }

    public final long getAndDecrement(int n2) {
        long l2;
        long l3;
        while (!this.compareAndSet(n2, l3 = this.get(n2), l2 = l3 - 1L)) {
        }
        return l3;
    }

    public final long getAndAdd(int n2, long l2) {
        long l3;
        long l4;
        while (!this.compareAndSet(n2, l4 = this.get(n2), l3 = l4 + l2)) {
        }
        return l4;
    }

    public final long incrementAndGet(int n2) {
        long l2;
        long l3;
        while (!this.compareAndSet(n2, l3 = this.get(n2), l2 = l3 + 1L)) {
        }
        return l2;
    }

    public final long decrementAndGet(int n2) {
        long l2;
        long l3;
        while (!this.compareAndSet(n2, l3 = this.get(n2), l2 = l3 - 1L)) {
        }
        return l2;
    }

    public long addAndGet(int n2, long l2) {
        long l3;
        long l4;
        while (!this.compareAndSet(n2, l4 = this.get(n2), l3 = l4 + l2)) {
        }
        return l3;
    }

    public String toString() {
        if (this.array.length > 0) {
            this.get(0);
        }
        return Arrays.toString(this.array);
    }
}

