/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.filechooser.GenericFileSystemView;
import javax.swing.filechooser.UnixFileSystemView;
import javax.swing.filechooser.WindowsFileSystemView;
import sun.awt.shell.ShellFolder;

public abstract class FileSystemView {
    static FileSystemView windowsFileSystemView = null;
    static FileSystemView unixFileSystemView = null;
    static FileSystemView genericFileSystemView = null;
    static boolean useSystemExtensionsHiding = false;

    public static FileSystemView getFileSystemView() {
        useSystemExtensionsHiding = UIManager.getDefaults().getBoolean("FileChooser.useSystemExtensionHiding");
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
                    useSystemExtensionsHiding = UIManager.getDefaults().getBoolean("FileChooser.useSystemExtensionHiding");
                }
            }
        });
        if (File.separatorChar == '\\') {
            if (windowsFileSystemView == null) {
                windowsFileSystemView = new WindowsFileSystemView();
            }
            return windowsFileSystemView;
        }
        if (File.separatorChar == '/') {
            if (unixFileSystemView == null) {
                unixFileSystemView = new UnixFileSystemView();
            }
            return unixFileSystemView;
        }
        if (genericFileSystemView == null) {
            genericFileSystemView = new GenericFileSystemView();
        }
        return genericFileSystemView;
    }

    public boolean isRoot(File file) {
        if (file == null || !file.isAbsolute()) {
            return false;
        }
        File[] fileArray = this.getRoots();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (!fileArray[i2].equals(file)) continue;
            return true;
        }
        return false;
    }

    public Boolean isTraversable(File file) {
        return file.isDirectory();
    }

    public String getSystemDisplayName(File file) {
        String string = null;
        if (!(file == null || (string = file.getName()).equals("..") || string.equals(".") || !useSystemExtensionsHiding && this.isFileSystem(file) && !this.isFileSystemRoot(file) || !(file instanceof ShellFolder) && !file.exists() || (string = this.getShellFolder(file).getDisplayName()) != null && string.length() != 0)) {
            string = file.getPath();
        }
        return string;
    }

    public String getSystemTypeDescription(File file) {
        return null;
    }

    public Icon getSystemIcon(File file) {
        if (file != null) {
            ShellFolder shellFolder = this.getShellFolder(file);
            Image image = shellFolder.getIcon(false);
            if (image != null) {
                return new ImageIcon(image, shellFolder.getFolderType());
            }
            return UIManager.getIcon(file.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
        }
        return null;
    }

    public boolean isParent(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        if (file instanceof ShellFolder) {
            File file3 = file2.getParentFile();
            if (file3 != null && file3.equals(file)) {
                return true;
            }
            File[] fileArray = this.getFiles(file, false);
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (!file2.equals(fileArray[i2])) continue;
                return true;
            }
            return false;
        }
        return file.equals(file2.getParentFile());
    }

    public File getChild(File file, String string) {
        if (file instanceof ShellFolder) {
            File[] fileArray = this.getFiles(file, false);
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (!fileArray[i2].getName().equals(string)) continue;
                return fileArray[i2];
            }
        }
        return this.createFileObject(file, string);
    }

    public boolean isFileSystem(File file) {
        if (file instanceof ShellFolder) {
            ShellFolder shellFolder = (ShellFolder)file;
            return shellFolder.isFileSystem() && (!shellFolder.isLink() || !shellFolder.isDirectory());
        }
        return true;
    }

    public abstract File createNewFolder(File var1) throws IOException;

    public boolean isHiddenFile(File file) {
        return file.isHidden();
    }

    public boolean isFileSystemRoot(File file) {
        return ShellFolder.isFileSystemRoot(file);
    }

    public boolean isDrive(File file) {
        return false;
    }

    public boolean isFloppyDrive(File file) {
        return false;
    }

    public boolean isComputerNode(File file) {
        return ShellFolder.isComputerNode(file);
    }

    public File[] getRoots() {
        File[] fileArray = (File[])ShellFolder.get("roots");
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (!this.isFileSystemRoot(fileArray[i2])) continue;
            fileArray[i2] = this.createFileSystemRoot(fileArray[i2]);
        }
        return fileArray;
    }

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File getDefaultDirectory() {
        File file = (File)ShellFolder.get("fileChooserDefaultFolder");
        if (this.isFileSystemRoot(file)) {
            file = this.createFileSystemRoot(file);
        }
        return file;
    }

    public File createFileObject(File file, String string) {
        if (file == null) {
            return new File(string);
        }
        return new File(file, string);
    }

    public File createFileObject(String string) {
        File file = new File(string);
        if (this.isFileSystemRoot(file)) {
            file = this.createFileSystemRoot(file);
        }
        return file;
    }

    public File[] getFiles(File file, boolean bl2) {
        Vector<File> vector = new Vector<File>();
        if (!(file instanceof ShellFolder)) {
            file = this.getShellFolder(file);
        }
        File[] fileArray = ((ShellFolder)file).listFiles(!bl2);
        int n2 = fileArray == null ? 0 : fileArray.length;
        for (int i2 = 0; i2 < n2 && !Thread.currentThread().isInterrupted(); ++i2) {
            File file2 = fileArray[i2];
            if (!(file2 instanceof ShellFolder)) {
                if (this.isFileSystemRoot(file2)) {
                    file2 = this.createFileSystemRoot(file2);
                }
                try {
                    file2 = ShellFolder.getShellFolder(file2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    continue;
                }
                catch (InternalError internalError) {
                    continue;
                }
            }
            if (bl2 && this.isHiddenFile(file2)) continue;
            vector.addElement(file2);
        }
        return vector.toArray(new File[vector.size()]);
    }

    public File getParentDirectory(File file) {
        ShellFolder shellFolder;
        File file2;
        if (file != null && file.exists() && (file2 = (shellFolder = this.getShellFolder(file)).getParentFile()) != null) {
            if (this.isFileSystem(file2)) {
                File file3;
                File file4 = file2;
                if (!(file4 == null || file4.exists() || (file3 = file2.getParentFile()) != null && this.isFileSystem(file3))) {
                    file4 = this.createFileSystemRoot(file4);
                }
                return file4;
            }
            return file2;
        }
        return null;
    }

    ShellFolder getShellFolder(File file) {
        if (!(file instanceof ShellFolder) && !(file instanceof FileSystemRoot) && this.isFileSystemRoot(file)) {
            file = this.createFileSystemRoot(file);
        }
        try {
            return ShellFolder.getShellFolder(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("FileSystemView.getShellFolder: f=" + file);
            fileNotFoundException.printStackTrace();
            return null;
        }
        catch (InternalError internalError) {
            System.err.println("FileSystemView.getShellFolder: f=" + file);
            internalError.printStackTrace();
            return null;
        }
    }

    protected File createFileSystemRoot(File file) {
        return new FileSystemRoot(file);
    }

    static class FileSystemRoot
    extends File {
        public FileSystemRoot(File file) {
            super(file, "");
        }

        public FileSystemRoot(String string) {
            super(string);
        }

        public boolean isDirectory() {
            return true;
        }

        public String getName() {
            return this.getPath();
        }
    }
}

