/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDragGestureRecognizer;
import javax.swing.plaf.basic.BasicDropTargetListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.Position;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.VariableHeightLayoutCache;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicTreeUI
extends TreeUI {
    private static final Actions SHARED_ACTION = new Actions();
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    private Color hashColor;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected Dimension preferredMinSize;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable<TreePath, Boolean> drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    private int lastWidth;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    private int leadRow;
    private boolean ignoreLAChange;
    private boolean leftToRight;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener selectionModelPropertyChangeListener;
    private MouseListener mouseListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private ComponentListener componentListener;
    private CellEditorListener cellEditorListener;
    private TreeSelectionListener treeSelectionListener;
    private TreeModelListener treeModelListener;
    private TreeExpansionListener treeExpansionListener;
    private boolean paintLines = true;
    private boolean lineTypeDashed;
    private long timeFactor = 1000L;
    private Handler handler;
    private static final TreeDragGestureRecognizer defaultDragRecognizer = new TreeDragGestureRecognizer();
    private static DropTargetListener defaultDropTargetListener = null;
    private static final TransferHandler defaultTransferHandler = new TreeTransferHandler();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTreeUI();
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("selectPrevious"));
        lazyActionMap.put(new Actions("selectPreviousChangeLead"));
        lazyActionMap.put(new Actions("selectPreviousExtendSelection"));
        lazyActionMap.put(new Actions("selectNext"));
        lazyActionMap.put(new Actions("selectNextChangeLead"));
        lazyActionMap.put(new Actions("selectNextExtendSelection"));
        lazyActionMap.put(new Actions("selectChild"));
        lazyActionMap.put(new Actions("selectChildChangeLead"));
        lazyActionMap.put(new Actions("selectParent"));
        lazyActionMap.put(new Actions("selectParentChangeLead"));
        lazyActionMap.put(new Actions("scrollUpChangeSelection"));
        lazyActionMap.put(new Actions("scrollUpChangeLead"));
        lazyActionMap.put(new Actions("scrollUpExtendSelection"));
        lazyActionMap.put(new Actions("scrollDownChangeSelection"));
        lazyActionMap.put(new Actions("scrollDownExtendSelection"));
        lazyActionMap.put(new Actions("scrollDownChangeLead"));
        lazyActionMap.put(new Actions("selectFirst"));
        lazyActionMap.put(new Actions("selectFirstChangeLead"));
        lazyActionMap.put(new Actions("selectFirstExtendSelection"));
        lazyActionMap.put(new Actions("selectLast"));
        lazyActionMap.put(new Actions("selectLastChangeLead"));
        lazyActionMap.put(new Actions("selectLastExtendSelection"));
        lazyActionMap.put(new Actions("toggle"));
        lazyActionMap.put(new Actions("cancel"));
        lazyActionMap.put(new Actions("startEditing"));
        lazyActionMap.put(new Actions("selectAll"));
        lazyActionMap.put(new Actions("clearSelection"));
        lazyActionMap.put(new Actions("scrollLeft"));
        lazyActionMap.put(new Actions("scrollRight"));
        lazyActionMap.put(new Actions("scrollLeftExtendSelection"));
        lazyActionMap.put(new Actions("scrollRightExtendSelection"));
        lazyActionMap.put(new Actions("scrollRightChangeLead"));
        lazyActionMap.put(new Actions("scrollLeftChangeLead"));
        lazyActionMap.put(new Actions("expand"));
        lazyActionMap.put(new Actions("collapse"));
        lazyActionMap.put(new Actions("moveSelectionToParent"));
        lazyActionMap.put(new Actions("addToSelection"));
        lazyActionMap.put(new Actions("toggleAndAnchor"));
        lazyActionMap.put(new Actions("extendTo"));
        lazyActionMap.put(new Actions("moveSelectionTo"));
        lazyActionMap.put(TransferHandler.getCutAction());
        lazyActionMap.put(TransferHandler.getCopyAction());
        lazyActionMap.put(TransferHandler.getPasteAction());
    }

    protected Color getHashColor() {
        return this.hashColor;
    }

    protected void setHashColor(Color color) {
        this.hashColor = color;
    }

    public void setLeftChildIndent(int n2) {
        this.leftChildIndent = n2;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int n2) {
        this.rightChildIndent = n2;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean bl2) {
        if (this.getRowHeight() < 1) {
            bl2 = false;
        }
        if (this.largeModel != bl2) {
            this.completeEditing();
            this.largeModel = bl2;
            this.treeState = this.createLayoutCache();
            this.configureLayoutCache();
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int n2) {
        this.completeEditing();
        if (this.treeState != null) {
            this.setLargeModel(this.tree.isLargeModel());
            this.treeState.setRowHeight(n2);
            this.updateSize();
        }
    }

    protected int getRowHeight() {
        return this.tree == null ? -1 : this.tree.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.completeEditing();
        this.updateRenderer();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected TreeCellRenderer getCellRenderer() {
        return this.currentCellRenderer;
    }

    protected void setModel(TreeModel treeModel) {
        this.completeEditing();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        this.treeModel = treeModel;
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if (this.treeState != null) {
            this.treeState.setModel(treeModel);
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean bl2) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.setRootVisible(bl2);
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean isRootVisible() {
        return this.tree != null ? this.tree.isRootVisible() : false;
    }

    protected void setShowsRootHandles(boolean bl2) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean getShowsRootHandles() {
        return this.tree != null ? this.tree.getShowsRootHandles() : false;
    }

    protected void setCellEditor(TreeCellEditor treeCellEditor) {
        this.updateCellEditor();
    }

    protected TreeCellEditor getCellEditor() {
        return this.tree != null ? this.tree.getCellEditor() : null;
    }

    protected void setEditable(boolean bl2) {
        this.updateCellEditor();
    }

    protected boolean isEditable() {
        return this.tree != null ? this.tree.isEditable() : false;
    }

    protected void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        this.completeEditing();
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeSelectionModel = treeSelectionModel;
        if (this.treeSelectionModel != null) {
            if (this.selectionModelPropertyChangeListener != null) {
                this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
            }
            if (this.treeSelectionListener != null) {
                this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
            }
            if (this.treeState != null) {
                this.treeState.setSelectionModel(this.treeSelectionModel);
            }
        } else if (this.treeState != null) {
            this.treeState.setSelectionModel(null);
        }
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        if (jTree != null && this.treeState != null) {
            Insets insets = jTree.getInsets();
            Rectangle rectangle = this.treeState.getBounds(treePath, null);
            if (rectangle != null && insets != null) {
                rectangle.x += insets.left;
                rectangle.y += insets.top;
            }
            return rectangle;
        }
        return null;
    }

    public TreePath getPathForRow(JTree jTree, int n2) {
        return this.treeState != null ? this.treeState.getPathForRow(n2) : null;
    }

    public int getRowForPath(JTree jTree, TreePath treePath) {
        return this.treeState != null ? this.treeState.getRowForPath(treePath) : -1;
    }

    public int getRowCount(JTree jTree) {
        return this.treeState != null ? this.treeState.getRowCount() : 0;
    }

    public TreePath getClosestPathForLocation(JTree jTree, int n2, int n3) {
        if (jTree != null && this.treeState != null) {
            Insets insets = jTree.getInsets();
            if (insets == null) {
                insets = EMPTY_INSETS;
            }
            return this.treeState.getPathClosestTo(n2 - insets.left, n3 - insets.top);
        }
        return null;
    }

    public boolean isEditing(JTree jTree) {
        return this.editingComponent != null;
    }

    public boolean stopEditing(JTree jTree) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    public void cancelEditing(JTree jTree) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    public void startEditingAtPath(JTree jTree, TreePath treePath) {
        jTree.scrollPathToVisible(treePath);
        if (treePath != null && jTree.isVisible(treePath)) {
            this.startEditing(treePath, null);
        }
    }

    public TreePath getEditingPath(JTree jTree) {
        return this.editingPath;
    }

    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("null component passed to BasicTreeUI.installUI()");
        }
        this.tree = (JTree)jComponent;
        this.prepareForUIInstall();
        this.installDefaults();
        this.installKeyboardActions();
        this.installComponents();
        this.installListeners();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.drawingCache = new Hashtable(7);
        this.leftToRight = BasicGraphicsUtils.isLeftToRight(this.tree);
        this.lastWidth = this.tree.getWidth();
        this.stopEditingInCompleteEditing = true;
        this.lastSelectedRow = -1;
        this.leadRow = -1;
        this.preferredSize = new Dimension();
        this.largeModel = this.tree.isLargeModel();
        if (this.getRowHeight() <= 0) {
            this.largeModel = false;
        }
        this.setModel(this.tree.getModel());
    }

    protected void completeUIInstall() {
        this.setShowsRootHandles(this.tree.getShowsRootHandles());
        this.updateRenderer();
        this.updateDepthOffset();
        this.setSelectionModel(this.tree.getSelectionModel());
        this.treeState = this.createLayoutCache();
        this.configureLayoutCache();
        this.updateSize();
    }

    protected void installDefaults() {
        if (this.tree.getBackground() == null || this.tree.getBackground() instanceof UIResource) {
            this.tree.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.getHashColor() == null || this.getHashColor() instanceof UIResource) {
            this.setHashColor(UIManager.getColor("Tree.hash"));
        }
        if (this.tree.getFont() == null || this.tree.getFont() instanceof UIResource) {
            this.tree.setFont(UIManager.getFont("Tree.font"));
        }
        this.setExpandedIcon((Icon)UIManager.get("Tree.expandedIcon"));
        this.setCollapsedIcon((Icon)UIManager.get("Tree.collapsedIcon"));
        this.setLeftChildIndent((Integer)UIManager.get("Tree.leftChildIndent"));
        this.setRightChildIndent((Integer)UIManager.get("Tree.rightChildIndent"));
        LookAndFeel.installProperty(this.tree, "rowHeight", UIManager.get("Tree.rowHeight"));
        this.largeModel = this.tree.isLargeModel() && this.tree.getRowHeight() > 0;
        Object object = UIManager.get("Tree.scrollsOnExpand");
        if (object != null) {
            LookAndFeel.installProperty(this.tree, "scrollsOnExpand", object);
        }
        this.paintLines = UIManager.getBoolean("Tree.paintLines");
        this.lineTypeDashed = UIManager.getBoolean("Tree.lineTypeDashed");
        Long l2 = (Long)UIManager.get("Tree.timeFactor");
        this.timeFactor = l2 != null ? l2 : 1000L;
        Object object2 = UIManager.get("Tree.showsRootHandles");
        if (object2 != null) {
            LookAndFeel.installProperty(this.tree, "showsRootHandles", object2);
        }
    }

    protected void installListeners() {
        DropTarget dropTarget;
        TransferHandler transferHandler;
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tree.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.tree.addMouseListener(defaultDragRecognizer);
        this.tree.addMouseMotionListener(defaultDragRecognizer);
        this.mouseListener = this.createMouseListener();
        if (this.mouseListener != null) {
            this.tree.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.tree.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tree.addFocusListener(this.focusListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.tree.addKeyListener(this.keyListener);
        }
        if ((this.treeExpansionListener = this.createTreeExpansionListener()) != null) {
            this.tree.addTreeExpansionListener(this.treeExpansionListener);
        }
        if ((this.treeModelListener = this.createTreeModelListener()) != null && this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if ((this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if ((this.treeSelectionListener = this.createTreeSelectionListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
        }
        if ((transferHandler = this.tree.getTransferHandler()) == null || transferHandler instanceof UIResource) {
            this.tree.setTransferHandler(defaultTransferHandler);
        }
        if ((dropTarget = this.tree.getDropTarget()) instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TreeDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
        LookAndFeel.installProperty(this.tree, "opaque", Boolean.TRUE);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tree, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tree, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.tree, BasicTreeUI.class, "Tree.actionMap");
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)DefaultLookup.get(this.tree, this, "Tree.ancestorInputMap");
        }
        if (n2 == 0) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)DefaultLookup.get(this.tree, this, "Tree.focusInputMap");
            if (this.tree.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)DefaultLookup.get(this.tree, this, "Tree.focusInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.tree.add(this.rendererPane);
        }
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected KeyListener createKeyListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return this.getHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return this.getHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return this.getHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return this.getHandler();
    }

    protected AbstractLayoutCache createLayoutCache() {
        if (this.isLargeModel() && this.getRowHeight() > 0) {
            return new FixedHeightLayoutCache();
        }
        return new VariableHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellEditor defaultTreeCellEditor = new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer);
            return defaultTreeCellEditor;
        }
        return new DefaultTreeCellEditor(this.tree, null);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return this.getHandler();
    }

    public void uninstallUI(JComponent jComponent) {
        this.completeEditing();
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void prepareForUIUninstall() {
    }

    protected void completeUIUninstall() {
        if (this.createdRenderer) {
            this.tree.setCellRenderer(null);
        }
        if (this.createdCellEditor) {
            this.tree.setCellEditor(null);
        }
        this.cellEditor = null;
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.mouseListener = null;
        this.focusListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.treeState = null;
        this.drawingCache = null;
        this.selectionModelPropertyChangeListener = null;
        this.tree = null;
        this.treeModel = null;
        this.treeSelectionModel = null;
        this.treeSelectionListener = null;
        this.treeExpansionListener = null;
    }

    protected void uninstallDefaults() {
        if (this.tree.getTransferHandler() instanceof UIResource) {
            this.tree.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.tree.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.tree.removeMouseListener(defaultDragRecognizer);
        this.tree.removeMouseMotionListener(defaultDragRecognizer);
        if (this.mouseListener != null) {
            this.tree.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.tree.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.focusListener != null) {
            this.tree.removeFocusListener(this.focusListener);
        }
        if (this.keyListener != null) {
            this.tree.removeKeyListener(this.keyListener);
        }
        if (this.treeExpansionListener != null) {
            this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        }
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tree, null);
        SwingUtilities.replaceUIInputMap(this.tree, 1, null);
        SwingUtilities.replaceUIInputMap(this.tree, 0, null);
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.tree.remove(this.rendererPane);
        }
    }

    private void redoTheLayout() {
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.tree != jComponent) {
            throw new InternalError("incorrect component");
        }
        if (this.treeState == null) {
            return;
        }
        int n2 = this.tree.getWidth();
        if (n2 != this.lastWidth) {
            this.lastWidth = n2;
            if (!this.leftToRight) {
                this.redoTheLayout();
                this.updateSize();
            }
        }
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.tree.getInsets();
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n3 = this.treeState.getRowForPath(treePath);
        int n4 = rectangle.y + rectangle.height;
        this.drawingCache.clear();
        if (treePath != null && enumeration != null) {
            TreePath treePath2 = treePath;
            for (treePath2 = treePath2.getParentPath(); treePath2 != null; treePath2 = treePath2.getParentPath()) {
                this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath2);
                this.drawingCache.put(treePath2, Boolean.TRUE);
            }
            boolean bl2 = false;
            Rectangle rectangle2 = new Rectangle();
            boolean bl3 = this.isRootVisible();
            while (!bl2 && enumeration.hasMoreElements()) {
                TreePath treePath3 = enumeration.nextElement();
                if (treePath3 != null) {
                    boolean bl4;
                    boolean bl5;
                    boolean bl6 = this.treeModel.isLeaf(treePath3.getLastPathComponent());
                    if (bl6) {
                        bl5 = false;
                        bl4 = false;
                    } else {
                        bl4 = this.treeState.getExpandedState(treePath3);
                        bl5 = this.tree.hasBeenExpanded(treePath3);
                    }
                    Rectangle rectangle3 = this.treeState.getBounds(treePath3, rectangle2);
                    if (rectangle3 == null) {
                        return;
                    }
                    rectangle3.x += insets.left;
                    rectangle3.y += insets.top;
                    treePath2 = treePath3.getParentPath();
                    if (treePath2 != null) {
                        if (this.drawingCache.get(treePath2) == null) {
                            this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath2);
                            this.drawingCache.put(treePath2, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle3, treePath3, n3, bl4, bl5, bl6);
                    } else if (bl3 && n3 == 0) {
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle3, treePath3, n3, bl4, bl5, bl6);
                    }
                    if (this.shouldPaintExpandControl(treePath3, n3, bl4, bl5, bl6)) {
                        this.paintExpandControl(graphics, rectangle, insets, rectangle3, treePath3, n3, bl4, bl5, bl6);
                    }
                    if (!this.leftToRight) {
                        rectangle3.x += 4;
                    }
                    this.paintRow(graphics, rectangle, insets, rectangle3, treePath3, n3, bl4, bl5, bl6);
                    if (rectangle3.y + rectangle3.height >= n4) {
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
                ++n3;
            }
        }
        this.rendererPane.removeAll();
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (!this.paintLines) {
            return;
        }
        int n3 = treePath.getPathCount() - 1;
        if ((n3 == 0 || n3 == 1 && !this.isRootVisible()) && !this.getShowsRootHandles()) {
            return;
        }
        int n4 = rectangle.x;
        int n5 = rectangle.x + (rectangle.width - 1);
        int n6 = rectangle.y;
        int n7 = rectangle.y + (rectangle.height - 1);
        int n8 = rectangle2.y + rectangle2.height / 2;
        if (this.leftToRight) {
            int n9 = rectangle2.x - this.getRightChildIndent();
            int n10 = rectangle2.x - this.getHorizontalLegBuffer();
            if (n8 >= n6 && n8 <= n7 && n10 >= n4 && n9 <= n5 && (n9 = Math.max(Math.max(insets.left, n9), n4)) != (n10 = Math.min(Math.max(insets.left, n10), n5))) {
                graphics.setColor(this.getHashColor());
                this.paintHorizontalLine(graphics, this.tree, n8, n9, n10);
            }
        } else {
            int n11 = rectangle2.x + rectangle2.width + this.getRightChildIndent();
            int n12 = rectangle2.x + rectangle2.width + this.getHorizontalLegBuffer() - 1;
            if (n8 >= n6 && n8 <= n7 && n11 >= n4 && n12 <= n5) {
                n11 = Math.min(n11, n5);
                n12 = Math.max(n12, n4);
                graphics.setColor(this.getHashColor());
                this.paintHorizontalLine(graphics, this.tree, n8, n12, n11);
            }
        }
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (!this.paintLines) {
            return;
        }
        int n2 = treePath.getPathCount() - 1;
        if (n2 == 0 && !this.getShowsRootHandles() && !this.isRootVisible()) {
            return;
        }
        int n3 = this.getRowX(-1, n2 + 1);
        n3 = this.leftToRight ? n3 - this.getRightChildIndent() + insets.left : this.lastWidth - this.getRowX(-1, n2) - 9;
        int n4 = rectangle.x;
        int n5 = rectangle.x + (rectangle.width - 1);
        if (n3 >= n4 && n3 <= n5) {
            int n6;
            Object object;
            TreeModel treeModel;
            int n7 = rectangle.y;
            int n8 = rectangle.y + rectangle.height;
            Rectangle rectangle2 = this.getPathBounds(this.tree, treePath);
            Rectangle rectangle3 = this.getPathBounds(this.tree, this.getLastChildPath(treePath));
            if (rectangle3 == null) {
                return;
            }
            int n9 = rectangle2 == null ? Math.max(insets.top + this.getVerticalLegBuffer(), n7) : Math.max(rectangle2.y + rectangle2.height + this.getVerticalLegBuffer(), n7);
            if (n2 == 0 && !this.isRootVisible() && (treeModel = this.getModel()) != null && treeModel.getChildCount(object = treeModel.getRoot()) > 0 && (rectangle2 = this.getPathBounds(this.tree, treePath.pathByAddingChild(treeModel.getChild(object, 0)))) != null) {
                n9 = Math.max(insets.top + this.getVerticalLegBuffer(), rectangle2.y + rectangle2.height / 2);
            }
            if (n9 <= (n6 = Math.min(rectangle3.y + rectangle3.height / 2, n8))) {
                graphics.setColor(this.getHashColor());
                this.paintVerticalLine(graphics, this.tree, n3, n9, n6);
            }
        }
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        Object object = treePath.getLastPathComponent();
        if (!(bl4 || bl3 && this.treeModel.getChildCount(object) <= 0)) {
            int n3 = this.leftToRight ? rectangle2.x - (this.getRightChildIndent() - 1) : rectangle2.x + rectangle2.width + this.getRightChildIndent();
            int n4 = rectangle2.y + rectangle2.height / 2;
            if (bl2) {
                Icon icon = this.getExpandedIcon();
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n3, n4);
                }
            } else {
                Icon icon = this.getCollapsedIcon();
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n3, n4);
                }
            }
        }
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (this.editingComponent != null && this.editingRow == n2) {
            return;
        }
        int n3 = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), this.tree.isRowSelected(n2), bl2, bl4, n2, n3 == n2);
        this.rendererPane.paintComponent(graphics, component, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (bl4) {
            return false;
        }
        int n3 = treePath.getPathCount() - 1;
        return n3 != 0 && (n3 != 1 || this.isRootVisible()) || this.getShowsRootHandles();
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        if (this.lineTypeDashed) {
            this.drawDashedVerticalLine(graphics, n2, n3, n4);
        } else {
            graphics.drawLine(n2, n3, n2, n4);
        }
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        if (this.lineTypeDashed) {
            this.drawDashedHorizontalLine(graphics, n2, n3, n4);
        } else {
            graphics.drawLine(n3, n2, n4, n2);
        }
    }

    protected int getVerticalLegBuffer() {
        return 0;
    }

    protected int getHorizontalLegBuffer() {
        return 0;
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n2, int n3) {
        icon.paintIcon(component, graphics, n2 - icon.getIconWidth() / 2, n3 - icon.getIconHeight() / 2);
    }

    protected void drawDashedHorizontalLine(Graphics graphics, int n2, int n3, int n4) {
        n3 += n3 % 2;
        for (int i2 = n3; i2 <= n4; i2 += 2) {
            graphics.drawLine(i2, n2, i2, n2);
        }
    }

    protected void drawDashedVerticalLine(Graphics graphics, int n2, int n3, int n4) {
        n3 += n3 % 2;
        for (int i2 = n3; i2 <= n4; i2 += 2) {
            graphics.drawLine(n2, i2, n2, i2);
        }
    }

    protected int getRowX(int n2, int n3) {
        return this.totalChildIndent * (n3 + this.depthOffset);
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    protected void updateExpandedDescendants(TreePath treePath) {
        this.completeEditing();
        if (this.treeState != null) {
            this.treeState.setExpandedState(treePath, true);
            Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    treePath = enumeration.nextElement();
                    this.treeState.setExpandedState(treePath, true);
                }
            }
            this.updateLeadRow();
            this.updateSize();
        }
    }

    protected TreePath getLastChildPath(TreePath treePath) {
        int n2;
        if (this.treeModel != null && (n2 = this.treeModel.getChildCount(treePath.getLastPathComponent())) > 0) {
            return treePath.pathByAddingChild(this.treeModel.getChild(treePath.getLastPathComponent(), n2 - 1));
        }
        return null;
    }

    protected void updateDepthOffset() {
        this.depthOffset = this.isRootVisible() ? (this.getShowsRootHandles() ? 1 : 0) : (!this.getShowsRootHandles() ? -1 : 0);
    }

    protected void updateCellEditor() {
        TreeCellEditor treeCellEditor;
        this.completeEditing();
        if (this.tree == null) {
            treeCellEditor = null;
        } else if (this.tree.isEditable()) {
            treeCellEditor = this.tree.getCellEditor();
            if (treeCellEditor == null && (treeCellEditor = this.createDefaultCellEditor()) != null) {
                this.tree.setCellEditor(treeCellEditor);
                this.createdCellEditor = true;
            }
        } else {
            treeCellEditor = null;
        }
        if (treeCellEditor != this.cellEditor) {
            if (this.cellEditor != null && this.cellEditorListener != null) {
                this.cellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = treeCellEditor;
            if (this.cellEditorListener == null) {
                this.cellEditorListener = this.createCellEditorListener();
            }
            if (treeCellEditor != null && this.cellEditorListener != null) {
                treeCellEditor.addCellEditorListener(this.cellEditorListener);
            }
            this.createdCellEditor = false;
        }
    }

    protected void updateRenderer() {
        if (this.tree != null) {
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            if (treeCellRenderer == null) {
                this.tree.setCellRenderer(this.createDefaultCellRenderer());
                this.createdRenderer = true;
            } else {
                this.createdRenderer = false;
                this.currentCellRenderer = treeCellRenderer;
                if (this.createdCellEditor) {
                    this.tree.setCellEditor(null);
                }
            }
        } else {
            this.createdRenderer = false;
            this.currentCellRenderer = null;
        }
        this.updateCellEditor();
    }

    protected void configureLayoutCache() {
        if (this.treeState != null && this.tree != null) {
            if (this.nodeDimensions == null) {
                this.nodeDimensions = this.createNodeDimensions();
            }
            this.treeState.setNodeDimensions(this.nodeDimensions);
            this.treeState.setRootVisible(this.tree.isRootVisible());
            this.treeState.setRowHeight(this.tree.getRowHeight());
            this.treeState.setSelectionModel(this.getSelectionModel());
            if (this.treeState.getModel() != this.tree.getModel()) {
                this.treeState.setModel(this.tree.getModel());
            }
            this.updateLayoutCacheExpandedNodes();
            if (this.isLargeModel()) {
                if (this.componentListener == null) {
                    this.componentListener = this.createComponentListener();
                    if (this.componentListener != null) {
                        this.tree.addComponentListener(this.componentListener);
                    }
                }
            } else if (this.componentListener != null) {
                this.tree.removeComponentListener(this.componentListener);
                this.componentListener = null;
            }
        } else if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
    }

    protected void updateSize() {
        this.validCachedPreferredSize = false;
        this.tree.treeDidChange();
    }

    protected void updateCachedPreferredSize() {
        if (this.treeState != null) {
            Insets insets = this.tree.getInsets();
            if (this.isLargeModel()) {
                Rectangle rectangle = this.tree.getVisibleRect();
                if (insets != null) {
                    rectangle.x -= insets.left;
                    rectangle.y -= insets.top;
                }
                this.preferredSize.width = this.leftToRight ? this.treeState.getPreferredWidth(rectangle) : (this.getRowCount(this.tree) == 0 ? 0 : this.lastWidth - this.getMinX(rectangle));
            } else if (this.leftToRight) {
                this.preferredSize.width = this.treeState.getPreferredWidth(null);
            } else {
                Rectangle rectangle = null;
                int n2 = this.tree.getRowCount();
                int n3 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    rectangle = this.treeState.getBounds(this.treeState.getPathForRow(i2), rectangle);
                    if (rectangle == null) continue;
                    n3 = Math.max(this.lastWidth - rectangle.x, n3);
                }
                this.preferredSize.width = n3;
            }
            this.preferredSize.height = this.treeState.getPreferredHeight();
            if (insets != null) {
                this.preferredSize.width += insets.left + insets.right;
                this.preferredSize.height += insets.top + insets.bottom;
            }
        }
        this.validCachedPreferredSize = true;
    }

    private int getMinX(Rectangle rectangle) {
        int n2;
        TreePath treePath;
        if (rectangle == null) {
            treePath = this.getPathForRow(this.tree, 0);
            n2 = Integer.MAX_VALUE;
        } else {
            treePath = this.treeState.getPathClosestTo(rectangle.x, rectangle.y);
            n2 = rectangle.height + rectangle.y;
        }
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n3 = 0;
        if (enumeration != null && enumeration.hasMoreElements()) {
            Rectangle rectangle2 = this.treeState.getBounds(enumeration.nextElement(), null);
            if (rectangle2 != null) {
                n3 = rectangle2.x + rectangle2.width;
                if (rectangle2.y >= n2) {
                    return n3;
                }
            }
            while (rectangle2 != null && enumeration.hasMoreElements()) {
                rectangle2 = this.treeState.getBounds(enumeration.nextElement(), rectangle2);
                if (rectangle2 != null && rectangle2.y < n2) {
                    n3 = Math.min(n3, rectangle2.x);
                    continue;
                }
                rectangle2 = null;
            }
            return n3;
        }
        return n3;
    }

    protected void pathWasExpanded(TreePath treePath) {
        if (this.tree != null) {
            this.tree.fireTreeExpanded(treePath);
        }
    }

    protected void pathWasCollapsed(TreePath treePath) {
        if (this.tree != null) {
            this.tree.fireTreeCollapsed(treePath);
        }
    }

    protected void ensureRowsAreVisible(int n2, int n3) {
        if (this.tree != null && n2 >= 0 && n3 < this.getRowCount(this.tree)) {
            boolean bl2 = DefaultLookup.getBoolean(this.tree, this, "Tree.scrollsHorizontallyAndVertically", false);
            if (n2 == n3) {
                Rectangle rectangle = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n2));
                if (rectangle != null) {
                    if (!bl2) {
                        rectangle.x = this.tree.getVisibleRect().x;
                        rectangle.width = 1;
                    }
                    this.tree.scrollRectToVisible(rectangle);
                }
            } else {
                Rectangle rectangle = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n2));
                Rectangle rectangle2 = this.tree.getVisibleRect();
                Rectangle rectangle3 = rectangle;
                int n4 = rectangle.y;
                int n5 = n4 + rectangle2.height;
                for (int i2 = n2 + 1; i2 <= n3; ++i2) {
                    rectangle3 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i2));
                    if (rectangle3.y + rectangle3.height <= n5) continue;
                    i2 = n3;
                }
                this.tree.scrollRectToVisible(new Rectangle(rectangle2.x, n4, 1, rectangle3.y + rectangle3.height - n4));
            }
        }
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent, true);
    }

    public Dimension getPreferredSize(JComponent jComponent, boolean bl2) {
        Dimension dimension = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.tree != null) {
            if (dimension != null) {
                return new Dimension(Math.max(dimension.width, this.preferredSize.width), Math.max(dimension.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (dimension != null) {
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.tree != null) {
            return this.getPreferredSize(this.tree);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl2, boolean bl3, boolean bl4) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component component = this.editingComponent;
            TreePath treePath = this.editingPath;
            TreeCellEditor treeCellEditor = this.cellEditor;
            Object object = treeCellEditor.getCellEditorValue();
            Rectangle rectangle = this.getPathBounds(this.tree, this.editingPath);
            boolean bl5 = this.tree != null && (this.tree.hasFocus() || SwingUtilities.findFocusOwner(this.editingComponent) != null);
            this.editingComponent = null;
            this.editingPath = null;
            if (bl2) {
                treeCellEditor.stopCellEditing();
            } else if (bl3) {
                treeCellEditor.cancelCellEditing();
            }
            this.tree.remove(component);
            if (this.editorHasDifferentSize) {
                this.treeState.invalidatePathBounds(treePath);
                this.updateSize();
            } else {
                rectangle.x = 0;
                rectangle.width = this.tree.getSize().width;
                this.tree.repaint(rectangle);
            }
            if (bl5) {
                this.tree.requestFocus();
            }
            if (bl4) {
                this.treeModel.valueForPathChanged(treePath, object);
            }
        }
    }

    protected boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.stopEditing(this.tree)) {
            return false;
        }
        this.completeEditing();
        if (this.cellEditor != null && this.tree.isPathEditable(treePath)) {
            int n2 = this.getRowForPath(this.tree, treePath);
            if (this.cellEditor.isCellEditable(mouseEvent)) {
                this.editingComponent = this.cellEditor.getTreeCellEditorComponent(this.tree, treePath.getLastPathComponent(), this.tree.isPathSelected(treePath), this.tree.isExpanded(treePath), this.treeModel.isLeaf(treePath.getLastPathComponent()), n2);
                Rectangle rectangle = this.getPathBounds(this.tree, treePath);
                this.editingRow = n2;
                Dimension dimension = this.editingComponent.getPreferredSize();
                if (dimension.height != rectangle.height && this.getRowHeight() > 0) {
                    dimension.height = this.getRowHeight();
                }
                if (dimension.width != rectangle.width || dimension.height != rectangle.height) {
                    this.editorHasDifferentSize = true;
                    this.treeState.invalidatePathBounds(treePath);
                    this.updateSize();
                } else {
                    this.editorHasDifferentSize = false;
                }
                this.tree.add(this.editingComponent);
                this.editingComponent.setBounds(rectangle.x, rectangle.y, dimension.width, dimension.height);
                this.editingPath = treePath;
                this.editingComponent.validate();
                Rectangle rectangle2 = this.tree.getVisibleRect();
                this.tree.paintImmediately(rectangle.x, rectangle.y, rectangle2.width + rectangle2.x - rectangle.x, dimension.height);
                if (this.cellEditor.shouldSelectCell(mouseEvent)) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.tree.setSelectionRow(n2);
                    }
                    catch (Exception exception) {
                        System.err.println("Editing exception: " + exception);
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                BasicLookAndFeel.compositeRequestFocus(this.editingComponent);
                if (mouseEvent != null && mouseEvent instanceof MouseEvent) {
                    Point point = SwingUtilities.convertPoint(this.tree, new Point(mouseEvent.getX(), mouseEvent.getY()), this.editingComponent);
                    Component component = SwingUtilities.getDeepestComponentAt(this.editingComponent, point.x, point.y);
                    if (component != null) {
                        new MouseInputHandler(this.tree, component, mouseEvent);
                    }
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    protected void checkForClickInExpandControl(TreePath treePath, int n2, int n3) {
        if (this.isLocationInExpandControl(treePath, n2, n3)) {
            this.handleExpandControlClick(treePath, n2, n3);
        }
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n2, int n3) {
        if (treePath != null && !this.treeModel.isLeaf(treePath.getLastPathComponent())) {
            Insets insets = this.tree.getInsets();
            int n4 = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
            int n5 = this.getRowX(this.tree.getRowForPath(treePath), treePath.getPathCount() - 1) - this.getRightChildIndent() - n4 / 2;
            n5 = this.leftToRight ? (n5 += insets.left) : insets.left + this.lastWidth - 1 - (treePath.getPathCount() - 2 + this.depthOffset) * this.totalChildIndent - this.getLeftChildIndent() - n4 / 2;
            int n6 = n5 + n4;
            return n2 >= n5 && n2 <= n6;
        }
        return false;
    }

    protected void handleExpandControlClick(TreePath treePath, int n2, int n3) {
        this.toggleExpandState(treePath);
    }

    protected void toggleExpandState(TreePath treePath) {
        if (!this.tree.isExpanded(treePath)) {
            int n2 = this.getRowForPath(this.tree, treePath);
            this.tree.expandPath(treePath);
            this.updateSize();
            if (n2 != -1) {
                if (this.tree.getScrollsOnExpand()) {
                    this.ensureRowsAreVisible(n2, n2 + this.treeState.getVisibleChildCount(treePath));
                } else {
                    this.ensureRowsAreVisible(n2, n2);
                }
            }
        } else {
            this.tree.collapsePath(treePath);
            this.updateSize();
        }
    }

    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isControlDown();
    }

    protected boolean isMultiSelectEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isShiftDown();
    }

    protected boolean isToggleEvent(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return false;
        }
        int n2 = this.tree.getToggleClickCount();
        if (n2 <= 0) {
            return false;
        }
        return mouseEvent.getClickCount() == n2;
    }

    protected void selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isToggleSelectionEvent(mouseEvent)) {
            if (this.tree.isPathSelected(treePath)) {
                this.tree.removeSelectionPath(treePath);
            } else {
                this.tree.addSelectionPath(treePath);
            }
            this.lastSelectedRow = this.getRowForPath(this.tree, treePath);
            this.setAnchorSelectionPath(treePath);
            this.setLeadSelectionPath(treePath);
        } else if (this.isMultiSelectEvent(mouseEvent)) {
            int n2;
            TreePath treePath2 = this.getAnchorSelectionPath();
            int n3 = n2 = treePath2 == null ? -1 : this.getRowForPath(this.tree, treePath2);
            if (n2 == -1 || this.tree.getSelectionModel().getSelectionMode() == 1) {
                this.tree.setSelectionPath(treePath);
            } else {
                int n4 = this.getRowForPath(this.tree, treePath);
                TreePath treePath3 = treePath2;
                if (n4 < n2) {
                    this.tree.setSelectionInterval(n4, n2);
                } else {
                    this.tree.setSelectionInterval(n2, n4);
                }
                this.lastSelectedRow = n4;
                this.setAnchorSelectionPath(treePath3);
                this.setLeadSelectionPath(treePath);
            }
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.tree.setSelectionPath(treePath);
            if (this.isToggleEvent(mouseEvent)) {
                this.toggleExpandState(treePath);
            }
        }
    }

    protected boolean isLeaf(int n2) {
        TreePath treePath = this.getPathForRow(this.tree, n2);
        if (treePath != null) {
            return this.treeModel.isLeaf(treePath.getLastPathComponent());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnchorSelectionPath(TreePath treePath) {
        this.ignoreLAChange = true;
        try {
            this.tree.setAnchorSelectionPath(treePath);
        }
        finally {
            this.ignoreLAChange = false;
        }
    }

    private TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    private void setLeadSelectionPath(TreePath treePath) {
        this.setLeadSelectionPath(treePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLeadSelectionPath(TreePath treePath, boolean bl2) {
        Rectangle rectangle = bl2 ? this.getPathBounds(this.tree, this.getLeadSelectionPath()) : null;
        this.ignoreLAChange = true;
        try {
            this.tree.setLeadSelectionPath(treePath);
        }
        finally {
            this.ignoreLAChange = false;
        }
        this.leadRow = this.getRowForPath(this.tree, treePath);
        if (bl2) {
            if (rectangle != null) {
                this.tree.repaint(rectangle);
            }
            if ((rectangle = this.getPathBounds(this.tree, treePath)) != null) {
                this.tree.repaint(rectangle);
            }
        }
    }

    private TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    private void updateLeadRow() {
        this.leadRow = this.getRowForPath(this.tree, this.getLeadSelectionPath());
    }

    private int getLeadSelectionRow() {
        return this.leadRow;
    }

    private void extendSelection(TreePath treePath) {
        TreePath treePath2 = this.getAnchorSelectionPath();
        int n2 = treePath2 == null ? -1 : this.getRowForPath(this.tree, treePath2);
        int n3 = this.getRowForPath(this.tree, treePath);
        if (n2 == -1) {
            this.tree.setSelectionRow(n3);
        } else {
            if (n2 < n3) {
                this.tree.setSelectionInterval(n2, n3);
            } else {
                this.tree.setSelectionInterval(n3, n2);
            }
            this.setAnchorSelectionPath(treePath2);
            this.setLeadSelectionPath(treePath);
        }
    }

    private void repaintPath(TreePath treePath) {
        Rectangle rectangle;
        if (treePath != null && (rectangle = this.getPathBounds(this.tree, treePath)) != null) {
            this.tree.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT_PREVIOUS = "selectPrevious";
        private static final String SELECT_PREVIOUS_CHANGE_LEAD = "selectPreviousChangeLead";
        private static final String SELECT_PREVIOUS_EXTEND_SELECTION = "selectPreviousExtendSelection";
        private static final String SELECT_NEXT = "selectNext";
        private static final String SELECT_NEXT_CHANGE_LEAD = "selectNextChangeLead";
        private static final String SELECT_NEXT_EXTEND_SELECTION = "selectNextExtendSelection";
        private static final String SELECT_CHILD = "selectChild";
        private static final String SELECT_CHILD_CHANGE_LEAD = "selectChildChangeLead";
        private static final String SELECT_PARENT = "selectParent";
        private static final String SELECT_PARENT_CHANGE_LEAD = "selectParentChangeLead";
        private static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        private static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_FIRST = "selectFirst";
        private static final String SELECT_FIRST_CHANGE_LEAD = "selectFirstChangeLead";
        private static final String SELECT_FIRST_EXTEND_SELECTION = "selectFirstExtendSelection";
        private static final String SELECT_LAST = "selectLast";
        private static final String SELECT_LAST_CHANGE_LEAD = "selectLastChangeLead";
        private static final String SELECT_LAST_EXTEND_SELECTION = "selectLastExtendSelection";
        private static final String TOGGLE = "toggle";
        private static final String CANCEL_EDITING = "cancel";
        private static final String START_EDITING = "startEditing";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String SCROLL_LEFT = "scrollLeft";
        private static final String SCROLL_RIGHT = "scrollRight";
        private static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        private static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        private static final String SCROLL_RIGHT_CHANGE_LEAD = "scrollRightChangeLead";
        private static final String SCROLL_LEFT_CHANGE_LEAD = "scrollLeftChangeLead";
        private static final String EXPAND = "expand";
        private static final String COLLAPSE = "collapse";
        private static final String MOVE_SELECTION_TO_PARENT = "moveSelectionToParent";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";

        Actions() {
            super(null);
        }

        Actions(String string) {
            super(string);
        }

        public boolean isEnabled(Object object) {
            if (object instanceof JTree && this.getName() == CANCEL_EDITING) {
                return ((JTree)object).isEditing();
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTree jTree = (JTree)actionEvent.getSource();
            BasicTreeUI basicTreeUI = (BasicTreeUI)BasicLookAndFeel.getUIOfType(jTree.getUI(), BasicTreeUI.class);
            if (basicTreeUI == null) {
                return;
            }
            String string = this.getName();
            if (string == SELECT_PREVIOUS) {
                this.increment(jTree, basicTreeUI, -1, false, true);
            } else if (string == SELECT_PREVIOUS_CHANGE_LEAD) {
                this.increment(jTree, basicTreeUI, -1, false, false);
            } else if (string == SELECT_PREVIOUS_EXTEND_SELECTION) {
                this.increment(jTree, basicTreeUI, -1, true, true);
            } else if (string == SELECT_NEXT) {
                this.increment(jTree, basicTreeUI, 1, false, true);
            } else if (string == SELECT_NEXT_CHANGE_LEAD) {
                this.increment(jTree, basicTreeUI, 1, false, false);
            } else if (string == SELECT_NEXT_EXTEND_SELECTION) {
                this.increment(jTree, basicTreeUI, 1, true, true);
            } else if (string == SELECT_CHILD) {
                this.traverse(jTree, basicTreeUI, 1, true);
            } else if (string == SELECT_CHILD_CHANGE_LEAD) {
                this.traverse(jTree, basicTreeUI, 1, false);
            } else if (string == SELECT_PARENT) {
                this.traverse(jTree, basicTreeUI, -1, true);
            } else if (string == SELECT_PARENT_CHANGE_LEAD) {
                this.traverse(jTree, basicTreeUI, -1, false);
            } else if (string == SCROLL_UP_CHANGE_SELECTION) {
                this.page(jTree, basicTreeUI, -1, false, true);
            } else if (string == SCROLL_UP_CHANGE_LEAD) {
                this.page(jTree, basicTreeUI, -1, false, false);
            } else if (string == SCROLL_UP_EXTEND_SELECTION) {
                this.page(jTree, basicTreeUI, -1, true, true);
            } else if (string == SCROLL_DOWN_CHANGE_SELECTION) {
                this.page(jTree, basicTreeUI, 1, false, true);
            } else if (string == SCROLL_DOWN_EXTEND_SELECTION) {
                this.page(jTree, basicTreeUI, 1, true, true);
            } else if (string == SCROLL_DOWN_CHANGE_LEAD) {
                this.page(jTree, basicTreeUI, 1, false, false);
            } else if (string == SELECT_FIRST) {
                this.home(jTree, basicTreeUI, -1, false, true);
            } else if (string == SELECT_FIRST_CHANGE_LEAD) {
                this.home(jTree, basicTreeUI, -1, false, false);
            } else if (string == SELECT_FIRST_EXTEND_SELECTION) {
                this.home(jTree, basicTreeUI, -1, true, true);
            } else if (string == SELECT_LAST) {
                this.home(jTree, basicTreeUI, 1, false, true);
            } else if (string == SELECT_LAST_CHANGE_LEAD) {
                this.home(jTree, basicTreeUI, 1, false, false);
            } else if (string == SELECT_LAST_EXTEND_SELECTION) {
                this.home(jTree, basicTreeUI, 1, true, true);
            } else if (string == TOGGLE) {
                this.toggle(jTree, basicTreeUI);
            } else if (string == CANCEL_EDITING) {
                this.cancelEditing(jTree, basicTreeUI);
            } else if (string == START_EDITING) {
                this.startEditing(jTree, basicTreeUI);
            } else if (string == SELECT_ALL) {
                this.selectAll(jTree, basicTreeUI, true);
            } else if (string == CLEAR_SELECTION) {
                this.selectAll(jTree, basicTreeUI, false);
            } else if (string == ADD_TO_SELECTION) {
                int n2;
                if (basicTreeUI.getRowCount(jTree) > 0 && !jTree.isRowSelected(n2 = basicTreeUI.getLeadSelectionRow())) {
                    TreePath treePath = basicTreeUI.getAnchorSelectionPath();
                    jTree.addSelectionRow(n2);
                    basicTreeUI.setAnchorSelectionPath(treePath);
                }
            } else if (string == TOGGLE_AND_ANCHOR) {
                if (basicTreeUI.getRowCount(jTree) > 0) {
                    int n3 = basicTreeUI.getLeadSelectionRow();
                    TreePath treePath = basicTreeUI.getLeadSelectionPath();
                    if (!jTree.isRowSelected(n3)) {
                        jTree.addSelectionRow(n3);
                    } else {
                        jTree.removeSelectionRow(n3);
                        basicTreeUI.setLeadSelectionPath(treePath);
                    }
                    basicTreeUI.setAnchorSelectionPath(treePath);
                }
            } else if (string == EXTEND_TO) {
                this.extendSelection(jTree, basicTreeUI);
            } else if (string == MOVE_SELECTION_TO) {
                if (basicTreeUI.getRowCount(jTree) > 0) {
                    int n4 = basicTreeUI.getLeadSelectionRow();
                    jTree.setSelectionInterval(n4, n4);
                }
            } else if (string == SCROLL_LEFT) {
                this.scroll(jTree, basicTreeUI, 0, -10);
            } else if (string == SCROLL_RIGHT) {
                this.scroll(jTree, basicTreeUI, 0, 10);
            } else if (string == SCROLL_LEFT_EXTEND_SELECTION) {
                this.scrollChangeSelection(jTree, basicTreeUI, -1, true, true);
            } else if (string == SCROLL_RIGHT_EXTEND_SELECTION) {
                this.scrollChangeSelection(jTree, basicTreeUI, 1, true, true);
            } else if (string == SCROLL_RIGHT_CHANGE_LEAD) {
                this.scrollChangeSelection(jTree, basicTreeUI, 1, false, false);
            } else if (string == SCROLL_LEFT_CHANGE_LEAD) {
                this.scrollChangeSelection(jTree, basicTreeUI, -1, false, false);
            } else if (string == EXPAND) {
                this.expand(jTree, basicTreeUI);
            } else if (string == COLLAPSE) {
                this.collapse(jTree, basicTreeUI);
            } else if (string == MOVE_SELECTION_TO_PARENT) {
                this.moveSelectionToParent(jTree, basicTreeUI);
            }
        }

        private void scrollChangeSelection(JTree jTree, BasicTreeUI basicTreeUI, int n2, boolean bl2, boolean bl3) {
            int n3 = basicTreeUI.getRowCount(jTree);
            if (n3 > 0 && basicTreeUI.treeSelectionModel != null) {
                TreePath treePath;
                Rectangle rectangle = jTree.getVisibleRect();
                if (n2 == -1) {
                    treePath = basicTreeUI.getClosestPathForLocation(jTree, rectangle.x, rectangle.y);
                    rectangle.x = Math.max(0, rectangle.x - rectangle.width);
                } else {
                    rectangle.x = Math.min(Math.max(0, jTree.getWidth() - rectangle.width), rectangle.x + rectangle.width);
                    treePath = basicTreeUI.getClosestPathForLocation(jTree, rectangle.x, rectangle.y + rectangle.height);
                }
                jTree.scrollRectToVisible(rectangle);
                if (bl2) {
                    basicTreeUI.extendSelection(treePath);
                } else if (bl3) {
                    jTree.setSelectionPath(treePath);
                } else {
                    basicTreeUI.setLeadSelectionPath(treePath, true);
                }
            }
        }

        private void scroll(JTree jTree, BasicTreeUI basicTreeUI, int n2, int n3) {
            Rectangle rectangle = jTree.getVisibleRect();
            Dimension dimension = jTree.getSize();
            if (n2 == 0) {
                rectangle.x += n3;
                rectangle.x = Math.max(0, rectangle.x);
                rectangle.x = Math.min(Math.max(0, dimension.width - rectangle.width), rectangle.x);
            } else {
                rectangle.y += n3;
                rectangle.y = Math.max(0, rectangle.y);
                rectangle.y = Math.min(Math.max(0, dimension.width - rectangle.height), rectangle.y);
            }
            jTree.scrollRectToVisible(rectangle);
        }

        private void extendSelection(JTree jTree, BasicTreeUI basicTreeUI) {
            int n2;
            if (basicTreeUI.getRowCount(jTree) > 0 && (n2 = basicTreeUI.getLeadSelectionRow()) != -1) {
                TreePath treePath = basicTreeUI.getLeadSelectionPath();
                TreePath treePath2 = basicTreeUI.getAnchorSelectionPath();
                int n3 = basicTreeUI.getRowForPath(jTree, treePath2);
                if (n3 == -1) {
                    n3 = 0;
                }
                jTree.setSelectionInterval(n3, n2);
                basicTreeUI.setLeadSelectionPath(treePath);
                basicTreeUI.setAnchorSelectionPath(treePath2);
            }
        }

        private void selectAll(JTree jTree, BasicTreeUI basicTreeUI, boolean bl2) {
            int n2 = basicTreeUI.getRowCount(jTree);
            if (n2 > 0) {
                if (bl2) {
                    if (jTree.getSelectionModel().getSelectionMode() == 1) {
                        int n3 = basicTreeUI.getLeadSelectionRow();
                        if (n3 != -1) {
                            jTree.setSelectionRow(n3);
                        } else if (jTree.getMinSelectionRow() == -1) {
                            jTree.setSelectionRow(0);
                            basicTreeUI.ensureRowsAreVisible(0, 0);
                        }
                        return;
                    }
                    TreePath treePath = basicTreeUI.getLeadSelectionPath();
                    TreePath treePath2 = basicTreeUI.getAnchorSelectionPath();
                    if (treePath != null && !jTree.isVisible(treePath)) {
                        treePath = null;
                    }
                    jTree.setSelectionInterval(0, n2 - 1);
                    if (treePath != null) {
                        basicTreeUI.setLeadSelectionPath(treePath);
                    }
                    if (treePath2 != null && jTree.isVisible(treePath2)) {
                        basicTreeUI.setAnchorSelectionPath(treePath2);
                    }
                } else {
                    TreePath treePath = basicTreeUI.getLeadSelectionPath();
                    TreePath treePath3 = basicTreeUI.getAnchorSelectionPath();
                    jTree.clearSelection();
                    basicTreeUI.setAnchorSelectionPath(treePath3);
                    basicTreeUI.setLeadSelectionPath(treePath);
                }
            }
        }

        private void startEditing(JTree jTree, BasicTreeUI basicTreeUI) {
            int n2;
            TreePath treePath = basicTreeUI.getLeadSelectionPath();
            int n3 = n2 = treePath != null ? basicTreeUI.getRowForPath(jTree, treePath) : -1;
            if (n2 != -1) {
                jTree.startEditingAtPath(treePath);
            }
        }

        private void cancelEditing(JTree jTree, BasicTreeUI basicTreeUI) {
            jTree.cancelEditing();
        }

        private void toggle(JTree jTree, BasicTreeUI basicTreeUI) {
            int n2 = basicTreeUI.getLeadSelectionRow();
            if (n2 != -1 && !basicTreeUI.isLeaf(n2)) {
                TreePath treePath = basicTreeUI.getAnchorSelectionPath();
                TreePath treePath2 = basicTreeUI.getLeadSelectionPath();
                basicTreeUI.toggleExpandState(basicTreeUI.getPathForRow(jTree, n2));
                basicTreeUI.setAnchorSelectionPath(treePath);
                basicTreeUI.setLeadSelectionPath(treePath2);
            }
        }

        private void expand(JTree jTree, BasicTreeUI basicTreeUI) {
            int n2 = basicTreeUI.getLeadSelectionRow();
            jTree.expandRow(n2);
        }

        private void collapse(JTree jTree, BasicTreeUI basicTreeUI) {
            int n2 = basicTreeUI.getLeadSelectionRow();
            jTree.collapseRow(n2);
        }

        private void increment(JTree jTree, BasicTreeUI basicTreeUI, int n2, boolean bl2, boolean bl3) {
            int n3;
            if (!bl2 && !bl3 && jTree.getSelectionModel().getSelectionMode() != 4) {
                bl3 = true;
            }
            if (basicTreeUI.treeSelectionModel != null && (n3 = jTree.getRowCount()) > 0) {
                int n4 = basicTreeUI.getLeadSelectionRow();
                int n5 = n4 == -1 ? (n2 == 1 ? 0 : n3 - 1) : Math.min(n3 - 1, Math.max(0, n4 + n2));
                if (bl2 && basicTreeUI.treeSelectionModel.getSelectionMode() != 1) {
                    basicTreeUI.extendSelection(jTree.getPathForRow(n5));
                } else if (bl3) {
                    jTree.setSelectionInterval(n5, n5);
                } else {
                    basicTreeUI.setLeadSelectionPath(jTree.getPathForRow(n5), true);
                }
                basicTreeUI.ensureRowsAreVisible(n5, n5);
                basicTreeUI.lastSelectedRow = n5;
            }
        }

        private void traverse(JTree jTree, BasicTreeUI basicTreeUI, int n2, boolean bl2) {
            int n3;
            if (!bl2 && jTree.getSelectionModel().getSelectionMode() != 4) {
                bl2 = true;
            }
            if ((n3 = jTree.getRowCount()) > 0) {
                int n4;
                int n5 = basicTreeUI.getLeadSelectionRow();
                if (n5 == -1) {
                    n4 = 0;
                } else if (n2 == 1) {
                    if (!basicTreeUI.isLeaf(n5) && !jTree.isExpanded(n5)) {
                        basicTreeUI.toggleExpandState(basicTreeUI.getPathForRow(jTree, n5));
                        n4 = -1;
                    } else {
                        n4 = Math.min(n5 + 1, n3 - 1);
                    }
                } else if (!basicTreeUI.isLeaf(n5) && jTree.isExpanded(n5)) {
                    basicTreeUI.toggleExpandState(basicTreeUI.getPathForRow(jTree, n5));
                    n4 = -1;
                } else {
                    TreePath treePath = basicTreeUI.getPathForRow(jTree, n5);
                    n4 = treePath != null && treePath.getPathCount() > 1 ? basicTreeUI.getRowForPath(jTree, treePath.getParentPath()) : -1;
                }
                if (n4 != -1) {
                    if (bl2) {
                        jTree.setSelectionInterval(n4, n4);
                    } else {
                        basicTreeUI.setLeadSelectionPath(basicTreeUI.getPathForRow(jTree, n4), true);
                    }
                    basicTreeUI.ensureRowsAreVisible(n4, n4);
                }
            }
        }

        private void moveSelectionToParent(JTree jTree, BasicTreeUI basicTreeUI) {
            int n2;
            int n3 = basicTreeUI.getLeadSelectionRow();
            TreePath treePath = basicTreeUI.getPathForRow(jTree, n3);
            if (treePath != null && treePath.getPathCount() > 1 && (n2 = basicTreeUI.getRowForPath(jTree, treePath.getParentPath())) != -1) {
                jTree.setSelectionInterval(n2, n2);
                basicTreeUI.ensureRowsAreVisible(n2, n2);
            }
        }

        private void page(JTree jTree, BasicTreeUI basicTreeUI, int n2, boolean bl2, boolean bl3) {
            int n3;
            if (!bl2 && !bl3 && jTree.getSelectionModel().getSelectionMode() != 4) {
                bl3 = true;
            }
            if ((n3 = basicTreeUI.getRowCount(jTree)) > 0 && basicTreeUI.treeSelectionModel != null) {
                TreePath treePath;
                Dimension dimension = jTree.getSize();
                TreePath treePath2 = basicTreeUI.getLeadSelectionPath();
                Rectangle rectangle = jTree.getVisibleRect();
                if (n2 == -1) {
                    treePath = basicTreeUI.getClosestPathForLocation(jTree, rectangle.x, rectangle.y);
                    if (treePath.equals(treePath2)) {
                        rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                        treePath = jTree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    }
                } else {
                    rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                    treePath = jTree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    if (treePath.equals(treePath2)) {
                        rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                        treePath = jTree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    }
                }
                Rectangle rectangle2 = basicTreeUI.getPathBounds(jTree, treePath);
                rectangle2.x = rectangle.x;
                rectangle2.width = rectangle.width;
                if (n2 == -1) {
                    rectangle2.height = rectangle.height;
                } else {
                    rectangle2.y -= rectangle.height - rectangle2.height;
                    rectangle2.height = rectangle.height;
                }
                if (bl2) {
                    basicTreeUI.extendSelection(treePath);
                } else if (bl3) {
                    jTree.setSelectionPath(treePath);
                } else {
                    basicTreeUI.setLeadSelectionPath(treePath, true);
                }
                jTree.scrollRectToVisible(rectangle2);
            }
        }

        private void home(JTree jTree, BasicTreeUI basicTreeUI, int n2, boolean bl2, boolean bl3) {
            int n3;
            if (!bl2 && !bl3 && jTree.getSelectionModel().getSelectionMode() != 4) {
                bl3 = true;
            }
            if ((n3 = basicTreeUI.getRowCount(jTree)) > 0) {
                if (n2 == -1) {
                    basicTreeUI.ensureRowsAreVisible(0, 0);
                    if (bl2) {
                        int n4;
                        TreePath treePath = basicTreeUI.getAnchorSelectionPath();
                        int n5 = n4 = treePath == null ? -1 : basicTreeUI.getRowForPath(jTree, treePath);
                        if (n4 == -1) {
                            jTree.setSelectionInterval(0, 0);
                        } else {
                            jTree.setSelectionInterval(0, n4);
                            basicTreeUI.setAnchorSelectionPath(treePath);
                            basicTreeUI.setLeadSelectionPath(basicTreeUI.getPathForRow(jTree, 0));
                        }
                    } else if (bl3) {
                        jTree.setSelectionInterval(0, 0);
                    } else {
                        basicTreeUI.setLeadSelectionPath(basicTreeUI.getPathForRow(jTree, 0), true);
                    }
                } else {
                    basicTreeUI.ensureRowsAreVisible(n3 - 1, n3 - 1);
                    if (bl2) {
                        int n6;
                        TreePath treePath = basicTreeUI.getAnchorSelectionPath();
                        int n7 = n6 = treePath == null ? -1 : basicTreeUI.getRowForPath(jTree, treePath);
                        if (n6 == -1) {
                            jTree.setSelectionInterval(n3 - 1, n3 - 1);
                        } else {
                            jTree.setSelectionInterval(n6, n3 - 1);
                            basicTreeUI.setAnchorSelectionPath(treePath);
                            basicTreeUI.setLeadSelectionPath(basicTreeUI.getPathForRow(jTree, n3 - 1));
                        }
                    } else if (bl3) {
                        jTree.setSelectionInterval(n3 - 1, n3 - 1);
                    } else {
                        basicTreeUI.setLeadSelectionPath(basicTreeUI.getPathForRow(jTree, n3 - 1), true);
                    }
                }
            }
        }
    }

    public class CellEditorHandler
    implements CellEditorListener {
        public void editingStopped(ChangeEvent changeEvent) {
            BasicTreeUI.this.getHandler().editingStopped(changeEvent);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            BasicTreeUI.this.getHandler().editingCanceled(changeEvent);
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = this.getScrollPane();
                if (jScrollPane == null) {
                    BasicTreeUI.this.updateSize();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicTreeUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container container;
            for (container = BasicTreeUI.this.tree.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
            }
            if (container instanceof JScrollPane) {
                return (JScrollPane)container;
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicTreeUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            BasicTreeUI.this.getHandler().focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.focusGained(focusEvent);
        }
    }

    private class Handler
    implements CellEditorListener,
    FocusListener,
    KeyListener,
    MouseListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeModelListener,
    TreeSelectionListener {
        private String prefix = "";
        private String typedString = "";
        private long lastTime = 0L;
        private boolean selectedOnPress;

        private Handler() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.getRowCount() > 0 && BasicTreeUI.this.tree.hasFocus() && BasicTreeUI.this.tree.isEnabled()) {
                TreePath treePath;
                if (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() || this.isNavigationKey(keyEvent)) {
                    return;
                }
                boolean bl2 = true;
                char c2 = keyEvent.getKeyChar();
                long l2 = keyEvent.getWhen();
                int n2 = BasicTreeUI.this.tree.getLeadSelectionRow();
                if (l2 - this.lastTime < BasicTreeUI.this.timeFactor) {
                    this.typedString = this.typedString + c2;
                    if (this.prefix.length() == 1 && c2 == this.prefix.charAt(0)) {
                        ++n2;
                    } else {
                        this.prefix = this.typedString;
                    }
                } else {
                    ++n2;
                    this.prefix = this.typedString = "" + c2;
                }
                this.lastTime = l2;
                if (n2 < 0 || n2 >= BasicTreeUI.this.tree.getRowCount()) {
                    bl2 = false;
                    n2 = 0;
                }
                if ((treePath = BasicTreeUI.this.tree.getNextMatch(this.prefix, n2, Position.Bias.Forward)) != null) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath);
                    int n3 = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                    BasicTreeUI.this.ensureRowsAreVisible(n3, n3);
                } else if (bl2 && (treePath = BasicTreeUI.this.tree.getNextMatch(this.prefix, 0, Position.Bias.Forward)) != null) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath);
                    int n4 = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                    BasicTreeUI.this.ensureRowsAreVisible(n4, n4);
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (this.isNavigationKey(keyEvent)) {
                this.prefix = "";
                this.typedString = "";
                this.lastTime = 0L;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        private boolean isNavigationKey(KeyEvent keyEvent) {
            InputMap inputMap = BasicTreeUI.this.tree.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            return inputMap != null && inputMap.get(keyStroke) != null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicTreeUI.this.treeSelectionModel) {
                BasicTreeUI.this.treeSelectionModel.resetRowSelection();
            } else if (propertyChangeEvent.getSource() == BasicTreeUI.this.tree) {
                DropTarget dropTarget;
                String string = propertyChangeEvent.getPropertyName();
                if (string == "leadSelectionPath") {
                    if (!BasicTreeUI.this.ignoreLAChange) {
                        BasicTreeUI.this.updateLeadRow();
                        BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getOldValue());
                        BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getNewValue());
                    }
                } else if (string == "anchorSelectionPath" && !BasicTreeUI.this.ignoreLAChange) {
                    BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getOldValue());
                    BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getNewValue());
                }
                if (string == "cellRenderer") {
                    BasicTreeUI.this.setCellRenderer((TreeCellRenderer)propertyChangeEvent.getNewValue());
                    BasicTreeUI.this.redoTheLayout();
                } else if (string == "model") {
                    BasicTreeUI.this.setModel((TreeModel)propertyChangeEvent.getNewValue());
                } else if (string == "rootVisible") {
                    BasicTreeUI.this.setRootVisible((Boolean)propertyChangeEvent.getNewValue());
                } else if (string == "showsRootHandles") {
                    BasicTreeUI.this.setShowsRootHandles((Boolean)propertyChangeEvent.getNewValue());
                } else if (string == "rowHeight") {
                    BasicTreeUI.this.setRowHeight((Integer)propertyChangeEvent.getNewValue());
                } else if (string == "cellEditor") {
                    BasicTreeUI.this.setCellEditor((TreeCellEditor)propertyChangeEvent.getNewValue());
                } else if (string == "editable") {
                    BasicTreeUI.this.setEditable((Boolean)propertyChangeEvent.getNewValue());
                } else if (string == "largeModel") {
                    BasicTreeUI.this.setLargeModel(BasicTreeUI.this.tree.isLargeModel());
                } else if (string == "selectionModel") {
                    BasicTreeUI.this.setSelectionModel(BasicTreeUI.this.tree.getSelectionModel());
                } else if (string == "font") {
                    BasicTreeUI.this.completeEditing();
                    if (BasicTreeUI.this.treeState != null) {
                        BasicTreeUI.this.treeState.invalidateSizes();
                    }
                    BasicTreeUI.this.updateSize();
                } else if (string == "componentOrientation") {
                    if (BasicTreeUI.this.tree != null) {
                        BasicTreeUI.this.leftToRight = BasicGraphicsUtils.isLeftToRight(BasicTreeUI.this.tree);
                        BasicTreeUI.this.redoTheLayout();
                        BasicTreeUI.this.tree.treeDidChange();
                        InputMap inputMap = BasicTreeUI.this.getInputMap(0);
                        SwingUtilities.replaceUIInputMap(BasicTreeUI.this.tree, 0, inputMap);
                    }
                } else if ("transferHandler" == string && (dropTarget = BasicTreeUI.this.tree.getDropTarget()) instanceof UIResource) {
                    if (defaultDropTargetListener == null) {
                        defaultDropTargetListener = new TreeDropTargetListener();
                    }
                    try {
                        dropTarget.addDropTargetListener(defaultDropTargetListener);
                    }
                    catch (TooManyListenersException tooManyListenersException) {
                        // empty catch block
                    }
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.handleSelection(mouseEvent);
                this.selectedOnPress = true;
            } else {
                this.selectedOnPress = false;
            }
        }

        void handleSelection(MouseEvent mouseEvent) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled()) {
                TreePath treePath;
                if (BasicTreeUI.this.isEditing(BasicTreeUI.this.tree) && BasicTreeUI.this.tree.getInvokesStopCellEditing() && !BasicTreeUI.this.stopEditing(BasicTreeUI.this.tree)) {
                    return;
                }
                if (BasicTreeUI.this.tree.isRequestFocusEnabled()) {
                    BasicTreeUI.this.tree.requestFocus();
                }
                if ((treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY())) != null) {
                    int n2;
                    Rectangle rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath);
                    if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        BasicTreeUI.this.checkForClickInExpandControl(treePath, mouseEvent.getX(), mouseEvent.getY());
                    }
                    if ((n2 = mouseEvent.getX()) > rectangle.x && n2 <= rectangle.x + rectangle.width && !BasicTreeUI.this.startEditing(treePath, mouseEvent)) {
                        BasicTreeUI.this.selectPathForEvent(treePath, mouseEvent);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && !this.selectedOnPress) {
                this.handleSelection(mouseEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (BasicTreeUI.this.tree != null) {
                Rectangle rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, BasicTreeUI.this.tree.getLeadSelectionPath());
                if (rectangle != null) {
                    BasicTreeUI.this.tree.repaint(rectangle);
                }
                if ((rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, BasicTreeUI.this.getLeadSelectionPath())) != null) {
                    BasicTreeUI.this.tree.repaint(rectangle);
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.focusGained(focusEvent);
        }

        public void editingStopped(ChangeEvent changeEvent) {
            BasicTreeUI.this.completeEditing(false, false, true);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            BasicTreeUI.this.completeEditing(false, false, false);
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object;
            TreePath[] treePathArray;
            BasicTreeUI.this.completeEditing();
            if (BasicTreeUI.this.tree.getExpandsSelectedPaths() && BasicTreeUI.this.treeSelectionModel != null && (treePathArray = BasicTreeUI.this.treeSelectionModel.getSelectionPaths()) != null) {
                for (int i2 = treePathArray.length - 1; i2 >= 0; --i2) {
                    object = treePathArray[i2].getParentPath();
                    boolean bl2 = true;
                    while (object != null) {
                        if (BasicTreeUI.this.treeModel.isLeaf(object.getLastPathComponent())) {
                            bl2 = false;
                            object = null;
                            continue;
                        }
                        object = object.getParentPath();
                    }
                    if (!bl2) continue;
                    BasicTreeUI.this.tree.makeVisible(treePathArray[i2]);
                }
            }
            treePathArray = BasicTreeUI.this.getLeadSelectionPath();
            BasicTreeUI.this.lastSelectedRow = BasicTreeUI.this.tree.getMinSelectionRow();
            TreePath treePath = BasicTreeUI.this.tree.getSelectionModel().getLeadSelectionPath();
            BasicTreeUI.this.setAnchorSelectionPath(treePath);
            BasicTreeUI.this.setLeadSelectionPath(treePath);
            object = treeSelectionEvent.getPaths();
            Rectangle rectangle = BasicTreeUI.this.tree.getVisibleRect();
            boolean bl3 = true;
            int n2 = BasicTreeUI.this.tree.getWidth();
            if (object != null) {
                int n3 = ((TreePath[])object).length;
                if (n3 > 4) {
                    BasicTreeUI.this.tree.repaint();
                    bl3 = false;
                } else {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        Rectangle rectangle2 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, object[i3]);
                        if (rectangle2 == null || !rectangle.intersects(rectangle2)) continue;
                        BasicTreeUI.this.tree.repaint(0, rectangle2.y, n2, rectangle2.height);
                    }
                }
            }
            if (bl3) {
                Rectangle rectangle3 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, (TreePath)treePathArray);
                if (rectangle3 != null && rectangle.intersects(rectangle3)) {
                    BasicTreeUI.this.tree.repaint(0, rectangle3.y, n2, rectangle3.height);
                }
                if ((rectangle3 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath)) != null && rectangle.intersects(rectangle3)) {
                    BasicTreeUI.this.tree.repaint(0, rectangle3.y, n2, rectangle3.height);
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            if (treeExpansionEvent != null && BasicTreeUI.this.tree != null) {
                TreePath treePath = treeExpansionEvent.getPath();
                BasicTreeUI.this.updateExpandedDescendants(treePath);
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            if (treeExpansionEvent != null && BasicTreeUI.this.tree != null) {
                TreePath treePath = treeExpansionEvent.getPath();
                BasicTreeUI.this.completeEditing();
                if (treePath != null && BasicTreeUI.this.tree.isVisible(treePath)) {
                    BasicTreeUI.this.treeState.setExpandedState(treePath, false);
                    BasicTreeUI.this.updateLeadRow();
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesChanged(treeModelEvent);
                TreePath treePath = treeModelEvent.getTreePath().getParentPath();
                if (treePath == null || BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesInserted(treeModelEvent);
                BasicTreeUI.this.updateLeadRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                } else {
                    int[] nArray = treeModelEvent.getChildIndices();
                    int n2 = BasicTreeUI.this.treeModel.getChildCount(treePath.getLastPathComponent());
                    if (nArray != null && n2 - nArray.length == 0) {
                        BasicTreeUI.this.updateSize();
                    }
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesRemoved(treeModelEvent);
                BasicTreeUI.this.updateLeadRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (BasicTreeUI.this.treeState.isExpanded(treePath) || BasicTreeUI.this.treeModel.getChildCount(treePath.getLastPathComponent()) == 0) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeStructureChanged(treeModelEvent);
                BasicTreeUI.this.updateLeadRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (treePath != null) {
                    treePath = treePath.getParentPath();
                }
                if (treePath == null || BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public void keyTyped(KeyEvent keyEvent) {
            BasicTreeUI.this.getHandler().keyTyped(keyEvent);
        }

        public void keyPressed(KeyEvent keyEvent) {
            BasicTreeUI.this.getHandler().keyPressed(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            BasicTreeUI.this.getHandler().keyReleased(keyEvent);
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            BasicTreeUI.this.getHandler().mousePressed(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            BasicTreeUI.this.getHandler().mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BasicTreeUI.this.getHandler().mouseMoved(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicTreeUI.this.getHandler().mouseReleased(mouseEvent);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component component, Component component2, MouseEvent mouseEvent) {
            this.source = component;
            this.destination = component2;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            component2.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
            this.removeFromSource();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }

    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        public Rectangle getNodeDimensions(Object object, int n2, int n3, boolean bl2, Rectangle rectangle) {
            if (BasicTreeUI.this.editingComponent != null && BasicTreeUI.this.editingRow == n2) {
                Dimension dimension = BasicTreeUI.this.editingComponent.getPreferredSize();
                int n4 = BasicTreeUI.this.getRowHeight();
                if (n4 > 0 && n4 != dimension.height) {
                    dimension.height = n4;
                }
                if (rectangle != null) {
                    rectangle.x = this.getRowX(n2, n3);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(this.getRowX(n2, n3), 0, dimension.width, dimension.height);
                }
                if (!BasicTreeUI.this.leftToRight) {
                    rectangle.x = BasicTreeUI.this.lastWidth - rectangle.width - rectangle.x - 2;
                }
                return rectangle;
            }
            if (BasicTreeUI.this.currentCellRenderer != null) {
                Component component = BasicTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(BasicTreeUI.this.tree, object, BasicTreeUI.this.tree.isRowSelected(n2), bl2, BasicTreeUI.this.treeModel.isLeaf(object), n2, false);
                if (BasicTreeUI.this.tree != null) {
                    BasicTreeUI.this.rendererPane.add(component);
                    component.validate();
                }
                Dimension dimension = component.getPreferredSize();
                if (rectangle != null) {
                    rectangle.x = this.getRowX(n2, n3);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(this.getRowX(n2, n3), 0, dimension.width, dimension.height);
                }
                if (!BasicTreeUI.this.leftToRight) {
                    rectangle.x = BasicTreeUI.this.lastWidth - rectangle.width - rectangle.x - 2;
                }
                return rectangle;
            }
            return null;
        }

        protected int getRowX(int n2, int n3) {
            return BasicTreeUI.this.getRowX(n2, n3);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicTreeUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicTreeUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        public TreeCancelEditingAction(String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.cancelEditing(BasicTreeUI.this.tree, BasicTreeUI.this);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled() && BasicTreeUI.this.isEditing(BasicTreeUI.this.tree);
        }
    }

    static class TreeDragGestureRecognizer
    extends BasicDragGestureRecognizer {
        TreeDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            TreeUI treeUI;
            TreePath treePath;
            JTree jTree;
            return super.isDragPossible(mouseEvent) && (jTree = (JTree)this.getComponent(mouseEvent)).getDragEnabled() && (treePath = (treeUI = jTree.getUI()).getClosestPathForLocation(jTree, mouseEvent.getX(), mouseEvent.getY())) != null && jTree.isPathSelected(treePath);
        }
    }

    static class TreeDropTargetListener
    extends BasicDropTargetListener {
        private int[] selectedIndices;

        TreeDropTargetListener() {
        }

        protected void saveComponentState(JComponent jComponent) {
            JTree jTree = (JTree)jComponent;
            this.selectedIndices = jTree.getSelectionRows();
        }

        protected void restoreComponentState(JComponent jComponent) {
            JTree jTree = (JTree)jComponent;
            jTree.setSelectionRows(this.selectedIndices);
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JTree jTree = (JTree)jComponent;
            BasicTreeUI basicTreeUI = (BasicTreeUI)jTree.getUI();
            TreePath treePath = basicTreeUI.getClosestPathForLocation(jTree, point.x, point.y);
            if (treePath != null) {
                jTree.setSelectionPath(treePath);
            }
        }
    }

    public class TreeExpansionHandler
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            BasicTreeUI.this.getHandler().treeExpanded(treeExpansionEvent);
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            BasicTreeUI.this.getHandler().treeCollapsed(treeExpansionEvent);
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeHomeAction(int n2, String string) {
            this(n2, string, false, true);
        }

        private TreeHomeAction(int n2, String string, boolean bl2, boolean bl3) {
            this.direction = n2;
            this.changeSelection = bl3;
            this.addToSelection = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.home(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeIncrementAction(int n2, String string) {
            this(n2, string, false, true);
        }

        private TreeIncrementAction(int n2, String string, boolean bl2, boolean bl3) {
            this.direction = n2;
            this.addToSelection = bl2;
            this.changeSelection = bl3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.increment(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeModelHandler
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.getHandler().treeNodesChanged(treeModelEvent);
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.getHandler().treeNodesInserted(treeModelEvent);
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.getHandler().treeNodesInserted(treeModelEvent);
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.getHandler().treeStructureChanged(treeModelEvent);
        }
    }

    public class TreePageAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreePageAction(int n2, String string) {
            this(n2, string, false, true);
        }

        private TreePageAction(int n2, String string, boolean bl2, boolean bl3) {
            this.direction = n2;
            this.addToSelection = bl2;
            this.changeSelection = bl3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.page(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            BasicTreeUI.this.getHandler().valueChanged(treeSelectionEvent);
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        public TreeToggleAction(String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.toggle(BasicTreeUI.this.tree, BasicTreeUI.this);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    static class TreeTransferHandler
    extends TransferHandler
    implements UIResource,
    Comparator {
        private JTree tree;

        TreeTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTree) {
                this.tree = (JTree)jComponent;
                TreePath[] treePathArray = this.tree.getSelectionPaths();
                if (treePathArray == null || treePathArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<ul>\n");
                TreeModel treeModel = this.tree.getModel();
                Object var6_6 = null;
                TreePath[] treePathArray2 = this.getDisplayOrderPaths(treePathArray);
                for (int i2 = 0; i2 < treePathArray2.length; ++i2) {
                    TreePath treePath = treePathArray2[i2];
                    Object object = treePath.getLastPathComponent();
                    boolean bl2 = treeModel.isLeaf(object);
                    String string = this.getDisplayString(treePath, true, bl2);
                    stringBuffer.append(string + "\n");
                    stringBuffer2.append("  <li>" + string + "\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</ul>\n</body>\n</html>");
                this.tree = null;
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        public int compare(Object object, Object object2) {
            int n2 = this.tree.getRowForPath((TreePath)object);
            int n3 = this.tree.getRowForPath((TreePath)object2);
            return n2 - n3;
        }

        String getDisplayString(TreePath treePath, boolean bl2, boolean bl3) {
            int n2 = this.tree.getRowForPath(treePath);
            boolean bl4 = this.tree.getLeadSelectionRow() == n2;
            Object object = treePath.getLastPathComponent();
            return this.tree.convertValueToText(object, bl2, this.tree.isExpanded(n2), bl3, n2, bl4);
        }

        TreePath[] getDisplayOrderPaths(TreePath[] treePathArray) {
            int n2;
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            for (n2 = 0; n2 < treePathArray.length; ++n2) {
                arrayList.add(treePathArray[n2]);
            }
            Collections.sort(arrayList, this);
            n2 = arrayList.size();
            TreePath[] treePathArray2 = new TreePath[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                treePathArray2[i2] = (TreePath)arrayList.get(i2);
            }
            return treePathArray2;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;
        private boolean changeSelection;

        public TreeTraverseAction(int n2, String string) {
            this(n2, string, true);
        }

        private TreeTraverseAction(int n2, String string, boolean bl2) {
            this.direction = n2;
            this.changeSelection = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.traverse(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.changeSelection);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }
}

