/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XVerticalScrollbar;
import sun.awt.X11.XWindow;

public class ListHelper
implements XScrollbarClient {
    private static final Logger log = Logger.getLogger("sun.awt.X11.ListHelper");
    private final int FOCUS_INSET = 1;
    private final int BORDER_WIDTH;
    private final int ITEM_MARGIN;
    private final int TEXT_SPACE;
    private final int SCROLLBAR_WIDTH;
    private List items;
    private List selected;
    private boolean multiSelect;
    private int focusedIndex;
    private int maxVisItems;
    private XVerticalScrollbar vsb;
    private boolean vsbVis;
    private XHorizontalScrollbar hsb;
    private boolean hsbVis;
    private Font font;
    private FontMetrics fm;
    private XWindow peer;
    private Color[] colors;

    public ListHelper(XWindow xWindow, Color[] colorArray, int n2, boolean bl2, boolean bl3, boolean bl4, Font font, int n3, int n4, int n5, int n6, int n7) {
        this.peer = xWindow;
        this.colors = colorArray;
        this.multiSelect = bl2;
        this.items = new ArrayList(n2);
        this.selected = new ArrayList(1);
        this.selected.add(new Integer(-1));
        this.maxVisItems = n3;
        if (bl3) {
            this.vsb = new XVerticalScrollbar(this);
            this.vsb.setValues(0, 0, 0, 0, 1, n3 - 1);
        }
        if (bl4) {
            this.hsb = new XHorizontalScrollbar(this);
            this.hsb.setValues(0, 0, 0, 0, 1, 1);
        }
        this.setFont(font);
        this.TEXT_SPACE = n4;
        this.ITEM_MARGIN = n5;
        this.BORDER_WIDTH = n6;
        this.SCROLLBAR_WIDTH = n7;
    }

    public Component getEventSource() {
        return this.peer.getEventSource();
    }

    public void add(String string) {
        this.items.add(string);
        this.updateScrollbars();
    }

    public void add(String string, int n2) {
        this.items.add(n2, string);
        this.updateScrollbars();
    }

    public void remove(String string) {
        this.items.remove(string);
        this.updateScrollbars();
    }

    public void remove(int n2) {
        this.items.remove(n2);
        this.updateScrollbars();
    }

    public void removeAll() {
        this.items.removeAll(this.items);
        this.updateScrollbars();
    }

    public void setMultiSelect(boolean bl2) {
        this.multiSelect = bl2;
    }

    public void select(int n2) {
        if (this.multiSelect) {
            assert (false) : "Implement ListHelper.select() for multiselect";
        } else if (this.getSelectedIndex() != n2) {
            this.selected.remove(0);
            this.selected.add(new Integer(n2));
            this.makeVisible(n2);
        }
    }

    public void deselect(int n2) {
        assert (false);
    }

    public int getSelectedIndex() {
        if (!this.multiSelect) {
            Integer n2 = (Integer)this.selected.get(0);
            return n2;
        }
        return -1;
    }

    int[] getSelectedIndexes() {
        assert (false);
        return null;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String getItem(int n2) {
        return (String)this.items.get(n2);
    }

    public void setFocusedIndex(int n2) {
        this.focusedIndex = n2;
    }

    public boolean isFocusedIndex(int n2) {
        return n2 == this.focusedIndex;
    }

    public void setFont(Font font) {
        if (font != this.font) {
            this.font = font;
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        }
    }

    public int getMaxItemWidth() {
        int n2 = 0;
        int n3 = this.getItemCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.fm.stringWidth(this.getItem(i2));
            n2 = Math.max(n2, n4);
        }
        return n2;
    }

    int getItemHeight() {
        return this.fm.getHeight() + 2 * this.TEXT_SPACE;
    }

    public int y2index(int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("y=" + n2 + ", firstIdx=" + this.firstDisplayedIndex() + ", itemHeight=" + this.getItemHeight() + ",item_margin=" + this.ITEM_MARGIN);
        }
        int n3 = this.firstDisplayedIndex() + n2 / (this.getItemHeight() + 2 * this.ITEM_MARGIN);
        return n3;
    }

    public int firstDisplayedIndex() {
        if (this.vsbVis) {
            return this.vsb.getValue();
        }
        return 0;
    }

    public int lastDisplayedIndex() {
        if (this.hsbVis) assert (false) : "Implement for horiz scroll bar";
        return this.vsbVis ? this.vsb.getValue() + this.maxVisItems - 1 : this.getItemCount() - 1;
    }

    public void makeVisible(int n2) {
        if (this.vsbVis) {
            if (n2 < this.firstDisplayedIndex()) {
                this.vsb.setValue(n2);
            } else if (n2 > this.lastDisplayedIndex()) {
                this.vsb.setValue(n2 - this.maxVisItems + 1);
            }
        }
    }

    public void up() {
        int n2 = this.getSelectedIndex();
        int n3 = this.getItemCount();
        assert (n2 >= 0);
        int n4 = n2 == 0 ? n3 - 1 : --n2;
        this.select(n4);
    }

    public void down() {
        int n2 = (this.getSelectedIndex() + 1) % this.getItemCount();
        this.select(n2);
    }

    public void pageUp() {
        if (this.vsbVis && this.firstDisplayedIndex() > 0) {
            if (this.multiSelect) {
                assert (false) : "Implement pageUp() for multiSelect";
            } else {
                int n2 = this.getSelectedIndex() - this.firstDisplayedIndex();
                int n3 = this.firstDisplayedIndex() - this.vsb.getBlockIncrement();
                this.vsb.setValue(n3);
                this.select(this.firstDisplayedIndex() + n2);
            }
        }
    }

    public void pageDown() {
        if (this.vsbVis && this.lastDisplayedIndex() < this.getItemCount() - 1) {
            if (this.multiSelect) {
                assert (false) : "Implement pageDown() for multiSelect";
            } else {
                int n2 = this.getSelectedIndex() - this.firstDisplayedIndex();
                int n3 = this.lastDisplayedIndex();
                this.vsb.setValue(n3);
                this.select(this.firstDisplayedIndex() + n2);
            }
        }
    }

    public void home() {
    }

    public void end() {
    }

    public boolean isVSBVisible() {
        return this.vsbVis;
    }

    public boolean isHSBVisible() {
        return this.hsbVis;
    }

    public XVerticalScrollbar getVSB() {
        return this.vsb;
    }

    public XHorizontalScrollbar getHSB() {
        return this.hsb;
    }

    public boolean isInVertSB(Rectangle rectangle, int n2, int n3) {
        if (this.vsbVis) {
            assert (this.vsb != null) : "Vert scrollbar is visible, yet is null?";
            int n4 = this.hsbVis ? rectangle.height - this.SCROLLBAR_WIDTH : rectangle.height;
            return n2 <= rectangle.width && n2 >= rectangle.width - this.SCROLLBAR_WIDTH && n3 >= 0 && n3 <= n4;
        }
        return false;
    }

    public boolean isInHorizSB(Rectangle rectangle, int n2, int n3) {
        if (this.hsbVis) {
            assert (this.hsb != null) : "Horiz scrollbar is visible, yet is null?";
            int n4 = this.vsbVis ? rectangle.width - this.SCROLLBAR_WIDTH : rectangle.width;
            return n2 <= n4 && n2 >= 0 && n3 >= rectangle.height - this.SCROLLBAR_WIDTH && n3 <= rectangle.height;
        }
        return false;
    }

    public void handleVSBEvent(MouseEvent mouseEvent, Rectangle rectangle, int n2, int n3) {
        int n4 = this.hsbVis ? rectangle.height - this.SCROLLBAR_WIDTH : rectangle.height;
        this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), n2 - (rectangle.width - this.SCROLLBAR_WIDTH), n3);
    }

    void updateScrollbars() {
        boolean bl2 = this.vsbVis = this.vsb != null && this.items.size() > this.maxVisItems;
        if (this.vsbVis) {
            this.vsb.setValues(this.vsb.getValue(), this.getNumItemsDisplayed(), this.vsb.getMinimum(), this.items.size());
        }
    }

    public int getNumItemsDisplayed() {
        return this.items.size() > this.maxVisItems ? this.maxVisItems : this.items.size();
    }

    public void repaintScrollbarRequest(XScrollbar xScrollbar) {
        Graphics graphics = this.peer.getGraphics();
        Rectangle rectangle = this.peer.getBounds();
        if (xScrollbar == this.vsb && this.vsbVis) {
            this.paintVSB(graphics, XComponentPeer.getSystemColors(), rectangle);
        } else if (xScrollbar == this.hsb && this.hsbVis) {
            this.paintHSB(graphics, XComponentPeer.getSystemColors(), rectangle);
        }
        graphics.dispose();
    }

    public void notifyValue(XScrollbar xScrollbar, int n2, int n3, boolean bl2) {
        if (xScrollbar == this.vsb) {
            this.vsb.setValue(n3);
            Graphics graphics = this.peer.getGraphics();
            Rectangle rectangle = this.peer.getBounds();
            int n4 = n3;
            int n5 = Math.min(this.getItemCount() - 1, n3 + this.maxVisItems);
            this.paintItems(graphics, this.colors, rectangle, n4, n5);
            graphics.dispose();
        } else if ((XHorizontalScrollbar)xScrollbar == this.hsb) {
            this.hsb.setValue(n3);
        }
    }

    public void updateColors(Color[] colorArray) {
        this.colors = colorArray;
    }

    public void paintItems(Graphics graphics, Color[] colorArray, Rectangle rectangle) {
    }

    public void paintAllItems(Graphics graphics, Color[] colorArray, Rectangle rectangle) {
        this.paintItems(graphics, colorArray, rectangle, this.firstDisplayedIndex(), this.lastDisplayedIndex());
    }

    public void paintItems(Graphics graphics, Color[] colorArray, Rectangle rectangle, int n2, int n3) {
        int n4 = this.BORDER_WIDTH + this.ITEM_MARGIN;
        int n5 = rectangle.width - 2 * this.ITEM_MARGIN - 2 * this.BORDER_WIDTH - (this.vsbVis ? this.SCROLLBAR_WIDTH : 0);
        int n6 = this.getItemHeight();
        int n7 = this.BORDER_WIDTH + this.ITEM_MARGIN;
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.paintItem(graphics, colorArray, this.getItem(i2), n4, n7, n5, n6, this.isItemSelected(i2), this.isFocusedIndex(i2));
            n7 += n6 + 2 * this.ITEM_MARGIN;
        }
        if (this.vsbVis) {
            this.paintVSB(graphics, XComponentPeer.getSystemColors(), rectangle);
        }
        if (this.hsbVis) {
            this.paintHSB(graphics, XComponentPeer.getSystemColors(), rectangle);
        }
    }

    public void paintItem(Graphics graphics, Color[] colorArray, String string, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        if (bl2) {
            graphics.setColor(colorArray[3]);
        } else {
            graphics.setColor(colorArray[0]);
        }
        graphics.fillRect(n2, n3, n4, n5);
        if (bl3) {
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n2 + 1, n3 + 1, n4 - 2, n5 - 2);
        }
        if (bl2) {
            graphics.setColor(colorArray[0]);
        } else {
            graphics.setColor(colorArray[3]);
        }
        graphics.setFont(this.font);
        int n6 = this.fm.getAscent();
        int n7 = this.fm.getDescent();
        graphics.drawString(string, n2 + this.TEXT_SPACE, n3 + (n5 + this.fm.getMaxAscent() - this.fm.getMaxDescent()) / 2);
    }

    boolean isItemSelected(int n2) {
        for (Integer n3 : this.selected) {
            if (n3 != n2) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintVSB(Graphics graphics, Color[] colorArray, Rectangle rectangle) {
        int n2 = rectangle.height - 2 * this.BORDER_WIDTH - (this.hsbVis ? this.SCROLLBAR_WIDTH - 2 : 0);
        Graphics graphics2 = graphics.create();
        graphics.setColor(colorArray[0]);
        try {
            graphics2.translate(rectangle.width - this.BORDER_WIDTH - this.SCROLLBAR_WIDTH, this.BORDER_WIDTH);
            this.vsb.setSize(this.SCROLLBAR_WIDTH, rectangle.height);
            this.vsb.paint(graphics2, colorArray, true);
        }
        finally {
            graphics2.dispose();
        }
    }

    public void paintHSB(Graphics graphics, Color[] colorArray, Rectangle rectangle) {
    }

    static boolean doWheelScroll(XVerticalScrollbar xVerticalScrollbar, XHorizontalScrollbar xHorizontalScrollbar, MouseWheelEvent mouseWheelEvent) {
        XScrollbar xScrollbar = null;
        if (xVerticalScrollbar != null) {
            xScrollbar = xVerticalScrollbar;
        } else if (xHorizontalScrollbar != null) {
            xScrollbar = xHorizontalScrollbar;
        } else {
            return false;
        }
        int n2 = mouseWheelEvent.getWheelRotation();
        if (n2 < 0 && xScrollbar.getValue() > xScrollbar.getMinimum() || n2 > 0 && xScrollbar.getValue() < xScrollbar.getMaximum() || n2 != 0) {
            int n3 = mouseWheelEvent.getScrollType();
            int n4 = n3 == 1 ? n2 * xScrollbar.getBlockIncrement() : mouseWheelEvent.getUnitsToScroll() * xScrollbar.getUnitIncrement();
            xScrollbar.setValue(xScrollbar.getValue() + n4);
            return true;
        }
        return false;
    }
}

