/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class Native {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    static int longSize;
    static int dataModel;

    Native() {
    }

    static boolean getBool(long l2) {
        return Native.getInt(l2) != 0;
    }

    static boolean getBool(long l2, int n2) {
        return Native.getInt(l2, n2) != 0;
    }

    static void putBool(long l2, boolean bl2) {
        Native.putInt(l2, bl2 ? 1 : 0);
    }

    static void putBool(long l2, int n2, boolean bl2) {
        Native.putInt(l2, n2, bl2 ? 1 : 0);
    }

    static int getByteSize() {
        return 1;
    }

    static byte getByte(long l2) {
        return unsafe.getByte(l2);
    }

    static byte getByte(long l2, int n2) {
        return Native.getByte(l2 + (long)n2);
    }

    static void putByte(long l2, byte by) {
        unsafe.putByte(l2, by);
    }

    static void putByte(long l2, int n2, byte by) {
        Native.putByte(l2 + (long)n2, by);
    }

    static byte[] toBytes(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = Native.getByte(l2);
            ++n3;
            ++l2;
        }
        return byArray;
    }

    static long toData(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        long l2 = XlibWrapper.unsafe.allocateMemory(byArray.length);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            Native.putByte(l2 + (long)i2, byArray[i2]);
        }
        return l2;
    }

    static int getUByteSize() {
        return 1;
    }

    static short getUByte(long l2) {
        return (short)(0xFF & unsafe.getByte(l2));
    }

    static short getUByte(long l2, int n2) {
        return Native.getUByte(l2 + (long)n2);
    }

    static void putUByte(long l2, short s2) {
        unsafe.putByte(l2, (byte)s2);
    }

    static void putUByte(long l2, int n2, short s2) {
        Native.putUByte(l2 + (long)n2, s2);
    }

    static short[] toUBytes(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        short[] sArray = new short[n2];
        int n3 = 0;
        while (n3 < n2) {
            sArray[n3] = Native.getUByte(l2);
            ++n3;
            ++l2;
        }
        return sArray;
    }

    static long toUData(short[] sArray) {
        if (sArray == null) {
            return 0L;
        }
        long l2 = XlibWrapper.unsafe.allocateMemory(sArray.length);
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            Native.putUByte(l2 + (long)i2, sArray[i2]);
        }
        return l2;
    }

    static int getShortSize() {
        return 2;
    }

    static short getShort(long l2) {
        return unsafe.getShort(l2);
    }

    static void putShort(long l2, short s2) {
        unsafe.putShort(l2, s2);
    }

    static void putShort(long l2, int n2, short s2) {
        Native.putShort(l2 + (long)(n2 * Native.getShortSize()), s2);
    }

    static long toData(short[] sArray) {
        if (sArray == null) {
            return 0L;
        }
        long l2 = XlibWrapper.unsafe.allocateMemory(sArray.length * Native.getShortSize());
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            Native.putShort(l2, i2, sArray[i2]);
        }
        return l2;
    }

    static int getUShortSize() {
        return 2;
    }

    static int getUShort(long l2) {
        return 0xFFFF & unsafe.getShort(l2);
    }

    static void putUShort(long l2, int n2) {
        unsafe.putShort(l2, (short)n2);
    }

    static void putUShort(long l2, int n2, int n3) {
        Native.putUShort(l2 + (long)(n2 * Native.getShortSize()), n3);
    }

    static long toUData(int[] nArray) {
        if (nArray == null) {
            return 0L;
        }
        long l2 = XlibWrapper.unsafe.allocateMemory(nArray.length * Native.getShortSize());
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Native.putUShort(l2, i2, nArray[i2]);
        }
        return l2;
    }

    static int getIntSize() {
        return 4;
    }

    static int getInt(long l2) {
        return unsafe.getInt(l2);
    }

    static int getInt(long l2, int n2) {
        return Native.getInt(l2 + (long)(Native.getIntSize() * n2));
    }

    static void putInt(long l2, int n2) {
        unsafe.putInt(l2, n2);
    }

    static void putInt(long l2, int n2, int n3) {
        Native.putInt(l2 + (long)(n2 * Native.getIntSize()), n3);
    }

    static long toData(int[] nArray) {
        if (nArray == null) {
            return 0L;
        }
        long l2 = XlibWrapper.unsafe.allocateMemory(nArray.length * Native.getIntSize());
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Native.putInt(l2, i2, nArray[i2]);
        }
        return l2;
    }

    static int getUIntSize() {
        return 4;
    }

    static long getUInt(long l2) {
        return 0xFFFFFFFFL & (long)unsafe.getInt(l2);
    }

    static long getUInt(long l2, int n2) {
        return Native.getUInt(l2 + (long)(Native.getIntSize() * n2));
    }

    static void putUInt(long l2, long l3) {
        unsafe.putInt(l2, (int)l3);
    }

    static void putUInt(long l2, int n2, long l3) {
        Native.putUInt(l2 + (long)(n2 * Native.getIntSize()), l3);
    }

    static long toUData(long[] lArray) {
        if (lArray == null) {
            return 0L;
        }
        long l2 = XlibWrapper.unsafe.allocateMemory(lArray.length * Native.getIntSize());
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            Native.putUInt(l2, i2, lArray[i2]);
        }
        return l2;
    }

    static int getLongSize() {
        return longSize;
    }

    static long getLong(long l2) {
        if (XlibWrapper.dataModel == 32) {
            return unsafe.getInt(l2);
        }
        return unsafe.getLong(l2);
    }

    static void putLong(long l2, long l3) {
        if (XlibWrapper.dataModel == 32) {
            unsafe.putInt(l2, (int)l3);
        } else {
            unsafe.putLong(l2, l3);
        }
    }

    static void putLong(long l2, int n2, long l3) {
        Native.putLong(l2 + (long)(n2 * Native.getLongSize()), l3);
    }

    static long getLong(long l2, int n2) {
        return Native.getLong(l2 + (long)(n2 * Native.getLongSize()));
    }

    static void put(long l2, long[] lArray) {
        int n2 = 0;
        while (n2 < lArray.length) {
            Native.putLong(l2, lArray[n2]);
            ++n2;
            l2 += (long)Native.getLongSize();
        }
    }

    static void putLong(long l2, Vector vector) {
        int n2 = 0;
        while (n2 < vector.size()) {
            Native.putLong(l2, (Long)vector.elementAt(n2));
            ++n2;
            l2 += (long)Native.getLongSize();
        }
    }

    static void putLongReverse(long l2, Vector vector) {
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            Native.putLong(l2, (Long)vector.elementAt(n2));
            --n2;
            l2 += (long)Native.getLongSize();
        }
    }

    static long[] toLongs(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        long[] lArray = new long[n2];
        int n3 = 0;
        while (n3 < n2) {
            lArray[n3] = Native.getLong(l2);
            ++n3;
            l2 += (long)Native.getLongSize();
        }
        return lArray;
    }

    static long toData(long[] lArray) {
        if (lArray == null) {
            return 0L;
        }
        long l2 = XlibWrapper.unsafe.allocateMemory(lArray.length * Native.getLongSize());
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            Native.putLong(l2, i2, lArray[i2]);
        }
        return l2;
    }

    static long allocateLongArray(int n2) {
        return unsafe.allocateMemory(Native.getLongSize() * n2);
    }

    static long getWindow(long l2) {
        return Native.getLong(l2);
    }

    static long getWindow(long l2, int n2) {
        return Native.getLong(l2 + (long)(Native.getWindowSize() * n2));
    }

    static void putWindow(long l2, long l3) {
        Native.putLong(l2, l3);
    }

    static void putWindow(long l2, int n2, long l3) {
        Native.putLong(l2, n2, l3);
    }

    static int getWindowSize() {
        return Native.getLongSize();
    }

    static long getCard32(long l2) {
        return Native.getLong(l2);
    }

    static void putCard32(long l2, long l3) {
        Native.putLong(l2, l3);
    }

    static long getCard32(long l2, int n2) {
        return Native.getLong(l2, n2);
    }

    static void putCard32(long l2, int n2, long l3) {
        Native.putLong(l2, n2, l3);
    }

    static int getCard32Size() {
        return Native.getLongSize();
    }

    static long[] card32ToArray(long l2, int n2) {
        return Native.toLongs(l2, n2);
    }

    static long card32ToData(long[] lArray) {
        return Native.toData(lArray);
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("sun.arch.data.model");
            }
        });
        try {
            dataModel = Integer.parseInt(string);
        }
        catch (Exception exception) {
            dataModel = 32;
        }
        longSize = dataModel == 32 ? 4 : 8;
    }
}

