/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.awt.X11.XAtom;
import sun.awt.X11.XToolkit;

class XAtomList {
    Set atoms = new HashSet();

    public XAtomList() {
    }

    public XAtomList(long l2, int n2) {
        this.init(l2, n2);
    }

    private void init(long l2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add(new XAtom(XToolkit.getDisplay(), XAtom.getAtom(l2 + (long)(n2 * XAtom.getAtomSize()))));
        }
    }

    public XAtomList(XAtom[] xAtomArray) {
        this.init(xAtomArray);
    }

    private void init(XAtom[] xAtomArray) {
        for (int i2 = 0; i2 < xAtomArray.length; ++i2) {
            this.add(xAtomArray[i2]);
        }
    }

    public XAtom[] getAtoms() {
        XAtom[] xAtomArray = new XAtom[this.size()];
        Iterator iterator = this.atoms.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            xAtomArray[n2++] = (XAtom)iterator.next();
        }
        return xAtomArray;
    }

    public long getAtomsData() {
        return XAtom.toData(this.getAtoms());
    }

    public boolean contains(XAtom xAtom) {
        return this.atoms.contains(xAtom);
    }

    public void add(XAtom xAtom) {
        this.atoms.add(xAtom);
    }

    public void remove(XAtom xAtom) {
        this.atoms.remove(xAtom);
    }

    public int size() {
        return this.atoms.size();
    }

    public XAtomList subset(int n2, Map map) {
        XAtomList xAtomList = new XAtomList();
        for (Integer n3 : map.keySet()) {
            XAtom xAtom;
            if ((n2 & n3) != n3 || !this.contains(xAtom = (XAtom)map.get(n3))) continue;
            xAtomList.add(xAtom);
        }
        return xAtomList;
    }

    public Iterator iterator() {
        return this.atoms.iterator();
    }

    public void addAll(XAtomList xAtomList) {
        Iterator iterator = xAtomList.iterator();
        while (iterator.hasNext()) {
            this.add((XAtom)iterator.next());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.atoms.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

