/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ButtonPeer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XToolkit;

public class XButtonPeer
extends XComponentPeer
implements ButtonPeer {
    boolean pressed = false;
    boolean armed = false;
    private Insets focusInsets;
    private Insets borderInsets;
    private Insets contentAreaInsets;
    private static final String propertyPrefix = "Button.";
    protected Color focusColor = SystemColor.windowText;
    private boolean disposed = false;
    String label;

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        this.borderInsets = new Insets(2, 2, 2, 2);
        this.focusInsets = new Insets(0, 0, 0, 0);
        this.contentAreaInsets = new Insets(3, 3, 3, 3);
    }

    public XButtonPeer(Button button) {
        super(button);
        this.label = button.getLabel();
        this.updateMotifColors(this.getPeerBackground());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Component component = this.target;
        synchronized (component) {
            this.disposed = true;
        }
        super.dispose();
    }

    public boolean isFocusable() {
        return true;
    }

    public void setLabel(String string) {
        this.label = string;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.target);
    }

    public void setBackground(Color color) {
        this.updateMotifColors(color);
        super.setBackground(color);
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: {
                Button button;
                if (!XToolkit.isLeftMouseButton(mouseEvent) || !(button = (Button)mouseEvent.getSource()).contains(mouseEvent.getX(), mouseEvent.getY())) break;
                if (!this.isEnabled()) {
                    return;
                }
                this.pressed = true;
                this.armed = true;
                this.repaint();
                break;
            }
            case 502: {
                if (!XToolkit.isLeftMouseButton(mouseEvent)) break;
                if (this.armed) {
                    this.action(mouseEvent.getWhen(), mouseEvent.getModifiers());
                }
                this.pressed = false;
                this.armed = false;
                this.repaint();
                break;
            }
            case 504: {
                if (!this.pressed) break;
                this.armed = true;
                break;
            }
            case 505: {
                this.armed = false;
            }
        }
    }

    public void action(long l2, int n2) {
        this.postEvent(new ActionEvent(this.target, 1001, ((Button)this.target).getActionCommand(), l2, n2));
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.repaint();
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        switch (n2) {
            case 401: {
                if (keyEvent.getKeyCode() != 32) break;
                this.pressed = true;
                this.armed = true;
                this.repaint();
                this.action(keyEvent.getWhen(), keyEvent.getModifiers());
                break;
            }
            case 402: {
                if (keyEvent.getKeyCode() != 32) break;
                this.pressed = false;
                this.armed = false;
                this.repaint();
            }
        }
    }

    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getPeerFont());
        if (this.label == null) {
            this.label = "";
        }
        return new Dimension(fontMetrics.stringWidth(this.label) + 14, fontMetrics.getHeight() + 8);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics, Component component) {
        if (!this.disposed && graphics != null) {
            Dimension dimension = this.getPeerSize();
            graphics.setColor(this.getPeerBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            this.paintBorder(graphics, this.borderInsets.left, this.borderInsets.top, dimension.width - (this.borderInsets.left + this.borderInsets.right), dimension.height - (this.borderInsets.top + this.borderInsets.bottom));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            rectangle2.width = dimension.width - (this.contentAreaInsets.left + this.contentAreaInsets.right);
            rectangle2.height = dimension.height - (this.contentAreaInsets.top + this.contentAreaInsets.bottom);
            rectangle2.x = this.contentAreaInsets.left;
            rectangle2.y = this.contentAreaInsets.right;
            String string = this.label != null ? this.label : "";
            String string2 = SwingUtilities.layoutCompoundLabel(fontMetrics, string, null, 0, 0, 0, 0, rectangle2, rectangle3, rectangle, 0);
            Font font = this.getPeerFont();
            graphics.setFont(font);
            if (this.pressed && this.armed) {
                this.paintButtonPressed(graphics, this.target);
            }
            this.paintText(graphics, this.target, rectangle, string2);
            if (this.hasFocus()) {
                this.paintFocus(graphics, this.focusInsets.left, this.focusInsets.top, dimension.width - (this.focusInsets.left + this.focusInsets.right) - 1, dimension.height - (this.focusInsets.top + this.focusInsets.bottom) - 1);
            }
        }
        this.flush();
    }

    public void paintBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        this.drawMotif3DRect(graphics, n2, n3, n4 - 1, n5 - 1, this.pressed);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.target.repaint();
    }

    protected void paintFocus(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.focusColor);
        graphics.drawRect(n2, n3, n4, n5);
    }

    protected void paintButtonPressed(Graphics graphics, Component component) {
        Dimension dimension = this.getPeerSize();
        graphics.setColor(this.selectColor);
        graphics.fillRect(this.contentAreaInsets.left, this.contentAreaInsets.top, dimension.width - (this.contentAreaInsets.left + this.contentAreaInsets.right), dimension.height - (this.contentAreaInsets.top + this.contentAreaInsets.bottom));
    }

    protected void paintText(Graphics graphics, Component component, Rectangle rectangle, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = -1;
        if (this.isEnabled()) {
            graphics.setColor(this.getPeerForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            graphics.setColor(this.getPeerBackground().brighter());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(component.getBackground().darker());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }
}

