/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.ChoicePeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.ListHelper;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XWindow;

public class XChoicePeer
extends XComponentPeer
implements ChoicePeer {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XChoicePeer");
    private static final int MAX_UNFURLED_ITEMS = 10;
    public static final int TEXT_SPACE = 1;
    public static final int BORDER_WIDTH = 1;
    public static final int ITEM_MARGIN = 1;
    public static final int SCROLLBAR_WIDTH = 15;
    private static final Insets focusInsets = new Insets(0, 0, 0, 0);
    private static final Insets borderInsets = new Insets(2, 2, 2, 2);
    static final int WIDGET_OFFSET = 18;
    static final int TEXT_XPAD = 8;
    static final int TEXT_YPAD = 6;
    static final Color focusColor = Color.black;
    private boolean unfurled = false;
    private boolean dragging = false;
    private boolean mouseInSB = false;
    private boolean firstPress = false;
    private ListHelper helper;
    private UnfurledChoice unfurledChoice;
    private Rectangle textRect;
    private Rectangle focusRect;
    private boolean drawSelectedItem = true;
    private Component alignUnder;
    private int dragStartIdx = -1;

    XChoicePeer(Choice choice) {
        super(choice);
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        Choice choice = (Choice)this.target;
        int n2 = choice.getItemCount();
        this.unfurledChoice = new UnfurledChoice(choice);
        this.helper = new ListHelper(this.unfurledChoice, this.getGUIcolors(), n2, false, true, false, choice.getFont(), 10, 1, 1, 1, 15);
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        Choice choice = (Choice)this.target;
        int n2 = choice.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.helper.add(choice.getItem(i2));
        }
        if (!this.helper.isEmpty()) {
            this.helper.select(choice.getSelectedIndex());
            this.helper.setFocusedIndex(choice.getSelectedIndex());
        }
        this.helper.updateColors(this.getGUIcolors());
        this.updateMotifColors(this.getPeerBackground());
    }

    public boolean isFocusable() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.repaint();
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            this.keyPressed(keyEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 40: 
            case 225: {
                if (this.helper.getItemCount() <= 1) break;
                this.helper.down();
                int n2 = this.helper.getSelectedIndex();
                ((Choice)this.target).select(n2);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(n2), 1));
                this.repaint();
                break;
            }
            case 38: 
            case 224: {
                if (this.helper.getItemCount() <= 1) break;
                this.helper.up();
                int n3 = this.helper.getSelectedIndex();
                ((Choice)this.target).select(n3);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(n3), 1));
                this.repaint();
                break;
            }
            case 34: {
                if (!this.unfurled || this.dragging) break;
                int n4 = this.helper.getSelectedIndex();
                this.helper.pageDown();
                int n5 = this.helper.getSelectedIndex();
                if (n4 == n5) break;
                ((Choice)this.target).select(n5);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(n5), 1));
                this.repaint();
                break;
            }
            case 33: {
                if (!this.unfurled || this.dragging) break;
                int n6 = this.helper.getSelectedIndex();
                this.helper.pageUp();
                int n7 = this.helper.getSelectedIndex();
                if (n6 == n7) break;
                ((Choice)this.target).select(n7);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(n7), 1));
                this.repaint();
                break;
            }
            case 10: 
            case 27: {
                if (!this.unfurled) break;
                this.unfurled = false;
                this.dragging = false;
                this.mouseInSB = false;
                XChoicePeer.ungrabInput();
                this.unfurledChoice.setVisible(false);
                break;
            }
            default: {
                if (!this.unfurled) break;
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    void handleJavaMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (this.unfurled && this.helper.isVSBVisible() && ListHelper.doWheelScroll(this.helper.getVSB(), null, mouseWheelEvent)) {
            this.repaint();
        }
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 506: {
                this.mouseDragged(mouseEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dragStartIdx = this.helper.getSelectedIndex();
        if (this.unfurled) {
            this.unfurledChoice.trackMouse(mouseEvent);
        } else {
            this.grabInput();
            this.unfurledChoice.toFront();
            this.firstPress = true;
            this.unfurled = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.unfurled) {
            if (this.mouseInSB) {
                this.unfurledChoice.trackMouse(mouseEvent);
            } else {
                if (!this.firstPress || this.unfurledChoice.isMouseEventInside(mouseEvent)) {
                    XChoicePeer.ungrabInput();
                    this.unfurledChoice.setVisible(false);
                    this.unfurled = false;
                }
                if (!this.helper.isEmpty()) {
                    if (this.unfurledChoice.isMouseInListArea(mouseEvent)) {
                        int n2 = this.helper.getSelectedIndex();
                        if (n2 >= 0) {
                            if (n2 != this.dragStartIdx) {
                                ((Choice)this.target).select(n2);
                            }
                            this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(n2), 1));
                        }
                    } else {
                        this.helper.select(this.dragStartIdx);
                    }
                }
            }
        }
        this.dragging = false;
        this.firstPress = false;
        this.dragStartIdx = -1;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragging = true;
        this.unfurledChoice.trackMouse(mouseEvent);
    }

    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        Choice choice = (Choice)this.target;
        int n2 = 0;
        int n3 = choice.countItems();
        while (n3-- > 0) {
            n2 = Math.max(fontMetrics.stringWidth(choice.getItem(n3)), n2);
        }
        return new Dimension(n2 + 8 + 18, fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 6);
    }

    public void layout() {
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getPeerSize();
        graphics.setColor(this.getPeerBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        this.drawMotif3DRect(graphics, 1, 1, this.width - 2, this.height - 2, false);
        this.drawMotif3DRect(graphics, this.width - 18, this.height / 2 - 3, 12, 6, false);
        if (!this.helper.isEmpty() && this.helper.getSelectedIndex() != -1) {
            graphics.setFont(this.getPeerFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.helper.getItem(this.helper.getSelectedIndex());
            if (string != null && this.drawSelectedItem) {
                graphics.setClip(1, 1, this.width - 18 - 2, this.height);
                if (this.isEnabled()) {
                    graphics.setColor(this.getPeerForeground());
                    graphics.drawString(string, 5, (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2);
                } else {
                    graphics.setColor(this.getPeerBackground().brighter());
                    graphics.drawString(string, 5, (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2);
                    graphics.setColor(this.getPeerBackground().darker());
                    graphics.drawString(string, 4, (this.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2 - 1);
                }
                graphics.setClip(0, 0, this.width, this.height);
            }
        }
        if (this.hasFocus()) {
            this.paintFocus(graphics, XChoicePeer.focusInsets.left, XChoicePeer.focusInsets.top, dimension.width - (XChoicePeer.focusInsets.left + XChoicePeer.focusInsets.right) - 1, dimension.height - (XChoicePeer.focusInsets.top + XChoicePeer.focusInsets.bottom) - 1);
        }
        if (this.unfurled) {
            this.unfurledChoice.repaint();
        }
    }

    protected void paintFocus(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.setColor(focusColor);
        graphics.drawRect(n2, n3, n4, n5);
    }

    public void select(int n2) {
        this.helper.select(n2);
        this.helper.setFocusedIndex(n2);
        this.repaint();
    }

    public void add(String string, int n2) {
        this.helper.add(string, n2);
        this.repaint();
    }

    public void remove(int n2) {
        if (n2 == this.helper.getSelectedIndex()) {
            this.helper.remove(n2);
            if (this.helper.isEmpty()) {
                this.helper.select(-1);
            } else {
                this.helper.select(0);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(0), 1));
            }
            this.repaint();
        } else {
            this.helper.remove(n2);
        }
    }

    public void removeAll() {
        this.helper.removeAll();
        this.helper.select(-1);
        this.repaint();
    }

    public void addItem(String string, int n2) {
        this.add(string, n2);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.helper.setFont(this.font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.helper.updateColors(this.getGUIcolors());
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.unfurledChoice.setBackground(color);
        this.helper.updateColors(this.getGUIcolors());
        this.updateMotifColors(color);
    }

    public void setDrawSelectedItem(boolean bl2) {
        this.drawSelectedItem = bl2;
    }

    public void setAlignUnder(Component component) {
        this.alignUnder = component;
    }

    public void dispose() {
        if (this.unfurledChoice != null) {
            this.unfurledChoice.destroy();
        }
        super.dispose();
    }

    class UnfurledChoice
    extends XWindow {
        public UnfurledChoice(Component component) {
            super(component);
        }

        public void preInit(XCreateWindowParams xCreateWindowParams) {
            super.preInit(xCreateWindowParams);
            xCreateWindowParams.add((Object)"parent window", 0L);
            xCreateWindowParams.remove("bounds");
            xCreateWindowParams.add((Object)"overrideRedirect", Boolean.TRUE);
        }

        public void toFront() {
            int n2;
            if (XChoicePeer.this.helper.isEmpty()) {
                n2 = 1;
            } else {
                int n3 = XChoicePeer.this.helper.getItemCount();
                n2 = Math.min(10, n3);
            }
            Point point = XChoicePeer.this.toGlobal(0, 0);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (XChoicePeer.this.alignUnder != null) {
                Rectangle rectangle = XChoicePeer.this.getBounds();
                rectangle.setLocation(0, 0);
                rectangle = XChoicePeer.this.toGlobal(rectangle);
                Rectangle rectangle2 = new Rectangle(XChoicePeer.this.alignUnder.getLocationOnScreen(), XChoicePeer.this.alignUnder.getSize());
                Rectangle rectangle3 = rectangle.union(rectangle2);
                this.width = rectangle3.width;
                this.x = rectangle3.x;
                this.y = rectangle3.y + rectangle3.height;
                this.height = 2 + n2 * (XChoicePeer.this.helper.getItemHeight() + 2);
            } else {
                this.x = point.x;
                this.y = point.y + XChoicePeer.this.height;
                this.width = Math.max(XChoicePeer.this.width, XChoicePeer.this.helper.getMaxItemWidth() + 6 + (XChoicePeer.this.helper.isVSBVisible() ? 15 : 0));
                this.height = 2 + n2 * (XChoicePeer.this.helper.getItemHeight() + 2);
            }
            if (this.x < 0) {
                this.x = 0;
            } else if (this.x + this.width > dimension.width) {
                this.x = dimension.width - this.width;
            }
            if (this.y < 0) {
                this.y = 0;
            } else if (this.y + this.height > dimension.height) {
                this.y = dimension.height - this.height;
            }
            this.xSetBounds(this.x, this.y, this.width, this.height);
            super.toFront();
            this.setVisible(true);
        }

        public void trackMouse(MouseEvent mouseEvent) {
            Point point = this.toLocalCoords(mouseEvent);
            switch (mouseEvent.getID()) {
                case 501: {
                    if (XChoicePeer.this.helper.isInVertSB(this.getBounds(), point.x, point.y)) {
                        XChoicePeer.this.mouseInSB = true;
                        XChoicePeer.this.helper.handleVSBEvent(mouseEvent, this.getBounds(), point.x, point.y);
                        break;
                    }
                    this.trackSelection(point.x, point.y);
                    break;
                }
                case 502: {
                    if (!XChoicePeer.this.mouseInSB) break;
                    XChoicePeer.this.mouseInSB = false;
                    XChoicePeer.this.helper.handleVSBEvent(mouseEvent, this.getBounds(), point.x, point.y);
                    break;
                }
                case 506: {
                    if (XChoicePeer.this.mouseInSB) {
                        XChoicePeer.this.helper.handleVSBEvent(mouseEvent, this.getBounds(), point.x, point.y);
                        break;
                    }
                    this.trackSelection(point.x, point.y);
                }
            }
        }

        private void trackSelection(int n2, int n3) {
            if (!XChoicePeer.this.helper.isEmpty() && n2 > 0 && n2 < this.width && n3 > 0 && n3 < this.height) {
                int n4 = XChoicePeer.this.helper.y2index(n3);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("transX=" + n2 + ", transY=" + n3 + ",width=" + this.width + ", height=" + this.height + ", newIdx=" + n4 + " on " + this.target);
                }
                if (n4 >= 0 && n4 < XChoicePeer.this.helper.getItemCount() && n4 != XChoicePeer.this.helper.getSelectedIndex()) {
                    XChoicePeer.this.helper.select(n4);
                    XChoicePeer.this.unfurledChoice.repaint();
                }
            }
        }

        public void paint(Graphics graphics) {
            Choice choice = (Choice)this.target;
            Color[] colorArray = XChoicePeer.this.getGUIcolors();
            XChoicePeer.this.draw3DRect(graphics, XComponentPeer.getSystemColors(), 0, 0, this.width - 1, this.height - 1, true);
            XChoicePeer.this.draw3DRect(graphics, XComponentPeer.getSystemColors(), 1, 1, this.width - 3, this.height - 3, true);
            XChoicePeer.this.helper.paintAllItems(graphics, colorArray, this.getBounds());
        }

        public void setVisible(boolean bl2) {
            this.xSetVisible(bl2);
            if (!bl2 && XChoicePeer.this.alignUnder != null) {
                XChoicePeer.this.alignUnder.requestFocusInWindow();
            }
        }

        private Point toLocalCoords(MouseEvent mouseEvent) {
            Point point = XChoicePeer.this.toGlobal(mouseEvent.getX(), mouseEvent.getY());
            point.x -= this.x;
            point.y -= this.y;
            return point;
        }

        private boolean isMouseEventInside(MouseEvent mouseEvent) {
            Point point = this.toLocalCoords(mouseEvent);
            return point.x > 0 && point.x < this.width && point.y > 0 && point.y < this.height;
        }

        private boolean isMouseInListArea(MouseEvent mouseEvent) {
            if (this.isMouseEventInside(mouseEvent)) {
                Point point = this.toLocalCoords(mouseEvent);
                Rectangle rectangle = this.getBounds();
                if (!XChoicePeer.this.helper.isInVertSB(rectangle, point.x, point.y)) {
                    return true;
                }
            }
            return false;
        }

        public void handleConfigureNotifyEvent(long l2) {
        }

        public void handleMapNotifyEvent(long l2) {
        }

        public void handleUnmapNotifyEvent(long l2) {
        }
    }
}

