/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.ColorData;
import sun.awt.X11.Native;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XIconSize;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVisualInfo;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11.awtImageData;

public class XIconWindow
extends XBaseWindow {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XIconWindow");
    XFramePeer parent;
    Dimension size;
    long iconPixmap;
    int iconWidth;
    int iconHeight;

    XIconWindow(XFramePeer xFramePeer) {
        super(new XCreateWindowParams(new Object[]{"parent", xFramePeer, "delayed", Boolean.TRUE}));
    }

    void instantPreInit(XCreateWindowParams xCreateWindowParams) {
        super.instantPreInit(xCreateWindowParams);
        this.parent = (XFramePeer)xCreateWindowParams.get("parent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XIconSize[] getIconSizes() {
        XToolkit.awtLock();
        try {
            long l2;
            AwtGraphicsConfigData awtGraphicsConfigData = this.parent.getGraphicsConfigurationData();
            long l3 = awtGraphicsConfigData.get_awt_visInfo().get_screen();
            long l4 = XToolkit.getDisplay();
            if (log.isLoggable(Level.FINEST)) {
                log.finest(awtGraphicsConfigData.toString());
            }
            if ((l2 = (long)XlibWrapper.XGetIconSizes(l4, XlibWrapper.RootWindow(l4, l3), XlibWrapper.larg1, XlibWrapper.iarg1)) == 0L) {
                XIconSize[] xIconSizeArray = null;
                return xIconSizeArray;
            }
            int n2 = Native.getInt(XlibWrapper.iarg1);
            long l5 = Native.getLong(XlibWrapper.larg1);
            log.log(Level.FINEST, "count = {1}, sizes_ptr = {0}", new Object[]{new Long(l5), new Integer(n2)});
            XIconSize[] xIconSizeArray = new XIconSize[n2];
            int n3 = 0;
            while (n3 < n2) {
                xIconSizeArray[n3] = new XIconSize(l5);
                log.log(Level.FINEST, "sizes_ptr[{1}] = {0}", new Object[]{xIconSizeArray[n3], new Integer(n3)});
                ++n3;
                l5 += (long)XIconSize.getSize();
            }
            XIconSize[] xIconSizeArray2 = xIconSizeArray;
            return xIconSizeArray2;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension calcIconSize(int n2, int n3) {
        int n4;
        XIconSize[] xIconSizeArray = this.getIconSizes();
        if (xIconSizeArray == null) {
            return new Dimension(16, 16);
        }
        boolean bl2 = false;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n4 = 0; n4 < xIconSizeArray.length; ++n4) {
            int n9;
            if (n2 < xIconSizeArray[n4].get_min_width() || n2 > xIconSizeArray[n4].get_max_width() || n3 < xIconSizeArray[n4].get_min_height() || n3 > xIconSizeArray[n4].get_max_height()) continue;
            bl2 = true;
            if ((n2 - xIconSizeArray[n4].get_min_width()) % xIconSizeArray[n4].get_width_inc() == 0 && (n3 - xIconSizeArray[n4].get_min_height()) % xIconSizeArray[n4].get_height_inc() == 0) {
                n7 = n2;
                n8 = n3;
                n5 = 0;
                break;
            }
            n6 = n2 - xIconSizeArray[n4].get_min_width();
            int n10 = n6 == 0 ? n2 : n2 - (n6 %= xIconSizeArray[n4].get_width_inc());
            int n11 = n10 * n10 + (n9 = (n6 = n3 - xIconSizeArray[n4].get_min_height()) == 0 ? n3 : n3 - (n6 %= xIconSizeArray[n4].get_height_inc())) * n9;
            if (n5 <= n11) continue;
            n7 = n10;
            n8 = n9;
            n5 = n11;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("found=" + bl2);
        }
        if (!bl2) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("widthHint=" + n2 + ", heightHint=" + n3 + ", saveWidth=" + n7 + ", saveHeight=" + n8 + ", max_width=" + xIconSizeArray[0].get_max_width() + ", max_height=" + xIconSizeArray[0].get_max_height() + ", min_width=" + xIconSizeArray[0].get_min_width() + ", min_height=" + xIconSizeArray[0].get_min_height());
            }
            if (n2 > xIconSizeArray[0].get_max_width() || n3 > xIconSizeArray[0].get_max_height()) {
                n4 = n2 - xIconSizeArray[0].get_max_width();
                int n12 = n3 - xIconSizeArray[0].get_max_height();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("wdiff=" + n4 + ", hdiff=" + n12);
                }
                if (n4 >= n12) {
                    n7 = xIconSizeArray[0].get_max_width();
                    n8 = (int)((double)xIconSizeArray[0].get_max_width() / (double)n2 * (double)n3);
                } else {
                    n7 = (int)((double)xIconSizeArray[0].get_max_height() / (double)n3 * (double)n2);
                    n8 = xIconSizeArray[0].get_max_height();
                }
            } else if (n2 < xIconSizeArray[0].get_min_width() || n3 < xIconSizeArray[0].get_min_height()) {
                n7 = (xIconSizeArray[0].get_min_width() + xIconSizeArray[0].get_max_width()) / 2;
                n8 = (xIconSizeArray[0].get_min_height() + xIconSizeArray[0].get_max_height()) / 2;
            } else {
                n7 = n2;
                n8 = n2;
            }
        }
        Object object = XIconWindow.getAWTLock();
        synchronized (object) {
            XlibWrapper.XFree(xIconSizeArray[0].pData);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("return " + n7 + "x" + n8);
        }
        return new Dimension(n7, n8);
    }

    Dimension getIconSize(int n2, int n3) {
        if (this.size == null) {
            this.size = this.calcIconSize(n2, n3);
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setIconImage(int n2, int n3, DataBuffer dataBuffer) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("iconsWidth = " + n2 + ", iconHeight = " + n3);
        }
        XToolkit.awtLock();
        try {
            AwtGraphicsConfigData awtGraphicsConfigData = this.parent.getGraphicsConfigurationData();
            awtImageData awtImageData2 = awtGraphicsConfigData.get_awtImage(0);
            XVisualInfo xVisualInfo = awtGraphicsConfigData.get_awt_visInfo();
            if (this.iconPixmap != 0L && (this.iconWidth != n2 || this.iconHeight != n3)) {
                XlibWrapper.XFreePixmap(XToolkit.getDisplay(), this.iconPixmap);
                this.iconPixmap = 0L;
                log.finest("Freed previous pixmap");
            }
            if (this.iconPixmap == 0L) {
                this.iconPixmap = XlibWrapper.XCreatePixmap(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xVisualInfo.get_screen()), n2, n3, awtImageData2.get_Depth());
                if (this.iconPixmap == 0L) {
                    log.finest("Can't create new pixmap for icon");
                    return;
                }
                log.finest("New pixmap for icon created");
                this.iconWidth = n2;
                this.iconHeight = n3;
            }
            long l2 = 0L;
            try {
                int n4;
                if (!(dataBuffer instanceof DataBufferByte)) {
                    if (dataBuffer instanceof DataBufferInt) {
                        l2 = Native.toData(((DataBufferInt)dataBuffer).getData());
                    } else {
                        if (!(dataBuffer instanceof DataBufferUShort)) throw new IllegalArgumentException("Unknown data buffer: " + dataBuffer);
                        l2 = Native.toData(((DataBufferUShort)dataBuffer).getData());
                    }
                } else {
                    byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                    ColorData colorData = awtGraphicsConfigData.get_color_data(0);
                    n4 = colorData.get_awt_numICMcolors();
                    for (int i2 = 0; i2 < byArray.length; ++i2) {
                        byArray[i2] = byArray[i2] >= n4 ? (byte)0 : colorData.get_awt_icmLUT2Colors(byArray[i2]);
                    }
                    l2 = Native.toData(byArray);
                }
                int n5 = awtImageData2.get_wsImageFormat().get_bits_per_pixel();
                int n6 = awtImageData2.get_wsImageFormat().get_scanline_pad();
                n4 = XlibWrapper.paddedwidth(n2 * n5, n6) >> 3;
                if ((n4 << 3) / n5 < n2) {
                    log.finest("Image format doesn't fit to icon width");
                    return;
                }
                long l3 = XlibWrapper.XCreateImage(XToolkit.getDisplay(), xVisualInfo.get_visual(), awtImageData2.get_Depth(), 2, 0, l2, n2, n3, 32, n4);
                if (l3 == 0L) {
                    log.finest("Can't create XImage for icon");
                    return;
                }
                log.finest("Created XImage for icon");
                try {
                    long l4 = XlibWrapper.XCreateGC(XToolkit.getDisplay(), this.iconPixmap, 0L, 0L);
                    if (l4 == 0L) {
                        log.finest("Can't create GC for pixmap");
                        return;
                    }
                    log.finest("Created GC for pixmap");
                    try {
                        XlibWrapper.XPutImage(XToolkit.getDisplay(), this.iconPixmap, l4, l3, 0, 0, 0, 0, n2, n3);
                    }
                    finally {
                        XlibWrapper.XFreeGC(XToolkit.getDisplay(), l4);
                    }
                }
                finally {
                    XlibWrapper.XDestroyImage(l3);
                }
            }
            finally {
                XlibWrapper.unsafe.freeMemory(l2);
            }
            XWMHints xWMHints = this.parent.getWMHints();
            this.window = xWMHints.get_icon_window();
            if (this.window == 0L) {
                log.finest("Icon window wasn't set");
                XCreateWindowParams xCreateWindowParams = this.getDelayedParams();
                xCreateWindowParams.add((Object)"border pixel", new Long(XToolkit.getAwtDefaultFg()));
                xCreateWindowParams.add((Object)"pixmap", this.iconPixmap);
                xCreateWindowParams.add((Object)"color map", awtGraphicsConfigData.get_awt_cmap());
                xCreateWindowParams.add((Object)"visual depth", awtImageData2.get_Depth());
                xCreateWindowParams.add((Object)"visual class", 1);
                xCreateWindowParams.add((Object)"visual", xVisualInfo.get_visual());
                xCreateWindowParams.add((Object)"value mask", 8201L);
                xCreateWindowParams.add((Object)"parent window", XlibWrapper.RootWindow(XToolkit.getDisplay(), xVisualInfo.get_screen()));
                xCreateWindowParams.add((Object)"bounds", new Rectangle(0, 0, n2, n3));
                xCreateWindowParams.remove("delayed");
                this.init(xCreateWindowParams);
                if (this.getWindow() == 0L) {
                    log.finest("Can't create new icon window");
                    xWMHints.set_flags(xWMHints.get_flags() | 4L);
                    xWMHints.set_icon_pixmap(this.iconPixmap);
                    XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.parent.getShell(), xWMHints.pData);
                    return;
                }
                log.finest("Created new icon window");
            }
            xWMHints.set_flags(xWMHints.get_flags() | 8L | 4L);
            xWMHints.set_icon_pixmap(this.iconPixmap);
            xWMHints.set_icon_window(this.window);
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.parent.getShell(), xWMHints.pData);
            log.finest("Set icon window hint");
            XlibWrapper.XSetWindowBackgroundPixmap(XToolkit.getDisplay(), this.getWindow(), this.iconPixmap);
            XlibWrapper.XClearWindow(XToolkit.getDisplay(), this.getWindow());
            return;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }
}

