/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.color;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;

class CMMImageLayout {
    private static final int typeBase = 256;
    public static final int typeComponentUByte = 256;
    public static final int typeComponentUShort12 = 257;
    public static final int typeComponentUShort = 258;
    public static final int typePixelUByte = 259;
    public static final int typePixelUShort12 = 260;
    public static final int typePixelUShort = 261;
    public static final int typeShort555 = 262;
    public static final int typeShort565 = 263;
    public static final int typeInt101010 = 264;
    public static final int typeIntRGBPacked = 265;
    public int Type;
    public int NumCols;
    public int NumRows;
    public int OffsetColumn;
    public int OffsetRow;
    public int NumChannels;
    public Object[] chanData;
    public int[] DataOffsets;
    public int[] sampleInfo;

    public CMMImageLayout(byte[] byArray, int n2, int n3) {
        this.Type = 256;
        this.chanData = new Object[n3];
        this.DataOffsets = new int[n3];
        this.NumCols = n2;
        this.NumRows = 1;
        this.OffsetColumn = n3;
        this.OffsetRow = this.NumCols * this.OffsetColumn;
        this.NumChannels = n3;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.chanData[i2] = byArray;
            this.DataOffsets[i2] = i2;
        }
    }

    public CMMImageLayout(short[] sArray, int n2, int n3) {
        this.Type = 258;
        this.chanData = new Object[n3];
        this.DataOffsets = new int[n3];
        this.NumCols = n2;
        this.NumRows = 1;
        this.OffsetColumn = n3 * 2;
        this.OffsetRow = this.NumCols * this.OffsetColumn;
        this.NumChannels = n3;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.chanData[i2] = sArray;
            this.DataOffsets[i2] = i2 * 2;
        }
    }

    public CMMImageLayout(BufferedImage bufferedImage) {
        this.Type = bufferedImage.getType();
        switch (this.Type) {
            case 1: 
            case 2: 
            case 4: {
                this.NumChannels = 3;
                this.NumCols = bufferedImage.getWidth();
                this.NumRows = bufferedImage.getHeight();
                int n2 = 3;
                if (this.Type == 2) {
                    n2 = 4;
                }
                this.chanData = new Object[n2];
                this.DataOffsets = new int[n2];
                this.sampleInfo = new int[n2];
                this.OffsetColumn = 4;
                IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)bufferedImage.getRaster();
                this.OffsetRow = integerComponentRaster.getScanlineStride() * 4;
                int n3 = integerComponentRaster.getDataOffset(0) * 4;
                int[] nArray = integerComponentRaster.getDataStorage();
                for (int i2 = 0; i2 < 3; ++i2) {
                    this.chanData[i2] = nArray;
                    this.DataOffsets[i2] = n3;
                    this.sampleInfo[i2] = this.Type == 4 ? 3 - i2 : i2 + 1;
                }
                if (this.Type != 2) break;
                this.chanData[3] = nArray;
                this.DataOffsets[3] = n3;
                this.sampleInfo[3] = 0;
                break;
            }
            case 5: 
            case 6: {
                int n4;
                this.NumChannels = 3;
                this.NumCols = bufferedImage.getWidth();
                this.NumRows = bufferedImage.getHeight();
                if (this.Type == 5) {
                    this.OffsetColumn = 3;
                    n4 = 3;
                } else {
                    this.OffsetColumn = 4;
                    n4 = 4;
                }
                this.chanData = new Object[n4];
                this.DataOffsets = new int[n4];
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                this.OffsetRow = byteComponentRaster.getScanlineStride();
                int n5 = byteComponentRaster.getDataOffset(0);
                byte[] byArray = byteComponentRaster.getDataStorage();
                for (int i3 = 0; i3 < n4; ++i3) {
                    this.chanData[i3] = byArray;
                    this.DataOffsets[i3] = n5 - i3;
                }
                break;
            }
            case 10: {
                this.Type = 256;
                this.NumChannels = 1;
                this.NumCols = bufferedImage.getWidth();
                this.NumRows = bufferedImage.getHeight();
                this.chanData = new Object[1];
                this.DataOffsets = new int[1];
                this.OffsetColumn = 1;
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                this.OffsetRow = byteComponentRaster.getScanlineStride();
                this.chanData[0] = byteComponentRaster.getDataStorage();
                this.DataOffsets[0] = byteComponentRaster.getDataOffset(0);
                break;
            }
            case 11: {
                this.Type = 258;
                this.NumChannels = 1;
                this.NumCols = bufferedImage.getWidth();
                this.NumRows = bufferedImage.getHeight();
                this.chanData = new Object[1];
                this.DataOffsets = new int[1];
                this.OffsetColumn = 2;
                ShortComponentRaster shortComponentRaster = (ShortComponentRaster)bufferedImage.getRaster();
                this.OffsetRow = shortComponentRaster.getScanlineStride() * 2;
                this.chanData[0] = shortComponentRaster.getDataStorage();
                this.DataOffsets[0] = shortComponentRaster.getDataOffset(0) * 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("CMMImageLayout - bad image type passed to constructor");
            }
        }
    }

    public CMMImageLayout(BufferedImage bufferedImage, SinglePixelPackedSampleModel singlePixelPackedSampleModel, int n2, int n3, int n4, int n5) {
        this.Type = 265;
        this.NumChannels = 3;
        this.NumCols = bufferedImage.getWidth();
        this.NumRows = bufferedImage.getHeight();
        int n6 = 3;
        if (n5 >= 0) {
            n6 = 4;
        }
        this.chanData = new Object[n6];
        this.DataOffsets = new int[n6];
        this.sampleInfo = new int[n6];
        this.OffsetColumn = 4;
        this.OffsetRow = singlePixelPackedSampleModel.getScanlineStride() * 4;
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n7 = (dataBufferInt.getOffset() - writableRaster.getSampleModelTranslateY() * singlePixelPackedSampleModel.getScanlineStride() - writableRaster.getSampleModelTranslateX()) * 4;
        for (int i2 = 0; i2 < n6; ++i2) {
            this.chanData[i2] = nArray;
            this.DataOffsets[i2] = n7;
        }
        this.sampleInfo[0] = n2;
        this.sampleInfo[1] = n3;
        this.sampleInfo[2] = n4;
        if (n5 >= 0) {
            this.sampleInfo[3] = n5;
        }
    }

    public CMMImageLayout(BufferedImage bufferedImage, ComponentSampleModel componentSampleModel) {
        ColorModel colorModel = bufferedImage.getColorModel();
        int n2 = colorModel.getNumColorComponents();
        boolean bl2 = colorModel.hasAlpha();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = componentSampleModel.getBandOffsets();
        this.NumChannels = n2++;
        this.NumCols = bufferedImage.getWidth();
        this.NumRows = bufferedImage.getHeight();
        if (bl2) {
            // empty if block
        }
        this.chanData = new Object[n2];
        this.DataOffsets = new int[n2];
        switch (componentSampleModel.getDataType()) {
            case 0: {
                this.Type = 256;
                this.OffsetColumn = componentSampleModel.getPixelStride();
                this.OffsetRow = componentSampleModel.getScanlineStride();
                DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                int[] nArray3 = dataBufferByte.getOffsets();
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.chanData[i2] = dataBufferByte.getData(nArray[i2]);
                    this.DataOffsets[i2] = nArray3[nArray[i2]] - writableRaster.getSampleModelTranslateY() * componentSampleModel.getScanlineStride() - writableRaster.getSampleModelTranslateX() * componentSampleModel.getPixelStride() + nArray2[i2];
                }
                break;
            }
            case 1: {
                this.Type = 258;
                this.OffsetColumn = componentSampleModel.getPixelStride() * 2;
                this.OffsetRow = componentSampleModel.getScanlineStride() * 2;
                DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
                int[] nArray4 = dataBufferUShort.getOffsets();
                for (int i3 = 0; i3 < n2; ++i3) {
                    this.chanData[i3] = dataBufferUShort.getData(nArray[i3]);
                    this.DataOffsets[i3] = (nArray4[nArray[i3]] - writableRaster.getSampleModelTranslateY() * componentSampleModel.getScanlineStride() - writableRaster.getSampleModelTranslateX() * componentSampleModel.getPixelStride() + nArray2[i3]) * 2;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("CMMImageLayout - bad image type passed to constructor");
            }
        }
    }

    public CMMImageLayout(Raster raster, ComponentSampleModel componentSampleModel) {
        int n2 = raster.getNumBands();
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = componentSampleModel.getBandOffsets();
        this.NumChannels = n2;
        this.NumCols = raster.getWidth();
        this.NumRows = raster.getHeight();
        this.chanData = new Object[n2];
        this.DataOffsets = new int[n2];
        switch (componentSampleModel.getDataType()) {
            case 0: {
                this.Type = 256;
                this.OffsetColumn = componentSampleModel.getPixelStride();
                this.OffsetRow = componentSampleModel.getScanlineStride();
                DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                int[] nArray3 = dataBufferByte.getOffsets();
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.chanData[i2] = dataBufferByte.getData(nArray[i2]);
                    this.DataOffsets[i2] = nArray3[nArray[i2]] + (raster.getMinY() - raster.getSampleModelTranslateY()) * componentSampleModel.getScanlineStride() + (raster.getMinX() - raster.getSampleModelTranslateX()) * componentSampleModel.getPixelStride() + nArray2[i2];
                }
                break;
            }
            case 1: {
                this.Type = 258;
                this.OffsetColumn = componentSampleModel.getPixelStride() * 2;
                this.OffsetRow = componentSampleModel.getScanlineStride() * 2;
                DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
                int[] nArray4 = dataBufferUShort.getOffsets();
                for (int i3 = 0; i3 < n2; ++i3) {
                    this.chanData[i3] = dataBufferUShort.getData(nArray[i3]);
                    this.DataOffsets[i3] = (nArray4[nArray[i3]] + (raster.getMinY() - raster.getSampleModelTranslateY()) * componentSampleModel.getScanlineStride() + (raster.getMinX() - raster.getSampleModelTranslateX()) * componentSampleModel.getPixelStride() + nArray2[i3]) * 2;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("CMMImageLayout - bad image type passed to constructor");
            }
        }
    }
}

