/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Hashtable;

abstract class Underline {
    private static final float DEFAULT_THICKNESS = 1.0f;
    private static final boolean USE_THICKNESS = true;
    private static final boolean IGNORE_THICKNESS = false;
    private static final Hashtable UNDERLINES = new Hashtable(6);

    Underline() {
    }

    abstract void drawUnderline(Graphics2D var1, float var2, float var3, float var4, float var5);

    abstract float getLowerDrawLimit(float var1);

    abstract Shape getUnderlineShape(float var1, float var2, float var3, float var4);

    static Underline getUnderline(Object object) {
        if (object == null) {
            return null;
        }
        return (Underline)UNDERLINES.get(object);
    }

    static {
        Underline underline = new StandardUnderline(0.0f, 1.0f, null, true);
        UNDERLINES.put(TextAttribute.UNDERLINE_ON, underline);
        underline = new StandardUnderline(1.0f, 1.0f, null, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_ONE_PIXEL, underline);
        underline = new StandardUnderline(1.0f, 2.0f, null, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_TWO_PIXEL, underline);
        underline = new StandardUnderline(1.0f, 1.0f, new float[]{1.0f, 1.0f}, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_DOTTED, underline);
        underline = new StandardUnderline(1.0f, 1.0f, new float[]{4.0f, 4.0f}, false);
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_DASHED, underline);
        underline = new IMGrayUnderline();
        UNDERLINES.put(TextAttribute.UNDERLINE_LOW_GRAY, underline);
    }

    private static class IMGrayUnderline
    extends Underline {
        private BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);

        IMGrayUnderline() {
        }

        void drawUnderline(Graphics2D graphics2D, float f2, float f3, float f4, float f5) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.stroke);
            Line2D.Float float_ = new Line2D.Float(f3, f5, f4, f5);
            graphics2D.draw(float_);
            float_.y1 += 1.0f;
            float_.y2 += 1.0f;
            float_.x1 += 1.0f;
            graphics2D.draw(float_);
            graphics2D.setStroke(stroke);
        }

        float getLowerDrawLimit(float f2) {
            return 2.0f;
        }

        Shape getUnderlineShape(float f2, float f3, float f4, float f5) {
            GeneralPath generalPath = new GeneralPath();
            Line2D.Float float_ = new Line2D.Float(f3, f5, f4, f5);
            generalPath.append(this.stroke.createStrokedShape(float_), false);
            float_.y1 += 1.0f;
            float_.y2 += 1.0f;
            float_.x1 += 1.0f;
            generalPath.append(this.stroke.createStrokedShape(float_), false);
            return generalPath;
        }
    }

    private static final class StandardUnderline
    extends Underline {
        private float shift;
        private float thicknessMultiplier;
        private float[] dashPattern;
        private boolean useThickness;
        private BasicStroke cachedStroke;

        StandardUnderline(float f2, float f3, float[] fArray, boolean bl2) {
            this.shift = f2;
            this.thicknessMultiplier = f3;
            this.dashPattern = fArray;
            this.useThickness = bl2;
            this.cachedStroke = null;
        }

        private BasicStroke createStroke(float f2) {
            if (this.dashPattern == null) {
                return new BasicStroke(f2);
            }
            return new BasicStroke(f2, 0, 0, 10.0f, this.dashPattern, 0.0f);
        }

        private float getLineThickness(float f2) {
            if (this.useThickness) {
                return f2 * this.thicknessMultiplier;
            }
            return 1.0f * this.thicknessMultiplier;
        }

        private Stroke getStroke(float f2) {
            float f3 = this.getLineThickness(f2);
            BasicStroke basicStroke = this.cachedStroke;
            if (basicStroke == null || basicStroke.getLineWidth() != f3) {
                this.cachedStroke = basicStroke = this.createStroke(f3);
            }
            return basicStroke;
        }

        void drawUnderline(Graphics2D graphics2D, float f2, float f3, float f4, float f5) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.getStroke(f2));
            graphics2D.draw(new Line2D.Float(f3, f5 + this.shift, f4, f5 + this.shift));
            graphics2D.setStroke(stroke);
        }

        float getLowerDrawLimit(float f2) {
            return this.shift + this.getLineThickness(f2);
        }

        Shape getUnderlineShape(float f2, float f3, float f4, float f5) {
            Stroke stroke = this.getStroke(f2);
            Line2D.Float float_ = new Line2D.Float(f3, f5 + this.shift, f4, f5 + this.shift);
            return stroke.createStrokedShape(float_);
        }
    }
}

