/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Composite;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java2d.AnimatingSurface;

public class ACrules
extends AnimatingSurface {
    private static String[] compNames = new String[]{"Src", "SrcOver", "SrcIn", "SrcOut", "SrcAtop", "Clear", "Dst", "DstOver", "DstIn", "DstOut", "DstAtop", "Xor"};
    private static AlphaComposite[] compObjs = new AlphaComposite[]{AlphaComposite.Src, AlphaComposite.SrcOver, AlphaComposite.SrcIn, AlphaComposite.SrcOut, AlphaComposite.SrcAtop, AlphaComposite.Clear, AlphaComposite.Dst, AlphaComposite.DstOver, AlphaComposite.DstIn, AlphaComposite.DstOut, AlphaComposite.DstAtop, AlphaComposite.Xor};
    private static int NUM_RULES = compObjs.length;
    private static int HALF_NUM_RULES = NUM_RULES / 2;
    private int fadeIndex;
    private static float[][] fadeValues = new float[][]{{1.0f, -0.1f, 0.0f, 1.0f, 0.0f, 1.0f}, {0.0f, 0.1f, 1.0f, 1.0f, -0.1f, 0.0f}, {1.0f, 0.0f, 1.0f, 0.0f, 0.1f, 1.0f}};
    private static String[] fadeNames = new String[]{"Src => transparent, Dest opaque", "Src => opaque, Dest => transparent", "Src opaque, Dest => opaque"};
    private static Font f = new Font("serif", 0, 10);
    private float srca;
    private float dsta;
    private String fadeLabel;
    private BufferedImage statBI;
    private BufferedImage animBI;
    private int PADLEFT;
    private int PADRIGHT;
    private int HPAD;
    private int PADABOVE;
    private int PADBELOW;
    private int VPAD;
    private int RECTWIDTH;
    private int RECTHEIGHT;
    private int PADDEDWIDTH;
    private int PADDEDHEIGHT;
    private GeneralPath srcpath;
    private GeneralPath dstpath;
    private LineMetrics lm;
    private BufferedImage dBI;
    private BufferedImage sBI;
    private GradientPaint gradientDst;
    private GradientPaint gradientSrc;

    public ACrules() {
        this.srca = fadeValues[this.fadeIndex][0];
        this.dsta = fadeValues[this.fadeIndex][3];
        this.fadeLabel = fadeNames[0];
        this.srcpath = new GeneralPath();
        this.dstpath = new GeneralPath();
        this.setBackground(Color.white);
    }

    public void reset(int n, int n2) {
        this.setSleepAmount(400L);
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        this.lm = f.getLineMetrics(compNames[0], fontRenderContext);
        this.PADLEFT = n < 150 ? 10 : 15;
        this.PADRIGHT = n < 150 ? 10 : 15;
        this.HPAD = this.PADLEFT + this.PADRIGHT;
        this.PADBELOW = n2 < 250 ? 1 : 2;
        this.PADABOVE = this.PADBELOW + (int)this.lm.getHeight();
        this.VPAD = this.PADABOVE + this.PADBELOW;
        this.RECTWIDTH = n / 4 - this.HPAD;
        this.RECTWIDTH = this.RECTWIDTH < 6 ? 6 : this.RECTWIDTH;
        this.RECTHEIGHT = (n2 - this.VPAD) / HALF_NUM_RULES - this.VPAD;
        this.RECTHEIGHT = this.RECTHEIGHT < 6 ? 6 : this.RECTHEIGHT;
        this.PADDEDWIDTH = this.RECTWIDTH + this.HPAD;
        this.PADDEDHEIGHT = this.RECTHEIGHT + this.VPAD;
        this.srcpath.reset();
        this.srcpath.moveTo(0.0f, 0.0f);
        this.srcpath.lineTo(this.RECTWIDTH, 0.0f);
        this.srcpath.lineTo(0.0f, this.RECTHEIGHT);
        this.srcpath.closePath();
        this.dstpath.reset();
        this.dstpath.moveTo(0.0f, 0.0f);
        this.dstpath.lineTo(this.RECTWIDTH, this.RECTHEIGHT);
        this.dstpath.lineTo(this.RECTWIDTH, 0.0f);
        this.dstpath.closePath();
        this.dBI = new BufferedImage(this.RECTWIDTH, this.RECTHEIGHT, 2);
        this.sBI = new BufferedImage(this.RECTWIDTH, this.RECTHEIGHT, 2);
        this.gradientDst = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 0.0f, 0.0f, 1.0f), 0.0f, this.RECTHEIGHT, new Color(1.0f, 0.0f, 0.0f, 0.0f));
        this.gradientSrc = new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 1.0f, 1.0f), this.RECTWIDTH, 0.0f, new Color(0.0f, 0.0f, 1.0f, 0.0f));
        this.statBI = new BufferedImage(n / 2, n2, 1);
        this.statBI = this.drawCompBI(this.statBI, true);
        this.animBI = new BufferedImage(n / 2, n2, 1);
    }

    public void step(int n, int n2) {
        if (this.getSleepAmount() == 5000L) {
            this.setSleepAmount(200L);
        }
        this.srca += fadeValues[this.fadeIndex][1];
        this.dsta += fadeValues[this.fadeIndex][4];
        this.fadeLabel = fadeNames[this.fadeIndex];
        if (this.srca < 0.0f || (double)this.srca > 1.0 || this.dsta < 0.0f || (double)this.dsta > 1.0) {
            this.setSleepAmount(5000L);
            this.srca = fadeValues[this.fadeIndex][2];
            this.dsta = fadeValues[this.fadeIndex][5];
            if (this.fadeIndex++ == fadeValues.length - 1) {
                this.fadeIndex = 0;
            }
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        if (this.statBI == null || this.animBI == null) {
            return;
        }
        graphics2D.drawImage((Image)this.statBI, 0, 0, null);
        graphics2D.drawImage((Image)this.drawCompBI(this.animBI, false), n / 2, 0, null);
        graphics2D.setColor(Color.black);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout("AC Rules", graphics2D.getFont(), fontRenderContext);
        textLayout.draw(graphics2D, 15.0f, (float)textLayout.getBounds().getHeight() + 3.0f);
        textLayout = new TextLayout(this.fadeLabel, f, fontRenderContext);
        float f = (float)((double)n * 0.75 - textLayout.getBounds().getWidth() / 2.0);
        if ((double)f + textLayout.getBounds().getWidth() > (double)n) {
            f = (float)((double)n - textLayout.getBounds().getWidth());
        }
        textLayout.draw(graphics2D, f, (float)textLayout.getBounds().getHeight() + 3.0f);
    }

    private BufferedImage drawCompBI(BufferedImage bufferedImage, boolean bl) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.AntiAlias);
        graphics2D.setFont(f);
        Graphics2D graphics2D2 = this.dBI.createGraphics();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.AntiAlias);
        Graphics2D graphics2D3 = this.sBI.createGraphics();
        graphics2D3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.AntiAlias);
        int n = 0;
        int n2 = 0;
        int n3 = (int)this.lm.getHeight() + this.VPAD;
        for (int i = 0; i < compNames.length; ++i) {
            n2 = i == 0 || i == HALF_NUM_RULES ? n3 : n2 + this.PADDEDHEIGHT;
            n = i >= HALF_NUM_RULES ? bufferedImage.getWidth() / 2 + this.PADLEFT : this.PADLEFT;
            graphics2D.translate(n, n2);
            graphics2D2.setComposite(AlphaComposite.Clear);
            graphics2D2.fillRect(0, 0, this.RECTWIDTH, this.RECTHEIGHT);
            graphics2D2.setComposite(AlphaComposite.Src);
            if (bl) {
                graphics2D2.setPaint(this.gradientDst);
                graphics2D2.fillRect(0, 0, this.RECTWIDTH, this.RECTHEIGHT);
            } else {
                graphics2D2.setPaint(new Color(1.0f, 0.0f, 0.0f, this.dsta));
                graphics2D2.fill(this.dstpath);
            }
            graphics2D3.setComposite(AlphaComposite.Clear);
            graphics2D3.fillRect(0, 0, this.RECTWIDTH, this.RECTHEIGHT);
            graphics2D3.setComposite(AlphaComposite.Src);
            if (bl) {
                graphics2D3.setPaint(this.gradientSrc);
                graphics2D3.fillRect(0, 0, this.RECTWIDTH, this.RECTHEIGHT);
            } else {
                graphics2D3.setPaint(new Color(0.0f, 0.0f, 1.0f, this.srca));
                graphics2D3.fill(this.srcpath);
            }
            graphics2D2.setComposite(compObjs[i]);
            graphics2D2.drawImage((Image)this.sBI, 0, 0, null);
            graphics2D.drawImage((Image)this.dBI, 0, 0, null);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(compNames[i], 0.0f, -this.lm.getDescent());
            graphics2D.drawRect(0, 0, this.RECTWIDTH, this.RECTHEIGHT);
            graphics2D.translate(-n, -n2);
        }
        graphics2D2.dispose();
        graphics2D3.dispose();
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void main(String[] stringArray) {
        ACrules.createDemoFrame(new ACrules());
    }
}

