/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class ExportControl {
    private static final Debug debug = Debug.getInstance("ssl");
    private static final HashSet EXPORT_CS = new HashSet<String>(Arrays.asList("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DH_ANON_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_ANON_EXPORT_WITH_RC4_40_MD5", "SSL_DH_ANON_WITH_3DES_EDE_CBC_SHA", "SSL_DH_ANON_WITH_DES_CBC_SHA", "SSL_DH_ANON_WITH_RC4_128_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DH_ANON_WITH_AES_128_CBC_SHA", "TLS_DH_ANON_WITH_AES_256_CBC_SHA", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", "TLS_KRB5_EXPORT_WITH_RC4_40_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "TLS_KRB5_WITH_3DES_EDE_CBC_MD5", "TLS_KRB5_WITH_3DES_EDE_CBC_SHA", "TLS_KRB5_WITH_DES_CBC_MD5", "TLS_KRB5_WITH_DES_CBC_SHA", "TLS_KRB5_WITH_RC4_128_MD5", "TLS_KRB5_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_AES_256_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_AES_256_CBC_SHA", "SSL_DH_ANON_WITH_AES_128_CBC_SHA", "SSL_DH_ANON_WITH_AES_256_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_DES_CBC_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_AES_256_CBC_SHA", "SSL_DH_ANON_WITH_RC4_MD5", "SSL_DH_DSS_EXPORT_WITH_DES_40_CBC_SHA", "SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_DH_DSS_WITH_AES_128_CBC_SHA", "TLS_DH_DSS_WITH_AES_256_CBC_SHA", "SSL_DH_DSS_WITH_DES_CBC_SHA", "SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_RSA_WITH_AES_128_CBC_SHA", "TLS_DH_RSA_WITH_AES_256_CBC_SHA", "SSL_DH_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_MD5", "SSL_RSA_WITH_DES_CBC_MD5", "SSL_RSA_WITH_RC2_CBC_MD5", "SSL_DH_RSA_EXPORT_WITH_DES_40_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES_40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_40_CBC_MD5", "SSL_DHE_DSS_EXPORT_WITH_DES_40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES_40_CBC_SHA", "SSL_DH_ANON_EXPORT_WITH_DES_40_CBC_SHA", "SSL_RSA_WITH_RC4_MD5", "SSL_RSA_WITH_RC4_SHA", "SSL_CK_RC4_128_WITH_MD5", "SSL_CK_RC4_128_EXPORT40_WITH_MD5", "SSL_CK_RC2_128_CBC_WITH_MD5", "SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5", "SSL_CK_IDEA_128_CBC_WITH_MD5", "SSL_CK_DES_64_CBC_WITH_MD5", "SSL_CK_DES_192_EDE3_CBC_WITH_MD5"));
    private static Hashtable checkedCSList = new Hashtable(5);

    private static void log(String string) {
        if (debug != null && Debug.isOn("pluggability")) {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean passExportCheck(String[] stringArray) {
        boolean bl = true;
        ExportControl.log("export control - checking the cipher suites");
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        List<String> list = Arrays.asList(stringArray);
        Boolean bl2 = (Boolean)checkedCSList.get(list);
        if (bl2 == null) {
            ExportControl.log("export control - no cached value available...");
            for (int i = 0; i < stringArray.length; ++i) {
                if (EXPORT_CS.contains(stringArray[i].toUpperCase())) continue;
                ExportControl.log("export control - illegal CS " + stringArray[i]);
                bl = false;
            }
            Class<ExportControl> clazz = ExportControl.class;
            synchronized (ExportControl.class) {
                checkedCSList.put(list, bl ? Boolean.TRUE : Boolean.FALSE);
                // ** MonitorExit[var4_5] (shouldn't be in output)
                ExportControl.log("export control - storing " + (bl ? "" : "il") + "legal entry into cache...");
            }
        } else {
            bl = bl2;
            ExportControl.log("export control - found " + (bl ? "" : "il") + "legal entry in cache...");
        }
        return bl;
    }

    public static final void checkCipherSuites(SSLSocketFactory sSLSocketFactory) {
        if (!ExportControl.passExportCheck(sSLSocketFactory.getSupportedCipherSuites())) {
            throw new RuntimeException("Export restriction: SSLSocketFactory supports non-pluggable ciphersuite(s)");
        }
    }

    public static final void checkCipherSuites(SSLServerSocketFactory sSLServerSocketFactory) {
        if (!ExportControl.passExportCheck(sSLServerSocketFactory.getSupportedCipherSuites())) {
            throw new RuntimeException("Export restriction: SSLServerSocketFactory supports non-pluggable ciphersuite(s)");
        }
    }

    public static final void checkCipherSuites(SSLEngine sSLEngine) {
        if (!ExportControl.passExportCheck(sSLEngine.getSupportedCipherSuites())) {
            throw new RuntimeException("Export restriction: SSLEngine supports non-pluggable ciphersuite(s)");
        }
    }
}

