/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* gui_savedialog.c - creation and destruction of the davedialog 
 *
 * this dialog is shown when you exit xlog and one of the logs is not saved,
 * when you click OK, we exit xlog anyway.
 */
#include <gtk/gtk.h>

#include "support.h"
#include "utils.h"
#include "gui_savedialog.h"

extern GtkWidget *mainwindow;

/* ok clicked, changed log not saved */
static void
on_saveokbutton_clicked (GtkButton * button, gpointer user_data)
{
	save_windowsize_and_cleanup ();
	gtk_main_quit ();
}

static void
on_savecancelbutton_clicked (GtkButton * button, gpointer user_data)
{
	gtk_widget_destroy (gtk_widget_get_toplevel (GTK_WIDGET (button)));
	gtk_widget_set_sensitive (mainwindow, 1);
}

/* save dialog is deleted */
static gboolean
on_savedialog_delete_event (GtkWidget * widget, GdkEvent * event,
					gpointer user_data)
{
	gtk_widget_set_sensitive (mainwindow, 1);
	return FALSE;
}

GtkWidget*
create_savedialog (void)
{
	GtkWidget *savedialog;
	GdkPixbuf *savedialog_icon_pixbuf;
	GtkWidget *dialog_vbox3;
	GtkWidget *vbox43;
	GtkWidget *image50;
	GtkWidget *label2;
	GtkWidget *dialog_action_area3;
	GtkWidget *savecancelbutton;
	GtkWidget *saveokbutton;

	savedialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (savedialog), _("xlog - saving"));
	gtk_window_set_position (GTK_WINDOW (savedialog), GTK_WIN_POS_MOUSE);
	savedialog_icon_pixbuf = create_pixbuf ("xlog.png");
	if (savedialog_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (savedialog), savedialog_icon_pixbuf);
			g_object_unref (savedialog_icon_pixbuf);
		}

	dialog_vbox3 = GTK_DIALOG (savedialog)->vbox;
	gtk_widget_show (dialog_vbox3);

	vbox43 = gtk_vbox_new (TRUE, 0);
	gtk_widget_show (vbox43);
	gtk_box_pack_start (GTK_BOX (dialog_vbox3), vbox43, FALSE, FALSE, 0);

	image50 = gtk_image_new_from_stock ("gtk-dialog-question", GTK_ICON_SIZE_DIALOG);
	gtk_widget_show (image50);
	gtk_box_pack_start (GTK_BOX (vbox43), image50, TRUE, TRUE, 0);

	label2 = gtk_label_new (_("One of your logs has not been saved, do you want to quit anyway?"));
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox43), label2, TRUE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label2), TRUE);
	gtk_misc_set_padding (GTK_MISC (label2), 10, 10);

	dialog_action_area3 = GTK_DIALOG (savedialog)->action_area;
	gtk_widget_show (dialog_action_area3);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area3), GTK_BUTTONBOX_SPREAD);

	savecancelbutton = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_show (savecancelbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (savedialog), savecancelbutton, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS (savecancelbutton, GTK_CAN_DEFAULT);

	saveokbutton = gtk_button_new_from_stock ("gtk-quit");
	gtk_widget_show (saveokbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (savedialog), saveokbutton, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (saveokbutton, GTK_CAN_DEFAULT);

	g_signal_connect ((gpointer) savedialog, "delete_event",
										G_CALLBACK (on_savedialog_delete_event),
										NULL);
	g_signal_connect ((gpointer) savecancelbutton, "clicked",
										G_CALLBACK (on_savecancelbutton_clicked),
										NULL);
	g_signal_connect ((gpointer) saveokbutton, "clicked",
										G_CALLBACK (on_saveokbutton_clicked),
										NULL);

	return savedialog;
}

