/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gui_setupdialog.c - creation and destruction if the setupdialog
 *
 * when xlog is started for the very first time we display a message where 
 * the logs are saved.
 */

#include <gtk/gtk.h>

#include "gui_setupdialog.h"
#include "support.h"
#include "types.h"

extern GtkWidget *mainwindow;
extern preferencestype preferences;
extern gchar *xlogdir;

void show_setupdialog (void)
{
	GtkWidget *setupdialog, *dialog_vbox, *setuplabel, *dialog_action_area,
		*setupbutton;
	GdkPixbuf *setupdialog_icon_pixbuf;
	gint response;
	gchar *labeltext;

	setupdialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (setupdialog), _("xlog - setup"));
	gtk_window_set_position (GTK_WINDOW (setupdialog), GTK_WIN_POS_MOUSE);
	setupdialog_icon_pixbuf = create_pixbuf ("xlog.png");
	if (setupdialog_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (setupdialog), setupdialog_icon_pixbuf);
			g_object_unref (setupdialog_icon_pixbuf);
		}

	dialog_vbox = GTK_DIALOG (setupdialog)->vbox;
	gtk_widget_show (dialog_vbox);

	labeltext = g_strdup_printf (_("Xlog has created %s, "
					"this is the directory where your log will be saved. "
					"You can change the default path for your logs "
					"in the preferences dialog."), xlogdir);
	setuplabel = gtk_label_new (labeltext);
	g_free (labeltext);
	gtk_widget_show (setuplabel);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), setuplabel, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (setuplabel), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (setuplabel), TRUE);
	gtk_misc_set_padding (GTK_MISC (setuplabel), 10, 10);

	dialog_action_area = GTK_DIALOG (setupdialog)->action_area;
	gtk_widget_show (dialog_action_area);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_SPREAD);

	setupbutton = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (setupbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (setupdialog), setupbutton, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (setupbutton, GTK_CAN_DEFAULT);

	response = gtk_dialog_run (GTK_DIALOG(setupdialog));
 	gtk_widget_destroy (setupdialog);
}
