/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * types.h - structs and defines used in the program
 */

#ifndef _TYPES_H
#define _TYPES_H 1

/* preferences saved to ~/.xlog/preferences */
typedef struct
{
	gint x;
	gint y;
	gint width;
	gint height;
	gdouble latitude;
	gint NS;
	gdouble longitude;
	gint EW;
	gint units;			/* kilometers or nautical miles */
	gchar *modes;
	gchar *bands;
	gint bandseditbox;		/* optionmenu or entry for bands? */
	gint modeseditbox;		/* optionmenu or entry modes? */
	gint bandoptionmenu;	/* position of optionmenu */
	gint modeoptionmenu;	/* position of optionmenu */
	gint printall;								/* 0 = all, 1 = range */
	gint printsize;							 /* A4 or letter */
	gint printpoint;							/* pointsize (10, 11, 12) */
	gint printorientation;				/* 0 = portrait, 1 = landscape */
	gint printdestination;				/* 0 = printer, 1 = file */
	gint hamlib;			/* hamlib enabled? 0 = no, 1 = yes, 2 = display freq on statusbar */
	gchar *radio;			/* what type of radio do you use? */
	gchar *device;		/* which serial port does it use? */
	gchar *rigconf;	 /* string for rig_set_conf */
	gint round;			/* how many digits to round to */
	gint polltime;	/* poll every 'polltime' milliseconds, 0 = no polling */
	gint clock;			/* clock on the statusbar? */
	gchar *themecolor;
	gchar *themefont;
	gint logcolor;		/* do we want to color the log? */
	gint autosave;
	gchar *savedir;
	gint saving;									/* 1= autosave, 2=save with click on toolbar */
	gchar *logstoload;
	gchar *locator;
	gchar *freefield1;
	gchar *freefield2;
	gchar *callsign;
	gchar *defaultmhz;
	gchar *defaultmode;
	gchar *defaulttxrst;
	gchar *defaultrxrst;
	gchar *defaultpower;
	gchar *defaultfreefield1;
	gchar *defaultfreefield2;
	gchar *defaultremarks;
	gchar *b4columns;
	gint typeaheadfind;					 /* do we want type ahead find */
	gint remoteadding;						/* add remote data to log or qso frame */
	gint viewtoolbar;
	gint viewb4;
	gint b4x;
	gint b4y;
	gint b4width;
	gint b4height;
}
preferencestype;

/* structure used for program state */
typedef struct
{
	gchar *mylocation;		/* latitude and longitude */
	gint countries;		/* number of countries loaded */
	gint qsos;			/* number of qso's read from the logs */
	gboolean controlkey;		/* control key is pressed */
	long long rigfrequency;	/* frequency read from the rig */
	guint rigmode;		/* mode read from the rig */
	gchar *rigrst;		/* signal strength read from rig */
	gint rigpower;		/* rf power */
	gint scounter;		/* counter for s-levels stored in array */
	gint hlcounter;		/* counter for hamlib */
	gboolean tx;			/* transmitting or receiving */
	gboolean statustimer;		/* 'ready' timer for the statusbar */
	gint shmid;			/* id for shared memory */
	gint logwindows;		/* number of logwindows */
	gchar *searchstr;		/* array with logs/qsos seached */
	gint dupecheck;		/* dupe check this log or all logs */
	gboolean notdupecheckmode;	/* exclude bands from dupecheck */
	gboolean notdupecheckband;	/* exclude modes from dupecheck */
	gboolean utf8error;		/* error in utf-8 conversion when reading the log*/
}
statetype;

/* struct for remote data state */
typedef struct
{
	gint version;
	gchar *program;
	gint nr;
}
remotetype;

/* struct for the message queue */
typedef struct
{
	glong mtype;
	gchar mtext[1024];
}
msgtype;

/* struct for dxcc information from cty.dat */
typedef struct
{
	gchar *countryname;
	gint waz;
	gint itu;
	gchar *continent;
	gint latitude;
	gint longitude;
	gint timezone;
	gchar *px;
	gchar *exceptions;
}
dxcc_data;


#define QSO_FIELDS 18
/* fields for the qso array */
#define NR	0
#define DATE	1
#define GMT	2
#define GMTEND	3
#define CALL	4
#define BAND	5
#define MODE	6
#define RST	7
#define MYRST	8
#define QSLOUT	9
#define QSLIN	10
#define POWER	11
#define NAME	12
#define QTH	13
#define LOCATOR	14
#define U1	15
#define U2	16
#define REMARKS	17

#endif /* _TYPES_H */
