
  

#ifndef KJSEMBED_QCanvasText_H
#define KJSEMBED_QCanvasText_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class QCanvasText;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for QCanvasText methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class QCanvasTextImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvasText_1,
       Constructor_QCanvasText_2,
       Constructor_QCanvasText_3,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_setText_5,
       Method_setFont_6,
       Method_setColor_7,
       Method_text_8,
       Method_font_9,
       Method_color_10,
       Method_moveBy_11,
       Method_textFlags_12,
       Method_setTextFlags_13,
       Method_boundingRect_14,
       Method_collidesWith_15,
       Method_rtti_16,
       Method_Last = -1
   };

   QCanvasTextImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~QCanvasTextImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static QCanvasText *toQCanvasText( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object QCanvasText_1( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object QCanvasText_2( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object QCanvasText_3( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value setText_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setFont_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setColor_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value text_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value font_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value color_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value moveBy_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value textFlags_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setTextFlags_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value boundingRect_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value collidesWith_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value rtti_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   QCanvasText *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasText_H

// Local Variables:
// c-basic-offset: 4
// End:


