/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.engine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.engine.ConvertFile;
import sun.plugin.converter.engine.ConvertSet;
import sun.plugin.converter.engine.Converter;
import sun.plugin.converter.engine.ConverterProgressEvent;
import sun.plugin.converter.engine.ConverterProgressListener;
import sun.plugin.converter.engine.DefaultSet;
import sun.plugin.converter.util.FlexFilter;
import sun.plugin.converter.util.NotDirectoryException;
import sun.plugin.converter.util.PrintManyPlaces;
import sun.plugin.converter.util.StdUtils;

public class PluginConverter
implements Converter,
Runnable {
    private String templateFilePath = null;
    private static String defaultTemplateFileName = "templates/default.tpl";
    private File logFile = null;
    private boolean createLog = false;
    private boolean processSubDirs = false;
    private boolean stopConversion = false;
    private static ConverterProgressEvent event = null;
    private int majorVersion = 0;
    private int minorVersion = 0;
    private int microVersion = 0;
    private int updateVersion = 0;
    private int updateCabVersion = 0;
    private int updateStringLen = 0;
    private int buildNumber = 0;
    private char updateAlphaVersion = (char)97;
    private String updateString = null;
    private String version = null;
    private String nodotVersion = null;
    private String cabVersion = null;
    private String urlString = null;
    private String cabFileLocation = null;
    private String nsFileLocation = null;
    private String smartUpdateLocation = null;
    private String mimeType = null;
    private String classId = null;
    private String defaultCabFileLocation = null;
    private String defaultNsFileLocation = null;
    private String defaultSmartUpdateLocation = null;
    private String defaultMimeType = null;
    private String defaultClassId = null;
    private String genericClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private String userPropsFileName = "converter.props";
    private String defaultLogFileName = "convertlog.txt";
    private String caption = null;
    private boolean commandLineInvocation = false;
    private boolean staticVersioning = false;
    private boolean outdated = false;
    private static final String propFileHeader = "#  Java Plug-in HTML Converter Properties";
    private ConvertSet convertSet = null;
    private boolean showProgressStdOut = true;
    private PrintManyPlaces printer = null;
    private boolean forceOverwrite = false;
    private OutputStream log = null;
    private PrintStream progress = null;
    private boolean debug = false;
    private Vector listeners = new Vector();
    private Thread runConvert = null;
    private boolean stdin = false;
    private boolean stdout = false;
    private Properties p = null;
    private String versionState = null;

    public PluginConverter() throws FileNotFoundException {
        this(false, false);
    }

    public PluginConverter(boolean bl, boolean bl2) throws FileNotFoundException {
        this.setVersion(System.getProperty("java.version"));
        this.setBuildNumber(System.getProperty("java.runtime.version"));
        this.setValues();
        this.setCreateLog(bl);
        this.setShowProgressStdOut(bl2);
        try {
            this.setTemplateFilePath(this.getDefaultTemplateFilePath());
            if (this.createLog) {
                this.setLogFile(this.getDefaultLogFile());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw fileNotFoundException;
        }
        this.caption = ResourceHandler.getMessage("caption.warning");
        this.setStaticVersioning(this.staticVersioning);
    }

    private void setVersion(String string) {
        int n = string.indexOf("-");
        this.version = n < 0 ? string : string.substring(0, n);
        StringTokenizer stringTokenizer = new StringTokenizer(this.version, "._");
        if (stringTokenizer.hasMoreTokens()) {
            this.majorVersion = new Integer(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.minorVersion = new Integer(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.microVersion = new Integer(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.updateString = stringTokenizer.nextToken();
            this.updateStringLen = this.updateString.length();
            if (this.updateStringLen <= 2) {
                this.updateVersion = new Integer(this.updateString);
                this.updateCabVersion = this.updateVersion * 10;
            } else {
                this.updateVersion = new Integer(this.updateString.substring(0, 2));
                this.updateAlphaVersion = this.updateString.charAt(this.updateStringLen - 1);
                int n2 = Character.getNumericValue(this.updateAlphaVersion) - Character.getNumericValue('a') + 1;
                this.updateCabVersion = this.updateVersion * 10 + n2;
            }
        }
    }

    private void setBuildNumber(String string) {
        String string2 = null;
        int n = string.lastIndexOf("b");
        string2 = n != -1 && string.length() > n + 1 ? string.substring(n) : "b00";
        try {
            this.buildNumber = Integer.parseInt(string2.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            this.buildNumber = 0;
        }
    }

    private void setValues() {
        int n;
        this.nodotVersion = this.majorVersion + "_" + this.minorVersion;
        this.cabVersion = this.minorVersion + "," + this.microVersion + ",";
        if (this.isStaticVersioning()) {
            this.nodotVersion = this.nodotVersion + "_" + this.microVersion;
            this.cabVersion = this.cabVersion + this.updateCabVersion + "," + this.buildNumber;
            if (this.updateVersion > 0) {
                this.nodotVersion = this.nodotVersion + "_" + this.updateString;
            }
            this.versionState = "static";
        } else {
            this.cabVersion = this.cabVersion + "0," + this.buildNumber;
            this.versionState = "dynamic";
        }
        this.urlString = this.majorVersion > 1 || this.minorVersion > 4 || this.minorVersion >= 4 && this.microVersion >= 2 ? "http://java.sun.com/update/" + this.majorVersion + "." + this.minorVersion + "." + this.microVersion : "http://java.sun.com/products/plugin/autodl";
        if (this.majorVersion > 1 || this.minorVersion >= 6) {
            this.defaultCabFileLocation = this.urlString + "/jinstall-" + this.minorVersion;
            if (this.updateVersion > 0) {
                this.defaultCabFileLocation = this.defaultCabFileLocation + "u" + this.updateCabVersion;
            }
            this.defaultCabFileLocation = this.defaultCabFileLocation + "-windows-i586.cab#Version=" + this.cabVersion;
        } else {
            this.defaultCabFileLocation = this.majorVersion > 1 || this.minorVersion > 4 || this.minorVersion >= 4 && this.microVersion >= 1 ? this.urlString + "/jinstall-" + this.nodotVersion + "-windows-i586.cab#Version=" + this.cabVersion : this.urlString + "/jinstall-" + this.nodotVersion + "-win.cab#Version=" + this.cabVersion;
        }
        this.defaultNsFileLocation = "http://java.sun.com/products/plugin/index.html#download";
        this.defaultSmartUpdateLocation = this.majorVersion > 1 || this.minorVersion > 4 || this.minorVersion >= 4 && this.microVersion >= 1 ? this.urlString + "/jre-" + this.nodotVersion + "-windows-i586.jar" : this.urlString + "/jre-" + this.nodotVersion + "-win.jar";
        this.defaultMimeType = this.isStaticVersioning() ? "application/x-java-applet;jpi-version=" + this.version : "application/x-java-applet;version=" + this.version;
        this.defaultClassId = "clsid:CAFEEFAC-";
        for (n = 0; n < 4 - ("" + this.majorVersion + this.minorVersion).length(); ++n) {
            this.defaultClassId = this.defaultClassId + "0";
        }
        this.defaultClassId = this.defaultClassId + "" + this.majorVersion + this.minorVersion;
        this.defaultClassId = this.defaultClassId + "-";
        for (n = 0; n < 4 - ("" + this.microVersion).length(); ++n) {
            this.defaultClassId = this.defaultClassId + "0";
        }
        this.defaultClassId = this.defaultClassId + this.microVersion;
        this.defaultClassId = this.defaultClassId + "-";
        for (n = 0; n < 4 - ("" + this.updateVersion).length(); ++n) {
            this.defaultClassId = this.defaultClassId + "0";
        }
        this.defaultClassId = this.defaultClassId + this.updateVersion;
        if (this.updateStringLen <= 2) {
            this.defaultClassId = this.defaultClassId + "-ABCDEFFEDCBA";
        } else {
            if (Character.isLowerCase(this.updateAlphaVersion)) {
                this.updateAlphaVersion = Character.toUpperCase(this.updateAlphaVersion);
            }
            this.updateAlphaVersion = (char)(this.updateAlphaVersion + '\u0001');
            String string = String.valueOf(this.updateAlphaVersion);
            this.defaultClassId = this.defaultClassId + "-" + string + "BCDEFFEDCBA";
        }
        this.cabFileLocation = this.defaultCabFileLocation;
        this.nsFileLocation = this.defaultNsFileLocation;
        this.smartUpdateLocation = this.defaultSmartUpdateLocation;
        this.mimeType = this.defaultMimeType;
        if (this.version.equals("1.3.0")) {
            this.defaultClassId = this.genericClassId;
        }
        this.classId = this.defaultClassId;
        if (this.p == null) {
            File file = new File(this.userPropsFileName);
            if (file.exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.p = new Properties();
                    this.p.load(fileInputStream);
                    fileInputStream.close();
                    this.versionState = this.p.getProperty("last.converter.state", this.versionState);
                    this.staticVersioning = this.versionState.compareTo("static") == 0;
                    this.cabFileLocation = this.p.getProperty(this.versionState + ".converter.cab.file.loc", this.cabFileLocation);
                    this.nsFileLocation = this.p.getProperty(this.versionState + ".converter.plugin.file.loc", this.nsFileLocation);
                    this.smartUpdateLocation = this.p.getProperty(this.versionState + ".converter.smartupdate.file.loc", this.smartUpdateLocation);
                    this.mimeType = this.p.getProperty(this.versionState + ".converter.template.mimetype", this.mimeType);
                    this.classId = this.p.getProperty(this.versionState + ".converter.classid", this.classId);
                }
                catch (Exception exception) {}
            } else {
                this.p = new Properties();
            }
        }
    }

    public void persistConverterSetting() {
        if (!this.outdated) {
            return;
        }
        this.p.put("last.converter.state", this.versionState);
        if (this.nsFileLocation != null) {
            this.p.put(this.versionState + ".converter.plugin.file.loc", this.p.getProperty(this.versionState + ".converter.plugin.file.loc", this.nsFileLocation));
        }
        if (this.cabFileLocation != null) {
            this.p.put(this.versionState + ".converter.cab.file.loc", this.p.getProperty(this.versionState + ".converter.cab.file.loc", this.cabFileLocation));
        }
        if (this.smartUpdateLocation != null) {
            this.p.put(this.versionState + ".converter.smartupdate.file.loc", this.p.getProperty(this.versionState + ".converter.smartupdate.file.loc", this.smartUpdateLocation));
        }
        if (this.mimeType != null) {
            this.p.put(this.versionState + ".converter.template.mimetype", this.p.getProperty(this.versionState + ".converter.template.mimetype", this.mimeType));
        }
        if (this.classId != null) {
            this.p.put(this.versionState + ".converter.classid", this.p.getProperty(this.versionState + ".converter.classid", this.classId));
        }
        File file = null;
        try {
            file = new File(this.userPropsFileName);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.p.store(fileOutputStream, propFileHeader);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(ResourceHandler.getMessage("plugin_converter.saveerror"));
        }
    }

    public void setConvertSet(ConvertSet convertSet) {
        this.convertSet = convertSet;
    }

    public ConvertSet getConvertSet() {
        return this.convertSet;
    }

    public void setShowProgressStdOut(boolean bl) {
        if (this.showProgressStdOut != bl) {
            this.showProgressStdOut = bl;
        }
    }

    public boolean isShowProgressStdOut() {
        return this.showProgressStdOut;
    }

    public void setCommandLine(boolean bl) {
        this.commandLineInvocation = bl;
    }

    public boolean getCommandLine() {
        return this.commandLineInvocation;
    }

    public void addConverterProgressListener(ConverterProgressListener converterProgressListener) {
        this.listeners.addElement(converterProgressListener);
    }

    public void removedConverterProgressListener(ConverterProgressListener converterProgressListener) {
        this.listeners.removeElement(converterProgressListener);
    }

    public void fireEvent(ConverterProgressEvent converterProgressEvent) {
        Vector vector = (Vector)this.listeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ConverterProgressListener converterProgressListener = (ConverterProgressListener)vector.elementAt(i);
            converterProgressListener.converterProgressUpdate(converterProgressEvent);
        }
    }

    public void startConversion() {
        if (this.debug) {
            System.out.println("Debug is on");
        }
        if (this.runConvert == null) {
            this.runConvert = new Thread(this);
            this.runConvert.start();
        }
    }

    public void stopConversion() {
        if (this.runConvert != null && this.runConvert.isAlive()) {
            this.stopConversion = true;
            if (this.progress != null) {
                this.progress.println(ResourceHandler.getMessage("plugin_converter.cancel"));
            }
        }
        this.runConvert = null;
    }

    public void run() {
        try {
            this.setPrintOutput();
        }
        catch (IOException iOException) {
            System.out.println(ResourceHandler.getMessage("plugin_converter.logerror"));
        }
        Date date = new Date();
        if (this.progress != null) {
            this.progress.println(ResourceHandler.getMessage("plugin_converter.appletconv") + DateFormat.getDateInstance(1).format(date) + " " + DateFormat.getTimeInstance(1).format(date));
        }
        event = new ConverterProgressEvent(this);
        this.stopConversion = false;
        try {
            this.runConversion(this.convertSet);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        event.setStatus(-14);
        this.fireEvent(event);
        if (this.progress != null) {
            this.progress.println(ResourceHandler.getMessage("plugin_converter.done") + event.getFilesProcessed() + ResourceHandler.getMessage("plugin_converter.appletfound") + event.getAppletsFound());
        }
    }

    private void runConversion(ConvertSet convertSet) throws IOException {
        File file = null;
        File file2 = null;
        String string = null;
        InputStream inputStream = null;
        Enumeration enumeration = convertSet.getFilesEnumeration();
        while (enumeration.hasMoreElements() && !this.stopConversion) {
            block35: {
                Object object;
                if (!this.stdout) {
                    file2 = new File(convertSet.getDestinationPath(), "temp.conv");
                }
                string = (String)enumeration.nextElement();
                file = new File(convertSet.getSourcePath(), string);
                if (file.isDirectory()) {
                    if (!this.processSubDirs) continue;
                    object = new DefaultSet();
                    boolean bl = ((FlexFilter)convertSet.getFilenameFilter()).isFilesOnly();
                    ((FlexFilter)((DefaultSet)object).getFilenameFilter()).setFilesOnly(bl);
                    try {
                        object.setSourcePath(file, convertSet.getFilenameFilter());
                    }
                    catch (NotDirectoryException notDirectoryException) {
                        notDirectoryException.printStackTrace();
                    }
                    object.setDestinationPath(new File(convertSet.getDestinationPath(), string));
                    object.setBackupPath(new File(convertSet.getBackupPath(), string));
                    this.runConversion((ConvertSet)object);
                    continue;
                }
                if (file.exists()) {
                    if (!file.canWrite()) {
                        if (!this.commandLineInvocation) {
                            JOptionPane.showMessageDialog(null, ResourceHandler.getMessage("file_unwritable.info") + file, this.caption, 0);
                        } else {
                            System.out.println(ResourceHandler.getMessage("file_unwritable.info") + file);
                        }
                        return;
                    }
                } else {
                    if (!this.commandLineInvocation) {
                        JOptionPane.showMessageDialog(null, ResourceHandler.getMessage("file_notexists.info") + file, this.caption, 0);
                    } else {
                        System.out.println(ResourceHandler.getMessage("file_notexists.info") + file);
                    }
                    return;
                }
                inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getTemplateFilePath());
                if (inputStream == null) {
                    object = new File(this.getTemplateFilePath());
                    inputStream = new FileInputStream((File)object);
                }
                object = new ConvertFile(inputStream);
                ((ConvertFile)object).setSource(file);
                ((ConvertFile)object).guessEncoding();
                if (StdUtils.countWords(file, "<APPLET", true, ((ConvertFile)object).getEncoding()) > 0) {
                    if (this.progress != null) {
                        this.progress.print(new File(convertSet.getSourcePath(), string) + ResourceHandler.getMessage("plugin_converter.processing"));
                    }
                    if (!this.stdin) {
                        event.setSourcePath(convertSet.getSourcePath().getAbsolutePath());
                    }
                    if (!this.stdout) {
                        event.setDestinationPath(convertSet.getDestinationPath().getAbsolutePath());
                    }
                    event.setBackupPath(convertSet.getBackupPath().getAbsolutePath());
                    if (!this.stdin) {
                        event.setCurrentFile(string);
                    }
                    event.setStatus(-11);
                    this.fireEvent(event);
                    ((ConvertFile)object).setSource(file);
                    if (!this.stdout) {
                        ((ConvertFile)object).setDestination(file2);
                    } else {
                        ((ConvertFile)object).setStandardOutput(this.stdout);
                    }
                    ((ConvertFile)object).setCabFileLocation(this.getCabFileLocation());
                    ((ConvertFile)object).setNSFileLocation(this.getNSFileLocation());
                    ((ConvertFile)object).setSmartUpdateLocation(this.getSmartUpdateLocation());
                    ((ConvertFile)object).setMimeType(this.getMimeType());
                    ((ConvertFile)object).setClassId(this.getClassId());
                    try {
                        boolean bl = ((ConvertFile)object).convert();
                        if (!bl) {
                            if (this.progress != null) {
                                this.progress.print(ResourceHandler.getMessage("plugin_converter.converted"));
                            }
                            file2.delete();
                        } else {
                            File file3;
                            File file4;
                            if (!StdUtils.createDirs(convertSet.getBackupPath())) {
                                if (this.progress != null) {
                                    this.progress.println(ResourceHandler.getMessage("plugin_converter.nobackuppath"));
                                }
                                event.setStatus(-15);
                                this.fireEvent(event);
                                if (!this.commandLineInvocation) {
                                    JOptionPane.showMessageDialog(null, ResourceHandler.getMessage("file_unwritable.info") + convertSet.getBackupPath().getAbsolutePath(), this.caption, 0);
                                } else {
                                    System.out.println(ResourceHandler.getMessage("file_unwritable.info") + convertSet.getBackupPath().getAbsolutePath());
                                }
                                return;
                            }
                            System.gc();
                            System.runFinalization();
                            if (!this.stdin && !this.updateFiles(file4 = new File(convertSet.getBackupPath().getAbsolutePath(), string), file3 = new File(file2.getParent() + File.separator + string), file2)) {
                                if (!this.commandLineInvocation) {
                                    JOptionPane.showMessageDialog(null, ResourceHandler.getMessage("plugin_converter.failure") + file2.getParent() + File.separator + string, this.caption, 0);
                                } else {
                                    System.out.println(ResourceHandler.getMessage("plugin_converter.failure") + file2.getParent() + File.separator + string);
                                }
                            }
                        }
                        event.setStatus(-13);
                        event.setFilesProcessed(event.getFilesProcessed() + 1);
                        event.setAppletsFound(event.getAppletsFound() + ((ConvertFile)object).getAppletsFound());
                        event.setErrorsFound(event.getErrorsFound() + ((ConvertFile)object).getErrors());
                        this.fireEvent(event);
                        if (this.progress != null) {
                            this.progress.println(ResourceHandler.getMessage("plugin_converter.donefound") + ((ConvertFile)object).getAppletsFound());
                        }
                        break block35;
                    }
                    catch (Exception exception) {
                        event.setStatus(-16);
                        event.setFilesProcessed(event.getFilesProcessed());
                        event.setAppletsFound(event.getAppletsFound() + ((ConvertFile)object).getAppletsFound());
                        event.setErrorsFound(event.getErrorsFound() + 1);
                        this.fireEvent(event);
                        if (this.progress != null) {
                            this.progress.println(ResourceHandler.getMessage("plugin_converter.seetrace"));
                            exception.printStackTrace(this.progress);
                        }
                        break block35;
                    }
                }
                if (this.progress != null) {
                    this.progress.println(ResourceHandler.getMessage("plugin_converter.noapplet") + file);
                }
            }
            if (!this.stdin || !file.exists()) continue;
            file.delete();
        }
    }

    public boolean updateFiles(File file, File file2, File file3) {
        return this.backupDirExists(file) && this.backupFileIsWritable(file, file2) && this.renameFileTo(file2, file) && this.renameFileTo(file3, file2);
    }

    public boolean backupDirExists(File file) {
        File file2 = new File(file.getParent());
        if (file2.exists()) {
            return true;
        }
        try {
            file2.mkdir();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return true;
    }

    public boolean renameFileTo(File file, File file2) {
        try {
            this.copy(file.getAbsolutePath(), file2.getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            file.delete();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String string, String string2) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        int n = -1;
        int n2 = (int)new File(string).length();
        byte[] byArray = new byte[n2];
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            bufferedInputStream.read(byArray, 0, n2);
            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            bufferedInputStream.close();
            filterOutputStream.close();
        }
    }

    public void setOverwrite(boolean bl) {
        this.forceOverwrite = bl;
    }

    public boolean backupFileIsWritable(File file, File file2) {
        if (file.exists()) {
            if (this.commandLineInvocation && !this.forceOverwrite) {
                System.out.println(ResourceHandler.getMessage("plugin_converter.overwrite1") + file2.getAbsolutePath());
            } else {
                if (this.commandLineInvocation && this.forceOverwrite) {
                    return true;
                }
                if (JOptionPane.showConfirmDialog(null, ResourceHandler.getMessage("plugin_converter.overwrite1") + file2.getAbsolutePath() + ResourceHandler.getMessage("plugin_converter.overwrite2"), this.caption, 0) == 0) {
                    file.delete();
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public static String getDefaultTemplateFileName() {
        return defaultTemplateFileName;
    }

    public void setTemplateFilePath(String string) throws FileNotFoundException {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            if (inputStream != null) {
                this.templateFilePath = string;
                return;
            }
            File file = new File(string);
            if (file.isFile()) {
                this.templateFilePath = string;
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        throw new FileNotFoundException(string);
    }

    public String getTemplateFilePath() {
        return this.templateFilePath;
    }

    public String getDefaultTemplateFilePath() throws FileNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            throw new FileNotFoundException(defaultTemplateFileName);
        }
        InputStream inputStream = classLoader.getResourceAsStream(defaultTemplateFileName);
        if (inputStream == null) {
            throw new FileNotFoundException(defaultTemplateFileName);
        }
        return defaultTemplateFileName;
    }

    public void setLogFile(File file) throws IllegalArgumentException {
        if (file.exists()) {
            if (this.progress != null) {
                this.progress.println(ResourceHandler.getMessage("plugin_converter.writelog"));
            }
        } else if (file.getParent() == null) {
            file = new File(System.getProperty("user.dir"), file.getName());
        } else {
            File file2 = new File(file.getParent());
            if (!file2.exists()) {
                file2.mkdirs();
            }
        }
        this.logFile = file;
    }

    public boolean isStaticVersioning() {
        return this.staticVersioning;
    }

    public void setStaticVersioning(boolean bl) {
        this.staticVersioning = bl;
        if (bl) {
            this.setVersion(System.getProperty("java.version"));
            this.setValues();
            String string = this.getMimeType();
            if (string.endsWith(".0")) {
                this.setMimeType(string.substring(0, string.length() - 2));
            }
            this.setClassId(this.defaultClassId);
        } else {
            this.setVersion(this.majorVersion + "." + this.minorVersion);
            this.setValues();
            int n = this.getMimeType().indexOf("jpi-");
            if (n >= 0) {
                this.setMimeType(this.getMimeType().substring(0, n) + this.getMimeType().substring(n + 4));
            }
            this.setClassId(this.genericClassId);
        }
    }

    public File getLogFile() {
        return this.logFile;
    }

    public File getDefaultLogFile() {
        return new File(System.getProperty("user.dir"), this.defaultLogFileName);
    }

    public void setPrintOutput() throws IOException {
        if (this.printer != null) {
            this.printer.closeAll();
        }
        this.printer = new PrintManyPlaces();
        if (this.showProgressStdOut || this.debug) {
            this.printer.addPlace(System.out);
        }
        if (this.createLog) {
            this.printer.addPlace(new FileOutputStream(this.getLogFile(), true));
        }
        this.progress = this.printer.countPlaces() > 0 ? new PrintStream(this.printer) : null;
    }

    public void setCreateLog(boolean bl) {
        if (bl != this.createLog) {
            this.createLog = bl;
        }
    }

    public boolean isCreateLog() {
        return this.createLog;
    }

    public void setRecurse(boolean bl) {
        ((FlexFilter)this.convertSet.getFilenameFilter()).setFilesOnly(!bl);
        this.processSubDirs = bl;
    }

    public boolean isRecurse() {
        return this.processSubDirs;
    }

    public String getCabFileLocation() {
        return this.p.getProperty(this.versionState + ".converter.cab.file.loc", this.cabFileLocation);
    }

    public String getDefaultCabFileLocation() {
        return this.defaultCabFileLocation;
    }

    public void setCabFileLocation(String string) {
        String string2 = this.p.getProperty(this.versionState + ".converter.cab.file.loc");
        if (string2 == null) {
            this.p.put(this.versionState + ".converter.cab.file.loc", string);
            if (!string.equals(this.defaultCabFileLocation)) {
                this.outdated = true;
            }
        } else if (!string.equals(string2)) {
            this.p.put(this.versionState + ".converter.cab.file.loc", string);
            this.outdated = true;
        }
    }

    public String getNSFileLocation() {
        return this.p.getProperty(this.versionState + ".converter.plugin.file.loc", this.nsFileLocation);
    }

    public String getDefaultNSFileLocation() {
        return this.defaultNsFileLocation;
    }

    public void setNSFileLocation(String string) {
        String string2 = this.p.getProperty(this.versionState + ".converter.plugin.file.loc", this.nsFileLocation);
        if (string2 == null) {
            this.p.put(this.versionState + ".converter.plugin.file.loc", string);
            if (!string.equals(this.defaultNsFileLocation)) {
                this.outdated = true;
            }
        } else if (!string.equals(string2)) {
            this.p.put(this.versionState + ".converter.plugin.file.loc", string);
            this.outdated = true;
        }
    }

    public String getSmartUpdateLocation() {
        return this.p.getProperty(this.versionState + ".converter.smartupdate.file.loc", this.smartUpdateLocation);
    }

    public String getDefaultSmartUpdateLocation() {
        return this.defaultSmartUpdateLocation;
    }

    public void setSmartUpdateLocation(String string) {
        String string2 = this.p.getProperty(this.versionState + ".converter.smartupdate.file.loc");
        if (string2 == null) {
            this.p.put(this.versionState + ".converter.smartupdate.file.loc", string);
            if (!string.equals(this.defaultSmartUpdateLocation)) {
                this.outdated = true;
            }
        } else if (!string.equals(string2)) {
            this.p.put(this.versionState + ".converter.smartupdate.file.loc", string);
            this.outdated = true;
        }
    }

    public String getMimeType() {
        return this.p.getProperty(this.versionState + ".converter.template.mimetype", this.mimeType);
    }

    public void setMimeType(String string) {
        String string2 = this.p.getProperty(this.versionState + ".converter.template.mimetype");
        if (string2 == null) {
            this.p.put(this.versionState + ".converter.template.mimetype", string);
            if (!string.equals(this.mimeType)) {
                this.outdated = true;
            }
        } else if (!string.equals(string2)) {
            this.p.put(this.versionState + ".converter.template.mimetype", string);
            this.outdated = true;
        }
    }

    public String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public void setDefaultMimeType(String string) {
        this.defaultMimeType = string;
    }

    public String getClassId() {
        return this.p.getProperty(this.versionState + ".converter.classid", this.classId);
    }

    public void setClassId(String string) {
        this.classId = string;
        String string2 = this.p.getProperty(this.versionState + ".converter.classid");
        if (string2 == null) {
            this.p.put(this.versionState + ".converter.classid", string);
        } else if (!string.equals(string2)) {
            this.p.put(this.versionState + ".converter.classid", string);
            this.outdated = true;
        }
    }

    public void setSourceType(boolean bl) {
        this.stdin = bl;
    }

    public void setDestType(boolean bl) {
        this.stdout = bl;
    }

    public String toString() {
        String string = "";
        string = string + "\nShow Progress StdOut:  " + this.showProgressStdOut;
        string = string + "\ndebug:  " + this.debug;
        string = string + "\nTemplate File Path:  " + this.templateFilePath.toString();
        string = string + "\nCount Listeners:  " + this.listeners.size();
        string = string + "\nLog File Path:  " + this.logFile.toString();
        string = string + "\nCreate Log:  " + this.createLog;
        string = string + "\nConvert Set:  " + ((Object)this.convertSet).toString();
        string = string + "\nProcess Sub Dirs:  " + this.processSubDirs;
        return string;
    }
}

