/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.dummy;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.dummy.DummyDebugger;
import sun.jvm.hotspot.debugger.dummy.DummyOopHandle;

class DummyAddress
implements Address {
    protected DummyDebugger debugger;
    protected long addr;
    private static final long badLong = 3131947710L;
    private static final double badDouble = 1.23456;

    DummyAddress(DummyDebugger debugger, long addr) {
        this.debugger = debugger;
        this.addr = addr;
    }

    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof DummyAddress)) {
            return false;
        }
        return this.addr == ((DummyAddress)arg).addr;
    }

    public int hashCode() {
        return (int)this.addr;
    }

    public String toString() {
        return this.debugger.addressToString(this);
    }

    public long getCIntegerAt(long offset, long numBytes, boolean isUnsigned) throws UnalignedAddressException, UnmappedAddressException {
        return 3131947710L;
    }

    public Address getAddressAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return new DummyAddress(this.debugger, 3131947710L);
    }

    public boolean getJBooleanAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return false;
    }

    public byte getJByteAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return -66;
    }

    public char getJCharAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return '\ubabe';
    }

    public double getJDoubleAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return 1.23456;
    }

    public float getJFloatAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return 1.23456f;
    }

    public int getJIntAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return -1163019586;
    }

    public long getJLongAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return 3131947710L;
    }

    public short getJShortAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return -17730;
    }

    public OopHandle getOopHandleAt(long offset) throws UnalignedAddressException, UnmappedAddressException, NotInHeapException {
        return new DummyOopHandle(this.debugger, 3131947710L);
    }

    public void setCIntegerAt(long offset, long numBytes, long value) {
        throw new DebuggerException("Unimplemented");
    }

    public void setAddressAt(long offset, Address value) {
        throw new DebuggerException("Unimplemented");
    }

    public void setJBooleanAt(long offset, boolean value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJByteAt(long offset, byte value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJCharAt(long offset, char value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJDoubleAt(long offset, double value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJFloatAt(long offset, float value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJIntAt(long offset, int value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJLongAt(long offset, long value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setJShortAt(long offset, short value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public void setOopHandleAt(long offset, OopHandle value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    public Address addOffsetTo(long offset) throws UnsupportedOperationException {
        long value = this.addr + offset;
        if (value == 0L) {
            return null;
        }
        return new DummyAddress(this.debugger, value);
    }

    public OopHandle addOffsetToAsOopHandle(long offset) throws UnsupportedOperationException {
        long value = this.addr + offset;
        if (value == 0L) {
            return null;
        }
        return new DummyOopHandle(this.debugger, value);
    }

    public long minus(Address arg) {
        if (arg == null) {
            return this.addr;
        }
        return this.addr - ((DummyAddress)arg).addr;
    }

    public boolean lessThan(Address arg) {
        DummyAddress DummyArg = (DummyAddress)arg;
        if (this.addr >= 0L && DummyArg.addr < 0L) {
            return true;
        }
        if (this.addr < 0L && DummyArg.addr >= 0L) {
            return false;
        }
        return this.addr < DummyArg.addr;
    }

    public boolean lessThanOrEqual(Address arg) {
        DummyAddress DummyArg = (DummyAddress)arg;
        if (this.addr >= 0L && DummyArg.addr < 0L) {
            return true;
        }
        if (this.addr < 0L && DummyArg.addr >= 0L) {
            return false;
        }
        return this.addr <= DummyArg.addr;
    }

    public boolean greaterThan(Address arg) {
        DummyAddress DummyArg = (DummyAddress)arg;
        if (this.addr >= 0L && DummyArg.addr < 0L) {
            return false;
        }
        if (this.addr < 0L && DummyArg.addr >= 0L) {
            return true;
        }
        return this.addr > DummyArg.addr;
    }

    public boolean greaterThanOrEqual(Address arg) {
        DummyAddress DummyArg = (DummyAddress)arg;
        if (this.addr >= 0L && DummyArg.addr < 0L) {
            return false;
        }
        if (this.addr < 0L && DummyArg.addr >= 0L) {
            return true;
        }
        return this.addr >= DummyArg.addr;
    }

    public Address andWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr & mask;
        if (value == 0L) {
            return null;
        }
        return new DummyAddress(this.debugger, value);
    }

    public Address orWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr | mask;
        if (value == 0L) {
            return null;
        }
        return new DummyAddress(this.debugger, value);
    }

    public Address xorWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr ^ mask;
        if (value == 0L) {
            return null;
        }
        return new DummyAddress(this.debugger, value);
    }

    long getValue() {
        return this.addr;
    }

    private static void check(boolean arg, String failMessage) {
        if (!arg) {
            System.err.println(failMessage + ": FAILED");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        DummyAddress p1 = new DummyAddress(null, 0x7FFFFFFFFFFFFFF0L);
        DummyAddress p2 = (DummyAddress)p1.addOffsetTo(10L);
        DummyAddress n1 = (DummyAddress)p2.addOffsetTo(10L);
        DummyAddress n2 = (DummyAddress)n1.addOffsetTo(10L);
        DummyAddress.check(p1.lessThan(p2), "lessThan 1");
        DummyAddress.check(p1.lessThan(n1), "lessThan 2");
        DummyAddress.check(p1.lessThan(n2), "lessThan 3");
        DummyAddress.check(p2.lessThan(n1), "lessThan 4");
        DummyAddress.check(p2.lessThan(n2), "lessThan 5");
        DummyAddress.check(n1.lessThan(n2), "lessThan 6");
        DummyAddress.check(!p1.lessThan(p1), "lessThan 7");
        DummyAddress.check(!p2.lessThan(p2), "lessThan 8");
        DummyAddress.check(!n1.lessThan(n1), "lessThan 9");
        DummyAddress.check(!n2.lessThan(n2), "lessThan 10");
        DummyAddress.check(!p2.lessThan(p1), "lessThan 11");
        DummyAddress.check(!n1.lessThan(p1), "lessThan 12");
        DummyAddress.check(!n2.lessThan(p1), "lessThan 13");
        DummyAddress.check(!n1.lessThan(p2), "lessThan 14");
        DummyAddress.check(!n2.lessThan(p2), "lessThan 15");
        DummyAddress.check(!n2.lessThan(n1), "lessThan 16");
        DummyAddress.check(p1.lessThanOrEqual(p1), "lessThanOrEqual 1");
        DummyAddress.check(p2.lessThanOrEqual(p2), "lessThanOrEqual 2");
        DummyAddress.check(n1.lessThanOrEqual(n1), "lessThanOrEqual 3");
        DummyAddress.check(n2.lessThanOrEqual(n2), "lessThanOrEqual 4");
        DummyAddress.check(p1.lessThanOrEqual(p2), "lessThanOrEqual 5");
        DummyAddress.check(p1.lessThanOrEqual(n1), "lessThanOrEqual 6");
        DummyAddress.check(p1.lessThanOrEqual(n2), "lessThanOrEqual 7");
        DummyAddress.check(p2.lessThanOrEqual(n1), "lessThanOrEqual 8");
        DummyAddress.check(p2.lessThanOrEqual(n2), "lessThanOrEqual 9");
        DummyAddress.check(n1.lessThanOrEqual(n2), "lessThanOrEqual 10");
        DummyAddress.check(!p2.lessThanOrEqual(p1), "lessThanOrEqual 11");
        DummyAddress.check(!n1.lessThanOrEqual(p1), "lessThanOrEqual 12");
        DummyAddress.check(!n2.lessThanOrEqual(p1), "lessThanOrEqual 13");
        DummyAddress.check(!n1.lessThanOrEqual(p2), "lessThanOrEqual 14");
        DummyAddress.check(!n2.lessThanOrEqual(p2), "lessThanOrEqual 15");
        DummyAddress.check(!n2.lessThanOrEqual(n1), "lessThanOrEqual 16");
        DummyAddress.check(n2.greaterThan(p1), "greaterThan 1");
        DummyAddress.check(n2.greaterThan(p2), "greaterThan 2");
        DummyAddress.check(n2.greaterThan(n1), "greaterThan 3");
        DummyAddress.check(n1.greaterThan(p1), "greaterThan 4");
        DummyAddress.check(n1.greaterThan(p2), "greaterThan 5");
        DummyAddress.check(p2.greaterThan(p1), "greaterThan 6");
        DummyAddress.check(!p1.greaterThan(p1), "greaterThan 7");
        DummyAddress.check(!p2.greaterThan(p2), "greaterThan 8");
        DummyAddress.check(!n1.greaterThan(n1), "greaterThan 9");
        DummyAddress.check(!n2.greaterThan(n2), "greaterThan 10");
        DummyAddress.check(!p1.greaterThan(n2), "greaterThan 11");
        DummyAddress.check(!p2.greaterThan(n2), "greaterThan 12");
        DummyAddress.check(!n1.greaterThan(n2), "greaterThan 13");
        DummyAddress.check(!p1.greaterThan(n1), "greaterThan 14");
        DummyAddress.check(!p2.greaterThan(n1), "greaterThan 15");
        DummyAddress.check(!p1.greaterThan(p2), "greaterThan 16");
        DummyAddress.check(p1.greaterThanOrEqual(p1), "greaterThanOrEqual 1");
        DummyAddress.check(p2.greaterThanOrEqual(p2), "greaterThanOrEqual 2");
        DummyAddress.check(n1.greaterThanOrEqual(n1), "greaterThanOrEqual 3");
        DummyAddress.check(n2.greaterThanOrEqual(n2), "greaterThanOrEqual 4");
        DummyAddress.check(n2.greaterThanOrEqual(p1), "greaterThanOrEqual 5");
        DummyAddress.check(n2.greaterThanOrEqual(p2), "greaterThanOrEqual 6");
        DummyAddress.check(n2.greaterThanOrEqual(n1), "greaterThanOrEqual 7");
        DummyAddress.check(n1.greaterThanOrEqual(p1), "greaterThanOrEqual 8");
        DummyAddress.check(n1.greaterThanOrEqual(p2), "greaterThanOrEqual 9");
        DummyAddress.check(p2.greaterThanOrEqual(p1), "greaterThanOrEqual 10");
        DummyAddress.check(!p1.greaterThanOrEqual(n2), "greaterThanOrEqual 11");
        DummyAddress.check(!p2.greaterThanOrEqual(n2), "greaterThanOrEqual 12");
        DummyAddress.check(!n1.greaterThanOrEqual(n2), "greaterThanOrEqual 13");
        DummyAddress.check(!p1.greaterThanOrEqual(n1), "greaterThanOrEqual 14");
        DummyAddress.check(!p2.greaterThanOrEqual(n1), "greaterThanOrEqual 15");
        DummyAddress.check(!p1.greaterThanOrEqual(p2), "greaterThanOrEqual 16");
        System.err.println("DummyAddress: all tests passed successfully.");
    }
}

