/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class TypeArrayKlass
extends ArrayKlass {
    private static CIntField type;
    private static CIntField scale;
    private static CIntField maxLength;
    public static final int T_BOOLEAN = 4;
    public static final int T_CHAR = 5;
    public static final int T_FLOAT = 6;
    public static final int T_DOUBLE = 7;
    public static final int T_BYTE = 8;
    public static final int T_SHORT = 9;
    public static final int T_INT = 10;
    public static final int T_LONG = 11;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type t = db.lookupType("typeArrayKlass");
        type = new CIntField(t.getCIntegerField("_type"), Oop.getHeaderSize());
        scale = new CIntField(t.getCIntegerField("_scale"), Oop.getHeaderSize());
        maxLength = new CIntField(t.getCIntegerField("_max_length"), Oop.getHeaderSize());
    }

    TypeArrayKlass(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public long getType() {
        return type.getValue(this);
    }

    public long getScale() {
        return scale.getValue(this);
    }

    public long getMaxLength() {
        return maxLength.getValue(this);
    }

    public String getTypeName() {
        switch ((int)this.getType()) {
            case 4: {
                return "[Z";
            }
            case 5: {
                return "[C";
            }
            case 6: {
                return "[F";
            }
            case 7: {
                return "[D";
            }
            case 8: {
                return "[B";
            }
            case 9: {
                return "[S";
            }
            case 10: {
                return "[I";
            }
            case 11: {
                return "[J";
            }
        }
        return "Unknown TypeArray";
    }

    public String getElementTypeName() {
        switch ((int)this.getType()) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
        }
        throw new RuntimeException("should not reach here");
    }

    public void printValueOn(PrintStream tty) {
        tty.print("TypeArrayKlass for " + this.getTypeName());
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doCInt(type, true);
            visitor.doCInt(scale, true);
            visitor.doCInt(maxLength, true);
        }
    }

    public Klass arrayKlassImpl(boolean orNull, int n) {
        int dimension = (int)this.getDimension();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(dimension <= n, "check order of chain");
        }
        if (dimension == n) {
            return this;
        }
        ObjArrayKlass ak = (ObjArrayKlass)this.getHigherDimension();
        if (ak == null) {
            if (orNull) {
                return null;
            }
            throw new RuntimeException("Can not allocate array klasses in debugging system");
        }
        if (orNull) {
            return ak.arrayKlassOrNull(n);
        }
        return ak.arrayKlass(n);
    }

    public Klass arrayKlassImpl(boolean orNull) {
        return this.arrayKlassImpl(orNull, (int)(this.getDimension() + 1L));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                TypeArrayKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

