/*  
 *  xcall - Packet radio program for GTK+
 *  Copyright (C) 2001 Joop Stakenborg <pa4tu@amsat.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* types.h */

/* normal messages in the main text window */
#define ERRORMESSAGE 0
#define TXMESSAGE 1
#define RXMESSAGE 2
#define STATUSMESSAGE 3

/* dx cluster messages */
#define DX1_8MESSAGE 102
#define DX3_5MESSAGE 103
#define DX7MESSAGE 104
#define DX10MESSAGE 105
#define DX14MESSAGE 106
#define DX18MESSAGE 107
#define DX21MESSAGE 108
#define DX24MESSAGE 109
#define DX28MESSAGE 110
#define DXOTHERMESSAGE 111

/* type of combobox dialog */
#define RECORDON 0
#define RECORDOFF 1
#define CONNECT 2
#define DISCONNECT 3
#define KILL 4

/* history for the tx widget and recording */
#define HISTORY 20

/* structure which stores preferences */
typedef struct {
  GString *font;
  GdkColor backgroundcolor;
  GdkColor txfgcolor;
  GdkColor rxfgcolor;
  GdkColor statusfgcolor;
  GdkColor errorfgcolor;
  gboolean scrollbar;
  gboolean menu;
  gint timeout;
  GString *downloaddir;
  gboolean origin;
  gboolean size;
  gint x;
  gint y;
  gint width;
  gint height;
  gboolean dxcluster;
  GdkColor dxbackgroundcolor;
  GdkColor dx1_8color;
  GdkColor dx3_5color;
  GdkColor dx7color;
  GdkColor dx10color;
  GdkColor dx14color;
  GdkColor dx18color;
  GdkColor dx21color;
  GdkColor dx24color;
  GdkColor dx28color;
  GdkColor dxothercolor;
} preferencestype;