/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <glib-object.h>

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "base/base-utils.h"
#include "core/gimp.h"
#include "core/gimpparamspecs.h"

#include "gimppdb.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static GValueArray *
version_invoker (GimpProcedure      *procedure,
                 Gimp               *gimp,
                 GimpContext        *context,
                 GimpProgress       *progress,
                 const GValueArray  *args,
                 GError            **error)
{
  GValueArray *return_vals;
  gchar *version = NULL;

  version = g_strdup (GIMP_VERSION);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_take_string (&return_vals->values[1], version);

  return return_vals;
}

static GValueArray *
getpid_invoker (GimpProcedure      *procedure,
                Gimp               *gimp,
                GimpContext        *context,
                GimpProgress       *progress,
                const GValueArray  *args,
                GError            **error)
{
  GValueArray *return_vals;
  gint32 pid = 0;

  pid = get_pid ();

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_int (&return_vals->values[1], pid);

  return return_vals;
}

static GValueArray *
quit_invoker (GimpProcedure      *procedure,
              Gimp               *gimp,
              GimpContext        *context,
              GimpProgress       *progress,
              const GValueArray  *args,
              GError            **error)
{
  gboolean success = TRUE;
  gboolean force;

  force = g_value_get_boolean (&args->values[0]);

  if (success)
    {
      gimp_exit (gimp, force);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_misc_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-version
   */
  procedure = gimp_procedure_new (version_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-version");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-version",
                                     "Returns the host GIMP version.",
                                     "This procedure returns the version number of the currently running GIMP.",
                                     "Manish Singh",
                                     "Manish Singh",
                                     "1999",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("version",
                                                           "version",
                                                           "GIMP version number",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-getpid
   */
  procedure = gimp_procedure_new (getpid_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-getpid");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-getpid",
                                     "Returns the PID of the host GIMP process.",
                                     "This procedure returns the process ID of the currently running GIMP.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("pid",
                                                          "pid",
                                                          "The PID",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-quit
   */
  procedure = gimp_procedure_new (quit_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-quit");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-quit",
                                     "Causes GIMP to exit gracefully.",
                                     "If there are unsaved images in an interactive GIMP session, the user will be asked for confirmation. If force is TRUE, the application is quit without querying the user to save any dirty images.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("force",
                                                     "force",
                                                     "Force GIMP to quit without asking",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
