//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  A combined button, line-edit and a popup list widget.
    ///  <li><b>Detail </b></li>
    ///  This widget inherits from QComboBox and implements the following
    ///  additional functionalities:  a completion object that provides both automatic
    ///  and manual text completion as well as text rotation features, configurable
    ///  key-bindings to activate these features, and a popup-menu item that can be
    ///  used to allow the user to change the text completion mode on the fly.
    ///  To support these new features KComboBox emits a few additional signals
    ///  such as completion( string ) and textRotation( KeyBindingType ).
    ///  The completion signal can be connected to a slot that will assist the user in
    ///  filling out the remaining text while the rotation signal can be used to traverse
    ///  through all possible matches whenever text completion results in multiple matches.
    ///  Additionally, a returnPressed() and a returnPressed( string )
    ///  signals are emitted when the user presses the Enter/Return key.
    ///  KCombobox by default creates a completion object when you invoke the
    ///  completionObject( bool ) member function for the first time or
    ///  explicitly use setCompletionObject( KCompletion, bool ) to assign your
    ///  own completion object.  Additionally, to make this widget more functional,
    ///  KComboBox will by default handle text rotation and completion events
    ///  internally whenever a completion object is created through either one of the
    ///  methods mentioned above.  If you do not need this functionality, simply use
    ///  KCompletionBase.SetHandleSignals(bool) or alternatively set the boolean
    ///  parameter in the <code>setCompletionObject</code> call to false.
    ///  Beware: The completion object can be deleted on you, especially if a call
    ///  such as setEditable(false) is made.  Store the pointer at your own risk,
    ///  and consider using QGuardedPtr<KCompletion>.
    ///  The default key-bindings for completion and rotation is determined from the
    ///  global settings in KStandardShortcut. These values, however, can be overridden
    ///  locally by invoking KCompletionBase.SetKeyBinding(). The values can
    ///  easily be reverted back to the default setting, by simply calling
    ///  useGlobalSettings(). An alternate method would be to default individual
    ///  key-bindings by usning setKeyBinding() with the default second argument.
    ///  A non-editable combobox only has one completion mode, <code>CompletionAuto.</code>
    ///  Unlike an editable combobox the CompletionAuto mode, works by matching
    ///  any typed key with the first letter of entries in the combobox. Please note
    ///  that if you call setEditable( false ) to change an editable combobox to a
    ///  non-editable one, the text completion object associated with the combobox will
    ///  no longer exist unless you created the completion object yourself and assigned
    ///  it to this widget or you called setAutoDeleteCompletionObject( false ). In other
    ///  words do not do the following:
    ///  <pre>
    ///  KComboBox combo = new KCompletionBox(true, this);
    ///  KCompletion comp = combo.CompletionObject();
    ///  combo.SetEditable( false );
    ///  comp.Clear(); // CRASH: completion object does not exist anymore.
    ///  </pre>
    ///  A read-only KComboBox will have the same background color as a
    ///  disabled KComboBox, but its foreground color will be the one used for
    ///  the read-write mode. This differs from QComboBox's implementation
    ///  and is done to give visual distinction between the three different modes:
    ///  disabled, read-only, and read-write.
    ///  <li><b>Usage </b></li>
    ///  To enable the basic completion feature:
    ///  <pre>
    ///  KComboBox combo = new KComboBox( true, this );
    ///  KCompletion comp = combo.CompletionObject();
    ///  // Connect to the return pressed signal - optional
    ///  connect(combo,SIGNAL("returnPressed(string)"),comp,SLOT("addItem(string)"));
    ///  // Provide the to be completed strings. Note that those are separate from the combo's
    ///  // contents.
    ///  comp.InsertItems( someList<string> );
    ///  </pre>
    ///  To use your own completion object:
    ///  <pre>
    ///  KComboBox combo = new KComboBox( this );
    ///  KUrlCompletion comp = new KUrlCompletion();
    ///  combo.SetCompletionObject( comp );
    ///  // Connect to the return pressed signal - optional
    ///  connect(combo,SIGNAL("returnPressed(string)"),comp,SLOT("addItem(string)"));
    ///  </pre>
    ///  Note that you have to either delete the allocated completion object
    ///  when you don't need it anymore, or call
    ///  setAutoDeleteCompletionObject( true );
    ///  Miscellaneous function calls:
    ///  <pre>
    ///  // Tell the widget not to handle completion and rotation
    ///  combo.SetHandleSignals( false );
    ///  // Set your own completion key for manual completions.
    ///  combo.SetKeyBinding( KCompletionBase.TextCompletion, Qt.End );
    ///  </pre>
    ///  See <see cref="IKComboBoxSignals"></see> for signals emitted by KComboBox
    /// </remarks>        <author> Dawit Alemayehu <adawit@kde.org>
    ///  </author>
    ///         <short> An enhanced combo box. </short>
    [SmokeClass("KComboBox")]
    public class KComboBox : QComboBox, IKCompletionBase, IDisposable {
        protected KComboBox(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KComboBox), this);
        }
        [Q_PROPERTY("bool", "autoCompletion")]
        public new bool AutoCompletion {
            get { return (bool) interceptor.Invoke("autoCompletion", "autoCompletion()", typeof(bool)); }
            set { interceptor.Invoke("setAutoCompletion$", "setAutoCompletion(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("bool", "urlDropsEnabled")]
        public bool UrlDropsEnabled {
            get { return (bool) interceptor.Invoke("urlDropsEnabled", "urlDropsEnabled()", typeof(bool)); }
            set { interceptor.Invoke("setUrlDropsEnabled$", "setUrlDropsEnabled(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("bool", "trapReturnKey")]
        public bool TrapReturnKey {
            get { return (bool) interceptor.Invoke("trapReturnKey", "trapReturnKey()", typeof(bool)); }
            set { interceptor.Invoke("setTrapReturnKey$", "setTrapReturnKey(bool)", typeof(void), typeof(bool), value); }
        }
        // QMap<KCompletionBase::KeyBindingType, KShortcut> getKeyBindings(); >>>> NOT CONVERTED
        /// <remarks>
        ///  Constructs a read-only or rather select-only combo box with a
        ///  parent object and a name.
        /// <param> name="parent" The parent object of this widget
        ///     </param></remarks>        <short>    Constructs a read-only or rather select-only combo box with a  parent object and a name.</short>
        public KComboBox(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KComboBox#", "KComboBox(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public KComboBox() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KComboBox", "KComboBox()", typeof(void));
        }
        /// <remarks>
        ///  Constructs a "read-write" or "read-only" combo box depending on
        ///  the value of the first argument( <code>rw</code> ) with a parent, a
        ///  name.
        /// <param> name="rw" When <code>true</code>, widget will be editable.
        /// </param><param> name="parent" The parent object of this widget.
        ///     </param></remarks>        <short>    Constructs a "read-write" or "read-only" combo box depending on  the value of the first argument( <code>rw</code> ) with a parent, a  name.</short>
        public KComboBox(bool rw, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KComboBox$#", "KComboBox(bool, QWidget*)", typeof(void), typeof(bool), rw, typeof(QWidget), parent);
        }
        public KComboBox(bool rw) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KComboBox$", "KComboBox(bool)", typeof(void), typeof(bool), rw);
        }
        /// <remarks>
        ///  Sets <code>url</code> into the edit field of the combobox. It uses
        ///  KUrl.PrettyUrl() so that the url is properly decoded for
        ///  displaying.
        ///      </remarks>        <short>    Sets <code>url</code> into the edit field of the combobox.</short>
        public void SetEditUrl(KUrl url) {
            interceptor.Invoke("setEditUrl#", "setEditUrl(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Appends <code>url</code> to the combobox.
        ///  KUrl.PrettyUrl() is used so that the url is properly decoded
        ///  for displaying.
        ///      </remarks>        <short>    Appends <code>url</code> to the combobox.</short>
        public void AddUrl(KUrl url) {
            interceptor.Invoke("addUrl#", "addUrl(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Appends <code>url</code> with the icon &p icon to the combobox.
        ///  KUrl.PrettyUrl() is used so that the url is properly decoded
        ///  for displaying.
        ///      </remarks>        <short>    Appends <code>url</code> with the icon &p icon to the combobox.</short>
        public void AddUrl(QIcon icon, KUrl url) {
            interceptor.Invoke("addUrl##", "addUrl(const QIcon&, const KUrl&)", typeof(void), typeof(QIcon), icon, typeof(KUrl), url);
        }
        /// <remarks>
        ///  Inserts <code>url</code> at position <code>index</code> into the combobox.
        ///  KUrl.PrettyUrl() is used so that the url is properly decoded
        ///  for displaying.
        ///      </remarks>        <short>    Inserts <code>url</code> at position <code>index</code> into the combobox.</short>
        public void InsertUrl(int index, KUrl url) {
            interceptor.Invoke("insertUrl$#", "insertUrl(int, const KUrl&)", typeof(void), typeof(int), index, typeof(KUrl), url);
        }
        /// <remarks>
        ///  Inserts <code>url</code> with the pixmap &p pixmap at position <code>index</code> into
        ///  the combobox. KUrl.PrettyUrl() is used so that the url is
        ///  properly decoded for displaying.
        ///      </remarks>        <short>    Inserts <code>url</code> with the pixmap &p pixmap at position <code>index</code> into  the combobox.</short>
        public void InsertUrl(int index, QIcon icon, KUrl url) {
            interceptor.Invoke("insertUrl$##", "insertUrl(int, const QIcon&, const KUrl&)", typeof(void), typeof(int), index, typeof(QIcon), icon, typeof(KUrl), url);
        }
        /// <remarks>
        ///  Replaces the item at position <code>index</code> with <code>url.</code>
        ///  KUrl.PrettyUrl() is used so that the url is properly decoded
        ///  for displaying.
        ///      </remarks>        <short>    Replaces the item at position <code>index</code> with <code>url.</code></short>
        public void ChangeUrl(int index, KUrl url) {
            interceptor.Invoke("changeUrl$#", "changeUrl(int, const KUrl&)", typeof(void), typeof(int), index, typeof(KUrl), url);
        }
        /// <remarks>
        ///  Replaces the item at position <code>index</code> with <code>url</code> and icon <code>icon.</code>
        ///  KUrl.PrettyUrl() is used so that the url is properly decoded
        ///  for displaying.
        ///      </remarks>        <short>    Replaces the item at position <code>index</code> with <code>url</code> and icon <code>icon.</code></short>
        public void ChangeUrl(int index, QIcon icon, KUrl url) {
            interceptor.Invoke("changeUrl$##", "changeUrl(int, const QIcon&, const KUrl&)", typeof(void), typeof(int), index, typeof(QIcon), icon, typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns the current cursor position.
        ///  This method always returns a -1 if the combo-box is <b>not</b>
        ///  editable (read-write).
        /// </remarks>        <return> Current cursor position.
        ///     </return>
        ///         <short>    Returns the current cursor position.</short>
        public int CursorPosition() {
            return (int) interceptor.Invoke("cursorPosition", "cursorPosition() const", typeof(int));
        }
        /// <remarks>
        ///  Re-implemented from QComboBox.
        ///  If <code>true</code>, the completion mode will be set to automatic.
        ///  Otherwise, it is defaulted to the global setting.  This
        ///  method has been replaced by the more comprehensive
        ///  setCompletionMode().
        /// <param> name="autocomplete" Flag to enable/disable automatic completion mode.
        ///     </param></remarks>        <short>    Re-implemented from QComboBox.</short>
        [SmokeMethod("setAutoCompletion(bool)")]
        public virtual void SetAutoCompletion(bool autocomplete) {
            interceptor.Invoke("setAutoCompletion$", "setAutoCompletion(bool)", typeof(void), typeof(bool), autocomplete);
        }
        /// <remarks>
        ///  Convenience method which iterates over all items and checks if
        ///  any of them is equal to <code>text.</code>
        ///  If <code>text</code> is an empty string, <code>false</code>
        ///  is returned.
        /// </remarks>        <return> <code>true</code> if an item with the string <code>text</code> is in the combobox.
        ///      </return>
        ///         <short>    Convenience method which iterates over all items and checks if  any of them is equal to <code>text.</code></short>
        public bool Contains(string text) {
            return (bool) interceptor.Invoke("contains$", "contains(const QString&) const", typeof(bool), typeof(string), text);
        }
        /// <remarks>
        ///  Re-implemented for internal reasons.  API not affected.
        ///     </remarks>        <short>    Re-implemented for internal reasons.</short>
        [SmokeMethod("eventFilter(QObject*, QEvent*)")]
        public override bool EventFilter(QObject arg1, QEvent arg2) {
            return (bool) interceptor.Invoke("eventFilter##", "eventFilter(QObject*, QEvent*)", typeof(bool), typeof(QObject), arg1, typeof(QEvent), arg2);
        }
        /// <remarks>
        /// <param> name="create" Set this to false if you don't want the box to be created
        ///                i.e. to test if it is available.
        ///      </param></remarks>        <return> the completion-box, that is used in completion mode
        ///  KGlobalSettings.CompletionPopup and KGlobalSettings.CompletionPopupAuto.
        ///  This method will create a completion-box by calling
        ///  KLineEdit.CompletionBox, if none is there, yet.
        /// </return>
        ///         <short>   </short>
        public KCompletionBox CompletionBox(bool create) {
            return (KCompletionBox) interceptor.Invoke("completionBox$", "completionBox(bool)", typeof(KCompletionBox), typeof(bool), create);
        }
        public KCompletionBox CompletionBox() {
            return (KCompletionBox) interceptor.Invoke("completionBox", "completionBox()", typeof(KCompletionBox));
        }
        /// <remarks>
        ///  Re-implemented for internal reasons.  API remains unaffected.
        ///  Note that QComboBox.SetLineEdit is not in Qt4, do not
        ///  use a KComboBox in a QComboBox pointer.
        ///  NOTE: Only editable comboboxes can have a line editor. As such
        ///  any attempt to assign a line-edit to a non-editable combobox will
        ///  simply be ignored.
        ///      </remarks>        <short>    Re-implemented for internal reasons.</short>
        [SmokeMethod("setLineEdit(QLineEdit*)")]
        public virtual void SetLineEdit(QLineEdit arg1) {
            interceptor.Invoke("setLineEdit#", "setLineEdit(QLineEdit*)", typeof(void), typeof(QLineEdit), arg1);
        }
        /// <remarks>
        ///  "Re-implemented" so that setEditable(true) creates a KLineEdit
        ///  instead of QLineEdit.
        ///  Note that QComboBox.SetEditable is not virtual, so do not
        ///  use a KComboBox in a QComboBox pointer.
        ///      </remarks>        <short>    "Re-implemented" so that setEditable(true) creates a KLineEdit  instead of QLineEdit.</short>
        public void SetEditable(bool editable) {
            interceptor.Invoke("setEditable$", "setEditable(bool)", typeof(void), typeof(bool), editable);
        }
        /// <remarks>
        ///  Iterates through all possible matches of the completed text
        ///  or the history list.
        ///  Depending on the value of the argument, this function either
        ///  iterates through the history list of this widget or the all
        ///  possible matches in whenever multiple matches result from a
        ///  text completion request.  Note that the all-possible-match
        ///  iteration will not work if there are no previous matches, i.e.
        ///  no text has been completed and the nix shell history list
        ///  rotation is only available if the insertion policy for this
        ///  widget is set either <code>QComobBox</code>.AtTop or <code>QComboBox</code>.AtBottom.
        ///  For other insertion modes whatever has been typed by the user
        ///  when the rotation event was initiated will be lost.
        /// <param> name="type" The key-binding invoked.
        ///     </param></remarks>        <short>    Iterates through all possible matches of the completed text  or the history list.</short>
        [Q_SLOT("void rotateText(KCompletionBase::KeyBindingType)")]
        public void RotateText(KCompletionBase.KeyBindingType type) {
            interceptor.Invoke("rotateText$", "rotateText(KCompletionBase::KeyBindingType)", typeof(void), typeof(KCompletionBase.KeyBindingType), type);
        }
        /// <remarks>
        ///  Sets the completed text in the line-edit appropriately.
        ///  This function is an implementation for
        ///  KCompletionBase.SetCompletedText.
        ///      </remarks>        <short>    Sets the completed text in the line-edit appropriately.</short>
        [Q_SLOT("void setCompletedText(QString)")]
        [SmokeMethod("setCompletedText(const QString&)")]
        public virtual void SetCompletedText(string arg1) {
            interceptor.Invoke("setCompletedText$", "setCompletedText(const QString&)", typeof(void), typeof(string), arg1);
        }
        /// <remarks>
        ///  Sets <code>items</code> into the completion-box if completionMode() is
        ///  CompletionPopup. The popup will be shown immediately.
        ///      </remarks>        <short>    Sets <code>items</code> into the completion-box if completionMode() is  CompletionPopup.</short>
        [Q_SLOT("void setCompletedItems(QStringList, bool)")]
        [SmokeMethod("setCompletedItems(const QStringList&, bool)")]
        public virtual void SetCompletedItems(List<string> items, bool autosubject) {
            interceptor.Invoke("setCompletedItems?$", "setCompletedItems(const QStringList&, bool)", typeof(void), typeof(List<string>), items, typeof(bool), autosubject);
        }
        [Q_SLOT("void setCompletedItems(QStringList)")]
        [SmokeMethod("setCompletedItems(const QStringList&)")]
        public virtual void SetCompletedItems(List<string> items) {
            interceptor.Invoke("setCompletedItems?", "setCompletedItems(const QStringList&)", typeof(void), typeof(List<string>), items);
        }
        /// <remarks>
        ///  Selects the first item that matches <code>item.</code> If there is no such item,
        ///  it is inserted at position <code>index</code> if <code>insert</code> is true. Otherwise,
        ///  no item is selected.
        ///      </remarks>        <short>    Selects the first item that matches <code>item.</code></short>
        [Q_SLOT("void setCurrentItem(QString, bool, int)")]
        public void SetCurrentItem(string item, bool insert, int index) {
            interceptor.Invoke("setCurrentItem$$$", "setCurrentItem(const QString&, bool, int)", typeof(void), typeof(string), item, typeof(bool), insert, typeof(int), index);
        }
        [Q_SLOT("void setCurrentItem(QString, bool)")]
        public void SetCurrentItem(string item, bool insert) {
            interceptor.Invoke("setCurrentItem$$", "setCurrentItem(const QString&, bool)", typeof(void), typeof(string), item, typeof(bool), insert);
        }
        [Q_SLOT("void setCurrentItem(QString)")]
        public void SetCurrentItem(string item) {
            interceptor.Invoke("setCurrentItem$", "setCurrentItem(const QString&)", typeof(void), typeof(string), item);
        }
        [SmokeMethod("setCompletedText(const QString&, bool)")]
        protected virtual void SetCompletedText(string arg1, bool arg2) {
            interceptor.Invoke("setCompletedText$$", "setCompletedText(const QString&, bool)", typeof(void), typeof(string), arg1, typeof(bool), arg2);
        }
        /// <remarks>
        ///  Reimplemented for internal reasons, the API is not affected.
        ///      </remarks>        <short>    Reimplemented for internal reasons, the API is not affected.</short>
        [SmokeMethod("create(WId, bool, bool)")]
        protected virtual void Create(uint arg1, bool initializeWindow, bool destroyOldWindow) {
            interceptor.Invoke("create$$$", "create(WId, bool, bool)", typeof(void), typeof(uint), arg1, typeof(bool), initializeWindow, typeof(bool), destroyOldWindow);
        }
        [SmokeMethod("create(WId, bool)")]
        protected virtual void Create(uint arg1, bool initializeWindow) {
            interceptor.Invoke("create$$", "create(WId, bool)", typeof(void), typeof(uint), arg1, typeof(bool), initializeWindow);
        }
        [SmokeMethod("create(WId)")]
        protected virtual void Create(uint arg1) {
            interceptor.Invoke("create$", "create(WId)", typeof(void), typeof(uint), arg1);
        }
        [SmokeMethod("create()")]
        protected virtual void Create() {
            interceptor.Invoke("create", "create()", typeof(void));
        }
        [SmokeMethod("wheelEvent(QWheelEvent*)")]
        protected override void WheelEvent(QWheelEvent ev) {
            interceptor.Invoke("wheelEvent#", "wheelEvent(QWheelEvent*)", typeof(void), typeof(QWheelEvent), ev);
        }
        [SmokeMethod("minimumSizeHint() const")]
        protected new virtual QSize MinimumSizeHint() {
            return (QSize) interceptor.Invoke("minimumSizeHint", "minimumSizeHint() const", typeof(QSize));
        }
        /// <remarks>
        ///  Completes text according to the completion mode.
        ///  Note: this method is <code>not</code> invoked if the completion mode is
        ///  set to CompletionNone.  Also if the mode is set to <code>CompletionShell</code>
        ///  and multiple matches are found, this method will complete the
        ///  text to the first match with a beep to inidicate that there are
        ///  more matches.  Then any successive completion key event iterates
        ///  through the remaining matches.  This way the rotation functionality
        ///  is left to iterate through the list as usual.
        ///     </remarks>        <short>    Completes text according to the completion mode.</short>
        [Q_SLOT("void makeCompletion(QString)")]
        [SmokeMethod("makeCompletion(const QString&)")]
        protected virtual void MakeCompletion(string arg1) {
            interceptor.Invoke("makeCompletion$", "makeCompletion(const QString&)", typeof(void), typeof(string), arg1);
        }
        ~KComboBox() {
            interceptor.Invoke("~KComboBox", "~KComboBox()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KComboBox", "~KComboBox()", typeof(void));
        }
        /// <remarks>
        ///  Returns a pointer to the current completion object.
        ///  If the completion object does not exist, it is automatically created and
        ///  by default handles all the completion signals internally unless <code>hsig</code>
        ///  is set to false. It is also automatically destroyed when the destructor
        ///  is called. You can change this default behavior using the
        ///  <see cref="#setAutoDeleteCompletionObject"></see> and <see cref="#setHandleSignals"></see> member
        ///  functions.
        ///  See also <see cref="#compObj"></see>.
        /// <param> name="hsig" if true, handles completion signals internally.
        /// </param></remarks>        <return> a pointer the completion object.
        ///      </return>
        ///         <short>    Returns a pointer to the current completion object.</short>
        public KCompletion CompletionObject(bool hsig) {
            return (KCompletion) interceptor.Invoke("completionObject$", "completionObject(bool)", typeof(KCompletion), typeof(bool), hsig);
        }
        public KCompletion CompletionObject() {
            return (KCompletion) interceptor.Invoke("completionObject", "completionObject()", typeof(KCompletion));
        }
        /// <remarks>
        ///  Sets up the completion object to be used.
        ///  This method assigns the completion object and sets it up to automatically
        ///  handle the completion and rotation signals internally.  You should use
        ///  this function if you want to share one completion object among your
        ///  widgets or need to use a customized completion object.
        ///  The object assigned through this method is not deleted when this object's
        ///  destructor is invoked unless you explicitly call <see cref="#setAutoDeleteCompletionObject"></see>
        ///  after calling this method. Be sure to set the bool argument to false, if
        ///  you want to handle the completion signals yourself.
        /// <param> name="compObj" a KCompletion() or a derived child object.
        /// </param><param> name="hsig" if true, handles completion signals internally.
        ///      </param></remarks>        <short>    Sets up the completion object to be used.</short>
        [SmokeMethod("setCompletionObject(KCompletion*, bool)")]
        public virtual void SetCompletionObject(KCompletion compObj, bool hsig) {
            interceptor.Invoke("setCompletionObject#$", "setCompletionObject(KCompletion*, bool)", typeof(void), typeof(KCompletion), compObj, typeof(bool), hsig);
        }
        [SmokeMethod("setCompletionObject(KCompletion*)")]
        public virtual void SetCompletionObject(KCompletion compObj) {
            interceptor.Invoke("setCompletionObject#", "setCompletionObject(KCompletion*)", typeof(void), typeof(KCompletion), compObj);
        }
        /// <remarks>
        ///  Enables this object to handle completion and rotation
        ///  events internally.
        ///  This function simply assigns a boolean value that
        ///  indicates whether it should handle rotation and
        ///  completion events or not.  Note that this does not
        ///  stop the object from emitting signals when these
        ///  events occur.
        /// <param> name="handle" if true, handle completion & rotation internally.
        ///      </param></remarks>        <short>    Enables this object to handle completion and rotation  events internally.</short>
        [SmokeMethod("setHandleSignals(bool)")]
        public virtual void SetHandleSignals(bool handle) {
            interceptor.Invoke("setHandleSignals$", "setHandleSignals(bool)", typeof(void), typeof(bool), handle);
        }
        /// <remarks>
        ///  Returns true if the completion object is deleted
        ///  upon this widget's destruction.
        ///  See setCompletionObject() and enableCompletion()
        ///  for details.
        /// </remarks>        <return> true if the completion object will be deleted
        ///               automatically
        ///      </return>
        ///         <short>    Returns true if the completion object is deleted  upon this widget's destruction.</short>
        public bool IsCompletionObjectAutoDeleted() {
            return (bool) interceptor.Invoke("isCompletionObjectAutoDeleted", "isCompletionObjectAutoDeleted() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets the completion object when this widget's destructor
        ///  is called.
        ///  If the argument is set to true, the completion object
        ///  is deleted when this widget's destructor is called.
        /// <param> name="autoDelete" if true, delete completion object on destruction.
        ///      </param></remarks>        <short>    Sets the completion object when this widget's destructor  is called.</short>
        public void SetAutoDeleteCompletionObject(bool autoDelete) {
            interceptor.Invoke("setAutoDeleteCompletionObject$", "setAutoDeleteCompletionObject(bool)", typeof(void), typeof(bool), autoDelete);
        }
        /// <remarks>
        ///  Sets the widget's ability to emit text completion and
        ///  rotation signals.
        ///  Invoking this function with <code>enable</code> set to <code>false</code> will
        ///  cause the completion & rotation signals not to be emitted.
        ///  However, unlike setting the completion object to <code>NULL</code>
        ///  using setCompletionObject, disabling the emition of
        ///  the signals through this method does not affect the current
        ///  completion object.
        ///  There is no need to invoke this function by default.  When a
        ///  completion object is created through completionObject or
        ///  setCompletionObject, these signals are set to emit
        ///  automatically.  Also note that disabling this signals will not
        ///  necessarily interfere with the objects ability to handle these
        ///  events internally.  See setHandleSignals.
        /// <param> name="enable" if false, disables the emition of completion & rotation signals.
        ///      </param></remarks>        <short>    Sets the widget's ability to emit text completion and  rotation signals.</short>
        public void SetEnableSignals(bool enable) {
            interceptor.Invoke("setEnableSignals$", "setEnableSignals(bool)", typeof(void), typeof(bool), enable);
        }
        /// <remarks>
        ///  Returns true if the object handles the signals.
        /// </remarks>        <return> true if this signals are handled internally.
        ///      </return>
        ///         <short>    Returns true if the object handles the signals.</short>
        public bool HandleSignals() {
            return (bool) interceptor.Invoke("handleSignals", "handleSignals() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns true if the object emits the signals.
        /// </remarks>        <return> true if signals are emitted
        ///      </return>
        ///         <short>    Returns true if the object emits the signals.</short>
        public bool EmitSignals() {
            return (bool) interceptor.Invoke("emitSignals", "emitSignals() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets the type of completion to be used.
        ///  The completion modes supported are those defined in
        ///  KGlobalSettings().  See below.
        /// <param> name="mode" Completion type:
        /// </param>
        /// <li>
        /// CompletionNone:  Disables completion feature.
        /// </li>
        /// 
        /// <li>
        /// CompletionAuto:  Attempts to find a match &
        ///                         fills-in the remaining text.
        /// </li>
        /// 
        /// <li>
        /// CompletionMan:   Acts the same as the above
        ///                         except the action has to be
        ///                         manually triggered through
        ///                         pre-defined completion key.
        /// </li>
        /// 
        /// <li>
        /// CompletionShell: Mimics the completion feature
        ///                         found in typical nix shell
        ///                         environments.
        /// </li>
        /// 
        /// <li>
        /// CompletionPopup: Shows all available completions at once,
        ///                         in a listbox popping up.
        ///      
        /// </li></remarks>        <short>    Sets the type of completion to be used.</short>
        [SmokeMethod("setCompletionMode(KGlobalSettings::Completion)")]
        public virtual void SetCompletionMode(KGlobalSettings.Completion mode) {
            interceptor.Invoke("setCompletionMode$", "setCompletionMode(KGlobalSettings::Completion)", typeof(void), typeof(KGlobalSettings.Completion), mode);
        }
        /// <remarks>
        ///  Returns the current completion mode.
        ///  The return values are of type KGlobalSettings.Completion.
        ///  See setCompletionMode() for details.
        /// </remarks>        <return> the completion mode.
        ///      </return>
        ///         <short>    Returns the current completion mode.</short>
        public KGlobalSettings.Completion CompletionMode() {
            return (KGlobalSettings.Completion) interceptor.Invoke("completionMode", "completionMode() const", typeof(KGlobalSettings.Completion));
        }
        /// <remarks>
        ///  Sets the key-binding to be used for manual text
        ///  completion, text rotation in a history list as
        ///  well as a completion list.
        ///  When the keys set by this function are pressed, a
        ///  signal defined by the inheriting widget will be activated.
        ///  If the default value or 0 is specified by the second
        ///  parameter, then the key-binding as defined in the global
        ///  setting should be used.  This method returns false value
        ///  for <code>key</code> is negative or the supplied key-binding conflicts
        ///  with the ones set for one of the other features.
        ///  NOTE: To use a modifier key (Shift, Ctrl, Alt) as part of
        ///  the key-binding simply simply <code>sum</code> up the values of the
        ///  modifier and the actual key.  For example, to use CTRL+E as
        ///  a key binding for one of the items, you would simply supply
        ///  <code></code>"Qt.CtrlButton + Qt.Key_E" as the second argument to this
        ///  function.
        /// <param> name="item" the feature whose key-binding needs to be set:
        /// </param>
        /// <li>
        /// TextCompletion the manual completion key-binding.
        /// </li>
        /// 
        /// <li>
        /// PrevCompletionMatch    the previous match key for multiple completion.
        /// </li>
        /// 
        /// <li>
        /// NextCompletionMatch    the next match key for for multiple completion.
        /// </li>
        /// 
        /// <li>
        /// SubstringCompletion  the key for substring completion
        /// </li>
        /// <param> name="key" key-binding used to rotate down in a list.
        /// </param></remarks>        <return> true if key-binding can successfully be set.
        /// </return>
        ///         <short>    Sets the key-binding to be used for manual text  completion, text rotation in a history list as  well as a completion list.</short>
        ///         <see> getKeyBinding</see>
        public bool SetKeyBinding(KCompletionBase.KeyBindingType item, KShortcut key) {
            return (bool) interceptor.Invoke("setKeyBinding$#", "setKeyBinding(KCompletionBase::KeyBindingType, const KShortcut&)", typeof(bool), typeof(KCompletionBase.KeyBindingType), item, typeof(KShortcut), key);
        }
        /// <remarks>
        ///  Returns the key-binding used for the specified item.
        ///  This methods returns the key-binding used to activate
        ///  the feature feature given by <code>item.</code>  If the binding
        ///  contains modifier key(s), the SUM of the modifier key
        ///  and the actual key code are returned.
        /// <param> name="item" the item to check
        /// </param></remarks>        <return> the key-binding used for the feature given by <code>item.</code>
        /// </return>
        ///         <short>    Returns the key-binding used for the specified item.</short>
        ///         <see> setKeyBinding</see>
        public KShortcut GetKeyBinding(KCompletionBase.KeyBindingType item) {
            return (KShortcut) interceptor.Invoke("getKeyBinding$", "getKeyBinding(KCompletionBase::KeyBindingType) const", typeof(KShortcut), typeof(KCompletionBase.KeyBindingType), item);
        }
        /// <remarks>
        ///  Sets this object to use global values for key-bindings.
        ///  This method changes the values of the key bindings for
        ///  rotation and completion features to the default values
        ///  provided in KGlobalSettings.
        ///  NOTE: By default inheriting widgets should uses the
        ///  global key-bindings so that there will be no need to
        ///  call this method.
        ///      </remarks>        <short>    Sets this object to use global values for key-bindings.</short>
        public void UseGlobalKeyBindings() {
            interceptor.Invoke("useGlobalKeyBindings", "useGlobalKeyBindings()", typeof(void));
        }
        /// <remarks>
        ///  Returns a pointer to the completion object.
        ///  This method is only different from completionObject()
        ///  in that it does not create a new KCompletion object even if
        ///  the internal pointer is <code>NULL.</code> Use this method to get the
        ///  pointer to a completion object when inheriting so that you
        ///  won't inadvertently create it!!
        /// </remarks>        <return> the completion object or @c NULL if one does not exist.
        ///      </return>
        ///         <short>    Returns a pointer to the completion object.</short>
        public KCompletion CompObj() {
            return (KCompletion) interceptor.Invoke("compObj", "compObj() const", typeof(KCompletion));
        }
        /// <remarks>
        ///  Returns a key-binding map.
        ///  This method is the same as getKeyBinding() except it
        ///  returns the whole keymap containing the key-bindings.
        /// </remarks>        <return> the key-binding used for the feature given by <code>item.</code>
        ///      </return>
        ///         <short>    Returns a key-binding map.</short>
        /// <remarks>
        ///  Sets or removes the delegation object. If a delegation object is
        ///  set, all function calls will be forwarded to the delegation object.
        /// <param> name="delegate" the delegation object, or 0 to remove it
        ///      </param></remarks>        <short>    Sets or removes the delegation object.</short>
        protected void SetDelegate(IKCompletionBase arg1) {
            interceptor.Invoke("setDelegate#", "setDelegate(KCompletionBase*)", typeof(void), typeof(IKCompletionBase), arg1);
        }
        /// <remarks>
        ///  Returns the delegation object.
        /// </remarks>        <return> the delegation object, or 0 if there is none
        /// </return>
        ///         <short>    Returns the delegation object.</short>
        ///         <see> setDelegate</see>
        protected IKCompletionBase Delegate() {
            return (IKCompletionBase) interceptor.Invoke("delegate", "delegate() const", typeof(IKCompletionBase));
        }
        protected new IKComboBoxSignals Emit {
            get { return (IKComboBoxSignals) Q_EMIT; }
        }
    }

    public interface IKComboBoxSignals : IQComboBoxSignals {
        /// <remarks>
        ///  Emitted when the user presses the Enter key.
        ///  Note that this signal is only emitted when the widget is editable.
        ///     </remarks>        <short>    Emitted when the user presses the Enter key.</short>
        [Q_SIGNAL("void returnPressed()")]
        void ReturnPressed();
        /// <remarks>
        ///  Emitted when the user presses the Enter key.
        ///  The argument is the current text being edited.  This signal is just like
        ///  returnPressed() except it contains the current text as its argument.
        ///  Note that this signal is only emitted when the
        ///  widget is editable.
        ///     </remarks>        <short>    Emitted when the user presses the Enter key.</short>
        [Q_SIGNAL("void returnPressed(QString)")]
        void ReturnPressed(string arg1);
        /// <remarks>
        ///  Emitted when the completion key is pressed.
        ///  The argument is the current text being edited.
        ///  Note that this signal is <b>not</b> available when the widget is non-editable
        ///  or the completion mode is set to <code>KGlobalSettings</code>.CompletionNone.
        ///     </remarks>        <short>    Emitted when the completion key is pressed.</short>
        [Q_SIGNAL("void completion(QString)")]
        void Completion(string arg1);
        /// <remarks>
        ///  Emitted when the shortcut for substring completion is pressed.
        ///      </remarks>        <short>    Emitted when the shortcut for substring completion is pressed.</short>
        [Q_SIGNAL("void substringCompletion(QString)")]
        void SubstringCompletion(string arg1);
        /// <remarks>
        ///  Emitted when the text rotation key-bindings are pressed.
        ///  The argument indicates which key-binding was pressed. In this case this
        ///  can be either one of four values: <code>PrevCompletionMatch</code>,
        ///  <code>NextCompletionMatch</code>, <code>RotateUp</code> or <code>RotateDown.</code> See
        ///  KCompletionBase.SetKeyBinding() for details.
        ///  Note that this signal is <b>NOT</b> emitted if the completion
        ///  mode is set to CompletionNone.
        ///     </remarks>        <short>    Emitted when the text rotation key-bindings are pressed.</short>
        [Q_SIGNAL("void textRotation(KCompletionBase::KeyBindingType)")]
        void TextRotation(KCompletionBase.KeyBindingType arg1);
        /// <remarks>
        ///  Emitted whenever the completion mode is changed by the user
        ///  through the context menu.
        ///      </remarks>        <short>    Emitted whenever the completion mode is changed by the user  through the context menu.</short>
        [Q_SIGNAL("void completionModeChanged(KGlobalSettings::Completion)")]
        void CompletionModeChanged(KGlobalSettings.Completion arg1);
        /// <remarks>
        ///  Emitted before the context menu is displayed.
        ///  The signal allows you to add your own entries into the context menu.
        ///  Note that you MUST NOT store the pointer to the QPopupMenu since it is
        ///  created and deleted on demand.  Otherwise, you can crash your app.
        /// <param> name="p" the context menu about to be displayed
        ///      </param></remarks>        <short>    Emitted before the context menu is displayed.</short>
        [Q_SIGNAL("void aboutToShowContextMenu(QMenu*)")]
        void AboutToShowContextMenu(QMenu p);
    }
}
