/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.io;

import java.io.IOException;
import java.io.InputStream;

public class CharPosInputStream
extends InputStream {
    private InputStream in = null;
    private int charCount = 1;
    private int lineNo = 1;
    private int colNo = 1;
    private boolean prevWasCR = false;

    public CharPosInputStream(InputStream r) {
        this.in = r;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumn() {
        return this.colNo;
    }

    public int getCharPos() {
        return this.charCount;
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (c != -1) {
            ++this.charCount;
            if (c == 13) {
                ++this.lineNo;
                this.colNo = 1;
                this.prevWasCR = true;
            } else if (c == 10) {
                if (!this.prevWasCR) {
                    ++this.lineNo;
                    this.colNo = 1;
                } else {
                    this.prevWasCR = false;
                }
            } else {
                ++this.colNo;
                this.prevWasCR = false;
            }
        }
        return c;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int charsRead = 0;
        while (charsRead < len) {
            int c = this.in.read();
            if (c == -1) {
                if (charsRead == 0) {
                    return -1;
                }
                return charsRead;
            }
            buf[off + charsRead] = (byte)c;
            ++charsRead;
            ++this.charCount;
            if (c == 13) {
                ++this.lineNo;
                this.colNo = 1;
                this.prevWasCR = true;
                break;
            }
            if (c == 10) {
                if (!this.prevWasCR) {
                    ++this.lineNo;
                    this.colNo = 1;
                    break;
                }
                this.prevWasCR = false;
                continue;
            }
            ++this.colNo;
            this.prevWasCR = false;
        }
        return charsRead;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

