#ifndef _DAVIS_MALLOC_H__
#define _DAVIS_MALLOC_H__
/*
 *  Copyright (c) 1993, 1994 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */

/* system specific malloc prototypes and macros. */

#ifdef msdos
#  define VOID void
#  ifdef MSC /* Changes for MS (Quick)C */
#    define FREE(buf)  _ffree((void far *)(buf))
#    define MALLOC(x) _fmalloc((unsigned long) (x))
#    define REALLOC(buf, n) _frealloc((void far *) (buf), (unsigned long) (n))
#    define CALLOC(n, m) _fcalloc((unsigned long) (n), (unsigned long) (m))
#  else
#    include <alloc.h>
#    define FREE(buf)  farfree((void far *)(buf))
#    define MALLOC(x) farmalloc((unsigned long) (x))
#    define REALLOC(buf, n) farrealloc((void far *) (buf), (unsigned long) (n))
#    define CALLOC(n, m) farcalloc((unsigned long) (n), (unsigned long) (m))
#  endif
#else
#  ifndef VMS
#    ifndef sequent
#    ifndef ISC
#      include <malloc.h>
#    endif
#    endif
#  endif
#  ifdef __os2__
#    define VOID void
#  else
#    define VOID unsigned char
#  endif
#  define FREE(p) free((VOID *)(p))
#  define MALLOC malloc
#  define REALLOC realloc
#  define CALLOC calloc
#endif


/* _DAVIS_MALLOC_H__ */
#endif 
