#include "includes.h"
#include "client.h"

int term_debug = 0;
int verbose = 0;

static int local_options ( char opt, char *optarg )
{
  switch(opt)
  {
  case 'v' :
    verbose = 1; 
    break;
  default:
    return -1;
  }
  return 0;
}

void main(int argc, char *argv[]) {
  int s;

  (void) client_options(argc, argv,"v",local_options);

#ifdef SHAREDIR
  set_share_mode();
#endif
  seteuid(getuid());
  setegid(getgid());

  if ((s = connect_server(term_server)) <0) {
    perror("Couldn't open term");
    exit(1);
  }

  if (verbose) 
    printf ("Shutting down remote...\n");
  if (send_command(s, C_QUIT, 0, 0) < 0)
    fprintf(stderr,"Couldn't shutdown remote: %u\n", term_errno);
  if (verbose)
    printf ("Shutting down local...\n");
  if (send_command(s, C_QUIT, 1, 0) < 0)
    fprintf(stderr,"Couldn't shutdown local: %u\n", term_errno);
}
