/* File managing
   Copyright (C) 1994 Miguel de Icaza.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <dirent.h>
#include <stdio.h>
#include <errno.h>
#include <ncurses.h>
#include "dialog.h"

static char rcsid [] = "$Header: /usr/users/miguel/c/CVS/nc/file.c,v 1.2 1994/05/14 21:34:44 miguel Exp $";
static char x [4096];
extern char *sys_errlist [];
int verbose = 1;

void copy_file_file (char *s, char *d)
{
    sprintf (x, "/bin/cp %s %s", s, d);
    system (x);
}

void copy_file_dir (char *s, char *d)
{
    sprintf (x, "/bin/cp %s %s", s, d);
    system (x);
}

int move_file (char *s, char *d)
{
    sprintf (x, "/bin/mv %s %s", s, d);
    system (x);
    return 1;
}

int move_file_dir (char *s, char *d)
{
    move_file (s, d);
}

int erase_file (char *s)
{
    int error;

    if (verbose)
	message (D_INSERT, " Delete ", " Deleting file %s ", s);
    error = unlink (s);
    if (verbose) done_dialog ();
    if (error){
	message (1, " Error ", sys_errlist [errno]);
	return 0;
    }
    return 1;
}

int erase_dir (char *s)
{
    int error = rmdir (s);
    if (error){
	message (1, " Error ", sys_errlist [errno]);
	return 0;
    }
    return 1;
}

FILE *mopen (char *filename, char *mode)
{
    FILE *f;
    
    if ((f = fopen (filename, mode)) == NULL){
	message (1, " Error ", " Can't open '%s' ", filename);
	return 0;
    }
    return f;
}
