/* Various utilities
   Copyright (C) 1994 Miguel de Icaza, Mauricio Plaza.
   The file_date routine is mostly from GNU's fileutils package,
   written by Richard Stallman and David MacKenzie.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <pwd.h>
#include <grp.h>
#ifdef linux
#include <regex.h>
#endif
#include "util.h"
#include "global.h"

static char rcsid [] = "$Header: /usr/users/miguel/c/CVS/nc/util.c,v 1.2 1994/05/14 21:35:05 miguel Exp $";

static char app_text [] = "MouseLess-Commander";

int easy_patterns = 1;
int align_extensions = 1;

#ifdef ultrix
char *strdup (char *s)
{
    char *t = malloc (strlen (s)+1);
    strcpy (t, s);
    return t;
}
#endif

/* Returns the message dimensions (lines and columns) */
int msglen (char *text, int *lines)
{
    int max = 0;
    int line_len = 0;
    
    for (*lines = 1;*text; text++){
	if (*text == '\n'){
	    line_len = 0;
	    (*lines)++;
	}
	line_len++;
	if (line_len > max)
	    max = line_len;
    }
    return max;
}

char *trim (char *s, char *d, int len)
{
    char *ptr;
  
    if (strlen (s) > len){
	strncpy (d, s, len-3);
	d [len-2] = '.';
	d [len-1] = '.';
	d [len] = 0;
    } else
	strcpy (d, s);
    return d;
}

char *name_trunc (char *txt, int trunc_len)
{
    static char x [150];

    if (trunc_len > sizeof (x)+1){
	fprintf (stderr, "name_trunc: too big");
	trunc_len = sizeof (x)-1;
    }
    if (strlen (txt) <= trunc_len)
	return txt;
    
    strncpy (x, txt, trunc_len-1);
    x [trunc_len] = 0;
    x [trunc_len-1] = '>';
    return x;
}

char *size_trunc (long int size)
{
    static char x [30];
    long int divisor = 1;
    char *xtra = "";
    
    if (size > 999999999L){
	divisor = 1024;
	xtra = "kb";
	if (size/divisor > 999999999L){
	    divisor = 1024*1024;
	    xtra = "Mb";
	}
    }
    sprintf (x, "%ld%s", (size/divisor), xtra);
    return x;
}

int is_exe (mode_t mode)
{
    if ((S_IXUSR & mode) || (S_IXGRP & mode) || (S_IXOTH & mode))
	return 1;
    return 0;
}

#define ismode(n,m) ((n & m) == m)

char *string_perm (mode_t mode_bits)
{
    static char mode [11];

    strcpy (mode, "----------");
    if (ismode (mode_bits, S_IFSOCK)) mode [0] = 's';
    if (ismode (mode_bits, S_IXOTH)) mode [9] = 'x';
    if (ismode (mode_bits, S_IWOTH)) mode [8] = 'w';
    if (ismode (mode_bits, S_IROTH)) mode [7] = 'r';
    if (ismode (mode_bits, S_IXGRP)) mode [6] = 'x';
    if (ismode (mode_bits, S_IWGRP)) mode [5] = 'w';
    if (ismode (mode_bits, S_IRGRP)) mode [4] = 'r';
    if (ismode (mode_bits, S_IXUSR)) mode [3] = 'x';
    if (ismode (mode_bits, S_IWUSR)) mode [2] = 'w';
    if (ismode (mode_bits, S_IRUSR)) mode [1] = 'r';
    if (ismode (mode_bits, S_ISUID)) mode [0] = 'S';
    if (ismode (mode_bits, S_IFCHR)) mode [0] = 'c';
    if (ismode (mode_bits, S_IFBLK)) mode [0] = 'b';
    if (ismode (mode_bits, S_ISVTX)) mode [0] = 'i';
    if (ismode (mode_bits, S_IFDIR)) mode [0] = 'd';
    if (ismode (mode_bits, S_IFLNK)) mode [0] = 'l';
    
    return mode;
}

char *strip_home(char *dir)
{
    static char newdir [MAXPATHLEN];

    if (home_dir && !strncmp (dir, home_dir, strlen (home_dir))){
	newdir [0] = '~';
	strcpy (&newdir [1], &dir [strlen (home_dir)]);
	return newdir;
    } else
	return dir;
}

/* 1 if string matches
   0 if string doesn't match
   -1 if error in pattern */

int regexp_match (char *pattern, char *string)
{
    char *s, *d;
    char new_pattern [100];
    char *x;
#ifdef linux
    static regex_t r;
    static char *old;
    static int first_time = 1;
#endif

    x = pattern;
    if (easy_patterns){
	for (s = pattern, d = new_pattern; *s; s++, d++){
	    switch (*s){
	    case '*':
		*d++ = '.';
		*d   = '*';
		break;
		
	    case '?':
		*d++ = '.';
		break;
		
	    case '.':
		*d++ = '\\';
		*d   = '.';
	    default:
		*d = *s;
	    }
	}
	*d = 0;
	pattern = new_pattern;
    }
#ifdef linux
    if (old != x){
	if (first_time)
	    first_time = 0;
	else
	    regfree (&r);
        if (regcomp (&r, pattern, REG_EXTENDED|REG_NOSUB)){
	    return -1;
        }
    }
    old = x;
    return !regexec (&r, string, 0, NULL, 0);
#else
    if (re_comp (pattern)){
	return -1;
    }
    return re_exec (string);
#endif    
}

char *extension (char *filename)
{
    char *d;

    if (!strlen (filename))
	return "";
    
    d = filename + strlen (filename) - 1;
    for (;d >= filename; d--){
	if (*d == '.')
	    return d+1;
    }
    return "";
}

/* This routine uses the fact that x is at most 14 chars or so */
char *split_extension (char *x, int pad)
{
    return x;

    /* Buggy code 
    if (!align_extensions)
	return x;

    if (strlen (x) >= pad)
	return x;
    
    if ((ext = extension (x)) == x || *ext == 0)
	return x;

    strcpy (xbuf, x);
    for (i = strlen (x); i < pad; i++)
	xbuf [i] = ' ';
    xbuf [pad] = 0;

    l = strlen (ext);
    for (i = 0; i < l; i++)
	xbuf [pad-i] = *(ext+l-i-1);
    for (i = xbuf + (ext - x); i < 
    return xbuf; */
}

void *xmalloc (int size, char *source)
{
    void *m = malloc (size);

    if (!m){
	fprintf (stderr, "memory exhausted in module (%s)\n");
	exit (1);
    }
    return m;
}

int get_int (char *file, char *key, int def)
{
    return GetPrivateProfileInt (app_text, key, def, file);
}

int set_int (char *file, char *key, int value)
{
    char buffer [6];

    sprintf (buffer,  "%d", value);
    return WritePrivateProfileString (app_text, key, buffer, file);
}

int exist_file (char *name)
{
    return access (name, R_OK) == 0;
}

char *load_file (char *filename)
{
    FILE *data_file;
    struct stat s;
    char *data;
    
    if (stat (filename, &s) != 0){
	message (1, " Error ", " Can't stat file %s ", filename);
	return 0;
    }
    if ((data_file = fopen (filename, "r")) == NULL){
	message (1, " Error ", " Can't open file %s ", filename);
	return 0;
    }
    data = (char *) xmalloc (s.st_size+1, "help, load_file");
    fread (data, s.st_size, 1, data_file);
    data [s.st_size] = 0;
    fclose (data_file);
    return data;
}

char *get_owner (int uid)
{
    struct passwd *pwd;
    static char ibuf [8];
    
    pwd = getpwuid (uid);
    if (pwd)
	return pwd->pw_name;
    else {
	sprintf (ibuf, "%d", uid);
	return ibuf;
    }
}

char *get_group (int gid)
{
    struct group *grp;
    static char gbuf [8];
    
    grp = getgrgid (gid);
    if (grp)
	return grp->gr_name;
    else {
	sprintf (gbuf, "%d", gid);
	return gbuf;
    }
}

char *file_date (time_t when)
{
    static char timebuf [40];
    time_t current_time = time ((time_t) 0);

    strcpy (timebuf, ctime (&when));
    if (current_time > when + 6L * 30L * 24L * 60L * 60L /* Old. */
	|| current_time < when - 60L * 60L) /* In the future. */
    {
	/* The file is fairly old or in the future.
	   POSIX says the cutoff is 6 months old;
	   approximate this by 6*30 days.
	   Allow a 1 hour slop factor for what is considered "the future",
	   to allow for NFS server/client clock disagreement.
	   Show the year instead of the time of day.  */
	strcpy (timebuf + 11, timebuf + 19);
    }
    timebuf[16] = 0;
    return &timebuf [4];
}

char *extract_line (char *s, char *top)
{
    static char tmp_line [500];
    char *t = tmp_line;
    
    while (*s && *s != '\n' && (t - tmp_line) < sizeof (tmp_line)-1 && s < top)
	*t++ = *s++;
    *t = 0;
    return tmp_line;
}

char *icase_search (char *text, char *data)
{
    char *d = text;
    char *e = data;
    
    for (;*e; e++){
	if ((*d | 0x20) == (*e | 0x20))
	    d++;
	else
	    d = text;
	if (!*d)
	    return e+1;
    }
    return 0;
}
