/* vgahico.c - used by ET4000 driver. */
/* Set Hicolor RAMDAC mode.
 *
 * HH: Added support for 24-bit Sierra RAMDAC (15025/6) (untested).
 */


#include "vga.h"
#include "libvga.h"
#include "driver.h"

int __vga_hicolor(int dac_type, int mode)
/* Enters hicolor mode - 0 for no hi, 1 for 15 bit, 2 for 16, 3 for 24 */
/* For any modes it doesn't know about, etc, it attempts to turn hicolor off. */
{
	int x;

	port_in(0x3C8);		/* Clears register funny mode */
	port_in(0x3C6);
	port_in(0x3C6);
	port_in(0x3C6);
	port_in(0x3C6);
	x = port_in(0x3c6);
	port_in(0x3C8);		/* Clears register funny mode */
	port_in(0x3C6);
	port_in(0x3C6);
	port_in(0x3C6);
	port_in(0x3C6);
	switch (dac_type & ~1)
	{
	    case 0:	/* Sierra SC11486 */
		if (mode == HI15_DAC)
		    port_out( x | 0x80, 0x3c6);
		else
		    port_out( x & ~0x80, 0x3c6);
		break;
	    case 2:	/* Sierra Mark2/Mark3 */
		switch (mode)
		{
		case HI15_DAC:
		    /* port_out( (x | 0x80) & ~0x40, 0x3c6); */
		    port_out( (x & 0x1f) | 0xa0, 0x3c6);
		    break;
		case HI16_DAC:
		    /* port_out( x | 0xC0, 0x3c6); */
		    port_out( (x & 0x1f) | 0xe0, 0x3c6);
		    break;
		default:
		    port_out( x & ~0xC0, 0x3c6);
		    break;
		}
		break;
	    case 4:	/* Diamond SS2410 */
		if (mode == HI15_DAC)
		    port_out( x | 0x80, 0x3c6);
		else
		    port_out( x & ~0x80, 0x3c6);
		break;
	    case 8:	/* AT&T 20c491/2 */
		switch (mode)
		{
		case HI15_DAC:
		    port_out((x & 0x1f) | 0xA0, 0x3C6);
		    break;
		case HI16_DAC:
		    port_out((x & 0x1f) | 0xC0, 0x3C6);
		    break;
		case TC24_DAC:
		    port_out((x & 0x1f) | 0xE0, 0x3C6);
		    break;
		default:
		    port_out(x & 0x1F, 0x3C6);
		    break;
		}
		break;
	    case 16:	/* AcuMos ADAC1 */
		switch (mode)
		{
		case HI15_DAC:
		    port_out(0xF0, 0x3C6);
		    break;
		case HI16_DAC:
		    port_out(0xE1, 0x3C6);
		    break;
		case TC24_DAC:
		    port_out(0xE5, 0x3C6);
		    break;
		default:
		    port_out(0, 0x3C6);
		    break;
		}
		break;
	    case 32:	/* Sierra 15025/6 24-bit DAC */
		switch (mode)
		{
		case HI15_DAC:
		    port_out((x & 0x1f) | 0xa0 , 0x3C6);
		    /* 0xa0 is also a 15-bit mode. */
		    break;
		case HI16_DAC:
		    port_out((x & 0x1f) | 0xe0, 0x3C6);
		    /* 0xc0 is also a 16-bit mode. */
		    /* 0xc0 doesn't seem to work, so use 0xe0. */
		    break;
		case TC24_DAC:
		    port_out((x & 0x1f) | 0x60, 0x3C6);
		    break;
		default:
		    port_out(x & 0x1f, 0x3C6);
		    break;
		}
		break;
	default:
		/* Normal VGA mode. */
		port_out(x & 0x1F, 0x3c6);
		break;
	}
	port_in(0x3C8);

	return 0;
}
