#include <OI/oi.H>


/*
 *	translations - using translations to notify enter/leave callbacks
 *
 *	This program demonstrates the use of the translation mechanism
 *	to add enter/leave callbacks to a set of glyphs.
 *
 *	The reader should refer back to the README file for
 *	other translations examples.
 *
 */

void
enter( OI_d_tech* obj, const XEvent*, const char **, unsigned int*)
{
	fprintf( stderr, "+%s ", obj->name() );
}
void
leave( OI_d_tech* obj, const XEvent*, const char **, unsigned int*)
{
	fprintf( stderr, "-%s ", obj->name() );
}

static OI_actions_rec myactions[] = {
	{"enter",	(OI_translation_fn *)&enter},
	{"leave",	(OI_translation_fn *)&leave},
};
static	char *Glyph_translations = "#override	\n\
		<EnterNotify>:	enter()			\n\
		<LeaveNotify>:	leave()			\n\
	";

void
populate_with_glyphs( OI_app_window * win )
{
	int		i;
	char		buf[ 32 ];
	OI_glyph	*gl;

	for (i=0; i<16; i++) {
		sprintf( buf, "glyph%d", i );
		gl = oi_create_glyph( buf, "../bitmaps/pps-logo.xbm", NULL, OI_PIC_MASK, OI_NO , OI_YES);
		gl->layout_associated_object( win, i%4, i/4, OI_ACTIVE );
		gl->override_translations( Glyph_translations );
	}
}

void
main( int argc, char ** argv )
{
	OI_app_window	* win;

	OI_init( &argc, argv );
	OI_add_actions(myactions, OI_count(myactions));
	win = oi_create_app_window( "main", 1, 1, "main" );
	win->set_layout( OI_layout_row );
	populate_with_glyphs( win );
	win->set_associated_object( win->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE );
	OI_begin_interaction();
	OI_fini();
}
