------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                           S Y S T E M . F F D                            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--             Copyright (c) 1992,1993, NYU, All Rights Reserved            --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms  of the GNU  General  Public  License  as  published  by the  Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  GNAT is distributed  in the hope  that it will be useful,  but --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License  for  more details.  You should have received  a copy of the GNU --
-- General Public License along with GNAT;  see file COPYING. If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the generic package which is instantiated with
--  predefined integer types to generate the runtime functions called by the
--  expanded code generated by Expand_Fixed_To_Fixed_Division. This
--  is an implementation of Paul Hilfinger's algorithms.

package System.Ffd is
pragma Pure (Ffd);

   generic
      type Int_Type is range <>;

   package Ffd_Util is

      function Compute_Result
        (X, Y, B : Int_Type;
         M       : Integer;
         Eps_Neg : Boolean)
         return    Int_Type;
      --  X and Y correspond to the two values of the division (X / Y).
      --  M and B correspond to scaling factors (B * (2 ** M)).
      --  The boolean parameter is computed in the expander and corresponds to
      --  different cases of Hilfinger's algorithms. It enables this function
      --  to compute the result in different ways depending on its value.

   end Ffd_Util;

end System.Ffd;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.1
--  date: Fri Jul 15 13:28:02 1994;  author: crozes
--  Initial revision
--  ----------------------------
--  revision 1.2
--  date: Tue Aug  2 12:21:46 1994;  author: dewar
--  Add pragma Pure
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
