.TH XFM 1 "May 16 1994" "X Version 11"
.SH NAME
xfm \- X file and applications manager

.SH SYNOPSIS
.B xfm
[\fIoptions\fP ...]
.sp
.SH DESCRIPTION
\fIXfm\fP is a file and applications manager program for the X window system.
It provides virtually all of the features that you would expect in a file
manager \- move around your directory tree in multiple windows, move, copy or
delete files, and launch programs with simple mouse operations. Directory
displays are updated automatically in regular intervals when the contents of
the directory changes. The integrated application manager provides a kind of
``shelf'' onto which you can place your favourite applications, as well as the
files and directories you are currently working with. It also allows you to
access different groups of applications and files.  User-definable file types
let you specify a command to be executed when double-clicking on a file or
dropping other files onto it. Last not least, \fIxfm\fP can automatically
mount and unmount special devices like floppies as you open and close the
corresponding directories (mount points).
.SH "OPTIONS"
\fIXfm\fP accepts all the usual toolkit options. Furthermore, the following
options let you control which windows should be displayed at startup.
.TP 4
.B \-appmgr
Only display the application manager window.
.TP 4
.B \-filemgr
Only display the file manager window. 
.PP
If both \fI-appmgr\fP and \fI-filemgr\fP are specified, then the
applications and one file manager window will be displayed, which is also
the default. If only \fI-filemgr\fP is specified, the application manager will
not be available in this session.
.SH "RUNNING XFM FOR THE FIRST TIME"
There are a number of configuration files which need to be placed in
your home directory in order to run xfm.  To install the default
configuration files, run the program
.B xfm.install
which will create a directory
.B ~/.xfm
and install some files in there.  These are your personal
configuration files, and may be edited to customise
\fIXfm\fP to your own tastes.
.SH "USAGE"
Most of it should be fairly obvious. There is one application window and zero
or more file windows in which directories (also termed \fIfolders\fP) are
displayed. In order to perform an action, you either select items and then
invoke a menu operation, or you drag items from a file window to a second
(maybe the same) file window or the application window. You can also
double-click on an item to start a corresponding action (like launching an
application, editing a file, or changing directories), and press the right
menu button on an item to bring up a menu containing operations for a single
file or application.  Pressing the right button on the background of the
application window displays the application menu. File operations are accessed
from the file window menu bar as usual.
.PP
The left-hand mouse button selects an item (and deselects all others in the
same window). The second button toggles the selected state of an item.
.PP
You can drag with the left-hand button to another window (or another icon, in
general a valid destination will be highlighted with a border when the cursor
is over it) to move files from one directory to another. The second button
used in the same way will copy files. Applications can be launched by dropping
files on them; and installing files and programs in the application manager
can be done by dropping files on the background of the application window.
Finally, new file windows can be opened by simply dragging a directory icon to
the root window.
.PP
The action taken when double-clicking on a file depends on the type of the
file. If it is a directory, it is displayed in the file window. If it is an
executable, the program is started. Other files are opened in the default
editor (specified by the \fIdefaultEditor\fP resource), unless another action
is given in the \fIxfmrc\fP file (see CONFIGURATION below).
.PP
Directories can be displayed in three different forms: \fItree\fP (display
subdirectories in tree-like form), \fIicon\fP (display directories and files
as icons) and \fItext\fP (similar to \fIls -l\fP). These options are selected
from the \fIView\fP menu. In the tree form, clicking on the arrows takes you
up or down one level.
.SH "MENU COMMANDS"
.sp
FILE MENU
.PP
File manipulation operations.
.TP 4
.I New...
.br
Create a new (and empty) file.
.TP 4
.I Move
.br
Rename a single item (directory or file) or move selected items to another
directory.
.TP 4
.I Copy
.br
Create a copy of a single item under a new name or copy selected items to
another directory.
.TP 4
.I Link...
.br
Create a symbolic link.
.TP 4
.I Delete
.br
Delete the selected items.
.TP 4
.I Select...
.br
Select items by pattern.
.TP 4
.I Select all
.br
Select all items in the current directory (except the parent directory).
.TP 4
.I Deselect
.br
Deselect all items.
.TP 4
.I Quit
.br
Terminate \fIxfm\fP.
.PP
FOLDER MENU
.PP
Operations dealing with directories and the file window.
.TP 4
.I New...
.br
Create a new directory.
.TP 4
.I Go to...
.br
Display the specified directory.
.TP 4
.I Home
.br
Display your home directory.
.TP 4
.I Up
.br
Display the parent directory.
.TP 4
.I Empty
.br
Delete all items in the current directory.
.TP 4
.I Close
.br
Close this file window.
.PP
VIEW MENU
.PP
Options for the directory display.
.TP 4
.I Tree
.br
Select the tree form display.
.TP 4
.I Icons
.br
Select the icons form display.
.TP 4
.I Text
.br
Select the text form display.
.TP 4
.I Sort by name
.br
Sort directory by name.
.TP 4
.I Sort by size
.br
Sort directory by size.
.TP 4
.I Sort by date
.br
Sort directory by date.
.TP 4
.I Hide folders
.br
Suppress directory items.
.TP 4
.I Mix folders/files
.br
Mix directories and other files.
.TP 4
.I Show hidden files
.br
Show hidden files (files starting with a dot).
.PP
FILE POPUP MENU
.PP
Operations on a single file. This menu pops up when pressing the right mouse
button on a directory or file icon.
.TP 4
.I Open
.TP 4
.I Edit
.br
Open a new file window if the selected item is a directory, otherwise edit the
selected file.
.TP 4
.I Move
.br
Move the selected item.
.TP 4
.I Copy
.br
Copy the selected item.
.TP 4
.I Delete
.br
Delete the selected item.
.TP 4
.I Information...
.br
Display information about the selected item (file size, permissions and such).
.TP 4
.I Permissions...
.br
Change the permissions of the selected item.
.PP
APPLICATION MENU
.PP
Operations for managing the applications window.
.TP 4
.I Install...
.br
Install a new application in the applications window. Pops up a dialog form
into which you can enter the necessary information (see CONFIGURATION for a
discussion of the fields in this form).
.TP 4
.I Delete
.br
Delete the selected items from the applications window.
.TP 4
.I Save setup
.br
Save the state of the applications window in the applications file (see
CONFIGURATION below).
.TP 4
.I Load setup
.br
Restore the setup from the applications file.
.TP 4
.I File window
.br
Open a new file window.
.TP 4
.I Quit
.br
Terminate \fIxfm\fP.
.PP
APPLICATION POPUP MENU
.PP
Operations on a single application item. This menu pops up when pressing the
right mouse button on an icon in the application window.
.TP 4
.I Edit
.br
Edit an application item. Pops up a dialog form which allows you to change
the configuration information associated with the selected item (see
CONFIGURATION for a discussion of the fields in this form).
.TP 4
.I Move
.br
Move the selected item to the bottom of the applications window. This
operation provides a (rather awkward) way of rearranging the order of
application items.
.TP 4
.I Copy
.br
Copy the selected item to the bottom of the applications window.
.TP 4
.I Delete
.br
Delete the selected item from the applications window.
.SH "RESOURCES"
Various aspects of \fIxfm\fP can be configured by changing corresponding
resource settings in the applications default file. Some important resources
are listed below:
.TP 4
.B bitmapPath
.TP 4
.B pixmapPath
.br
The path on which to search for bitmap and pixmap icons, respectively.
.TP 4
.B applicationDataFile
.TP 4
.B configFile
.TP 4
.B devFile
.br
The names of the application and configuration files used by \fIxfm\fP (see
CONFIGURATION). Normally, these will be hidden files in your home directory.
You may wish to change this, e.g., if you want to provide a system-wide
\fIxfmrc\fP file. (The applications file should always be kept in the user's
home directory, such that each user can save his/her private application
settings.)
.TP 4
.B autoSave
.br
Enable or disable automatic saving of application files. When this feature is
enabled (which it is by default), then \fIxfm\fP saves your application setup
(if modified) whenever you switch to a new file (by means of the \fILOAD\fP
action, see CONFIGURATION), or when you terminate \fIxfm\fP.
.TP 4
.B doubleClickTime
.br
Set the time interval in milliseconds for which a sequence of two mouse clicks
should be interpreted as a double click. Default: 500.
.TP 4
.B updateInterval
.br
Set the time interval in milliseconds in which to perform automatic folder
updates. Default: 10000.
.TP 4
.B confirmXXX
.br
Resources to request confirmation for various operations. \fIXXX\fP can be
any one of \fIDeletes\fP, \fIDeleteFolder\fP, \fICopies\fP, \fIMoves\fP,
\fIOverwrite\fP and \fIQuit\fP. By default these are all enabled.
.TP 4
.B defaultEditor
.br
The command with which \fIxfm\fP invokes your favourite editor.
.PP
There are way too many available resources to list them all in this manual
page, so please take a look at the application defaults file for more
information.
.SH "CONFIGURATION"
Besides the application resources, \fIxfm\fP can be configured by means of
three different files, which are usually named \fIxfmrc\fP, \fIxfmdev\fP
and \fIxfm-apps\fP, and are located in the \fI~/.xfm\fP directory. These are
plain ASCII files which can be edited using any text editor. (Note that
the \fIxfm-apps\fP file is also written by \fIxfm\fP when invoking the
corresponding menu command, and when the autosave feature is enabled.)
Any line in these files which starts with a hash sign (\fI#\fP) is interpreted
as a comment; empty lines are ignored.
.SH "FILE TYPE CONFIGURATION"
The \fIxfmrc\fP file specifies the types of ordinary (non-executable,
non-directory) files which \fIxfm\fP should recognize. Each line has the
following format:
.sp
.nf
        pattern:icon:push-action:drop-action
.fi
.sp
As indicated, the different fields are separated by a colon (use \fI\\:\fP
to escape the \fI:\fP character, and \fI\\\\\fP to escape the backslash
character itself). The meaning of these fields is explained below.
.TP 4
.B pattern
The filename pattern a file must match in order to belong to this type. There
are three types of patterns: \fILiteral\fP patterns specify a literal filename
such as ``\fIcore\fP.'' \fISuffix\fP patterns specify a suffix the filename
must match, and are indicated by a leading asterisk, as in ``\fI*.c\fP.'' (All
characters following the initial \fI*\fP are interpreted as literals; there
is no expansion of embedded wildcards.) Finally, \fIprefix\fP patterns specify
a prefix to be matched against the filename. They are denoted by a trailing
asterisk, as in ``\fIREADME*\fP.''
.TP 4
.B icon
The name of the bitmap or pixmap file containing the icon to be displayed
for this file type.
.TP 4
.B push-action
The command to be executed when the user double-clicks on a file of this
type. This command is passed to the shell (via \fI-c\fP), together with
the name of the selected file. The command is executed in the directory
where the selected file is located. The filename is available in the command
as the positional parameter number one, such that an action of the form
\fIxyz $1\fP invokes the command \fIxyz\fP on the selected file. There
are also two special kinds of push actions built into \fIxfm\fP, \fIEDIT\fP
which invokes the default editor on the selected file, and \fILOAD\fP which
loads the selected file as an applications file (discussed in Section
APPLICATION FILES).
.TP 4
.B drop-action
Similar to the push action, this field denotes a command to be executed when
a collection of selected files is dropped onto the file. The absolute target
filename itself is available as positional parameter \fI$1\fP, the remaining
arguments denote the names of the files dropped onto the target file. The
command is executed in the directory which contains the selected files. No
special built-in commands are available for this type of action.
.PP
If an action field is empty, the corresponding action defaults to ``do
nothing.'' For instance, the following entry defines an icon and an
\fIEDIT\fP push action for \fI.c\fP files:
.sp
.nf
        *.c:xfm_c.xpm:EDIT:
.fi
.sp
As another example, here is an entry for compressed (i.e. gzipped) tar
files. The push action causes the archive to be extracted, while the drop
action replaces the contents of the archive with the files which have been
dragged onto the archive:
.sp
.nf
        *.tar.gz:xfm_taz.xpm:exec tar xfvz $1:exec tar cfvz $*
.fi
.sp
(Note the use of the shell's \fIexec\fP command. Since actions are invoked
through the shell, it is often useful to replace the shell with the actual
command which is to be executed, in order to conserve memory space on
small systems.)
.PP
It is possible that different patterns given in the \fIxfmrc\fP file overlap.
In this case \fIxfm\fP uses the \fIfirst\fP pattern which matches. Therefore
you should always list the more specific patterns first. For instance, the
following two entries specify what to do with compressed tar files (specific
case) and other \fI.gz\fP files (default case):
.sp
.nf
        *.tar.gz:xfm_taz.xpm:exec tar xfvz $1:exec tar cfvz $*
        *.gz:xfm_z.xpm:exec gunzip $1:
.fi
.PP
\fIXfm\fP also enables you to prompt for additional parameters before an action
is executed. This is generally more useful with application entries than
with file actions, and will therefore be described in the context of
application configuration, see PARAMETER DIALOGS below.
.SH DEVICE CONFIGURATION
The device configuration file, \fIxfmdev\fP, lets you specify which mount
points \fIxfm\fP should keep track of, and which actions to perform in order
to mount and unmount the corresponding file systems. This allows you to access
file systems on special devices such as floppies, CD-Roms, etc. in a
transparent way. All you have to do is to enter a directory named
in \fIxfmdev\fP (e.g. by opening a file window on it), and \fIxfm\fP will
automatically perform the corresponding mount action for you. Likewise, if you
leave such a directory, \fIxfm\fP invokes the corresponding unmount
action. (CAUTION: You still have to take care that you unmount a file system,
e.g. by closing every file window which has been opened on it, before you
physically remove the corresponding medium.)
.PP
An entry of the \fIxfmdev\fP file has the following format:
.sp
.nf
        directory:mount-action:umount-action
.fi
.sp
The \fIdirectory\fP field denotes the mount point of the file system,
\fImount-action\fP the command to be executed in order to mount the file
system, and \fIumount-action\fP the command for unmounting the file system.
Here is a ``typical'' entry from my \fIxfmdev\fP file:
.sp
.nf
        /disk/a:mount -t msdos -o user /dev/fd0 /disk/a:umount /disk/a
.fi
.sp
Of course, the details of how to mount a floppy file system may vary from
system to system, and you might have to take special actions if you want to
use \fImount\fP as an ordinary user. See \fImount\fP(8) for details.
.SH APPLICATION FILES
.PP
Application files are used to specify the contents of the application window.
Normally, these files are not altered with a text editor, but are written by
\fIxfm\fP using the corresponding menu operation or the autosave feature. An
understanding of the application data is necessary, however, if you want to
edit an existing or create a new entry using the \fIInstall\fP and \fIEdit\fP
options of the applications menu. Each entry has the following form:
.sp
.nf
        name:directory:filename:icon:push-action:drop-action
.fi
.sp
The \fIname\fP and \fIicon\fP fields specify the name of the application and
a corresponding icon which should be displayed in the application window. The
\fIpush-action\fP and \fIdrop-action\fP fields have the same meaning as in
the \fIxfmrc\fP file: they indicate the commands to be passed to the shell
when the user double-clicks on the icon or drops files onto it, respectively.
The \fIdirectory\fP and \fIfilename\fP fields let you specify a file to be
passed to the application. These fields are filled in by \fIxfm\fP when the
user drags a file or directory onto the application window. \fIXfm\fP also
properly sets up the action fields when installing a file which has a
matching entry in the \fIxfmrc\fP file.
.PP
As usual, the target file (if specified) and any dropped files are passed to
the push and drop actions as the first and the remaining parameters,
respectively, see FILE TYPE CONFIGURATION for details. The drop action
is executed in the directory containing the selected files, while the
push action starts in the directory specified by the \fIdirectory\fP
field, if it is nonempty, and in the user's home directory otherwise.
.PP
In an application file, \fIXfm\fP recognizes three special types of built-in
push actions. The \fIEDIT\fP action, as in \fIxfmrc\fP, invokes the default
editor. The \fIOPEN\fP action indicates that the target file actually is a
directory onto which \fIxfm\fP should open a new file window when the user
double-clicks on the corresponding icon. Finally, the \fILOAD\fP action tells
\fIxfm\fP that the target is an application file whose contents are to be
loaded into the application window. This action allows you to manage different
groups of applications. For instance, you might have an entry loading a
``toolbox'' applications file from \fIxfm-apps\fP which in turn contains an
entry to reload the \fIxfm-apps\fP file. By these means, application groups
can be organized in a tree-like fashion. Note that application files can also
be loaded by a corresponding file type entry, since the \fILOAD\fP action is
also supported in the \fIxfmrc\fP file. (The \fIOPEN\fP action is not
supported there, however, as it wouldn't make sense anyhow. Note that you can
only specify file types for regular files.)
.PP
It is time for some examples. Here are three useful entries from
my \fIxfm-apps\fP files which I use to start an xterm, my favourite editor,
and print a file using lpr, respectively:
.sp
.nf
        Terminal:::xterm.xpm:exec xterm:
        Editor:::editor.xpm:exec emacs:exec emacs $*
        Printer:::printer.xpm::exec lpr $*
.fi
.sp
\fIXfm\fP gives you great flexibility in configuring special types of actions.
For instance, the following entries can be used to implement a simple
trashcan feature and an action to open a window on a floppy disk:
.sp
.nf
        Trash::.trash:trash.xpm:OPEN:shift; mv $* ~/.trash
        A\\::/disk:a:disk.xpm:OPEN:
.fi
.sp
It is also instructive to take a look at how \fIxfm\fP sets up the entries
when you drag files or directories to the application window. Play around
with these features. It is fun! Many things can be done, if not with a
single command then maybe with a tiny shell script.
.SH "PARAMETER DIALOGS"
\fIXfm\fP lets you prompt the user for additional parameters when a push
or drop action is invoked. In such a case, a dialog form appears, with one
field for each parameter, into which the user can enter the required
arguments. Currently, no checking is done on the supplied parameters; in
fact, the user can simply leave all fields empty. Parameters are specified
in an action using the form
.sp
.nf
        %parameter-name%
.fi
.sp
where \fIparameter-name\fP is an arbitrary string not containing the \fI%\fP
character, which will be displayed in the dialog form. (As usual, a literal
\fI%\fP character can be escaped with the backslash.) \fIXfm\fP replaces
each such \fI%...%\fP construct with the corresponding value entered by the
user.
.PP
For instance, here is an entry for the \fIxfm-apps\fP file which invokes
\fIgrep\fP to search a given collection of files for a regular expression
the user is prompted for:
.sp
.nf
        grep:::grep.xpm::grep '%Regular expression\\:%' $*
.fi
.sp
More than one parameter field may be specified. For instance:
.sp
.nf
        find:::find.xpm:find %Directory\\:% %Find expression\\:%:
.fi
.sp
.SH "CONSOLE OUTPUT"
Programs started by \fIxfm\fP inherit their standard output and error streams
from \fIxfm\fP. Therefore, if you start \fIxfm\fP from your session or window
manager instead of an xterm, you should redirect \fIxfm\fP's standard
output and error to something which you can read while \fIxfm\fP is running,
if the window manager does not already do that for you. Usually, you will
reassign both \fIstdout\fP and \fIstderr\fP to \fI/dev/console\fP, using the
command:
.sp
.nf
        xfm >/dev/console 2>&1
.fi
.sp
Then you can read error messages and other output produced by launched
applications in the console window on your desktop (such as \fIxconsole\fP,
or \fIxterm -C\fP).
.SH "ICONS"
\fIXfm\fP supports icons in both the X bitmap and Arnaud Le Hors' XPM format.
A collection of useful icons is included in the distribution.
.SH "FILES"
.TP 4
.B ~/.xfm
Standard location for \fIxfm\fP configuration files.
.SH "SEE ALSO"
\fIX\fP(1), \fIxconsole\fP(1), \fIxterm\fP(1), \fImount\fP(8), Arnaud Le Hors:
\fIXPM Manual. The X PixMap Format\fP, Groupe Bull, 1993.
.SH "CAVEATS AND BUGS"
\fIxfm\fP catches the TERM signal to gracefully terminate the program,
saving the current application file if the autosave feature is enabled,
and unmounting all open file systems which have been mounted by \fIxfm\fP.
However, some window and session managers may not send TERM signals
to their client applications when terminating an X session. Therefore it might
be necessary to explicitly quit \fIxfm\fP or manually save the applications
file and close file windows before exiting X.
.SH "COPYRIGHT"
Copyright (c) 1990-1993 by Simon Marlow
.br
Copyright (c) 1994 by Albert Graef
.SH "AUTHORS"
The original version of this program was written by Simon Marlow
(simonm@dcs.glasgow.ac.uk) at the University of Glasgow. Albert Graef
(ag@muwiinfa.geschichte.uni-mainz.de) at the University of Mainz is the
author of the present version which contains many bug fixes and enhancements.
