.TH PolygonComp 3U "23 January 1991" "Unidraw" "InterViews Reference Manual"
.SH NAME
PolygonComp, PolygonView, PSPolygon
\- polygon component subject, view, and PostScript external
representation
.SH SYNOPSIS
.B #include <Unidraw/Components/polygon.h>
.SH DESCRIPTION
PolygonComp is a VerticesComp that defines a polygon.  It uses an
SF_Polygon graphic to store its graphical attributes.  PolygonView is
a VerticesView for displaying the polygon.  PSPolygon is a PSVertices
that externalizes the subject's information in PostScript form.
.SH POLYGONCOMP PUBLIC OPERATIONS
.TP
.B "PolygonComp(SF_Polygon* = nil)"
The constructor takes an optional stroked-filled polygon graphic
that defines the attributes of the polygon.
.TP
.B "SF_Polygon* GetPolygon()"
Return the Polygon graphic that defines the polygon's attributes.
GetPolygon is simply a more specific form of the GetGraphic
operation.
.SH POLYGONVIEW PUBLIC OPERATIONS
.TP
.B "PolygonView(PolygonComp* = nil)"
Create an PolygonView, optionally supplying the subject.
.TP
.B "virtual Manipulator* CreateManipulator("
.ns
.TP
.B "   Viewer*, Event&, Transformer*, Tool*"
.ns
.TP
.B ")"
.ns
.TP
.B "virtual void InterpretManipulator(Manipulator*)"
PolygonView redefines its response to manipulation with a
GraphicCompTool.  The user clicks the left mouse button to specify
each vertex and clicks with the middle mouse button to specify the
final vertex.  Vertex positioning will be constrained by gravity, if
any.  PolygonView also defines a response to the ReshapeTool, allowing
the user to click on one of its vertices to reposition it.  The
subject is actually replaced (via ReplaceCmd) with a new PolygonComp
subject reflecting the repositioned vertex.  Repositioning will be
influenced by gravity.
.TP
.B "PolygonComp* GetPolygonComp()"
Return the subject.
.SH PSPOLYGON PUBLIC OPERATIONS
.TP
.B "PSPolygon(PolygonComp* = nil)"
Construct a PostScript external representation of the given subject,
if any.
.SH PSPOLYGON PROTECTED OPERATIONS
.TP
.B "virtual const char* Name()"
PSPolygon identifies itself as "Poly" in the PostScript output.
.SH SEE ALSO
Event(3I), GraphicComp(3U), GraphicCompTool(3U),
GraphicView(3U), Grid(3U), PatternCmd(3U), PostScriptView(3U),
ReshapeTool(3U), Rubband(3I), Transformer(3I), VerticesComp(3U),
Viewer(3U), align(3U), edit(3U), polygons(3U)
