% This is digraph.sl. It allows for easy input of accented characters 
% and other 8-bit characters. It is an alternative to the mutekeys.sl package.
% I wrote it because I don't like mutekeys. I added a lot of
% characters not found in mutekeys.sl. 
% Usage: put this file in $JED_ROOT/lib and add a line
%
%   autoload ("digraph_cmd",  "digraph");  setkey ("digraph_cmd", "\ek");
%
% to your .jedrc file. The digraphs are now available by typing
% Esc-K 'accent' 'letter'. 
% 
% Thanks to John Davis for reducing the number of case statements in the 
% original code and for adding the user-friendly interface (don't type too
% fast, otherwise you can't read it).
% 
% This does not work yet under MSDOS and OS2 . Any volunteers?
% 
% Ronald Rietman, 1995/03/05

#ifndef MSDOS OS2

define digraph_cmd ()
{
   variable accent, letters;
   variable i;

   EXIT_BLOCK
     {
	message (Null_String);
     }
   
   flush ("Enter one of the accent characters: / \" ' ` , ^ ~");
   
   switch (getkey ())
     {
      case '/':
	"aAdDeEoOstT$";
	"\d229\d197\d240\d208\d230\d198\d248\d216\d223\d254\d222\d163";
     }
     {
      case '\"':
	"aAeEiIoOsuU";
        "\d228\d196\d235\d203\d239\d207\d246\d214\d223\d252\d220";
     }
     {
      case '\'':
	"aAeEiIoOuU1/!?";
        "\d225\d193\d233\d201\d237\d205\d243\d211\d250\d218\d161\d191\d161\d191";
     }
     {
      case '\`':
	"aAeEiIoOuU";
	"\d224\d192\d232\d200\d236\d204\d242\d210\d249\d217";
     }
     {
      case '^':
	"aAeEiIoOuU";
	"\d226\d194\d234\d202\d238\d206\d244\d212\d251\d219";
     }
     {
      case '~':
	"aAnNoO!?";
	"\d227\d195\d241\d209\d245\d213\d161\d191";
     }
     {	
      case ',':
	"cC";
	"\d231\d199";
     }
     {
	% default
	pop (); return;
     }
   
   (letters, accent) = ();
   
   flush (Sprintf ("Enter one of \"%s\" to get corresponding \"%s\"",
		    letters, accent, 2));

   i = is_substr (letters, char (getkey ()));
   
   !if (i)
     {
	beep ();
	return;
     }
   i--;
   insert_char (accent[i]);
}

#endif

