/*
 *  linux/ibcs/svr4.c
 *
 *  Copyright (C) 1995  Mike Jagdis
 *
 * $Id: svr4.c,v 1.1 1995/03/21 11:11:05 mike Exp $
 * $Source: /u3/CVS/ibcs/iBCSemul/svr4.c,v $
 */

#include <linux/config.h>

#include <linux/module.h>
#include <linux/version.h>

#include <asm/segment.h>
#ifndef KERNEL_DS
#include <linux/segment.h>
#endif

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/stddef.h>
#include <linux/unistd.h>
#include <linux/ptrace.h>
#include <linux/fcntl.h>
#include <linux/time.h>

#include <asm/system.h>
#include <linux/fs.h>
#include <linux/sys.h>
#include <linux/malloc.h>

#include <ibcs/ibcs.h>
#include <ibcs/svr4.h>

#ifdef IBCS_TRACE
#include <ibcs/trace.h>
#endif


int svr4_getgroups(int n, unsigned long *buf)
{
	int i;

	if (n) {
		i = verify_area(VERIFY_WRITE, buf, sizeof(unsigned long) * n);
		if (i)
			return i;
	}
	for (i = 0 ; (i < NGROUPS) && (current->groups[i] != NOGROUP) ; i++) {
		if (!n)
			continue;
		if (i >= n)
			break;
		put_fs_long(current->groups[i], buf);
		buf++;
	}
	return(i);
}


int svr4_setgroups(int n, unsigned long *buf)
{
	int i;

	if (!suser())
		return -EPERM;
	if (n > NGROUPS)
		return -EINVAL;
	for (i = 0; i < n; i++, buf++) {
		current->groups[i] = get_fs_long(buf);
	}
	if (i < NGROUPS)
		current->groups[i] = NOGROUP;
	return 0;
}


/* XXX Usage unknown - guesswork */
int svr4_waitsys(struct pt_regs *regs)
{
	long result, opt, kopt;
	int pid;
	unsigned long loc;

	opt = get_fs_long(((unsigned long *) regs->esp) + 1);
	pid = get_fs_long(((unsigned long *) regs->esp) + 2);
	loc = get_fs_long(((unsigned long *) regs->esp) + 3);

	kopt = 0;
	if (opt & 0100) kopt |= WNOHANG;
	if (opt & 4) kopt |= WUNTRACED;

	result = SYS(wait4)(pid, loc, kopt, NULL);

	if (result >= 0 && loc) {
		regs->edx = get_fs_long((unsigned long *) loc);
		if ((regs->edx & 0xff) == 0x7f) {
			int sig = (regs->edx >> 8) & 0xff;
			sig = current->exec_domain->signal_map[sig];
			regs->edx = (regs->edx & (~0xff00)) | (sig << 8);
			put_fs_long(regs->edx, (unsigned long *)loc);
		} else if (regs->edx && regs->edx == (regs->edx & 0xff)) {
			regs->edx = current->exec_domain->signal_map[regs->edx & 0x7f];
			put_fs_long(regs->edx, (unsigned long *)loc);
		}
	}
	return result;
}
