/* error handling common to all routines. */
/* Copyright (c) 1992, 1995 John E. Davis
 * All rights reserved.
 * 
 * You may distribute under the terms of either the GNU General Public
 * License or the Perl Artistic License.
 */


#include <stdio.h>
#include <string.h>
#ifndef NO_STDLIB_H
#include <stdlib.h>
#endif

#include "slang.h"

void (*SLang_Error_Routine)(char *);
void (*SLang_Exit_Error_Hook)(char *);
volatile int SLang_Error = 0;
char *SLang_Error_Message;

void SLang_doerror(char *error)
{
   char err[80]; char *str = NULL;

   if (!SLang_Error) SLang_Error = UNKNOWN_ERROR;
   *err = 0;
   
   if (SLang_Error_Message != NULL) str = SLang_Error_Message;
   else switch(SLang_Error)
     {
      case (UNDEFINED_NAME): str = "Undefined_Name"; break;
      case (SYNTAX_ERROR): str = "Syntax_Error"; break;
      case (STACK_OVERFLOW): str = "Stack_Overflow"; break;
      case (STACK_UNDERFLOW): str = "Stack_Underflow"; break;
      case (DUPLICATE_DEFINITION): str = "Duplicate_Definition"; break;
      case (TYPE_MISMATCH): str = "Type_Mismatch"; break;
      case(READONLY_ERROR): str = "Variable is read only."; break;
      case (SL_MALLOC_ERROR) : str = "S-Lang: Malloc Error."; break;
      case (SL_INVALID_PARM) : str = "S-Lang: Invalid Parameter."; break;
      case USER_BREAK: strcpy(err, "User Break!"); break;
      case (INTRINSIC_ERROR): str = "Intrinsic Error"; break;
      case DIVIDE_ERROR: str = "Divide by zero."; break;
	/* application code should handle this */
      default: if (error != NULL) str = error; else str = "Unknown Error.";
     }
   
   SLang_Error_Message = NULL;
   
   if (*err == 0) sprintf(err, "S-Lang Error: %s", str);
   
   if (SLang_Error_Routine == NULL)
     {
	if (error != NULL) 
	  {
	     fputs(error, stderr);
	     putc('\n', stderr);
	  }
	
	if (err != error) 
	  {
	     fputs(err, stderr);
	     putc('\n', stderr);
	  }
     }
   else
     {	if (error != NULL) (*SLang_Error_Routine)(error);
	if (err != error) (*SLang_Error_Routine)(err);
     }
}

void SLang_exit_error (char *s)
{
   if (SLang_Exit_Error_Hook != NULL)
     {
	(*SLang_Exit_Error_Hook) (s);
     }
   fprintf (stderr, "%s\n", s);
   exit (-1);
}
